#!/usr/bin/env python

import mysql.connector as myc
import json
import requests
import numpy as np

ARQUIVO_CONFIGURACAO = "/home/adapter/resources/rotinas/6/config.json"
configuracao = json.load(open(ARQUIVO_CONFIGURACAO,'r'))

def connect_db(host, database, port, user, password):
    try:
        return myc.connect(host=host, database=database, port=port, user=user, password=password)
    except Exception as e:
        print ('%s' % e)

def find_avisos_tecnicos_pendente(cnx, limiteMensagem):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT IDLogAvisoTecnicoApp AS 'IDLogAvisoApp',`Status`, UNIX_TIMESTAMP(DataCadastro) AS 'DataEnvio',Mensagem, Titulo, Descricao, IDTecnico FROM TB_LogAvisoTecnicoApp WHERE `Status` = 'PENDENTE' LIMIT %s;" % limiteMensagem)
        resultado = cur.fetchall()
        cur.close()
        return resultado
    except Exception as e:
        print ('ERRO (find_avisos_tecnicos_pendente): %s' % e)    

def update_avisos_tecnicos_pendente(cnx,IDLogAvisoTecnicoApp):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("UPDATE TB_LogAvisoTecnicoApp SET `Status` = 'ENVIADO', DataEnvio = NOW() WHERE IDLogAvisoTecnicoApp = %s;" % IDLogAvisoTecnicoApp)
        cur.close()
        return cnx.commit()
    except Exception as e:
        print ('ERRO (update_avisos_tecnicos_pendente): %s' % e  )      

def envia_avisos_tecnico(configuracao,aviso):
    try:
        data = {}
        data["where"] = {}
        data["where"]["idTecnico"]= {}
        data["where"]["idTecnico"]["$in"] = [str(aviso["IDTecnico"])]
        data["data"] = {}
        data["data"]["title"] = aviso["Titulo"]
        data["data"]["alert"] = aviso["Descricao"]
        data["data"]["aviso"] = json.loads(json.dumps(aviso))
        r = requests.post(configuracao['urlParse'],json=data, headers={"X-Parse-Application-Id" : configuracao['applicationID'], "X-Parse-Master-Key": configuracao['masterKey']})
        try:
            return aviso["IDLogAvisoApp"] 
        except Exception as e:
            print ('ERRO %s' % e)
    except Exception as e:
        print ('ERRO %s' % e)
    
    return None

def realiza_envio(aviso,cnx):
    IDLogAvisoTecnicoApp = envia_avisos_tecnico(configuracao,aviso)
    if not IDLogAvisoTecnicoApp is None:
        update_avisos_tecnicos_pendente(cnx,IDLogAvisoTecnicoApp)


def main():
    cnx = connect_db(configuracao['host'],configuracao['database'],configuracao['port'],configuracao['user'],configuracao['password'])
    avisos = find_avisos_tecnicos_pendente(cnx,configuracao['limiteMensagem'])
    if len(avisos) > 0:
        for aviso in avisos:
            realiza_envio(aviso,cnx)
    cnx.close()

if __name__== "__main__":
    main()
