# -*- coding: utf-8 -*-
import db, conf, json, log
import datetime, requests, time
import json

class SapService():
        def __init__(self, pool, dados_faturamento, erros, lock, log, cf):
            self.pool = pool
            self.dados_faturamento = dados_faturamento
            self.lock = lock
            self.log = log
            self.cf = cf
            self.erros = erros
            self.id_faturamentos = [int(id) for id in dados_faturamento['Faturamento']['IDsFaturamentos'].split(',')]
            self.erro_sap = False
            self.url = ''
            self.tempo_resposta = None
            self.response = None
            self.resposta_SAP = None
            self.nota_SAP = None
            

        def salvar_log_sucesso(self):
            try:
                acao = '''ATUALIZACAO DE NOTAS NO ADAPTER ORIGINADA NO SAP
            #Disparado por: RotinaPY-IntegracaoSAPNotas
            # URL: {} 
            # Notas inseridas
            # Tempo de resposta: {}
            # Dados Enviados: \n{}
            # Resposta: {}
            # Data: \n {} \n
                '''.format(self.url,
                        self.tempo_resposta if self.tempo_resposta is not None else 'Nao foi possivel calcular tempo de resposta.',
                        'Foi enviado para busca do docEntry: {} '.format(self.dados_faturamento['Faturamento']['IDDocumentoSap']),
                        self.resposta_SAP if self.resposta_SAP is not None else 'Nao foi possivel obter a respota do SAP',
                        self.response if self.response is not None else 'Nao obteve os dados de retorno do SAP'
                )
                db.insere_log_integracao(self.cnx,acao,'ATUALIZACAO',self.dados_faturamento['Faturamento']['IDsFaturamentos'],int(self.dados_faturamento['IDUsuarioTarefas']))
            except Exception as erro:
                self.log.log.info('=========== * {} Ocorreu o erro ao inserir log de sucesso: {} * ==========='.format(self.dados_faturamento['UUID'],erro))

        def integrar(self):
            cf = self.cf
            self.log.log.info('=========== * {} Iniciando processo de integracao * ==========='.format(self.dados_faturamento['UUID']))
            try:
                self.cnx = db.connect_db(self.pool)
                try:
                    self.busca_notas_geradas()
                    if self.nota_SAP is not None:
                        self.nota_SAP['IDCliente2'] = self.dados_faturamento['Faturamento']['IDCliente']
                        id_modelo_nota = db.busca_modelo_nota_sequence_usage(self.cnx,self.nota_SAP['SequenceCode'],self.nota_SAP['Usage'])
                        if id_modelo_nota is None:
                            raise ValueError('Erro ao obter o modelo nota fiscal no adapter.\n O SequenceCode: {} e o Usage: {} retorna pelo DocEntry: {}, não foi localizado'.format(
                                            self.nota_SAP['SequenceCode'],self.nota_SAP['Usage'],self.dados_faturamento['Faturamento']['IDDocumentoSap']
                                            ))
                        id_nota = db.busca_id_nota_fiscal(self.cnx,self.dados_faturamento['Faturamento']['IDCliente'],self.nota_SAP['NumeroNF'],self.nota_SAP['Vencimento'],id_modelo_nota)
                        if id_nota is not None:
                            self.nota_ja_existe_adapter(id_nota)
                        else:
                            self.nota_nao_existe_adapter(id_modelo_nota)

                        self.salvar_log_sucesso()
                    else:
                        self.erros[self.dados_faturamento['Faturamento']['IDsFaturamentos']] = 'Erro ao tentar inserir nota no adapter. Mensagem: Nota nao identificada no SAP'
                except Exception as erro:
                    self.log.log.info('=========== * {} Ocorreu o erro ao atualizar: {} * ==========='.format(self.dados_faturamento['UUID'],erro))
                        
                    origem_erro = "Resposta obtida do SAP" if self.erro_sap else "Erro"
                    acao = '''ERRO NA ATUALIZACAO DE NOTAS NO ADAPTER ORIGINADA NO SAP
        #Disparado por: RotinaPY-IntegracaoSAPNotas
        # URL: {} 
        # {}: {}
        # Tempo de resposta: {}
        # Dados Enviados: \n{}
        # Resposta: {}
        # Data: \n {} \n
                        '''.format(self.url,origem_erro,erro,
                                self.tempo_resposta if self.tempo_resposta is not None else 'Nao foi possivel calcular tempo de resposta.',
                                'Foi enviado para busca do docEntry: {} '.format(self.dados_faturamento['Faturamento']['IDDocumentoSap']),
                                self.resposta_SAP if self.resposta_SAP is not None else 'Nao foi possivel obter a respota do SAP',
                                self.response if self.response is not None else 'Nao obteve os dados de retorno do SAP'
                        )
                    db.insere_log_integracao(self.cnx,acao,'ATUALIZACAO_ERRO',self.dados_faturamento['Faturamento']['IDsFaturamentos'],int(self.dados_faturamento['IDUsuarioTarefas']))
                    self.lock.acquire()
                    self.erros[self.dados_faturamento['Faturamento']['IDsFaturamentos']] = acao
                    self.lock.release()
            except Exception as erro:
                self.log.log.info('=========== * {} Ocorreu o erro ao atualizar: {} * ==========='.format(self.dados_faturamento['UUID'],erro))
            finally:
                db.close_connect_db(self.cnx)
        
        def busca_notas_geradas(self):
            senha = self.dados_faturamento['ServidorIntegracao']['Senha'].decode("utf-8") 
            print(senha); 
            self.url = '{}:{}/api/Invoice/BuscarNotaSaidaPorId?docEntry={}'.format(self.dados_faturamento['ServidorIntegracao']['URL'],
            self.dados_faturamento['ServidorIntegracao']['Porta'], self.dados_faturamento['Faturamento']['IDDocumentoSap'])
            print(self.url)
            inicio = time.time()
            r = requests.get(self.url, headers={'Connection': 'close'},auth=requests.auth.HTTPBasicAuth(self.dados_faturamento['ServidorIntegracao']['Login'], senha))
            self.response = r.json()
            fim = time.time()
            self.tempo_resposta = abs(fim - inicio)  # Em ms

            if r.status_code != 200:
                r.close()
                raise ValueError("Erro ao buscas os dados da nota {} no SAP. O servidor nao conseguiu processar a requisiçao".format(self.dados_faturamento['Faturamento']['IDDocumentoSap']))
            r.close()
            self.resposta_SAP = None
            if 'message' in self.response:
                self.resposta_SAP = self.response['message']
            elif 'Message' in self.response:
                self.resposta_SAP = self.response['Message']
            else:
                self.resposta_SAP = 'Nao identificada'
            
            self.nota_SAP = None
            if 'data' in self.response:
                self.nota_SAP = self.response['data']
            elif 'Data' in self.response:
                self.nota_SAP = self.response['Data']
            else:
                self.nota_SAP = 'Nao identificada'
			
            if 'status' not in self.response or self.response['status'] != '0':               
                self.erro_sap = True
                if self.erro_sap:
                    raise ValueError('Erro do SAP: {}'.format(self.resposta_SAP))
        
        def nota_nao_existe_adapter(self, id_modelo_nota):

            id_empresa = self.dados_faturamento['Faturamento']['IDEmpresa']
            id_nota = db.insere_nota_integracao(self.cnx,self.nota_SAP,id_modelo_nota,id_empresa)
            if id_nota is None:
                raise ValueError('Ocorreu um erro ao criar a nota dos faturamentos: {}'.format(self.dados_faturamento['Faturamento']['IDsFaturamentos']))
            itens_nota = self.nota_SAP['itens']
            for item in itens_nota:
                id_item_nota = db.insere_item_nota_integracao(self.cnx,id_nota,item)
                if id_item_nota is None:
                        raise ValueError('Ocorreu erro ao inserir o item nota da Nota: {}'.format(id_nota))
                atualizou = db.atualiza_item_nota_faturamento(self.cnx,id_item_nota,int(item['IDFaturamento']))
                if not atualizou:
                    raise ValueError('Ocorreu ao atualizar o Faturamento {} com o IDItemNota: {}'.format(item['IDFaturamento'],id_item_nota))

        def nota_ja_existe_adapter(self, id_nota):
            itens_nota = self.nota_SAP['itens']
            pesquisa = False
            if itens_nota is not None and len(itens_nota) > 0:
                for item in itens_nota:
                    id_item_nota = db.obtem_id_item_nota(self.cnx,id_nota,item)
                    if id_item_nota is None:
                        id_item_nota = db.insere_item_nota_integracao(self.cnx,id_nota,item)
                        pesquisa = True
                    else:
                        id_faturamento = db.item_nota_livre(self.cnx,id_item_nota)
                        if id_faturamento is not None and int(item['IDFaturamento']) != 0 and int(id_faturamento) != int(item['IDFaturamento']):
                            id_item_nota = db.insere_item_nota_integracao(self.cnx,id_nota,item)
                            pesquisa = True

                    if id_item_nota is None:
                        raise ValueError('Ocorreu erro ao inserir o item nota da Nota: {}'.format(id_nota))
                    if pesquisa:
                        id_faturamento = db.item_nota_livre(self.cnx,id_item_nota)
                    print(id_faturamento)
                    if id_faturamento is None and int(item['IDFaturamento']) != 0:
                        print('AQUI')
                        atualizou = db.atualiza_item_nota_faturamento(self.cnx,id_item_nota,int(item['IDFaturamento']))
                        if not atualizou:
                            raise ValueError('Ocorreu ao atualizar o Faturamento {} com o IDItemNota: {}'.format(int(item['IDFaturamento']),id_item_nota))
                        
                    

