# -*- coding: utf-8 -*-

import threading
import concurrent.futures
import uuid, sys
import conf, db, emailAdapter, log, controleExecucao, sap_service

def forma_lista_integracao(servidor_integracao,faturamentos,id_usuario_tarefas):
    lista_integracao = []
    faturamento = {}
    for faturamento in faturamentos:
        lista_integracao.append({ 'UUID':str(uuid.uuid4()), 'Faturamento':faturamento,
                                'ServidorIntegracao':servidor_integracao, 'IDUsuarioTarefas':id_usuario_tarefas})
    return lista_integracao

def main_cadastro():
    cf = conf.open_conf()
    controleExecucao.cadastro(cf)
    exit(0)

def main(args):
    cf = conf.open_conf()
    log.log_config(int(cf['app']['log_level']))
    log.log.info('=========== * Iniciando a busca de Notas no SAP * ===========')

    controle_dados = None
    ids_faturamentos = None
    por_controle = False
    data_corte = cf['app']['data_corte']
    limite_execucao = cf['app']['limite_default']
    log.log.info('=========== * Verificando tipo de parametro para executar a rotina * ===========')
    if len(args) == 1:
        log.log.info('=========== * Nao Pode executar sem parametro * ===========')
        exit(0)
    else:
        if int(args[1]) > 0:
            log.log.info('=========== * Por controle * ===========')
            controle_dados = controleExecucao.obtem_dados_controle(cf, args[1])
            por_controle = True
        elif str(args[1]) == '-1':
            log.log.info('=========== * Por IDs de faturamentos * ===========')
            ids_faturamentos = args[2]
        elif str(args[1]) == '-2':
            log.log.info('=========== * Buscando por Limite e Data corte* ===========')
            data_corte = args[2]
            limite_execucao = args[3]

    pool = db.create_pool(cf['db']['host'], cf['db']['database'], cf['db']['port'], cf['db']['user'],cf['db']['password'])
    cnx = db.connect_db(pool)

    log.log.info('=========== * Buscando servidor de integracao * ===========')
    servidor_integracao = db.busca_servidor_integracao(cnx,cf['db']['database_gateway'])
    
    if servidor_integracao is None or servidor_integracao['URL'] is None:
        raise ValueError("O Servidor de Integracao nao esta configurado corretamente")

    log.log.info('=========== * Buscando notas a ser inseridas no adapter * ===========')
    faturamentos = db.busca_faturamentos_sem_nota(cnx,data_corte,limite_execucao,ids_faturamentos)
    
    log.log.info('=========== * Validando se possui faturamentos a ser integrados * ===========')
    if faturamentos is not None and len(faturamentos) > 0:
        log.log.info("Quantidade de faturamento: {}".format(len(faturamentos)))
        log.log.info('=========== * Buscando chaves de configuracoes para integracao * ===========')
        id_usuario_tarefa = db.busca_valor_configuracao_chave(cnx,'ID_USUARIO_TAREFAS_AUTOMATICAS',cf['db']['database_comercial'])
        log.log.info('=========== * Formatando a lista para integrar * ===========')
        lista_integracao = forma_lista_integracao(servidor_integracao,faturamentos,id_usuario_tarefa)
        
        erros = {}
        lock = threading.Lock()

        log.log.info('=========== * Iniciando o processo de integracao de busca de Notas do SAP * ===========')
        with concurrent.futures.ThreadPoolExecutor(max_workers=int(cf['app']['max_workers'])) as executor:
            for integrar in lista_integracao:
                log.log.info('=========== * Enviando para integrar: {} * ==========='.format(integrar['UUID']))
                future = executor.submit(sap_service.SapService(pool, integrar, erros, lock, log, cf).integrar)
        log.log.info('=========== * Finalizando o processo de integracao de busca de Notas do SAP * ===========')
        if len(erros) > 0:
            log.log.info('=========== * Enviando email com os erros de integracao * ===========')
            emailAdapter.send_email(cf,emailAdapter.cria_mensagem(erros))
    else:
        log.log.info('=========== * Não possui Notas para buscar no SAP* ===========')

    print(por_controle)
    if por_controle:
        controleExecucao.finaliza_execucao_controle(cf, args[1], 'FINALIZADO')

    db.close_connect_db(cnx)
    
    log.log.info('=========== * Finalizando a busca de Notas no SAP * ===========')

    exit()


if __name__ == '__main__':
    if len(sys.argv) == 1:
        main_cadastro()
    else:
        main(sys.argv)
