# -*- coding: utf-8 -*-

import log
import mysql.connector as myc

def connect_db(host='localhost', database='information_schema', port=3306, user='root', password=''):
    try:
        log.log.info('- Abrindo conexão com o host "%s", porta "%s" e banco de dados "%s"' % (
        str(host), str(port), str(database)))

        return myc.connect(host=host, database=database, port=port, user=user, password=password, charset='utf8',
                           use_unicode=True, pool_size=32, pool_reset_session=True)
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados: %s' % e)

def close_connect_db(cnx):
    try:
        cnx.close()
        log.log.info('- Fechando a conexão com o banco de dados...')
    except Exception as e:
        log.log.error('Falha ao finalizar a conexão com o banco de dados: %s' % e)

def busca_dados(cnx,id_controle,banco):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''
        SELECT
            cer.IDControleExecucaoRotina,
            per.NomeParametro, per.ValorParametro,
            usu.IDUsuario, usu.NomeUsuario, usu.EmailUsuario
        FROM
            TB_ControleExecucaoRotina cer
        INNER JOIN TB_ParametroExecucaoRotina per ON cer.IDControleExecucaoRotina = per.IDControleExecucaoRotina
        INNER JOIN {}.TB_Usuario usu ON cer.IDUsuario = usu.IDUsuario
        WHERE
            cer.IDControleExecucaoRotina = {}
        '''.format(banco,id_controle))
        parametros = cur.fetchall()
        cur.close()
        return parametros
    except Exception as e:
        log.log.error('Erro ao busca Controle de Execucao Rotina: %s' % e)
        return None

def atualiza_status_pid_controle(cnx, id_controle, status, pid):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''
            UPDATE TB_ControleExecucaoRotina 
                SET `Status` = '{}', PID = {}, DataInicio = NOW(), DataFim = NULL WHERE IDControleExecucaoRotina = {}
        '''.format(status,pid,id_controle))
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Falha ao tentar atualizar contrato: %s' % e)
        return False

def atualiza_status_data_fim_controle(cnx, id_controle, status):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''
            UPDATE TB_ControleExecucaoRotina 
                SET `Status` = '{}', DataFim = NOW() WHERE IDControleExecucaoRotina = {}
        '''.format(status,id_controle))
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Falha ao tentar atualizar contrato: %s' % e)
        return False

def insert_controle_execucao(cnx, banco, idusuario, idrotina):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
            """
            INSERT %s.TB_ControleExecucaoRotina (IDUsuario,DataCadastro,`Status`,IDRotina) VALUES (%s,NOW(),'NOVO',%s)
        """ % (banco, idusuario, idrotina)
        )
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Falha ao realizar o insert no controle execucao rotina: %s' % e)
        return False
