# -*- coding: utf-8 -*-

import log
from mysql.connector import Error
from mysql.connector import pooling

def create_pool(host='localhost', database='information_schema', port=3306, user='root', password=''):
    return pooling.MySQLConnectionPool(pool_name="pynative_pool",
                                                  pool_size=32,
                                                  pool_reset_session=True,
                                                  host=host,
                                                  database=database,
                                                  user=user,
                                                  password=password,
                                                  port=port)

def connect_db(pool):
    try:
        return pool.get_connection()
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados: %s' % e)

def close_connect_db(cnx):
    try:
        cnx.close()
        log.log.info('- Fechando a conexão com o banco de dados...')
    except Exception as e:
        log.log.error('Falha ao finalizar a conexão com o banco de dados: %s' % e)

def busca_faturamentos_sem_nota(cnx,data_corte, limite_faturamentos, id_faturamento = None):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(monta_consulta_find_faturamentos(data_corte, limite_faturamentos, id_faturamento))
        faturamentos = cur.fetchall()
        cur.close()
        return faturamentos
    except Exception as e:
        log.log.error('Falha ao buscar os faturamentos: %s' % e)
        return None

def busca_modelo_nota_sequence_usage(cnx,sequence_code,usage):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT IDModeloNotaFiscal FROM TB_ControleNumeroNota WHERE SequenceCodeSap = '{}' AND UsageSap = '{}'".format(sequence_code,usage))
        modelo = cur.fetchone()
        print(modelo)
        cur.close()
        return modelo['IDModeloNotaFiscal']
    except Exception as e:
        log.log.error('Falha ao buscar o modelo de nota fiscal: %s' % e)
        return None

def busca_valor_configuracao_chave(cnx, chave, banco):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT ValorConfiguracao FROM {}.TB_Configuracoes WHERE ChaveConfiguracao = '{}'".format(banco,chave))
        valor = cur.fetchone()
        cur.close()
        return valor['ValorConfiguracao']
    except Exception as e:
        log.log.error('Falha ao buscar o dado da chave de configuracao: %s' % e)
        return None

def monta_consulta_find_faturamentos(data_corte, limite_faturamentos = 50000, ids_faturamento = None):
    sql = '''
        SELECT DISTINCT GROUP_CONCAT(IDFaturamentoMes) as IDsFaturamentos, IDDocumentoSap, IDCliente, contaf.IDEmpresa
        FROM TB_FaturamentoMes fm 
        INNER JOIN TB_FormaCobranca fc ON fm.IDFormaCobranca = fc.IDFormaCobranca 
        INNER JOIN TB_ContaFinanceira contaf ON fc.IDContaFinanceira = contaf.IDContaFinanceira 
        WHERE IDDocumentoSap IS NOT NULL 
        AND IDItemNota IS NULL 
        AND IsIntegrado = 'S' 
        AND IsCancelado = 0 
        AND DataGeracaoFaturamento >= '{} 00:00:00' 
    '''.format(data_corte)
    
    if ids_faturamento is not None:
        sql = ' {} AND fm.IDFaturamentoMes IN ( {} )\n '.format(sql,ids_faturamento)
    sql = ' {} GROUP BY IDDocumentoSap\n '.format(sql,ids_faturamento)
    sql = ' {} LIMIT {} '.format(sql,limite_faturamentos)

    return sql

def busca_servidor_integracao(cnx,banco_gateway):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''
            SELECT
                URL, Porta, Login, AES_DECRYPT(Senha,'F583BE47632CEE39') as Senha 
            FROM
                {0}.TB_Configuracoes conf 
            INNER JOIN
                {0}.TB_ServidorIntegracao si ON conf.ValorConfiguracao = si.IDServidorIntegracao
            WHERE conf.ChaveConfiguracao = 'ID_SERVIDOR_INTEGRACAO'
        '''.format(banco_gateway))
        servidor = cur.fetchone()
        cur.close()
        return servidor
    except Exception as e:
        log.log.error('Falha ao buscar o Servidor de Integracao SAP: %s' % e)
        return None

def insere_log_integracao(cnx, acao, tipo_acao, ids_faturamentos, id_usuario_tarefa):
    
    try:
        cur = cnx.cursor()
        cur.execute('''
            INSERT INTO TB_LogIntegracaoFaturamento (Acao, TipoAcao, DataLog, IDFaturamentoMes, IDUsuario) 
            VALUES (%s, %s, NOW(), %s, %s)
        ''',(acao, tipo_acao, ids_faturamentos,id_usuario_tarefa))
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Erro ao inserir LogIntegracaoFaturamento: %s' % e)
        return False

def busca_id_nota_fiscal(cnx,id_cliente,numero_nf,vencimento,id_modelo_nota):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''SELECT n.IDNota FROM TB_Nota n WHERE 
                        n.IDCliente = {} AND n.NumeroNF = '{}'
                        AND n.IDModeloNotaFiscal = {} AND n.Vencimento = '{}'
                    '''.format(id_cliente,numero_nf,id_modelo_nota,vencimento))
        nota = cur.fetchone()
        cur.close()
        if nota is None:
            return nota
        return nota['IDNota']
    except Exception as e:
        log.log.error('Falha ao buscar a nota: %s' % e)
        return None

def item_nota_livre(cnx,id_item_nota):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''SELECT IDFaturamentoMes FROM TB_FaturamentoMes fm
                        WHERE fm.IDItemNota = {} 
                    '''.format(id_item_nota))
        faturamento = cur.fetchone()
        cur.close()
        return faturamento['IDFaturamentoMes']
    except Exception as e:
        log.log.error('Falha ao buscar faturamento pelo IDItemNota: %s' % e)
        return None

def obtem_id_item_nota(cnx,id_nota,item):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(monta_consulta_busca_id_item(),monta_dados_consulta_busca_id_item(id_nota,trata_item(item)))
        item_nota = cur.fetchone()
        print(item_nota)
        cur.close()
        return item_nota['IDItemNota']
    except Exception as e:
        log.log.error('Falha ao buscar o id do item nota: %s' % e)
        return None

def monta_consulta_busca_id_item():
    return '''
        SELECT  MAX(i.IDItemNota) AS IDItemNota FROM TB_ItemNota i 
        WHERE i.IDNota = %s AND i.ValorIRRF = %s
        AND i.ValorCOFINS = %s AND i.ValorICMS = %s 
        AND i.ValorPIS = %s AND i.ValorOutrosICMS = %s 
        AND i.BaseICMS = %s AND i.AliquotaICMS = %s 
        AND i.BasePIS = %s AND i.BaseCOFINS = %s 
        AND i.Descricao = %s AND i.ValorCSLL = %s 
        AND i.ValorItem = %s AND i.ValorIsentoICMS = %s 
        AND i.AliquotaPIS = %s AND i.BaseCSLL = %s 
        AND i.BaseIRRF = %s AND i.AliquotaCOFINS = %s
        AND i.ValorISS = %s AND i.BaseISS = %s 
        ORDER BY i.IDItemNota DESC;
    '''
def monta_dados_consulta_busca_id_item(id_nota, item):
    return (id_nota,item['ValorIRRF'],item['ValorCOFINS'],item['ValorICMS'],item['ValorPIS'],item['ValorOutrosICMS'],item['BaseICMS'],
            item['AliquotaICMS'],item['BasePIS'],item['BaseCOFINS'],item['Descricao'],item['ValorCSLL'],item['ValorItem'],item['ValorIsentoICMS'],
            item['AliquotaPIS'],item['BaseCSLL'],item['BaseIRRF'],item['AliquotaCOFINS'],item['ValorISS'],item['BaseISS'])

def insere_item_nota_integracao(cnx, id_nota, item):
    try:
        cur = cnx.cursor()
        
        cur.execute('''
            INSERT INTO TB_ItemNota 
                (IDNota,Descricao,ValorIRRF,BaseCOFINS,BaseCSLL,  
                BaseICMS,BaseIRRF,BaseISS,BasePIS,ValorCOFINS,ValorCSLL,  
                ValorICMS,ValorISS,ValorIsentoICMS,ValorItem,ValorPIS,  
                AliquotaICMS,AliquotaPIS,AliquotaCOFINS,ValorOutrosICMS)  
            VALUES  
                (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)
        ''',monta_dados_insere_item_nota_integracao(id_nota, trata_item(item)))
        id_item_nota = cur.lastrowid
        cnx.commit()
        cur.close()
        return id_item_nota
    except Exception as e:
        log.log.error('Erro ao inserir o ItemNota: %s' % e)
        return None

def monta_dados_insere_item_nota_integracao(id_nota, item):
    return (id_nota,item['Descricao'],item['ValorIRRF'],item['BaseCOFINS'],item['BaseCSLL'],
            item['BaseICMS'],item['BaseIRRF'],item['BaseISS'],item['BasePIS'],item['ValorCOFINS'],item['ValorCSLL'],
            item['ValorICMS'],item['ValorISS'],item['ValorIsentoICMS'],item['ValorItem'],item['ValorPIS'],
            item['AliquotaICMS'],item['AliquotaPIS'],item['AliquotaCOFINS'],item['ValorOutrosICMS'])

def atualiza_item_nota_faturamento(cnx, id_item_nota, id_faturamento_mes):
    print((id_item_nota,id_faturamento_mes))
    try:
        cur = cnx.cursor()
        cur.execute('''
            UPDATE TB_FaturamentoMes f SET f.IDItemNota = %s WHERE f.IDFaturamentoMes = %s
        ''',(id_item_nota,id_faturamento_mes))
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Falha atualizar Faturamento Mes com o IDItemNota: %s' % e)
        return False

def insere_nota_integracao(cnx, nota,id_modelo_nota,id_empresa):
    try:
        cur = cnx.cursor()
        cur.execute('''
            INSERT INTO TB_Nota 
                (DataEmissao,IDCLiente,IDEmpresa,NumeroNF,Valor,Vencimento,
                IDModeloNotaFiscal,Situacao,ChaveCodificacaoDigital,IsIntegrado)  
            VALUES 
                (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)
        ''',monta_dados_insere_nota_integracao(nota,id_modelo_nota,id_empresa))
        id_nota = cur.lastrowid
        cnx.commit()
        cur.close()
        return id_nota
    except Exception as e:
        log.log.error('Falha ao inserir a Nota: %s' % e)
        return None

def monta_dados_insere_nota_integracao(nota, id_modelo_nota,id_empresa):
    return (nota['DataEmissao'],nota['IDCliente2'],id_empresa,nota['NumeroNF'],nota['Valor'],
            nota['Vencimento'],id_modelo_nota,nota['Situacao'],nota['ChaveCodificacaoDigital'],'S')

def trata_item(item):
    item_retorno = {}
   
    item_retorno['Descricao'] = item['Descricao']
    item_retorno['ValorItem'] = item['ValorItem']
    item_retorno['AliquotaCOFINS'] = 0
    item_retorno['BaseCOFINS'] = 0
    item_retorno['ValorCOFINS'] = 0
    item_retorno['AliquotaICMS'] = 0
    item_retorno['BaseICMS'] = 0
    item_retorno['ValorICMS'] = 0
    item_retorno['AliquotaIRRF'] = 0
    item_retorno['BaseIRRF'] = 0
    item_retorno['ValorIRRF'] = 0
    item_retorno['AliquotaIRRF'] = 0
    item_retorno['AliquotaPIS'] = 0
    item_retorno['BasePIS'] = 0
    item_retorno['ValorPIS'] = 0
    item_retorno['AliquotaISS'] = 0
    item_retorno['BaseISS'] = 0
    item_retorno['ValorISS'] = 0
    item_retorno['AliquotaCSLL'] = 0
    item_retorno['BaseCSLL'] = 0
    item_retorno['ValorCSLL'] = 0
    item_retorno['ValorOutrosICMS'] = 0
    item_retorno['ValorIsentoICMS'] = 0
    for imposto in item['Imposto']:
        if imposto['TipoImposto'] == 'COFINS':
            if 'Aliquota' in imposto:
                item_retorno['AliquotaCOFINS'] = imposto['Aliquota']
            if 'BaseCalculo' in imposto:
                item_retorno['BaseCOFINS'] = imposto['BaseCalculo']
            if 'Imposto' in imposto:
                item_retorno['ValorCOFINS'] = imposto['Imposto']
        if imposto['TipoImposto'] == 'PIS':
            if 'Aliquota' in imposto:
                item_retorno['AliquotaPIS'] = imposto['Aliquota']
            if 'BaseCalculo' in imposto:
                item_retorno['BasePIS'] = imposto['BaseCalculo']
            if 'Imposto' in imposto:
                item_retorno['ValorPIS'] = imposto['Imposto']
        if imposto['TipoImposto'] == 'CSLL':
            if 'Aliquota' in imposto:
                item_retorno['AliquotaCSLL'] = imposto['Aliquota']
            if 'BaseCalculo' in imposto:
                item_retorno['BaseCSLL'] = imposto['BaseCalculo']
            if 'Imposto' in imposto:
                item_retorno['ValorCSLL'] = imposto['Imposto']
        if imposto['TipoImposto'] == 'ISS':
            if 'Aliquota' in imposto:
                item_retorno['AliquotaISS'] = imposto['Aliquota']
            if 'BaseCalculo' in imposto:
                item_retorno['BaseISS'] = imposto['BaseCalculo']
            if 'Imposto' in imposto:
                item_retorno['ValorISS'] = imposto['Imposto']
        if imposto['TipoImposto'] == 'ICMS':
            if 'Aliquota' in imposto:
                item_retorno['AliquotaICMS'] = imposto['Aliquota']
            if 'BaseCalculo' in imposto:
                item_retorno['BaseICMS'] = imposto['BaseCalculo']
            if 'Imposto' in imposto:
                item_retorno['ValorICMS'] = imposto['Imposto']
            if 'Outros' in imposto:
                item_retorno['ValorOutrosICMS'] = imposto['Outros']
            if 'Isento' in imposto:
                item_retorno['ValorIsentoICMS'] = imposto['Isento']
        if imposto['TipoImposto'] == 'IRRF':
            if 'Aliquota' in imposto:
                item_retorno['AliquotaIRRF'] = imposto['Aliquota']
            if 'BaseCalculo' in imposto:
                item_retorno['BaseIRRF'] = imposto['BaseCalculo']
            if 'Imposto' in imposto:
                item_retorno['ValorIRRF'] = imposto['Imposto']

    return item_retorno
    
