# -*- coding: utf-8 -*-

import log, db_rotina
import os

def cadastro(configuracao):
    cnx = db_rotina.connect_db(configuracao['db']['host'], configuracao['db']['database_rotinas'], configuracao['db']['port'], configuracao['db']['user'],
                        configuracao['db']['password'])

    registro = db_rotina.insert_controle_execucao(cnx, configuracao['db']['database_rotinas'], configuracao['app']['id_usuario'],
                                           configuracao['app']['id_rotina'])
    if registro:
        print ('Registrado na tabela de controle.')
    else:
        print ('Erro ao registra a rotina')
    db_rotina.close_connect_db(cnx)

def obtem_dados_controle(configuracao,id_controle):
    dados = []
    cnx = db_rotina.connect_db(configuracao['db']['host'], configuracao['db']['database_rotinas'], configuracao['db']['port'], configuracao['db']['user'],
                        configuracao['db']['password'])
    
    dados = db_rotina.busca_dados(cnx,id_controle,configuracao['db']['database_gateway'])
    atualizado = db_rotina.atualiza_status_pid_controle(cnx,id_controle,'EM_EXECUCAO',os.getpid())

    if not atualizado:
        raise ValueError("Erro ao atualizar o Status do controle: {}".format(id_controle))

    db_rotina.close_connect_db(cnx)

    return dados

def finaliza_execucao_controle(configuracao,id_controle, status):
    dados = []
    cnx = db_rotina.connect_db(configuracao['db']['host'], configuracao['db']['database_rotinas'], configuracao['db']['port'], configuracao['db']['user'],
                        configuracao['db']['password'])
    
    atualizado = db_rotina.atualiza_status_data_fim_controle(cnx,id_controle,status)

    if not atualizado:
        raise ValueError("Erro ao atualizar o Status do controle: {}".format(id_controle))

    db_rotina.close_connect_db(cnx)
