# -*- coding: utf-8 -*-
import db, conf, json, log
import datetime, requests, time
import json

class SapService():
        def __init__(self, pool, dados_faturamento, erros, centro_custo_contratos, lock, log, cf):
            self.pool = pool
            self.dados_faturamento = dados_faturamento
            self.lock = lock
            self.log = log
            self.cf = cf
            self.erros = erros
            self.centro_custo_contratos = centro_custo_contratos
            self.id_faturamentos_inseridos_documento = set()
            self.erro_sap = False
            self.url = ''
            self.tempo_resposta = None
            self.response = None
            self.resposta_SAP = None
            self.data_SAP = None
            
        def integrar(self):
            
            self.log.log.info('=========== * {} Iniciando processo de integracao * ==========='.format(self.dados_faturamento['UUID']))
            self.cnx = db.connect_db(self.pool)
            try:
                json_sap = None
                ja_integrado = False
                
                self.log.log.info('=========== * {} Validando se o faturamento já possui IDDocumentoSap * ==========='.format(self.dados_faturamento['UUID']))
                if self.dados_faturamento['IDDocumentoSAP'] is not None:
                    self.atualiza_faturamento_adapter(self.cnx,self.dados_faturamento['ItensFaturamento'],self.dados_faturamento['IDDocumentoSAP'],self.dados_faturamento['IDUsuarioTarefas'])
                else:
                    try:
                        self.log.log.info('=========== * {} Validando se o faturamento já foi integrado * ==========='.format(self.dados_faturamento['UUID']))
                        ja_integrado = self.valida_faturamento_integrado()
                        if not ja_integrado:
                            self.log.log.info('=========== * {} Iniciando processo de montar o JSON para integrar * ==========='.format(self.dados_faturamento['UUID']))
                            json_sap = self.gera_novo_faturamento_integrar(self.dados_faturamento,log)
                            self.log.log.info('=========== * {} Realizando integracao do faturamento * ==========='.format(self.dados_faturamento['UUID']))
                            if('DocumentLines' in json_sap and len(json_sap['DocumentLines']) > 0):
                                self.realiza_intergracao_faturamento(json_sap)
                            else:
                                self.log_integracao_sem_envio()
                    except Exception as erro:
                        self.log.log.info('=========== * {} Ocorreu o erro ao integrar: {} * ==========='.format(self.dados_faturamento['UUID'],erro))
                        if len(self.id_faturamentos_inseridos_documento) > 0:
                            db.atualiza_faturamento_integracao(self.cnx,'E',self.id_faturamentos_inseridos_documento)
                        
                        origem_erro = "Resposta obtida do SAP" if self.erro_sap else "Erro"
                        acao = '''Erro ao integrar os dados do faturamento ao SAP
        #Disparado por: RotinaPY-IntegracaoSAPFaturamentos
        # URL: {} 
        # {}: {}
        # Tempo de resposta: {}
        # Dados Enviados: \n{}
        # Resposta: {}
        # Data: \n {} \n
                        '''.format(self.url,origem_erro,erro,
                                self.tempo_resposta if self.tempo_resposta is not None else 'Nao foi possivel calcular tempo de resposta.',
                                json_sap if json_sap is not None else 'Nao foi possivel montar o json para envio ao SAP',
                                self.resposta_SAP if self.resposta_SAP is not None else 'Nao foi possivel obter a respota do SAP',
                                self.response if self.response is not None else 'Nao obteve os dados de retorno do SAP'
                        )
                        db.insere_log_integracao(self.cnx,acao,'CADASTRO_ERRO',[id['IDFaturamentoMes'] for id in self.dados_faturamento['ItensFaturamento']],int(self.dados_faturamento['IDUsuarioTarefas']))
                        self.lock.acquire()
                        self.erros[','.join([str(id['IDFaturamentoMes']) for id in self.dados_faturamento['ItensFaturamento']])] = acao
                        self.lock.release()
            except Exception as erro:
                self.log.log.info('=========== * {} Ocorreu o erro ao integrar: {} * ==========='.format(self.dados_faturamento['UUID'],erro))
            finally:
                db.close_connect_db(self.cnx)

        def log_integracao_sem_envio(self):
            self.log.log.info('=========== * {} Sem dados para integrar * ==========='.format(self.dados_faturamento['UUID']))
            
            acao = '''Faturamento com valor Zerado
        #Disparado por: RotinaPY-IntegracaoSAPFaturamentos
        # URL: {} 
        # Não possui faturamentos para integrar. Valores zerados. '''.format(self.url)
            db.insere_log_integracao(self.cnx,acao,'CADASTRO_SEM_ENVIO',[id['IDFaturamentoMes'] for id in self.dados_faturamento['ItensFaturamento']],int(self.dados_faturamento['IDUsuarioTarefas']))
       

        def valida_faturamento_integrado(self):
            senha = self.dados_faturamento['ServidorIntegracao']['Senha'].decode("utf-8")
            self.url = '{}:{}/api/Invoice/BuscarNotaSaidaPorFA?FATTELCO={}'.format(self.dados_faturamento['ServidorIntegracao']['URL'],
            self.dados_faturamento['ServidorIntegracao']['Porta'], self.dados_faturamento['ItensFaturamento'][0]['IDFaturamentoMes'])
            inicio = time.time()
            r = requests.get(self.url, headers={'Connection': 'close'},auth=requests.auth.HTTPBasicAuth(self.dados_faturamento['ServidorIntegracao']['Login'], senha))
            self.response = r.json()
            r.close()
            fim = time.time()
            self.tempo_resposta = abs(fim - inicio)  # Em ms

            if r.status_code != 200:
                r.close()
                raise ValueError("Erro ao verificar se faturamento ja estava integrado ao SAP. O servidor nao conseguiu processar a requisiçao")
            r.close()
            self.resposta_SAP = None
            if 'message' in self.response:
                self.resposta_SAP = self.response['message']
            elif 'Message' in self.response:
                self.resposta_SAP = self.response['Message']
            else:
                self.resposta_SAP = 'Nao identificada'
            
            self.data_SAP = None
            if 'data' in self.response:
                self.data_SAP = self.response['data']
            elif 'Data' in self.response:
                self.data_SAP = self.response['Data']
            else:
                self.data_SAP = 'Nao identificada'

            if 'status' in self.response and self.response['status'] == '0' and "Retorno de Nota" in self.resposta_SAP:
                nota = self.response['data']
                id_documento_sap = int(nota['DocEntry'])
                print([id['IDFaturamentoMes'] for id in self.dados_faturamento['ItensFaturamento']])
                atualizou = db.atualiza_faturamento_integracao(self.cnx,'S',[id['IDFaturamentoMes'] for id in self.dados_faturamento['ItensFaturamento']],id_documento_sap)
                if not atualizou:
                    raise ValueError('Erro ao atualizar informacao do Faturamentos na TB_FaturamentoMes')
                acao = '''DADOS DE FATURAMENTO ENVIADOS AO SAP\n
                    \t# URL: {}\n
                    \t# Resposta: {}\n
					\t# Data: {}\n
					\t# Tempo de resposta: {} segundos\n
					\t# Dados enviados:\n{}\n\n
					\t# Dados recebidos:\n{}\n\n
                '''.format(self.url,self.resposta_SAP,self.data_SAP,self.tempo_resposta,'Nao foi enviado dados, pois o faturamento se encontra ja no SAP, atualizando informacao no Adapter',self.response)
                db.insere_log_integracao(self.cnx,acao,'ATUALIZANDO_INFORMACAO',[id['IDFaturamentoMes'] for id in self.dados_faturamento['ItensFaturamento']],int(self.dados_faturamento['IDUsuarioTarefas']))
                return True
            return False

        def gera_novo_faturamento_integrar(self,dados_faturamento,log):
            self.log.log.info('=========== * {} Iniciando a criacao do JSON para envio* ==========='.format(self.dados_faturamento['UUID']))
            itens_faturamento = dados_faturamento['ItensFaturamento']
        
            faturamento_integrar = {}
            faturamento_integrar['Series'] = 4
            faturamento_integrar['DocType'] = "I"
            faturamento_integrar['DocDate'] = datetime.date.today().isoformat()
            faturamento_integrar['DocDueDate'] = dados_faturamento['Vencimento']
            
            if dados_faturamento['CardCodeDocumento'] is not None and int(dados_faturamento['CardCodeDocumento']) == 1:
                if dados_faturamento['ItensFaturamento'][0]['CNPJ'] is not None and dados_faturamento['ItensFaturamento'][0]['CNPJ'] != '':
                    faturamento_integrar['CardCode'] = 'C{}'.format(dados_faturamento['ItensFaturamento'][0]['CNPJ'])
                else:
                    faturamento_integrar['CardCode'] = 'C000{}'.format(dados_faturamento['ItensFaturamento'][0]['CPF'])
            else:
                faturamento_integrar['CardCode'] = 'C{}'.format(dados_faturamento['IDCliente'])
            
            faturamento_integrar["PaymentGroupCode"] = -1#* ID do pagamento *
            faturamento_integrar["TaxDate"] = datetime.date.today().isoformat() #*Data do documento*
            faturamento_integrar["DocObjectCode"] = "oInvoices" #* VALOR FIXO *

            faturamento_integrar["SequenceCode"] = dados_faturamento['ItensFaturamento'][0]['SequenceCodeSap'] #*Código para modelo da nota *
            faturamento_integrar["BPL_IDAssignedToInvoice"] = dados_faturamento['IDFilialSAP'] #* VALOR FIXO *
            #faturamento_integrar["U_SKILL_TipTrib"] = dados_faturamento['ItensFaturamento'][0]['TipoTribitarioSAP'] #* VALOR FIXO *
            #faturamento_integrar["NumAtCard"] = "" #* MOB ver o q vai colocar *
            faturamento_integrar["U_TU_ADAP_NBOL"] = self.gera_numero_documento(dados_faturamento['Vencimento'],dados_faturamento['IDContrato'])
            faturamento_integrar["PaymentMethod"] = dados_faturamento['CodigoFormaCobrancaSAP'] 
            # for faturamento in itens_faturamento:
            #     if 'Numero' in faturamento and faturamento['Numero'] is not None:
            #         numero = str(faturamento['Numero'])[2:]
            #         faturamento_integrar["U_Campo22CAT79"] = numero
            #         faturamento_integrar["U_Campo26CAT79"] = numero
            #         break
            contratos = str("")
            obsersacoes_fiscais = str("")
            obs = ""
            for faturamento in itens_faturamento:
                if len(contratos) == 0:
                    contratos = faturamento['Contrato']
                else:
                    contratos = '{},{}'.format(contratos,faturamento['Contrato'])
                
                if faturamento['ObservacaoFiscal'] is not None:
                    obs = faturamento['ObservacaoFiscal']
                else:
                    obs = str("")
                if len(obsersacoes_fiscais) == 0:
                    obsersacoes_fiscais = obs
                else:
                    obsersacoes_fiscais = '{},{}'.format(obsersacoes_fiscais,obs)
                                  
            faturamento_integrar["TU_ADAP_CONT"] = contratos
            # if obsersacoes_fiscais is not None and len(obsersacoes_fiscais) > 0:
            #     if len(obsersacoes_fiscais) > 500:
            #         obsersacoes_fiscais = obsersacoes_fiscais[0:500]
            #     faturamento_integrar['OpeningRemarks'] = obsersacoes_fiscais

            faturamento_integrar["U_TU_AGRUPAR"] = 'Y' if 'FaturaUnica' in itens_faturamento[0] and int(itens_faturamento[0]['FaturaUnica']) == 1 else 'N'
            
            self.log.log.info('=========== * {} Gerando os DocumentLines do JSON * ==========='.format(self.dados_faturamento['UUID']))
            document_lines = self.gera_documentos_lines(itens_faturamento)
            if len(document_lines) > 0:
                faturamento_integrar["DocumentLines"] = document_lines
                #faturamento_integrar["ControlAccount"] = dados_faturamento['ControlAccount'] if dados_faturamento['ControlAccount'] is not None else ''
                #faturamento_integrar["U_TU_ItemID"] = ''
                
                # dados_carne = self.monta_notas_carnes()
                # if dados_carne is not None:
                #     faturamento_integrar['DownPaymentsToDraw'] = dados_carne
            
            
            self.log.log.info('=========== * {} Retornando o JSON Gerado * ==========='.format(self.dados_faturamento['UUID']))
            return faturamento_integrar
            
        def gera_documentos_lines(self,itens_faturamento):
            document_lines = []
            
            self.log.log.info('=========== * {} Pecorrendo a lista de faturamentos para montar * ==========='.format(self.dados_faturamento['UUID']))
            for faturamento in itens_faturamento:
                if faturamento['IDFaturamentoMes'] not in self.id_faturamentos_inseridos_documento:
                    valor = float(faturamento['Valor'])
                    if 'Desconto' in faturamento and faturamento['Desconto'] is not None and faturamento['Desconto'] != '':
                        desconto = float(faturamento['Desconto'])
                        valor = valor - desconto
                    if valor > 0.000:
                        self.log.log.info('=========== * {} O Faturamento de id: {} possui o valor R$ {} * ==========='.format(self.dados_faturamento['UUID'], faturamento['IDFaturamentoMes'], valor))
                        documento = {}
                        documento['U_TU_FATADAPTER'] = str(faturamento['IDFaturamentoMes'])
                        documento['WhsCode'] = 'POP'
                        if faturamento['ItemCodeSap'] is not None:
                            documento['ItemCode'] = faturamento['ItemCodeSap']
                        #documento['Quantity'] = 1
                        documento['UnitPrice'] = valor
                        if faturamento['UsageSap'] is not None:
                            documento['Usage'] = faturamento['UsageSap']
                        
                        centro_custo = self.busca_centro_custo_contrato(faturamento['IDContrato'])
                        if centro_custo is not None and centro_custo != '':
                            documento['CostingCode2'] = centro_custo

                        documento['CFOPCode'] = self.dados_faturamento['NumeroCFOP']
                        documento['FreeText'] = faturamento['Periodo']
                        #documento['U_TU_VELOCIDADE'] = faturamento['Velocidade'] if faturamento['Velocidade'] is not None else ''
                        #documento['ItemDetails'] = faturamento['Descricao']
                        document_lines.append(documento)
                        self.id_faturamentos_inseridos_documento.add(faturamento['IDFaturamentoMes'])

                    else:
                        self.log.log.info('=========== * {} O Faturamento de id: {} está com valor zerado * ==========='.format(self.dados_faturamento['UUID'],faturamento['IDFaturamentoMes']))
                        db.atualiza_faturamento_integracao(self.cnx,'Z',[faturamento['IDFaturamentoMes']])

            return document_lines

        def busca_centro_custo_contrato(self,id_contrato):
            
            self.log.log.info('=========== * {} buscando o centro de custo do contrato: {} * ==========='.format(self.dados_faturamento['UUID'], id_contrato))
            if id_contrato in self.centro_custo_contratos:
                self.log.log.info('=========== * {} o centro de custo já existe na lista * ==========='.format(self.dados_faturamento['UUID']))
                return self.centro_custo_contratos[id_contrato]
            centro_custo_sap = None
            endereco_instalacao = False
            endereco_padrao = False
            self.log.log.info('=========== * {} buscando dados do contrato * ==========='.format(self.dados_faturamento['UUID']))
            centros_custos = db.busca_centro_custo_contrato(self.cnx,self.cf['db']['database_comercial'],self.cf['db']['database_terceiros'],id_contrato)
            if centros_custos is not None:
                if len(centros_custos) == 1 and centros_custos[0]['CostingCodeSap'] is not None and centros_custos[0]['CostingCodeSap'] != '':
                    centro_custo_sap = centros_custos[0]['CostingCodeSap']
                else:
                    for centro_custo in centros_custos:
                        if centro_custo['TipoEndereco'] == 'INSTALACAO':
                            centro_custo_sap = centro_custo['CostingCodeSap']
                            endereco_instalacao = True
                            break
                        elif centro_custo['TipoEndereco'] == 'PADRAO':
                            centro_custo_sap = centro_custo['CostingCodeSap']
                            endereco_padrao = True
                        
                    if not endereco_instalacao and not endereco_padrao:
                        if centros_custos[0]['CostingCodeSap'] is not None and centros_custos[0]['CostingCodeSap'] != '':
                            centro_custo_sap = centros_custos[0]['CostingCodeSap']

            self.log.log.info('=========== * {} retornando o centro de custo: {} * ==========='.format(self.dados_faturamento['UUID'], centro_custo_sap))
            self.lock.acquire()
            self.centro_custo_contratos[id_contrato] = centro_custo_sap
            self.lock.release()
            return centro_custo_sap

        def monta_notas_carnes(self):
            doc_entry_carne = db.fatura_carne_sap_id_faturamento(self.cnx,self.dados_faturamento['ItensFaturamento'][0]['IDFaturamentoMes'])
            if doc_entry_carne is not None:
                nota_carne = {}
                nota_carne['DocEntry'] = doc_entry_carne
                nota_carne['DueDate'] = self.dados_faturamento['Vencimento']
                valor = float(self.dados_faturamento['ItensFaturamento'][0]['Valor'])
                if 'Desconto' in self.dados_faturamento['ItensFaturamento'][0] and self.dados_faturamento['ItensFaturamento'][0]['Desconto'] is not None and self.dados_faturamento['ItensFaturamento'][0]['Desconto'] != '':
                    desconto = float(self.dados_faturamento['ItensFaturamento'][0]['Desconto'])
                    valor = valor - desconto
                
                nota_carne['AmountToDraw'] = valor

                return [nota_carne]
            return None

        def gera_numero_documento(self, vencimento, id_contrato):
            vencimento = datetime.date(int(vencimento.split('-')[0]),int(vencimento.split('-')[1]),int(vencimento.split('-')[2]))
            vencimento = vencimento.strftime("%m%y")
            numero = "{}{}".format(vencimento,id_contrato)
            if len(numero) > 10:
                id_contrato = id_contrato[(len(id_contrato)-6):]
                numero = "{}{}".format(vencimento,id_contrato)
            return numero.zfill(10)

        def atualiza_faturamento_adapter(self,cnx,itens_faturamento,id_documento_sap,id_usuario_tarefa):
            ids_faturamentos = []
            for faturamento in itens_faturamento:
                ids_faturamentos.append(faturamento['IDFaturamentoMes'])
            atualizou = db.atualiza_faturamento_integracao(cnx,'S',ids_faturamentos,id_documento_sap)
            if atualizou:
                acao = "FATURAMENTO ATUALIZADO\nO faturamento ja havia sido integrado e a nota ja foi gerada.\nFaturamento atualizado no Adapter"
                db.insere_log_integracao(cnx,acao,'CADASTRO',ids_faturamentos,id_usuario_tarefa)
            else:
                self.lock.acquire()
                self.erros.append[','.join(str(id) for id in ids_faturamentos)] = "O faturamento ja havia sido integrado e a nota ja foi gerada.\nErro ao atualizar no banco"
                self.lock.release()
        
        def realiza_intergracao_faturamento(self,json_sap):
            senha = self.dados_faturamento['ServidorIntegracao']['Senha'].decode("utf-8")
            self.url = '{}:{}/api/Invoice/NovaNotaSaida'.format(self.dados_faturamento['ServidorIntegracao']['URL'],self.dados_faturamento['ServidorIntegracao']['Porta'])
            inicio = time.time()
            r = requests.post(self.url, json=json_sap,headers={'Connection': 'close', 'Content-Type': 'application/json'},auth=requests.auth.HTTPBasicAuth(self.dados_faturamento['ServidorIntegracao']['Login'], senha))
            self.response = r.json()
            fim = time.time()
            self.tempo_resposta = abs(fim - inicio)  # Em ms

            if r.status_code != 200:
                r.close()
                raise ValueError("Erro ao integrar os dados do faturamento ao SAP. O servidor nao conseguiu processar a requisiçao")
            r.close()
            self.resposta_SAP = None
            if 'message' in self.response:
                self.resposta_SAP = self.response['message']
            elif 'Message' in self.response:
                self.resposta_SAP = self.response['Message']
            else:
                self.resposta_SAP = 'Nao identificada'
            
            self.data_SAP = None
            if 'data' in self.response:
                self.data_SAP = self.response['data']
            elif 'Data' in self.response:
                self.data_SAP = self.response['Data']
            else:
                self.data_SAP = 'Nao identificada'
			
            if 'status' not in self.response or self.response['status'] != '0':
                if 'status' in self.response and self.response['status'] == '1':
                    if 'Fatura do Adapter Ja Existe no SAP' in self.resposta_SAP or 'Numero do Documento existente no SAP' in self.resposta_SAP:
                        doc_sap = self.resposta_SAP[self.resposta_SAP.rindex(':')+2:len(self.resposta_SAP)].strip()
                        if doc_sap is not None and doc_sap != '':
                            id_documento_sap = int(doc_sap)
                            db.atualiza_faturamento_integracao(self.cnx,'S',self.id_faturamentos_inseridos_documento,id_documento_sap)
                        else:
                            self.erro_sap = True
                    else:
                        self.erro_sap = True
                else:
                    self.erro_sap = True
                if self.erro_sap:
                    raise ValueError('Erro do SAP: {}'.format(self.resposta_SAP))
            else:
                print('AAAAAAAA')
                nota = self.response['data']
                id_documento_sap = int(nota['DocEntry'])
                print(self.id_faturamentos_inseridos_documento)
                db.atualiza_faturamento_integracao(self.cnx,'S',self.id_faturamentos_inseridos_documento,id_documento_sap)
                acao = '''DADOS DE FATURAMENTO ENVIADOS AO SAP
                    # URL: {}
                    # Resposta: {}
					# Data: {}
					# Tempo de resposta: {} segundos
					# Dados enviados:\n{}\n
					# Dados recebidos:\n{}
                '''.format(self.url,self.resposta_SAP,self.data_SAP,self.tempo_resposta,json_sap,self.response)
                db.insere_log_integracao(self.cnx,acao,'CADASTRO',self.id_faturamentos_inseridos_documento,int(self.dados_faturamento['IDUsuarioTarefas']))