# -*- coding: utf-8 -*-

import threading
import concurrent.futures
import uuid, sys
import conf, db, emailAdapter, log, controleExecucao, sap_service

def agrupa_faturamentos(lista_faturamentos):
    lista_a_faturar = []
    chave = None
    dados_auxiliar = {}
    dados_agrupados_faturamento = {}
    for faturamento in lista_faturamentos:
        if faturamento['CodigoModeloNF'] == '99':
            chave = "{}|{}|{}|{}|{}|{}".format(faturamento['IDFormaCobranca'],faturamento['DataVencimento'],faturamento['IDModeloNotaFiscal'],faturamento['IDCliente'],
            faturamento['ItemCodeSap'],faturamento['IDEmpresa'])
        else:
            chave = "{}|{}|{}|{}|{}".format(faturamento['IDFormaCobranca'],faturamento['DataVencimento'],faturamento['IDModeloNotaFiscal'],faturamento['IDCliente'],
            faturamento['IDEmpresa'])
        lista_a_faturar = []
        if chave in dados_auxiliar:
            lista_a_faturar = dados_auxiliar[chave]
        lista_a_faturar.append(faturamento)
        dados_auxiliar[chave] = lista_a_faturar
    
    lista_temp = []
    nota_fatura_unica = 0
    for key in dados_auxiliar.keys():
        lista_temp = dados_auxiliar[key]
        nota_fatura_unica = 0
        for fatu in lista_temp:
            if 'FaturaUnica' in fatu and fatu['FaturaUnica'] == 1:
                nota_fatura_unica = 1
                break
        dados_agrupados_faturamento["{}|{}".format(key,nota_fatura_unica)] = lista_temp
    
    dados_auxiliar = {}
    lista_temp = []
    for key in dados_agrupados_faturamento.keys():
        lista_temp = dados_agrupados_faturamento[key]
        nota_fatura_unica = int(key[-1])
        if nota_fatura_unica == 0:
            for fatu in lista_temp:
                if fatu['CodigoModeloNF'] == '99':
                    chave = "{}|{}|{}|{}|{}|{}|0".format(fatu['IDFormaCobranca'],fatu['DataVencimento'],fatu['IDModeloNotaFiscal'],
                        fatu['ItemCodeSap'],fatu['IDEmpresa'],fatu['IDContrato'])
                else:
                    chave = "{}|{}|{}|{}|{}|0".format(fatu['IDFormaCobranca'],fatu['DataVencimento'],fatu['IDModeloNotaFiscal'],
                    fatu['IDEmpresa'], fatu['IDContrato'])
                lista_a_faturar = []
                if chave in dados_auxiliar:
                    lista_a_faturar = dados_auxiliar[chave]
                lista_a_faturar.append(fatu)
                dados_auxiliar[chave] = lista_a_faturar
        else:
            dados_auxiliar[key] = lista_temp
    return dados_auxiliar

def forma_lista_integracao(servidor_integracao,formas_cobranca,faturamentos,controlAccount,cardCodeDocumento,id_usuario_tarefas):
    lista_integracao = []
    faturamento = {}
    for key in faturamentos.keys():
        id_forma_cobranca = int(key.split("|")[0])
        codigo_forma_cobranca_sap = ''
        for forma in formas_cobranca:
            if forma['IDFormaCobranca'] == id_forma_cobranca:
                codigo_forma_cobranca_sap = forma['CodigoSap'] if 'CodigoSap' in forma and forma['CodigoSap'] is not None else ""
                break
        vencimento = key.split("|")[1]
        id_cliente = int(faturamentos[key][0]['IDCliente'])
        id_contrato = int(faturamentos[key][0]['IDContrato'])
        numero_cfop = int(faturamentos[key][0]['NumeroCFOP'])
        id_filial_sap = faturamentos[key][0]['IDFilialSap']  if faturamentos[key][0]['IDFilialSap'] is not None else 1
        itens_faturamento = faturamentos[key]
        id_documento_sap = int(faturamentos[key][0]['IDDocumentoSap']) if faturamentos[key][0]['IDDocumentoSap'] is not None else None
        lista_integracao.append({ 'Vencimento':vencimento, 'IDContrato':id_contrato, 'IDCliente':id_cliente, 'IDFilialSAP':id_filial_sap, 'NumeroCFOP':numero_cfop,
                                  'CodigoFormaCobrancaSAP':codigo_forma_cobranca_sap, 'IDDocumentoSAP':id_documento_sap, 'ItensFaturamento':itens_faturamento, 'UUID':str(uuid.uuid4()),
                                  'ControlAccount':controlAccount, 'CardCodeDocumento':cardCodeDocumento, 'ServidorIntegracao':servidor_integracao, 'IDUsuarioTarefas':id_usuario_tarefas})
    return lista_integracao
    
def main(args):
    cf = conf.open_conf()
    log.log_config(int(cf['app']['log_level']))
    log.log.info('=========== * Iniciando integracao de faturamenotos SAP * ===========')

    controle_dados = None
    ids_faturamentos = None
    log.log.info('=========== * Verificando tipo de parametro para executar a rotina * ===========')
    if str(args[1]) != '-1':
        log.log.info('=========== * Por controle * ===========')
        controle_dados = controleExecucao.obtem_dados_controle(cf, args[1])
    else:
        log.log.info('=========== * Por IDs de faturamentos * ===========')
        ids_faturamentos = args[2]

    pool = db.create_pool(cf['db']['host'], cf['db']['database'], cf['db']['port'], cf['db']['user'],cf['db']['password'])
    cnx = db.connect_db(pool)

    log.log.info('=========== * Buscando servidor de integracao * ===========')
    servidor_integracao = db.busca_servidor_integracao(cnx,cf['db']['database_gateway'])
    
    if servidor_integracao is None or servidor_integracao['URL'] is None:
        raise ValueError("O Servidor de Integracao nao esta configurado corretamente")

    log.log.info('=========== * Buscando faturamentos a ser integrados * ===========')
    lista_faturamentos = db.busca_faturamentos(cnx,controle_dados,cf['db']['database_comercial'],cf['db']['database_terceiros'],ids_faturamentos)
    
    log.log.info('=========== * Validando se possui faturamentos a ser integrados * ===========')
    if lista_faturamentos is not None and len(lista_faturamentos) > 0:
        log.log.info("Quantidade de linhas de faturamento: {}".format(len(lista_faturamentos)))
        log.log.info('=========== * Agrupando os faturamentos * ===========')
        faturamentos = agrupa_faturamentos(lista_faturamentos)
        log.log.info('=========== * Buscando chaves de configuracoes para integracao * ===========')
        controlAccount = db.busca_valor_configuracao_chave(cnx,'CONTROL_ACCOUNT_FATURAMENTO_SAP',cf['db']['database'])
        cardCodeDocumento = db.busca_valor_configuracao_chave(cnx,'CARDCODE_DOCUMENTO_INTEGRACAO_CLIENTES_SAP',cf['db']['database_comercial'])
        id_usuario_tarefa = db.busca_valor_configuracao_chave(cnx,'ID_USUARIO_TAREFAS_AUTOMATICAS',cf['db']['database_comercial'])
        formas_cobranca = db.busca_formas_cobranca(cnx)
        log.log.info('=========== * Formatando a lista para integrar * ===========')
        lista_integracao = forma_lista_integracao(servidor_integracao,formas_cobranca,faturamentos,controlAccount,cardCodeDocumento,id_usuario_tarefa)
        
        erros = {}
        centro_custo_contratos = {}
        lock = threading.Lock()

        log.log.info('=========== * Iniciando o processo de integracao dos faturamentos ao SAP * ===========')
        with concurrent.futures.ThreadPoolExecutor(max_workers=int(cf['app']['max_workers'])) as executor:
            for integrar in lista_integracao:
                log.log.info('=========== * Enviando para integrar: {} * ==========='.format(integrar['UUID']))
                future = executor.submit(sap_service.SapService(pool, integrar, erros, centro_custo_contratos, lock, log, cf).integrar)
        log.log.info('=========== * Finalizando o processo de integracao dos faturamentos ao SAP * ===========')
        if len(erros) > 0:
            log.log.info('=========== * Enviando email com os erros de integracao * ===========')
            emailAdapter.send_email(cf,emailAdapter.cria_mensagem(erros))
    else:
        log.log.info('=========== * Nao possui faturamentos a serem integrados * ===========')

    if controle_dados is not None:
        controle_dados = controleExecucao.finaliza_execucao_controle(cf, args[1], 'FINALIZADO')

    db.close_connect_db(cnx)
    
    log.log.info('=========== * Finalizando integracao de faturamenotos SAP * ===========')

    exit()


if __name__ == '__main__':
    main(sys.argv)
