# -*- coding: utf-8 -*-

import log
from mysql.connector import Error
from mysql.connector import pooling
def create_pool(host='localhost', database='information_schema', port=3306, user='root', password=''):
    return pooling.MySQLConnectionPool(pool_name="pynative_pool",
                                                  pool_size=32,
                                                  pool_reset_session=True,
                                                  host=host,
                                                  database=database,
                                                  user=user,
                                                  password=password,
                                                  port=port)

def connect_db(pool):
    try:
        return pool.get_connection()
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados: %s' % e)

def close_connect_db(cnx):
    try:
        if cnx.is_connected():
            cnx.close()
        log.log.info('- Fechando a conexão com o banco de dados...')
    except Exception as e:
        log.log.error('Falha ao finalizar a conexão com o banco de dados: %s' % e)

def busca_faturamentos(cnx,parametros, banco_comercial, banco_terceiros, id_faturamento = None):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(monta_consulta_find_faturamentos(parametros, banco_comercial, banco_terceiros, id_faturamento))
        faturamentos = cur.fetchall()
        cur.close()
        return faturamentos
    except Exception as e:
        log.log.error('Falha ao buscar os faturamentos: %s' % e)
        return None

def busca_formas_cobranca(cnx):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT * FROM TB_FormaCobranca")
        faturamentos = cur.fetchall()
        cur.close()
        return faturamentos
    except Exception as e:
        log.log.error('Falha ao buscar as formas de cobranca: %s' % e)
        return None

def busca_valor_configuracao_chave(cnx, chave, banco):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT ValorConfiguracao FROM {}.TB_Configuracoes WHERE ChaveConfiguracao = '{}'".format(banco,chave))
        valor = cur.fetchone()
        cur.close()
        return valor['ValorConfiguracao']
    except Exception as e:
        log.log.error('Falha ao buscar o dado da chave de configuracao: %s' % e)
        return None

def monta_consulta_find_faturamentos(parametros, banco_comercial, banco_terceiros, id_faturamento = None):
    sql = '''
     SELECT f.*, cnn.SequenceCodeSap, cnn.UsageSap, c.ItemCodeSap, cf.NumeroCFOP, CONCAT(con.IDContrato, " - ", p.DescricaoPlano) as Contrato, 
			 SUBSTRING(f.Descricao, POSITION('(' IN f.Descricao), LENGTH(f.Descricao)) as Periodo, con.ObservacaoFiscal, e.IDFilialSap, mnf.CodigoModelo as CodigoModeloNF, 
			 dvc.Numero, vel.Descricao as Velocidade, cli.CPF, cli.CNPJ, e.IDEmpresa, c.TipoTribitarioSAP 
			 FROM TB_FaturamentoMes f -- FORCE INDEX(DataGeracaoFaturamento)
			 INNER JOIN TB_Composicao c ON f.IDComposicao = c.IDComposicaoServico 
			 INNER JOIN TB_FormaCobranca fc ON f.IDFormaCobranca = fc.IDFormaCobranca 
			 INNER JOIN TB_ContaFinanceira contaf ON fc.IDContaFinanceira = contaf.IDContaFinanceira 
			 INNER JOIN TB_ControleNumeroNota cnn ON cnn.IDModeloNotaFiscal = f.IDModeloNotaFiscal AND cnn.IDEmpresa = contaf.IDEmpresa
			 INNER JOIN TB_ModeloNotaFiscal mnf ON mnf.IDModeloNotaFiscal = f.IDModeloNotaFiscal 
			 INNER JOIN {0}.TB_Cliente cli ON f.IDCliente = cli.IDCliente 
			 INNER JOIN {0}.TB_CFOP cf ON cli.IDCFOP = cf.IDCFOP 
			 INNER JOIN {0}.TB_Contrato con ON f.IDContrato = con.IDContrato 
             INNER JOIN {0}.TB_StatusContrato sc ON sc.IDStatusContrato = con.IDStatusContrato 
			 INNER JOIN {0}.TB_Plano p ON con.IDPlano = p.IDPlano 
			 LEFT JOIN {0}.TB_DadosVozContrato dvc ON con.IDDadosVozContrato = dvc.IDDadosVozContrato 
			 LEFT JOIN {0}.TB_DadosRedeContrato drc ON drc.IDDadosRedeContrato = con.IDDadosRedeContrato 
			 LEFT JOIN {0}.TB_VelocidadeConexaoRadius vcr ON vcr.IDVelocidadeConexaoRadius = drc.IDVelocidadeConexaoRadius 
			 LEFT JOIN {0}.TB_Velocidade vel ON vel.IDVelocidade = vcr.IDVelocidade 
			 LEFT JOIN {1}.TB_Empresa e ON contaf.IDEmpresa = e.IDEmpresa 
             
    '''.format(banco_comercial,banco_terceiros)
    if parametros is not None:
        pagamento = [ parametro['ValorParametro'] if 'ValorParametro' in parametro and parametro['ValorParametro'] is not None else '0' for parametro in parametros if parametro['NomeParametro'] == 'POSSUI_PAGAMENTO']
        if(pagamento is not None and len(pagamento) > 0 and pagamento[0] is not None and str(pagamento[0]) == '1'):
            sql = '{}\n{}\n'.format(sql,' INNER JOIN TB_Fatura fat ON fat.IDFatura = f.IDFatura ')
            
    sql = ''' {}\nWHERE f.IDDocumentoSap IS NULL AND f.IsCancelado = 0\n '''.format(sql)        
    
    if id_faturamento is not None:
        sql = '{} AND f.IDFaturamentoMes IN ({})\n'.format(sql,id_faturamento)
    elif parametros is not None:
        for parametro in parametros:
            if parametro['NomeParametro'] == 'STATUS_INTEGRACAO_SAP':
                if parametro['ValorParametro'] == "'TODOS'":
                    sql = "{} AND (f.isIntegrado IS NULL OR f.isIntegrado IN ('N','E')) \n".format(sql)
                else:
                    sql = "{} AND f.isIntegrado IN ({}) \n".format(sql,parametro['ValorParametro'])
            elif parametro['NomeParametro'] == 'DATA_VENCIMENTO_INICIO':
                 sql = "{} AND f.DataVencimento >= '{}' \n".format(sql,trata_data(parametro['ValorParametro']))
            elif parametro['NomeParametro'] == 'DATA_VENCIMENTO_FIM':
                 sql = "{} AND f.DataVencimento <= '{}' \n".format(sql,trata_data(parametro['ValorParametro']))
            elif parametro['NomeParametro'] == 'DATA_GERACAO_INICIO':
                 sql = "{} AND DATE(f.DataGeracaoFaturamento) >= '{}' \n".format(sql,trata_data(parametro['ValorParametro']))
            elif parametro['NomeParametro'] == 'DATA_GERACAO_FIM':
                 sql = "{} AND DATE(f.DataGeracaoFaturamento) <= '{}' \n".format(sql,trata_data(parametro['ValorParametro']))
            elif parametro['NomeParametro'] == 'ID_CLIENTE':
                 sql = "{} AND f.IDCliente = {} \n".format(sql,parametro['ValorParametro'])
            elif parametro['NomeParametro'] == 'CPF':
                 sql = "{} AND c.CPF = '{}' \n".format(sql,parametro['ValorParametro'])
            elif parametro['NomeParametro'] == 'CNPJ':
                 sql = "{} AND c.CNPJ = '{}' \n".format(sql,parametro['ValorParametro'])
            elif parametro['NomeParametro'] == 'NOME_CLIENTE':
                 sql = "{} AND c.Nome LIKE '%{}%' \n".format(sql,parametro['ValorParametro'])
            elif parametro['NomeParametro'] == 'ID_CONTRATO':
                sql = "{} AND f.IDContrato = {} \n".format(sql,parametro['ValorParametro'])
            elif parametro['NomeParametro'] == 'ID_FORMA_COBRANCA':
                sql = "{} AND f.IDFormaCobranca = {} \n".format(sql,parametro['ValorParametro'])
            elif parametro['NomeParametro'] == 'IS_CARNE':
                sql = "{} AND fc.IsCarne = {} \n".format(sql,parametro['ValorParametro'])
                if('ValorParametro' in parametro and parametro['ValorParametro'] is not None and str(parametro['ValorParametro']) == '1'):
                    sql = "{} AND sc.DescricaoStatusContrato NOT IN ('SUSPENSO', 'HABILITADO EM CONFIANCA') \n".format(sql)
            elif parametro['NomeParametro'] == 'ID_FATURAMENTO_MES':
                sql = "{} AND f.IDFaturamentoMes IN ({}) \n".format(sql,parametro['ValorParametro'])
            elif parametro['NomeParametro'] == 'POSSUI_PAGAMENTO' and 'ValorParametro' in parametro and parametro['ValorParametro'] is not None and str(parametro['ValorParametro']) == '1':
                sql = "{} AND fat.DataPagamento IS NOT NULL  \n".format(sql)
    return sql


def busca_servidor_integracao(cnx,banco_gateway):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''
            SELECT
                URL, Porta, Login, AES_DECRYPT(Senha,'F583BE47632CEE39') as Senha 
            FROM
                {0}.TB_Configuracoes conf 
            INNER JOIN
                {0}.TB_ServidorIntegracao si ON conf.ValorConfiguracao = si.IDServidorIntegracao
            WHERE conf.ChaveConfiguracao = 'ID_SERVIDOR_INTEGRACAO'
        '''.format(banco_gateway))
        servidor = cur.fetchone()
        cur.close()
        return servidor
    except Exception as e:
        log.log.error('Falha ao buscar o Servidor de Integracao SAP: %s' % e)
        return None

def fatura_carne_sap_id_faturamento(cnx,id_faturamento):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''
            SELECT DocEntry FROM TB_FaturaCarneSAP c
            INNER JOIN TB_Fatura f ON TRIM(f.codfat) = c.Codfat
            INNER JOIN TB_FaturamentoMes fm ON fm.IDFatura = f.IDFatura
            WHERE fm.IDFaturamentoMes = {} 
        '''.format(id_faturamento))
        doc_entry = cur.fetchone()
        cur.close()
        return doc_entry['DocEntry']
    except Exception as e:
        log.log.error('Falha ao buscar os dados da fatura carne sap: %s' % e)
        return None

def busca_centro_custo_contrato(cnx,banco_comercial,banco_terceiros,id_contrato):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute('''
            SELECT ecli.TipoEndereco, cid.CostingCodeSap
					FROM {0}.TB_Contrato c 
					JOIN {0}.TB_EnderecoContrato ec ON ec.IDContrato = c.IDContrato 
					JOIN {0}.TB_EnderecoCliente ecli ON ec.IDEnderecoCliente = ecli.IDEnderecoCliente 
					JOIN {1}.TB_Endereco e ON ecli.IDEndereco = e.IDEndereco 
					JOIN {1}.TB_Bairro b ON e.IDBairro = b.IDBairro 
					JOIN {1}.TB_Cidade cid ON b.IDCidade = cid.IDCidade
					WHERE c.idContrato = {2}
					GROUP BY ecli.TipoEndereco
        '''.format(banco_comercial,banco_terceiros,id_contrato))
        servidor = cur.fetchall()
        cur.close()
        return servidor
    except Exception as e:
        log.log.error('Falha ao buscar o centro de custo do contrato: %s' % e)
        return None

def atualiza_faturamento_integracao(cnx, is_integrado, ids_faturamento_mes, id_documento_sap = None):
    try:

        atualiza_sql = " UPDATE TB_FaturamentoMes f SET f.IsIntegrado = '{}' ".format(is_integrado)

        if id_documento_sap is not None:
            atualiza_sql = "{}, f.IDDocumentoSap = {}".format(atualiza_sql,id_documento_sap)
        print(atualiza_sql)
        atualiza_sql = "{} WHERE f.IDFaturamentoMes IN ({})".format(atualiza_sql,','.join(str(id) for id in ids_faturamento_mes))
        print(atualiza_sql)
        cur = cnx.cursor()
        cur.execute(atualiza_sql)
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Falha ao atualizar o faturamento Mes: %s' % e)
        return False

def insere_log_integracao(cnx, acao, tipo_acao, ids_faturamentos, id_usuario_tarefa):
    try:
        cur = cnx.cursor()
        cur.execute('''
            INSERT INTO TB_LogIntegracaoFaturamento (Acao, TipoAcao, DataLog, IDFaturamentoMes, IDUsuario) 
            VALUES (%s, %s, NOW(), %s, %s)
        
        ''',(acao, tipo_acao, ','.join(str(id) for id in ids_faturamentos),id_usuario_tarefa))
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Falha ao remover o atributo de suspenso no radius: %s' % e)
        return False

def trata_data(valor):
    valores = valor.split('-')
    return '{}-{}-{}'.format(valores[2],valores[1],valores[0])
