# -*- coding: utf-8 -*-

import log, db_rotina
import os



def obtem_dados_controle(configuracao,id_controle):
    dados = []
    cnx = db_rotina.connect_db(configuracao['db']['host'], configuracao['db']['database_rotinas'], configuracao['db']['port'], configuracao['db']['user'],
                        configuracao['db']['password'])
    
    dados = db_rotina.busca_dados(cnx,id_controle)
    atualizado = db_rotina.atualiza_status_pid_controle(cnx,id_controle,'EM_EXECUCAO',os.getpid())

    if not atualizado:
        raise ValueError("Erro ao atualizar o Status do controle: {}".format(id_controle))

    db_rotina.close_connect_db(cnx)

    return dados

def finaliza_execucao_controle(configuracao,id_controle, status):
    dados = []
    cnx = db_rotina.connect_db(configuracao['db']['host'], configuracao['db']['database_rotinas'], configuracao['db']['port'], configuracao['db']['user'],
                        configuracao['db']['password'])
    
    atualizado = db_rotina.atualiza_status_data_fim_controle(cnx,id_controle,status)

    if not atualizado:
        raise ValueError("Erro ao atualizar o Status do controle: {}".format(id_controle))

    db_rotina.close_connect_db(cnx)