# -*- coding: utf-8 -*-
from urllib.parse import urlparse
import log
import mysql.connector as myc


def connect_db(host='localhost', database='information_schema', port=3306, user='root', password=''):
    try:
        log.log.info('- Abrindo conexão com o host "%s", porta "%s"e banco de dados "%s"' %
                     (str(host), str(port), str(database)))
        return myc.connect(host=host, database=database, port=port, user=user, password=password)
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados: %s' % e)


def extratoperiodo(cnx, con_radios, day, month):
    try:
        cur = cnx.cursor(buffered=True)
        cur.execute("SELECT CONCAT('REPLACE INTO TB_DadosNavegacao (DataColeta,Download,DuracaoSessao,FimSessao,InicioSessao,IPCliente,IPNas,LoginRadius,MACCliente,IDRadacct,Upload,IsProcessado,CircuitID,MotivoDesconexao,IDConexaoRadius,Chave) VALUES (', IFNULL(CONCAT('\"', DataColeta, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', Download, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', DuracaoSessao, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', FimSessao, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', InicioSessao, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', IPCliente, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', IPNas, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', LoginRadius, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', MACCliente, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', IDRadacct, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', Upload, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', IsProcessado, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', CircuitID, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', MotivoDesconexao, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', IDConexaoRadius, '\"'), 'NULL'), ',', IFNULL(CONCAT('\"', Chave, '\"'), 'NULL'), ')' ) AS InsertDadosNavegacao FROM (SELECT CURRENT_TIMESTAMP AS DataColeta, rc.acctoutputoctets AS Download, IF( rc.acctstoptime IS NOT NULL, TIMESTAMPDIFF(SECOND, rc.acctstarttime, rc.acctstoptime), TIMESTAMPDIFF(SECOND, rc.acctstarttime, CURRENT_TIMESTAMP) ) AS DuracaoSessao, rc.acctstoptime AS FimSessao, rc.acctstarttime AS InicioSessao, rc.framedipaddress AS IPCliente, rc.nasipaddress AS IPNas, rc.username AS LoginRadius, REPLACE(rc.callingstationid, '-', ':') AS MACCliente, rc.radacctid AS IDRadacct, rc.acctinputoctets AS Upload, 0 AS IsProcessado, rc.nasportid AS CircuitID, rc.acctterminatecause AS MotivoDesconexao, %s AS IDConexaoRadius, rc.acctuniqueid AS Chave FROM radius.radacct rc WHERE(rc.acctstoptime IS NULL OR rc.acctstoptime > DATE_SUB(CURRENT_TIMESTAMP, INTERVAL %s DAY)) AND rc.acctstarttime > DATE_SUB(CURRENT_TIMESTAMP, INTERVAL %s MONTH)) dn" % (con_radios, day, month))
        return cur.fetchall()
    except Exception as e:
        log.log.error(
            'Falha ao realizar uma consulta no banco de dados: %s' % e)


def inserirDadosNavegacao(cnx, query):
    try:
        cur = cnx.cursor()
        cur.execute(query)
        return True
    except Exception as e:
        log.log.error(
            'Falha ao realizar uma replicacao no banco de dados: %s' % e)


def conexoesRadius(cnx):
    try:
        cur = cnx.cursor(buffered=True)
        cur.execute(
            "SELECT IDConexaoRadius, PersistenceUnit from TB_ConexaoRadius WHERE Ativa = 1")
        return cur.fetchall()
    except Exception as e:
        log.log.error(
            'Falha ao retornar identificadores das conexoes radius %s' % e)


def busca_dados_servidor_integracao_by_ID(cnx, pu):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
            "SELECT IDServidorIntegracao, URL, Login, AES_DECRYPT(Senha,'F583BE47632CEE39') as Senha, Porta, DatabaseName FROM TB_ServidorIntegracao WHERE Descricao = (%s)", (pu,))
        return cur.fetchall()[0]
    except Exception as e:
        log.log.error(
            'Falha ao buscar servidor de integracao: %s' % e)


# Fecha a conexão com o banco de dados
def close_connect_db(cnx):
    try:
        cnx.close()
        log.log.info('- Fechando a conexão com o banco de dados...')
    except Exception as e:
        log.log.error(
            'Falha ao finalizar a conexão com o banco de dados: %s' % e)
