# -*- coding: utf-8 -*-
import db, conf, json, dbRadius, dbVSC, log
import habilitarcontratos

class HabilitaContrato():
        def __init__(self, pool, dados_contrato, loginsDesconectar, timeout, sucessos, erros, lock, log, cf):
            self.pool = pool
            self.dados_contrato = dados_contrato
            self.loginsDesconectar = loginsDesconectar
            self.timeout = timeout
            self.lock = lock
            self.log = log
            self.cf = cf
            self.sucessos = sucessos
            self.erros = erros
            
        def habilitaContrato(self):
            dados_contrato = self.dados_contrato
            log = self.log 
            cf = self.cf
            alteraAdapter = None
            sucessos = self.sucessos
            erros = self.erros
            timeout = self.timeout
            dados_vsc = None
            dados_radius = None
            cnxRadius = None
            cnxVsc = None
            cnx = None
            tipo_integracao = None
            alteraAdapter = None
            try:
                try:
                    banco_gateway = cf['db']['database_gateway']
                    cnx = db.connect_db(self.pool)
                    log.log.info('%s: Contrato %s' % (dados_contrato['TipoTecnologia'], dados_contrato['IDContrato']))
                    if(str(dados_contrato['TipoTecnologia']) == 'INTERNET'):
                        tipo_integracao = 'RADIUS'
                        try:

                            if(dados_contrato['PersistenceUnit'] is None):
                                raise ValueError('O Contrato: {}, não possui vinculo com o Radius para realizar a habilitação.'.format(dados_contrato['IDContrato']))
                            if(dados_contrato['Autenticacao'] is None):
                                raise ValueError('O Contrato: {}, não possui o login configurado.'.format(dados_contrato['IDContrato']))

                            if(int(dados_contrato['IntegraRadius']) == 1):
                                tipo_integracao = 'RADIUS'
                                dados_radius = db.busca_dados_servidor_integracao(cnx, banco_gateway, dados_contrato['PersistenceUnit'])
                                cnxRadius = dbRadius.connect_db(dados_radius[0]['URL'],dados_radius[0]['DatabaseName'],dados_radius[0]['Porta'],
                                dados_radius[0]['Login'], dados_radius[0]['Senha'],timeout)

                                print(isinstance(cnxRadius,str))
                                if(isinstance(cnxRadius,str)):
                                    raise ValueError(cnxRadius)

                                if(dados_contrato['RemocaoAtributosRadius'] is not None):
                                    camposRadiusRemocao = json.loads(dados_contrato['RemocaoAtributosRadius'])
                                    for tabela in camposRadiusRemocao.keys(): 
                                        for linha in camposRadiusRemocao[tabela]:
                                            sql = montaSQLDelete(linha,tabela)
                                            alteraAdapter = dbRadius.atualizacao_atributos(cnxRadius, sql)
                                            if(not alteraAdapter['Sucesso']):
                                                raise ValueError('Nao foi possivel atualizar os atributos do radius do Contrato %s\n%s' % (dados_contrato['IDContrato'],alteraAdapter['Erro']))
                                
                                if(dados_contrato['InsercaoAtributosRadius'] is not None):
                                    camposRadiusAdicao = json.loads(dados_contrato['InsercaoAtributosRadius'])                        
                                    for tabela in camposRadiusAdicao.keys(): 
                                        for linha in camposRadiusAdicao[tabela]:
                                            sql = montaSQLInsert(linha,tabela)
                                            if sql is not None:
                                                alteraAdapter = dbRadius.atualizacao_atributos(cnxRadius, sql)
                                                if(not alteraAdapter['Sucesso']):
                                                    raise ValueError('Nao foi possivel atualizar os atributos do radius do Contrato %s\n%s' % (dados_contrato['IDContrato'],alteraAdapter['Erro']))
                                
                                self.lock.acquire()
                                for item in self.loginsDesconectar:
                                    if(item['PU'] == dados_contrato['PersistenceUnit']):
                                        item['Logins'].append({'Login': dados_contrato['Autenticacao'],
                                                        'IDContrato': dados_contrato['IDContrato']})
                                        break
                                self.lock.release()
                                if(cnxRadius is not None and not isinstance(cnxRadius,str)):
                                    dbRadius.close_connect_db(cnxRadius)
                            
                        except Exception as error:
                            alteraAdapter = {'Sucesso': False,
                                             'IDContrato': dados_contrato['IDContrato'],
                                             'DescricaoConexaoRadiusVSC': dados_contrato['PersistenceUnit'],
                                             'Erro' : 'Erro no radius: {}'.format(error), 'Integracao': tipo_integracao}
                            log.log.error('Falha ao tentar alterar os atributos no radius referente ao contrato %s: %s' % (dados_contrato['IDContrato'], error))
                            if(cnxRadius is not None and not isinstance(cnxRadius,str)):
                                dbRadius.close_connect_db(cnxRadius)
                    
                    elif(str(dados_contrato['TipoTecnologia']) == 'TELEFONIA'):
                        tipo_integracao = 'VSC'
                        try:

                            if dados_contrato['PersistenceUnit'] is None:
                                raise ValueError('O Contrato: {}, não possui vinculo com a VSC para realizar a habilitação.'.format(dados_contrato['IDContrato']))
                            if dados_contrato['Autenticacao'] is None:
                                raise ValueError('O Contrato: {}, não possui o ControlNumber configurado.'.format(dados_contrato['IDContrato']))
                            if dados_contrato['IDBatch'] is None:
                                raise ValueError('O Contrato: {}, não possui a configuração do Batch de suspensão.'.format(dados_contrato['IDContrato']))

                            if(int(dados_contrato['IntegraVSC']) == 1 ):
                                tipo_integracao = 'VSC'
                                dados_vsc = db.busca_dados_servidor_integracao(cnx, banco_gateway, dados_contrato['PersistenceUnit'])
                                cnxVsc = dbVSC.connect_db(dados_vsc[0]['URL'],dados_vsc[0]['DatabaseName'],dados_vsc[0]['Porta'], dados_vsc[0]['Login'], dados_vsc[0]['Senha'] )
                                if(isinstance(cnxVsc,str)):
                                    raise ValueError(cnxVsc)      
                                alteraAdapter = dbVSC.update_batch(cnxVsc, dados_contrato['IDBatch'], dados_contrato['Autenticacao'])
                                if(not alteraAdapter['Sucesso']):
                                    raise ValueError('Nao foi possivel atualizar os atributos do batch na VSC do Contrato %s' % dados_contrato['IDContrato'])
                                alteraAdapter = dbVSC.habilita_user(cnxVsc, dados_contrato['Autenticacao'])
                                if(not alteraAdapter['Sucesso']):
                                    raise ValueError('Nao foi possivel atualizar os atributos User na VSC do Contrato %s' % dados_contrato['IDContrato'])
                                if(cnxVsc is not None and not isinstance(cnxVsc,str)):
                                    dbVSC.close_connect_db(cnxVsc)
                        except Exception as error:
                            alteraAdapter = {'Sucesso': False, 'Erro' : 'Erro na VSC: {}'.format(error), 'Integracao': tipo_integracao}
                            log.log.error('Falha ao tentar alterar os atributos na VSC referente ao contrato %s: %s' % (dados_contrato['IDContrato'], error))
                            if(cnxVsc is not None and not isinstance(cnxVsc,str)):
                                dbVSC.close_connect_db(cnxVsc)
                    else:
                        alteraAdapter = {'Sucesso': True}
                        alteraAdapter['IDContrato'] = dados_contrato['IDContrato']
                        alteraAdapter['DescricaoConexaoRadiusVSC'] = dados_contrato['PersistenceUnit']
                
                    if(alteraAdapter['Sucesso']):
                        try:        
                            atualizou = db.update_contrato_and_log(cnx, dados_contrato['AtualizaContrato'])
                            if(not atualizou['Sucesso']):
                                raise ValueError('Nao foi possivel atualizar o Contrato %s\n%s' % (dados_contrato['IDContrato'], atualizou['Erro']))
                            atualizou = db.update_contrato_and_log(cnx, dados_contrato['InsereLogContrato'])
                            if(not atualizou['Sucesso']):
                                raise ValueError('Nao foi possivel atualizar o Contrato %s\n%s' % (dados_contrato['IDContrato'], atualizou['Erro']))
                            log.log.info('Contrato %s habilitado com sucesso ----- ' % dados_contrato['IDContrato'])
                            cnx.commit()
                            self.lock.acquire()
                            sucessos.append(alteraAdapter)
                            self.lock.release()
                        except Exception as error:
                            alteraAdapter = {'Sucesso': False,
                                             'IDContrato': dados_contrato['IDContrato'],
                                             'DescricaoConexaoRadiusVSC': dados_contrato['PersistenceUnit'],
                                             'Erro': 'Falha ao tentar suspender o contrato %s no adapter: %s' % (dados_contrato['IDContrato'], error), 'Integracao': tipo_integracao}
                            self.lock.acquire()
                            erros.append(alteraAdapter)
                            self.lock.release()
                            insere_log(cnx,alteraAdapter)
                            log.log.error('Falha ao tentar habilitar o contrato %s no adapter: %s' % (dados_contrato['IDContrato'], error))                            
                    else:
                        alteraAdapter['IDContrato'] = dados_contrato['IDContrato']
                        alteraAdapter['DescricaoConexaoRadiusVSC'] = dados_contrato['PersistenceUnit']
                        self.lock.acquire()
                        erros.append(alteraAdapter)
                        self.lock.release()
                        insere_log(cnx,alteraAdapter)

                    db.close_connect_db(cnx)
                except Exception as error:
                    alteraAdapter = {'Sucesso': False,
                                     'IDContrato': dados_contrato['IDContrato'],
                                     'DescricaoConexaoRadiusVSC': dados_contrato['PersistenceUnit'],
                                     'Erro':'Falha ao tentar suspender o contrato %s no adapter: %s' % (dados_contrato['IDContrato'], error), 'Integracao': tipo_integracao}
                    self.lock.acquire()
                    erros.append(alteraAdapter)
                    self.lock.release()
                    insere_log(cnx,alteraAdapter)
                    log.log.error('Erro %s: %s' % (dados_contrato['IDContrato'], error))
            except Exception as error:
                log.log.error('Erro %s: %s' % (dados_contrato['IDContrato'], error))
            finally:
                if(cnx is not None):
                    db.close_connect_db(cnx)
                
                        
def montaSQLDelete(jsonLinha, tabela):
    sql = 'DELETE FROM '+tabela + ' WHERE '
    for campo in jsonLinha.keys(): 
        sql += campo + '="'+jsonLinha[campo]+'" AND '
        
    return sql[:-4]

def montaSQLInsert(jsonLinha, tabela):
    achouVazio = 0 
    sql = 'INSERT INTO  '+tabela + ' ('
    for campo in jsonLinha.keys(): 
        sql += campo + ','
    sql = sql[:-1]
    sql += ') VALUES ('
    for campo in jsonLinha.keys(): 
        sql += '"'+jsonLinha[campo]+'",'
        if '"",' in sql:
            print('entrei')
            achouVazio = 1
    sql = sql[:-1]
    sql += ')'
    if achouVazio == 1:
        return None
    return sql

def insere_log(cnx,dados):
    if('Integracao' in dados):
        if(dados['Integracao'] == 'RADIUS'):
            db.insere_log_radius(cnx,dados)
        elif(dados['Integracao'] == 'VSC'):
            db.insere_log_vsc(cnx,dados)