# -*- coding: utf-8 -*-

import smtplib
from socket import gaierror
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart

def send_email(cf,mensagem="Rotina"):
    
    port = cf['email_adapter']['porta_SMTP']
    smtp_server = cf['email_adapter']['host_SMTP']
    login = cf['email_adapter']['login_email']
    password = cf['email_adapter']['senha_email']

    sender_email = cf['email_adapter']['remetente_email']
    receiver_email = cf['email_adapter']['destinatario']

    message = MIMEMultipart("alternative")
    message["Subject"] = cf['email_adapter']['assunto']
    message["From"] = sender_email
    message["To"] = receiver_email
    # write the plain text part
    
    # convert both parts to MIMEText objects and add them to the MIMEMultipart message
    message.attach(MIMEText(mensagem, "html"))

    try:
        #send your message with credentials specified above
        server = smtplib.SMTP(str(smtp_server), int(port))
        server.login(login, password)
        server.sendmail(sender_email, receiver_email, message.as_string())
        server.close()
        # tell the script to report if your message was sent or which errors need to be fixed 
        print('Sent')
    except (gaierror):
        return 'Failed to connect to the server. Bad connection settings?'
    except smtplib.SMTPServerDisconnected:
        return 'Failed to connect to the server. Wrong user/password?'
    except smtplib.SMTPException as e:
        return 'SMTP error occurred: ' + str(e)
    except Exception as e:
        return str(e)

def cria_mensagem(sucessos = [], erros = []):
    mensagem = ""
    mensagem = "{}{}{}{}{}{}{}{}".format('''<html><head><style type='text/css'>.line:hover {background-color: #E0FFFF;} tr td {font-family: arial; vertical-align: center; 
				text-align: center; border:1px solid #598080; text-decoration: none; overflow: hidden;}
				table {width:100%; border-collapse: collapse; border-spacing: 0; border:1px #598080; border-bottom-style:solid;}
				.title {font-family: arial; font-size: 31px; font-weight: bold; border:1px solid #598080; background-color: #598080}
				.header {font-weight: bold; font-size: 10px; border:1px solid #598080; background-color: #95CECE}</style></head>''',"<body><br/>",
                "<p>Total de Contratos Habilitados: ",len(sucessos),"<br/><p>Total de contrato com erro ao habilitar: ",len(erros),
                "<br/><br/><table cellpadding='8'><tr class='title'> <td colspan='14'><p>Relação dos contratos não habilitados</p></td></tr>",
                "<tr class='header'><td>Contrato</td></tr>")
    contratos = ""
    for erro in erros:
        if erro['Sucesso']:
            contratos = "{}{}".format(contratos,"<tr class='line'><td style='font-size: 10px;'>" + str(erro['IDContrato']) + "</td></tr>")
        else:
            contratos = "{}{}".format(contratos,"<tr class='line'><td style='font-size: 10px;'>" + str(erro['IDContrato']) + " - "+ erro['Erro'] +" </td></tr>")
    mensagem = "{}{}{}".format(mensagem,contratos,"</table></body></html>")

    return mensagem