# -*- coding: utf-8 -*-

import log
import mysql.connector as myc


def connect_db(host='localhost', database='information_schema', port=3306, user='root', password=''):
    try:
        log.log.info('- Abrindo conexão com o host "%s", porta "%s" e banco de dados "%s"' % (
        str(host), str(port), str(database)))

        return myc.connect(host=host, database=database, port=port, user=user, password=password, charset='utf8',
                           use_unicode=True, pool_size=32, pool_reset_session=True)
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados: %s' % e)


def busca_contratos(cnx, idEmpresa, idOperacao, diasSuspensaoParcial, diasSuspensaoTotal, suspendeParcial,
                    valorMinimoSuspensao, tipoTecnologia, isSupendePrimeiraFatura, diasMinimosSuspensaoPrimeiraFatura):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.callproc("spuHabilitacaoContrato",
                     [idEmpresa, idOperacao, diasSuspensaoParcial, diasSuspensaoTotal, suspendeParcial,
                      valorMinimoSuspensao, tipoTecnologia, isSupendePrimeiraFatura,
                      diasMinimosSuspensaoPrimeiraFatura])
        values = [value.fetchall() for value in cur.stored_results()]
        return values[0]

    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)


def close_connect_db(cnx):
    try:
        cnx.close()
        log.log.info('- Fechando a conexão com o banco de dados...')
    except Exception as e:
        log.log.error('Falha ao finalizar a conexão com o banco de dados: %s' % e)


def update_contrato_and_log(cnx, sql):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(sql)
        cnx.commit()
        return True
    except Exception as e:
        log.log.error('Falha ao tentar atualizar contrato: %s' % e)
        return False


def busca_configuracao_suspensao(cnx):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT * FROM TB_ConfiguraSuspensao ")
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao buscar configuracoes de suspensao: %s' % e)


def busca_dados_servidor_integracao(cnx, database, pu):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
            "SELECT URL, Login, AES_DECRYPT(Senha,'F583BE47632CEE39') as Senha, DatabaseName, Porta FROM %s.TB_ServidorIntegracao WHERE TRIM(Descricao) = TRIM('%s') LIMIT 1" % (
            database, pu.upper()))
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao buscar pu para habilitacao: %s' % e)


def busca_campos_radius(cnx):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
            "SELECT * FROM TB_PersonalizacaoAtributosRadiusContrato WHERE IDPersonalizacaoAtributosRadiusContrato = 22")
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao buscar configuracoes de suspensao: %s' % e)


def busca_conexoes_radius(cnx):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT * FROM TB_ConexaoRadius")
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao buscar conexoes Radius: %s' % e)

def insere_log_vsc(cnx,dados):
    try:
        cur = cnx.cursor()
        cur.execute('INSERT INTO TB_LogIntegracaoVSC (IDContrato,Acao,TipoAcao,DataLog) VALUES (%s,"%s","HABILITACAO",NOW())' % (dados['IDContrato'],dados['Erro']))
        cnx.commit()
        return True
    except Exception as e:
        log.log.error('Falha ao inserir log vsc: %s' % e)

def insere_log_radius(cnx,dados):
    try:
        cur = cnx.cursor()
        cur.execute('INSERT INTO TB_LogIntegracaoRadius (IDContrato,Acao,TipoAcao,DataLog) VALUES (%s,"%s","HABILITACAO",NOW())' % (dados['IDContrato'],dados['Erro']))
        cnx.commit()
        return True
    except Exception as e:
        log.log.error('Falha ao inserir log radius: %s' % e)

def busca_dados_servidor_integracao_by_ID(cnx, database, id):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
            "SELECT URL, Login, AES_DECRYPT(Senha,'F583BE47632CEE39') as Senha, Porta FROM %s.TB_ServidorIntegracao WHERE IDServidorIntegracao = %s" % (
            database, id))
        return cur.fetchall()[0]
    except Exception as e:
        log.log.error('Falha ao buscar servidor de integracao para desconexao: %s' % e)


def find_valor_configuracao(cnx, params):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT ValorConfiguracao FROM %s.TB_Configuracoes WHERE ChaveConfiguracao = '%s'" % params)
        return cur.fetchall()[0]['ValorConfiguracao']
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
        return None


def insert_log_desconexao(cnx, params):
    try:
        cur = cnx.cursor()
        cur.execute(
            "INSERT INTO %s.TB_LogDesconexao (DataLogDesconexao, IDContrato, StatusDesconexao, Acao) VALUES (NOW(), %s, '%s', '%s')" % params)
        cnx.commit()
    except Exception as e:
        log.log.error('Falha ao realizar uma inserção no banco de dados: %s' % e)
