# -*- coding: utf-8 -*-

import log
import pymssql

def connect_db(host='localhost', database='information_schema', port=3306, user='root', password=''):
    try:
        log.log.info('- Abrindo conexão com o VSC no host "%s", porta "%s" e banco de dados "%s"' % (str(host), str(port), str(database)))
        return pymssql.connect(host=str(str(host)+':'+str(port)), user=str(user), password=str(password), database=str(database),charset='UTF-8')  
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados da VSC: %s' % e)
        return str('Falha ao conectar no banco de dados da VSC: %s' % e)

def update_batch(cnx, idBatch, controlNumber):
    try:
        cur = cnx.cursor()
        cur.execute('UPDATE [User] SET UGroupID = %s WHERE UserID = %s' % (idBatch, controlNumber))
        cnx.commit()
        return {'Sucesso': True}
    except Exception as e:
        log.log.error('Falha ao tentar atualizar Batch na VSC: %s' % e)
        return {'Sucesso': False, 'Erro' : 'Falha ao atualizar os atributos na VSC: {}'.format(e), 'Integracao': 'VSC'}
    
def habilita_user(cnx, controlNumber):
    try:
        cur = cnx.cursor()
        cur.execute('UPDATE [User] SET Enabled = %s WHERE UserID = %s' % (-1, controlNumber))
        cnx.commit()
        return {'Sucesso': True}
    except Exception as e:
        log.log.error('Falha ao tentar habilitar User na VSC: %s' % e)
        return {'Sucesso': False, 'Erro' : 'Falha ao atualizar os atributos na VSC: {}'.format(e), 'Integracao': 'VSC'}

def close_connect_db(cnx):
    try:
        cnx.close()
        log.log.info('- Fechando a conexão com o banco de dados VSC...')
    except Exception as e:
        log.log.error('Falha ao finalizar a conexão com o banco de dados VSC: %s' % e) 
