# -*- coding: utf-8 -*-

import log
import pymysql

def connect_db(host='localhost', database='information_schema', port=3306, user='root', password='',timeout=15):
    try:
        log.log.info('- Abrindo conexão com o host "%s", porta "%s" e banco de dados "%s"' % (str(host), str(port), str(database)))
        return pymysql.connect(host=host, database=database, port=port, user=user, password=password, charset='utf8', 
        use_unicode=True, write_timeout=float(timeout))
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados do Radius: %s' % e)
        return str('Falha ao conectar no banco de dados do Radius: %s' % e)

def close_connect_db(cnx):
    try:
        cnx.close()
        log.log.info('- Fechando a conexão com o banco de dados do Radius ...')
    except Exception as e:
        log.log.error('Falha ao finalizar a conexão com o banco de dados do Radius: %s' % e)

def atualizacao_atributos(cnx, sql):
    try:
        cur = cnx.cursor()
        cur.execute(sql)
        cnx.commit()
        return {'Sucesso': True}
    except Exception as e:
        log.log.error('Falha ao atualizar os atributos no radius: %s' % e)
        return {'Sucesso': False, 'Erro' : 'Falha ao atualizar os atributos no radius: {}'.format(e), 'Integracao': 'RADIUS'}

def deleteAtributoRadiusLogin(cnx, username):
    try:
        cur = cnx.cursor()
        cur.execute('DELETE FROM radreply where username = "%s" AND attribute = "Mikrotik-Address-List" AND op = "=" AND value = "suspenso"', username)
        cnx.commit()
        return {'Sucesso': True}
    except Exception as e:
        log.log.error('Falha ao remover o atributo de suspenso no radius: %s' % e)
        return {'Sucesso': False, 'Erro' : 'Falha ao atualizar os atributos no radius: {}'.format(e), 'Integracao': 'RADIUS'}

def deleteAtributoRadiusCircuitID(cnx, circuitID):
    try:
        cur = cnx.cursor()
        cur.execute('DELETE FROM radreply where username = "%s" AND attribute = "Framed-Pool" AND op = "=" AND value = "pool-suspenso"', circuitID)
        cnx.commit()
        return {'Sucesso': True}
    except Exception as e:
        log.log.error('Falha ao remover o atributo de pool-suspenso no radius: %s' % e)
        return {'Sucesso': False, 'Erro' : 'Falha ao atualizar os atributos no radius: {}'.format(e), 'Integracao': 'RADIUS'}
    
