# -*- coding: utf-8 -*-

import log
import db
import requests
import json


def format_url(url):
    return url if url.endswith('/') else url + '/'


def get_token_auth(url, username, password, timeout=15):
    url = format_url(url)
    r = requests.post('%slogin' % url, timeout=float(timeout), json={'username': username, 'password': password}, headers={'Connection': 'close'})
    response = r.json()
    r.close()
    return response


def disconnect_user_pppoe(url, username, token, timeout=15):
    url = format_url(url)
    r = requests.post('%sdisconnectuserpppoe' % url, timeout=float(timeout), json={'username': username},
                      headers={'Connection': 'close', 'Authorization': 'Bearer %s' % token})
    response = r.json()
    r.close()
    return response


def desconectar_cliente(cnx, banco_redes, servidor_integracao, token, id_contrato, username, timeout=15):
    try:
        if token == None or not token:
            token = get_token_auth(servidor_integracao['URL'], servidor_integracao['Login'], servidor_integracao['Senha'], timeout)
            if token != None and token['data'] != None and token['data']['token'] != None:
                token = token['data']['token']
            else:
                log.log.error('Falha ao obter o token de acesso da API de integracao do servico de desconexao de usuarios no radius.')
        if token:
            disconnect = disconnect_user_pppoe(servidor_integracao['URL'], username, token, timeout)
            if disconnect != None and disconnect['status'] and disconnect['data'] != None and [d for d in disconnect['data'] if d['status']]:
                db.insert_log_desconexao(cnx, (banco_redes, id_contrato, 'SUCESSO', json.dumps(disconnect)))
                log.log.info('Cliente de login "%s" desconectado com sucesso.' % username)
            else:
                db.insert_log_desconexao(cnx, (banco_redes, id_contrato, 'FALHA', json.dumps(disconnect)))
                log.log.error('Nao foi possivel desconectar o cliente de login "%s".' % username)
        else:
            log.log.error('O token de acesso da API de integracao do servico de desconexao de usuarios no radius não foi fornecido.')
    except Exception as e:
        log.log.error('Ocorreu um erro ao tentar desconectar o cliente de login "%s": %s' % (username, e))
