# -*- coding: utf-8 -*-

import threading
import concurrent.futures

import conf
import db
import emailAdapter
import executaSuspensao
import apidesconexaousuarioradius
import log
import ssh
import sys
import os
from importlib import reload

def main(args):
    cf = conf.open_conf()
    log.log_config(int(cf['app']['log_level']))
    log.log.info('=========== * Iniciando suspensao de contratos * ===========')

    pool = db.create_pool(cf['db']['host'], cf['db']['database'], cf['db']['port'], cf['db']['user'],
                        cf['db']['password'])
    cnx = db.connect_db(pool)
    banco_gateway = cf['db']['database_gateway']
    banco_redes = cf['db']['database_redes']
    banco_rotinas = cf['db']['database_rotinas']
    idRotina = cf['app']['id_rotina']
    idUsuarioRotina = cf['app']['id_usuario_rotina']

    idsEmpresas = str(args[1]) if str(args[1]) != 'NULL' else None
    idsOperacoes = str(args[2]) if str(args[2]) != 'NULL' else None
    idsFormaCobranca = str(args[3]) if str(args[3]) != 'NULL' else None
    suspendeParcial = str(args[4])

    if not suspendeParcial.isdigit() or (int(suspendeParcial) != 0 and int(suspendeParcial) != 1):
        log.log.info('Para o parametro Suspende parcial so e aceito os valores: 0 - NAO e 1 - SIM')
        exit()
    limiteContratos = str(args[5])
    if not limiteContratos.isdigit():
        log.log.info('Para o parametro Limite de contratos so e aceito os valores numericos positivos. Ex: 500')
        exit()
    regraSuspensaoPrimeiraFatura = str(args[6])
    if not regraSuspensaoPrimeiraFatura.isdigit() or (
            int(regraSuspensaoPrimeiraFatura) != 0 and int(regraSuspensaoPrimeiraFatura) != 1):
        log.log.info('Para o parametro Suspende primeira fatura so e aceito os valores: 0 - NAO e 1 - SIM')
        exit()
    
    podeSuspender = db.pode_suspender(cnx)
    if podeSuspender is not None and podeSuspender == 0:
        log.log.info('Configurado para a data "{}" nao pode suspender'.format(datetime.date.today().isoformat()))
        exit()

    rotinaIgualRodando = True
    countRotinaRodando = db.find_controle_rotina_em_execucao(cnx, banco_rotinas, idRotina)
    
    if countRotinaRodando > 0:
        if idsEmpresas is not None:
            countParametro = db.find_parametro_rotina_em_execucao(cnx, (banco_rotinas, banco_rotinas, idRotina, 'IDS_EMPRESAS', idsEmpresas))
        else:
            countParametro = db.find_parametro_sem_valor_rotina_em_execucao(cnx, (banco_rotinas, banco_rotinas, idRotina, 'IDS_EMPRESAS'))
            if countParametro == 0:
                countParametro = 1
            else:
                countParametro = 0
        if countParametro > 0:
            if idsOperacoes is not None:
                countParametro = db.find_parametro_rotina_em_execucao(cnx, (banco_rotinas, banco_rotinas, idRotina, 'IDS_OPERACOES', idsOperacoes))
            else:
                countParametro = db.find_parametro_sem_valor_rotina_em_execucao(cnx, (banco_rotinas, banco_rotinas, idRotina, 'IDS_OPERACOES'))
                if countParametro == 0:
                    countParametro = 1
                else:
                    countParametro = 0
            if countParametro > 0:
                countParametro = db.find_parametro_rotina_em_execucao(cnx, (banco_rotinas, banco_rotinas, idRotina, 'SUSPENDE_PARCIAL', suspendeParcial))
                if countParametro > 0:
                    countParametro = db.find_parametro_rotina_em_execucao(cnx, (banco_rotinas, banco_rotinas, idRotina, 'SUSPENDE_PRIMEIRA_FATURA', regraSuspensaoPrimeiraFatura))
                    if countParametro > 0:
                        if idsFormaCobranca is not None:
                            countParametro = db.find_parametro_rotina_em_execucao(cnx, (banco_rotinas, banco_rotinas, idRotina, 'IDS_FORMASCOBRANCA', idsFormaCobranca))
                        else:
                            countParametro = db.find_parametro_sem_valor_rotina_em_execucao(cnx, (banco_rotinas, banco_rotinas, idRotina, 'IDS_FORMASCOBRANCA'))
                            if countParametro == 0:
                                countParametro = 1
                            else:
                                countParametro = 0
                        if countParametro == 0:
                            rotinaIgualRodando = False    
                    else:
                        rotinaIgualRodando = False    
                else:
                    rotinaIgualRodando = False
            else:
                rotinaIgualRodando = False
        else:
            rotinaIgualRodando = False    
    else:
        rotinaIgualRodando = False
    
    if not rotinaIgualRodando:
        pid = os.getpid()
        db.insert_controle_execucao_rotina(cnx, (banco_rotinas, idUsuarioRotina, idRotina, pid))
        idControle = db.find_ultimo_id_controle_rotina(cnx, banco_rotinas)
        if idsEmpresas is not None:
            db.insert_parametro_controle_execucao_rotina(cnx, (banco_rotinas, idControle, 'IDS_EMPRESAS', 'STRING', idsEmpresas))
        if idsOperacoes is not None:
            db.insert_parametro_controle_execucao_rotina(cnx, (banco_rotinas, idControle, 'IDS_OPERACOES', 'STRING', idsOperacoes))
        db.insert_parametro_controle_execucao_rotina(cnx, (banco_rotinas, idControle, 'SUSPENDE_PARCIAL', 'STRING', suspendeParcial))
        db.insert_parametro_controle_execucao_rotina(cnx, (banco_rotinas, idControle, 'SUSPENDE_PRIMEIRA_FATURA', 'STRING', regraSuspensaoPrimeiraFatura))
        if idsFormaCobranca is not None:
            db.insert_parametro_controle_execucao_rotina(cnx, (banco_rotinas, idControle, 'IDS_FORMASCOBRANCA', 'STRING', idsFormaCobranca))

        configura_suspensao = db.busca_configuracao_suspensao(cnx)
        conexoesRadius = db.busca_conexoes_radius(cnx)

        timeout = db.find_valor_configuracao(cnx, (cf['db']['database'], 'TEMPO_LIMITE_REQUISICAO_BANCO_RADIUS'))
        if not timeout:
            timeout = 15

        lock = threading.Lock()
        loginsDesconectar = []
        sucessos = []
        erros = []

        for conexao in conexoesRadius:
            conexoesParaDesconectar = {}
            conexoesParaDesconectar['PU'] = conexao['PersistenceUnit']
            conexoesParaDesconectar['Comando'] = conexao['ComandoDesconexao']
            conexoesParaDesconectar['ServidorIntegracao'] = conexao['IDServidorIntegracao']
            conexoesParaDesconectar['Logins'] = []
            loginsDesconectar.append(conexoesParaDesconectar)

        for config in configura_suspensao:
            diasSuspensaoParcial = config['DiasSuspensaoParcial'] if int(regraSuspensaoPrimeiraFatura) != 1 else config['DiasSuspensaoPrimeiroDebito']
            diasSuspensaoTotal = config['DiasSuspensaoTotal'] 
            if int(suspendeParcial) != 1 and int(regraSuspensaoPrimeiraFatura) == 1:
                diasSuspensaoTotal = config['DiasSuspensaoPrimeiroDebito']
            elif int(suspendeParcial) == 1 and int(regraSuspensaoPrimeiraFatura) == 1:
                diasSuspensaoTotal = config['DiasSuspensaoPrimeiroDebito']
            else:
                diasSuspensaoTotal = config['DiasSuspensaoTotal']

            log.log.info('Buscando contratos para suspender de: ' + config['TipoTecnologia'])
            retorno = db.busca_contratos(cnx,idsEmpresas,idsOperacoes,idsFormaCobranca,suspendeParcial,diasSuspensaoParcial,diasSuspensaoTotal,config['ValorMinimoSuspensao'], limiteContratos, regraSuspensaoPrimeiraFatura, config['TipoTecnologia'])
            retornoFormatado = formataListaContratos(retorno, config['TipoTecnologia'])
            with concurrent.futures.ThreadPoolExecutor(max_workers=5) as executor:
                for dados_contrato in retornoFormatado:
                    future = executor.submit(
                        executaSuspensao.SuspendeContrato(pool, dados_contrato, loginsDesconectar, timeout, sucessos, erros, lock,
                                                        log, cf).suspendeContrato)

        log.log.info('Inicio da desconexao dos contratos --------- ')

        for desconectar in loginsDesconectar:
            if len(desconectar['Logins']) > 0:
                try:
                    servidor_integracao = None
                    id_servidor_integracao = db.find_valor_configuracao(cnx, (
                        banco_redes, 'ID_SERVIDOR_API_INTEGRACAO_DESCONEXAO_USUARIO_RADIUS'))
                    if id_servidor_integracao:
                        servidor_integracao = db.busca_dados_servidor_integracao_by_ID(cnx, banco_gateway,
                                                                                    id_servidor_integracao)
                    if servidor_integracao is not None:
                        timeout_api_desconexao_cliente = db.find_valor_configuracao(cnx, (
                            banco_redes, 'TEMPO_LIMITE_REQUISICAO_API_INTEGRACAO_DESCONEXAO_USUARIO_RADIUS'))
                        token = apidesconexaousuarioradius.get_token_auth(servidor_integracao['URL'],
                                                                        servidor_integracao['Login'],
                                                                        servidor_integracao['Senha'], timeout)
                        if token is not None and token['data'] is not None and token['data']['token'] is not None:
                            for login in desconectar['Logins']:
                                id_contrato = None
                                if login['IDContrato'] is not None:
                                    id_contrato = int(login['IDContrato'])
                                apidesconexaousuarioradius.desconectar_cliente(cnx, banco_redes, servidor_integracao,
                                                                            token['data']['token'], id_contrato,
                                                                            login['Login'],
                                                                            timeout_api_desconexao_cliente)
                        else:
                            log.log.error('Falha ao obter o token de acesso da API de integracao do servico de desconexao '
                                        'de usuarios no radius.')
                    else:
                        servidor_integracao = db.busca_dados_servidor_integracao_by_ID(cnx, banco_gateway,
                                                                                    desconectar['ServidorIntegracao'])
                        if servidor_integracao is not None:
                            client = ssh.connect(servidor_integracao['URL'], servidor_integracao['Porta'],
                                                servidor_integracao['Login'], servidor_integracao['Senha'].decode('utf-8'))
                            for login in desconectar['Logins']:
                                comando = '%s %s' % (desconectar['Comando'], login['Login'])
                                log.log.info('Desconectando: %s ' % comando)
                                output = ssh.execute(client, comando)
                            ssh.close(client)
                except Exception as e:
                    log.log.error('Falha na desconexão dos logins da PU %s: %s' % (desconectar['PU'], e))
                    if ssh is not None:
                        ssh.close(client)

        log.log.info('Fim da desconexao dos contratos --------- ')
        log.log.info('=========== * Fim da suspensao de contrato * ===========')
        db.update_controle_execucao_rotina(cnx, banco_rotinas, idControle, 'FINALIZADO')
        '''db.close_connect_db(cnx)'''

        try:
            emailAdapter.send_email(cf, emailAdapter.cria_mensagem(sucessos, erros))
        except Exception as e:
            log.log.error('Falha ao enviar email: %s' % e)

    else:
        log.log.info('Rotina ja encontra em execucao.')
        log.log.info('=========== * Fim da suspensao de contrato * ===========')

    db.close_connect_db(cnx)

    exit()


def formataListaContratos(lista, tipoTecnologia):
    listaNova = []
    for dados_contrato in lista:
        dados_contrato['TipoTecnologia'] = tipoTecnologia
        listaNova.append(dados_contrato)
    return listaNova


if __name__ == '__main__':
    reload(sys)

    if len(sys.argv) == 1 or (len(sys.argv) > 1 and sys.argv[1] == '?'):
        print('''
        
        ########## Rotina de Suspensao de contratos ##########
        
            Para o funcionamento da rotina e necessario os seguintes parametros:
            1° idsEmpresas = pode ser 1 id ou uma lista de ids. Ex: 1,2,3 ou 1. para nao informar necessario passar NULL
            2° idsOperacoes = pode ser 1 id ou uma lista de ids. Ex: 1,2,3 ou 1. para nao informar necessario passar NULL
            3° idsFormaCobranca = pode ser 1 id ou uma lista de ids. Ex: 1,2,3 ou 1. para nao informar necessario passar NULL
            4° suspendeParcial* = Valor aceito 0 = NAO ou 1 = SIM
            5° limiteContratos* = Valores acima de 0.
            6° regraSuspensaoPrimeiraFatura* = Valor aceito 0 = NAO ou 1 = SIM

        Os parametros marcado com '*' sao obrigatorios.

        Para exibir essa lista novamente, necessario passar o parametro '?'

        ########## Rotina de Suspensao de contratos ##########

        ''')
        exit()

    main(sys.argv)
