# -*- coding: utf-8 -*-

import log
import base64
import paramiko


def connect(hostname, port, username, password):
    client = paramiko.SSHClient()
    client.load_system_host_keys()
    client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    log.log.info('ssh %s@%s -p %d' % (username, hostname, port))
    client.connect(hostname, port=port, username=username, password=password)
    return client

def execute(client, command):
    log.log.debug('> %s' % command)
    stdin, stdout, stderr = client.exec_command(command)
    return {'stdout': [l.strip('\n') for l in stdout], 'stderr': [l.strip('\n') for l in stderr]}

def close(client):
    log.log.info('disconnecting from ssh...');
    client.close()

