# -*- coding: utf-8 -*-
import db, conf, json, dbRadius, dbVSC, log
import suspendercontratos
import datetime
from datetime import date


class SuspendeContrato():
        def __init__(self, pool, dados_contrato, loginsDesconectar, timeout, sucessos, erros, lock, log, cf):
            self.pool = pool
            self.dados_contrato = dados_contrato
            self.loginsDesconectar = loginsDesconectar
            self.lock = lock
            self.log = log
            self.cf = cf
            self.timeout = timeout
            self.sucessos = sucessos
            self.erros = erros


        def suspendeContrato(self):
            dados_contrato = self.dados_contrato
            bancoRadius = dbRadius.BancoRadius()
            log = self.log 
            cf = self.cf
            sucessos = self.sucessos
            erros = self.erros
            timeout = self.timeout
            alteraAdapter = None
            tipo_integracao = None
            cnx = None
            try:
                try:
                    banco_gateway = cf['db']['database_gateway']
                    cnx = db.connect_db(self.pool)
                
                    log.log.info('%s: Contrato %s' % (dados_contrato['TipoTecnologia'], dados_contrato['IDContrato']))
                    
                    if(dados_contrato['TipoTecnologia'] == 'INTERNET'):
                        tipo_integracao = 'RADIUS'
                        if(dados_contrato['PersistenceUnit'] is None):
                            raise ValueError('O Contrato: {}, não possui vinculo com o Radius para realizar a habilitação.')
                        if(dados_contrato['Autenticacao'] is None):
                            raise ValueError('O Contrato: {}, não possui o login configurado.')

                        try:
                            if(int(dados_contrato['IntegraRadius']) == 1):
                                tipo_integracao = 'RADIUS'
                                dados_radius = db.busca_dados_servidor_integracao(cnx, banco_gateway, dados_contrato['PersistenceUnit'])
                                cnxRadius = bancoRadius.connect_db(str(dados_radius[0]['URL']),str(dados_radius[0]['DatabaseName']),
                                int(dados_radius[0]['Porta']), str(dados_radius[0]['Login']), (dados_radius[0]['Senha']).decode('utf-8'),timeout) 
                                if(isinstance(cnxRadius,str)):
                                    raise ValueError(cnxRadius)
                                if(dados_contrato['RemocaoAtributosRadius'] is not None):
                                    camposRadiusRemocao = json.loads(str(dados_contrato['RemocaoAtributosRadius']))
                                    for tabela in camposRadiusRemocao.keys(): 
                                        for linha in camposRadiusRemocao[tabela]:
                                            sql = montaSQLDelete(linha,tabela) 
                                            alteraAdapter = bancoRadius.atualizacao_atributos(cnxRadius, sql)
                                            if (not alteraAdapter['Sucesso']):
                                                raise ValueError('Nao foi possivel atualizar os atributos do radius do Contrato %s\n%s' % (dados_contrato[0], alteraAdapter['Erro']))
                                
                                if(dados_contrato['InsercaoAtributosRadius'] is not None):
                                    camposRadiusAdicao = json.loads(dados_contrato['InsercaoAtributosRadius'])                        
                                    for tabela in camposRadiusAdicao.keys(): 
                                        for linha in camposRadiusAdicao[tabela]:
                                            sql = montaSQLInsert(linha,tabela)
                                            alteraAdapter = bancoRadius.atualizacao_atributos(cnxRadius, sql)
                                            if (not alteraAdapter['Sucesso']):
                                                raise ValueError('Nao foi possivel atualizar os atributos do radius do Contrato %s\n%s' % (dados_contrato[0], alteraAdapter['Erro']))
                                
                                self.lock.acquire()
                                for item in self.loginsDesconectar:
                                    if(item['PU'] == dados_contrato['PersistenceUnit']):
                                        item['Logins'].append({'Login': dados_contrato['Autenticacao'],
                                                        'IDContrato': dados_contrato['IDContrato']})
                                        break
                                self.lock.release()
                                
                                if(cnxRadius is not None and not isinstance(cnxRadius,str)):
                                    bancoRadius.close_connect_db(cnxRadius)
                            
                        except Exception as error:
                            alteraAdapter = {'Sucesso': False,
                                             'IDContrato': dados_contrato['IDContrato'],
                                             'TipoSuspensao': dados_contrato['TipoSuspensao'],
                                             'DescricaoConexaoRadiusVSC': dados_contrato['PersistenceUnit'],
                                             'Erro' : 'Erro no radius: {}'.format(error), 'Integracao': 'RADIUS'}
                            log.log.error('Falha ao tentar alterar os atributos no radius referente ao contrato %s: %s' % (dados_contrato['IDContrato'], error))
                            if(cnxRadius is not None and not isinstance(cnxRadius,str)):
                                bancoRadius.close_connect_db(cnxRadius)
                    
                    elif(dados_contrato['TipoTecnologia'] == 'TELEFONIA'):
                        tipo_integracao = 'VSC'
                        if(dados_contrato['PersistenceUnit'] is None):
                            raise ValueError('O Contrato: {}, não possui vinculo com a VSC para realizar a habilitação.')
                        if(dados_contrato['Autenticacao'] is None):
                            raise ValueError('O Contrato: {}, não possui o ControlNumber configurado.')
                        
                        if(int(dados_contrato['IntegraVSC']) == 1 and dados_contrato['AtualizaVSC'] is not None):
                            try:
                                dados_vsc = db.busca_dados_servidor_integracao(cnx, banco_gateway, dados_contrato['PersistenceUnit'])
                                cnxVsc = dbVSC.connect_db(dados_vsc[0]['URL'],dados_vsc[0]['DatabaseName'],dados_vsc[0]['Porta'], dados_vsc[0]['Login'], dados_vsc[0]['Senha'].decode('utf-8') )
                                if(isinstance(cnxVsc,str)):
                                    raise ValueError(cnxVsc)  
                                alteraAdapter = dbVSC.atualizacao_atributos(cnxVsc, dados_contrato['AtualizaVSC'])
                                if (not alteraAdapter['Sucesso']):
                                    raise ValueError('Nao foi possivel o Contrato na VSC: %s\n%s' % (dados_contrato[0], alteraAdapter['Erro']))

                                if(cnxVsc is not None and not isinstance(cnxVsc,str)):
                                    dbVSC.close_connect_db(cnxVsc)
                            except Exception as error:
                                alteraAdapter = {'Sucesso': False,
                                                 'IDContrato': dados_contrato['IDContrato'],
                                                 'TipoSuspensao': dados_contrato['TipoSuspensao'],
                                                 'DescricaoConexaoRadiusVSC': dados_contrato['PersistenceUnit'],
                                                 'Erro': 'Erro no VSC: {}'.format(error), 'Integracao': tipo_integracao}
                                log.log.error('Falha ao tentar alterar os atributos na VSC referente ao contrato %s: %s' % (dados_contrato['IDContrato'], error))
                                if(cnxVsc is not None and not isinstance(cnxVsc,str)):
                                    dbVSC.close_connect_db(cnxVsc)
                    else:
                        alteraAdapter = {'Sucesso': True}
                        alteraAdapter['IDContrato'] = dados_contrato['IDContrato']
                        alteraAdapter['TipoSuspensao'] = dados_contrato['TipoSuspensao']
                        alteraAdapter['DescricaoConexaoRadiusVSC'] = dados_contrato['PersistenceUnit']

                    if(alteraAdapter['Sucesso']):
                        try:        
                            if(str(dados_contrato['TipoSuspensao']) == 'SUSPENSO'):
                                calculaProporcional(cnx, dados_contrato['IDContrato'], db, cf['db']['database_financeiro'])

                            log.log.info(dados_contrato['AtualizaContrato'])
                            atualizou = db.update_contrato_and_log(cnx, dados_contrato['AtualizaContrato'])
                            if(not atualizou['Sucesso']):
                                raise ValueError('Nao foi possivel atualizar o Contrato %s\n%s' % (dados_contrato['IDContrato'], atualizou['Erro']))
                            atualizou = db.update_contrato_and_log(cnx, dados_contrato['InsereLogContrato'])
                            if(not atualizou['Sucesso']):
                                raise ValueError('Nao foi possivel inserir o log do Contrato %s\n%s' % (dados_contrato['IDContrato'], atualizou['Erro']))
                            cnx.commit()
                            self.lock.acquire()
                            sucessos.append(alteraAdapter)
                            self.lock.release()
                            log.log.info('Contrato %s suspenso com sucesso ----- ' % dados_contrato['IDContrato'])
                        except Exception as error:
                            alteraAdapter = {'Sucesso': False,
                                             'IDContrato': dados_contrato['IDContrato'],
                                             'TipoSuspensao': dados_contrato['TipoSuspensao'],
                                             'DescricaoConexaoRadiusVSC': dados_contrato['PersistenceUnit'],
                                             'Erro': 'Falha ao tentar suspender o contrato %s no adapter: %s' % (dados_contrato['IDContrato'], error), 'Integracao': tipo_integracao}
                            self.lock.acquire()
                            erros.append(alteraAdapter)
                            self.lock.release()
                            log.log.error('Falha ao tentar suspender o contrato %s no adapter: %s' % (dados_contrato['IDContrato'], error)) 
                            insere_log(cnx,alteraAdapter)
                    else:
                        alteraAdapter['IDContrato'] = dados_contrato['IDContrato']
                        alteraAdapter['TipoSuspensao'] = dados_contrato['TipoSuspensao']
                        alteraAdapter['DescricaoConexaoRadiusVSC'] = dados_contrato['PersistenceUnit']
                        self.lock.acquire()
                        erros.append(alteraAdapter)
                        self.lock.release()
                        insere_log(cnx,alteraAdapter)

                    '''db.close_connect_db(cnx)'''
                except Exception as error:
                    alteraAdapter = {'Sucesso': False,
                                     'IDContrato': dados_contrato['IDContrato'],
                                     'TipoSuspensao': dados_contrato['TipoSuspensao'],
                                     'DescricaoConexaoRadiusVSC': dados_contrato['PersistenceUnit'],
                                     'Erro':'Falha ao tentar suspender o contrato %s no adapter: %s' % (dados_contrato['IDContrato'], error), 'Integracao': tipo_integracao}
                    self.lock.acquire()
                    erros.append(alteraAdapter)
                    self.lock.release()
                    insere_log(cnx,alteraAdapter)
                    log.log.error('Erro %s: %s' % (dados_contrato['IDContrato'], error))
            except Exception as error:
                log.log.error('Erro %s: %s' % (dados_contrato['IDContrato'], error))
            finally:
                if(cnx is not None):
                    db.close_connect_db(cnx)
                if(cnxRadius is not None and not isinstance(cnxRadius,str)):
                    bancoRadius.close_connect_db(cnxRadius)


def calculaProporcional(cnx, idContrato, db, banco_financeiro):
    dadosFinanceiros = db.busca_dadosfinanceiros_contrato(cnx, idContrato)
    ultimoFaturamento = dadosFinanceiros[0]['UltimoFaturamento']
    periodoCobranca = dadosFinanceiros[0]['PeriodoCobranca']
    valorContrato = dadosFinanceiros[0]['ValorContrato']
    dataatual = date.today()
    if(ultimoFaturamento != None and dataatual.toordinal() > ultimoFaturamento.toordinal()):
        ultimoFaturamento += datetime.timedelta(days=1)
        diasUtilizados = dataatual.toordinal() - ultimoFaturamento.toordinal()
        if(diasUtilizados > 0):
            diasPeriodo = 30
            if (periodoCobranca == "SEMESTRAL"):
                diasPeriodo = 180
            elif (periodoCobranca == "ANUAL"):
                diasPeriodo = 365
            elif (periodoCobranca == "TRIMESTRAL"):
                diasPeriodo = 90
            valorAPagar = valorContrato / diasPeriodo * (diasUtilizados+1)
            periodo = "(" + ultimoFaturamento.strftime('%d/%m/%y') + " a " + dataatual.strftime("%d/%m/%y") + ")"
            for dado in dadosFinanceiros:
                valor = round((dado['PercentualValor'] / 100.0) * valorAPagar,2)
                db.salvar_proporcionalsuspensao(cnx, banco_financeiro, valor, periodo, dado['IDComposicaoServico'], idContrato)


def montaSQLDelete(jsonLinha, tabela):
    sql = 'DELETE FROM '+tabela + ' WHERE '
    for campo in jsonLinha.keys(): 
        sql += campo + '="'+jsonLinha[campo]+'" AND '
        
    return sql[:-4]


def montaSQLInsert(jsonLinha, tabela):
    sql = 'INSERT INTO  '+tabela + ' ('
    for campo in jsonLinha.keys(): 
        sql += campo + ','
    sql = sql[:-1]
    sql += ') VALUES ('
    for campo in jsonLinha.keys(): 
        sql += '"'+jsonLinha[campo]+'",'
    sql = sql[:-1]
    sql += ')'
    return sql


def insere_log(cnx,dados):
    if('Integracao' in dados):
        if(dados['Integracao'] == 'RADIUS'):
            db.insere_log_radius(cnx,dados)
        elif(dados['Integracao'] == 'VSC'):
            db.insere_log_vsc(cnx,dados)
