# -*- coding: utf-8 -*-

import log
import pymssql

def connect_db(host='localhost', database='information_schema', port=3306, user='root', password=''):
    try:
        log.log.info('- Abrindo conexão com o VSC no host "%s", porta "%s" e banco de dados "%s"' % (str(host), str(port), str(database)))
        return pymssql.connect(host=str(str(host)+':'+str(port)), user=str(user), password=str(password), database=str(database),charset='UTF-8')  
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados da VSC: %s' % e)
        return str('Falha ao conectar no banco de dados da VSC: %s' % e)

def atualizacao_atributos(cnx, sql):
    try:
        cur = cnx.cursor()
        cur.execute(sql)
        cnx.commit()
        return {'Sucesso': True}
    except Exception as e:
        log.log.error('Falha ao atualizar os atributos na VSC: %s' % e)
        return {'Sucesso': False, 'Erro' : 'Falha ao atualizar os atributos na VSC: {}'.format(e), 'Integracao': 'VSC'}

def close_connect_db(cnx):
    try:
        cnx.close()
        log.log.info('- Fechando a conexão com o banco de dados VSC...')
    except Exception as e:
        log.log.error('Falha ao finalizar a conexão com o banco de dados VSC: %s' % e) 