# -*- coding: utf-8 -*-

import log
from mysql.connector import Error 
from mysql.connector import pooling


def create_pool(host='localhost', database='information_schema', port=3306, user='root', password=''):
    return pooling.MySQLConnectionPool(pool_name="pynative_pool",
                                                  pool_size=10,
                                                  pool_reset_session=True,
                                                  host=host,
                                                  database=database,
                                                  user=user,
                                                  password=password,
                                                  port=port)


def connect_db(pool):
    try:
        return pool.get_connection()
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados do Adapter: %s' % e)


def busca_contratos(cnx, idEmpresa, idOperacao, idsFormaCobranca, suspendeParcial, diasSuspensaoParcial,
                    diasSuspensaoTotal, valorMinimoSuspensao, limiteContratos, regraSuspensaoPrimeiraFatura,
                    tipoTecnologia):
    try:
        log.log.info("Parametro de execucao da rotina: ")
        log.log.info([idEmpresa, idOperacao, idsFormaCobranca, suspendeParcial, diasSuspensaoParcial,
                      diasSuspensaoTotal, valorMinimoSuspensao, limiteContratos, regraSuspensaoPrimeiraFatura,
                      tipoTecnologia])
        cur = cnx.cursor(dictionary=True)
        cur.callproc("spuSuspensaoContrato",
                     [idEmpresa, idOperacao, idsFormaCobranca, suspendeParcial, diasSuspensaoParcial,
                      diasSuspensaoTotal, valorMinimoSuspensao, limiteContratos, regraSuspensaoPrimeiraFatura,
                      tipoTecnologia])
        values = [value.fetchall() for value in cur.stored_results()]
        return values[0]
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados do Adapter: %s' % e)


def close_connect_db(cnx):
    try:
        if(cnx is not None):
            cnx.close()
            cnx = None
        log.log.info('- Fechando a conexão com o banco de dados do Adapter...')
    except Exception as e:
        log.log.error('Falha ao finalizar a conexão com o banco de dados do Adapter: %s' % e)


def update_contrato_and_log(cnx, sql):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(sql)
        return {'Sucesso': True}
    except Exception as e:
        log.log.error('Falha ao tentar atualizar contrato: %s' % e)
        return {'Sucesso': False, 'Erro' : 'Falha ao tentar atualizar contrato: {}'.format(e)}


def busca_configuracao_suspensao(cnx):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT * FROM TB_ConfiguraSuspensao")
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao buscar configuracoes de suspensao: %s' % e)


def busca_dados_servidor_integracao(cnx, database, pu):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
            "SELECT URL, Login, AES_DECRYPT(Senha,'F583BE47632CEE39') as Senha, DatabaseName, Porta FROM %s.TB_ServidorIntegracao WHERE TRIM(Descricao) = TRIM('%s') LIMIT 1" % (
            database, pu.upper()))
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao buscar servidor de integracao da pu: %s %s' % (pu,e))


def busca_conexoes_radius(cnx):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT * FROM TB_ConexaoRadius")
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao buscar conexoes Radius: %s' % e)


def busca_timeout_radius(cnx):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT ValorConfiguracao FROM TB_Configuracoes WHERE ChaveConfiguracao = 'TEMPO_LIMITE_REQUISICAO_BANCO_RADIUS'")
        return cur.fetchone()['ValorConfiguracao']
    except Exception as e:
        log.log.error('Falha ao buscar configuracoes de suspensao: %s' % e)
        return 15


def busca_dados_servidor_integracao_by_ID(cnx, database, id):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT URL, Login, AES_DECRYPT(Senha,'F583BE47632CEE39') as Senha, Porta FROM %s.TB_ServidorIntegracao WHERE IDServidorIntegracao = %s" %(database,id))
        return cur.fetchone()
    except Exception as e:
        log.log.error('Falha ao buscar servidor de integracao para desconexao: %s' % e)


def busca_dadosfinanceiros_contrato(cnx, idContrato):
    try:
        sql = "SELECT c.IDContrato, c.ValorContrato, c.UltimoFaturamento, df.PeriodoCobranca, df.IDComposicaoServico, df.PercentualValor "
        sql += "FROM TB_Contrato c "
        sql += "INNER JOIN TB_DadosFinanceiroContrato df ON df.IDContrato = c.IDContrato "
        sql += "WHERE c.IDContrato = %s" % idContrato
        cur = cnx.cursor(dictionary=True)
        cur.execute(sql)
        return cur.fetchall()
    except Exception as e:
        log.log.error('Falha ao buscar dados financeiros de contrato: %s' % e)


def insere_log_vsc(cnx,dados):
    try:
        cur = cnx.cursor()
        cur.execute('INSERT INTO TB_LogIntegracaoVSC (IDContrato,Acao,TipoAcao,DataLog) VALUES (%s,"%s","SUSPENSAO",NOW())' % (dados['IDContrato'],dados['Erro']))
        cnx.commit()
        return True
    except Exception as e:
        log.log.error('Falha ao inserir log vsc: %s' % e)


def insere_log_radius(cnx,dados):
    try:
        cur = cnx.cursor()
        cur.execute('INSERT INTO TB_LogIntegracaoRadius (IDContrato,Acao,TipoAcao,DataLog) VALUES (%s,%s,"SUSPENSAO",NOW())', (dados['IDContrato'],dados['Erro']))
        cnx.commit()
        return True
    except Exception as e:
        log.log.error('Falha ao inserir log radius: %s' % e)


def salvar_proporcionalsuspensao(cnx,financeiro,valor, periodo, idComposicao, idContrato):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
            "INSERT %s.TB_ProporcionalSuspensao SET DataInsercao = NOW(), IsFaturado = 0, IDContrato = %s, Periodo = '%s', Valor = %s, IDComposicao = %s" % (
            financeiro, idContrato, periodo, valor, idComposicao))
        cnx.commit()
        return True
    except Exception as e:
        log.log.error('Falha ao tentar salvar proporcional de suspensao: %s' % e)
        return False


def find_valor_configuracao(cnx, params):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT ValorConfiguracao FROM %s.TB_Configuracoes WHERE ChaveConfiguracao = '%s'" % params)
        return cur.fetchall()[0]['ValorConfiguracao']
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
        return None


def insert_log_desconexao(cnx, params):
    try:
        cur = cnx.cursor()
        cur.execute(
            "INSERT INTO %s.TB_LogDesconexao (DataLogDesconexao, IDContrato, StatusDesconexao, Acao) VALUES (NOW(), %s, '%s', '%s')" % params)
        cnx.commit()
    except Exception as e:
        log.log.error('Falha ao realizar uma inserção no banco de dados: %s' % e)


def pode_suspender(cnx):
    try:
        sql = "SELECT IFNULL((SELECT PodeSuspender FROM TB_DiaNaoUtil WHERE DataNaoUtil = CURDATE()), 1) as PodeSuspender"
        cur = cnx.cursor(dictionary=True)
        cur.execute(sql)
        dados = cur.fetchone()['PodeSuspender']
    except Exception as e:
        log.log.error('Falha ao buscar se pode suspender: %s' % e)
        return 1

def insert_controle_execucao_rotina(cnx, params):
    try:
        cur = cnx.cursor()
        cur.execute(
            "INSERT INTO %s.TB_ControleExecucaoRotina (IDUsuario, DataCadastro, DataInicio, Status, IDRotina, PID) VALUES (%s, NOW(), NOW(), 'EM_EXECUCAO', %s, %s)" % params)
        cnx.commit()
    except Exception as e:
        log.log.error('Falha ao realizar uma inserção na tabela TB_ControleExecucaoRotina: %s' % e)
        
def find_ultimo_id_controle_rotina(cnx, db):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT LAST_INSERT_ID() as idControle FROM %s.TB_ControleExecucaoRotina LIMIT 1" % db)
        return cur.fetchall()[0]['idControle']
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
        return None

        
def insert_parametro_controle_execucao_rotina(cnx, params):
    try:
        cur = cnx.cursor()
        cur.execute(
            "INSERT INTO %s.TB_ParametroExecucaoRotina (IDControleExecucaoRotina, NomeParametro, TipoParametro, ValorParametro) VALUES (%s, '%s', '%s', '%s')" % params)
        cnx.commit()
    except Exception as e:
        log.log.error('Falha ao realizar uma inserção na tabela TB_ParametroExecucaoRotina: %s' % e)
        
def update_controle_execucao_rotina(cnx, bd, idControle, status):
    try:
        cur = cnx.cursor()
        cur.execute(
            "UPDATE %s.TB_ControleExecucaoRotina SET DataFim = NOW(), Status = '%s' WHERE IDControleExecucaoRotina = %s" % (bd, status, idControle))
        cnx.commit()
    except Exception as e:
        log.log.error('Falha ao realizar uma atualizacao na tabela TB_ControleExecucaoRotina: %s' % e)

def find_controle_rotina_em_execucao(cnx, db, idRotina):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT COUNT(*) as count FROM %s.TB_ControleExecucaoRotina WHERE IDRotina = %s AND Status = 'EM_EXECUCAO'" % (db, idRotina))
        return cur.fetchall()[0]['count'] 
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
        return 0

def find_parametro_rotina_em_execucao(cnx, params):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT COUNT(*) as count FROM %s.TB_ParametroExecucaoRotina p INNER JOIN %s.TB_ControleExecucaoRotina c ON c.IDControleExecucaoRotina = p.IDControleExecucaoRotina WHERE c.IDRotina = %s AND c.`Status` = 'EM_EXECUCAO' AND p.NomeParametro = '%s' AND p.ValorParametro = '%s'" % params)
        return cur.fetchall()[0]['count'] 
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
        return 0

def find_parametro_sem_valor_rotina_em_execucao(cnx, params):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute("SELECT COUNT(*) as count FROM %s.TB_ParametroExecucaoRotina p INNER JOIN %s.TB_ControleExecucaoRotina c ON c.IDControleExecucaoRotina = p.IDControleExecucaoRotina WHERE c.IDRotina = %s AND c.`Status` = 'EM_EXECUCAO' AND p.NomeParametro = '%s'" % params)
        return cur.fetchall()[0]['count'] 
    except Exception as e:
        log.log.error('Falha ao realizar uma consulta no banco de dados: %s' % e)
        return 0
