# -*- coding: utf-8 -*-
import configparser
import log
from exception import Exceptions
import mysql.connector as myc
from mysql.connector import Error
from mysql.connector import pooling
from Configuracoes import Configuracoes
import utils

CONFIG = Configuracoes().getConfig()


def create_pool(host='localhost', database='information_schema', port=3306, user='root', password=''):
    return pooling.MySQLConnectionPool(pool_name="pynative_pool",
                                                  pool_size=32,
                                                  pool_reset_session=True,
                                                  host=host,
                                                  database=database,
                                                  user=user,
                                                  password=password,
                                                  port=port)

def connect_db(pool):
    try:
        return pool.get_connection()
    except Exception as e:
        log.log.error('Falha ao conectar no banco de dados: %s' % e)

def close_connect_db(cnx):
    try:
        print("Fechando conexao:", cnx.connection_id)
        cnx.close()
        print('- Conexao fechada com o banco de dados...')
        log.log.info('- Fechando a conexao com o banco de dados...')
    except Exception as e:
        print('Falha ao finalizar a conexao com o banco de dados: %s' % e)
        log.log.error('Falha ao finalizar a conexao com o banco de dados: %s' % e)

def findContatosCliente(cnx, idCliente):
    cur = cnx.cursor(dictionary=True)
    sql = """SELECT cc.NomeOutorgado as Nome, cc.Email, cc.Telefone, cc.Celular , tc.Descricao as Tipo
					FROM TB_Cliente c
					INNER JOIN TB_ContatoCliente cc ON c.IDCliente = cc.IDCliente
					INNER JOIN TB_TipoContato tc ON cc.IDTipoContato = tc.IDTipoContato
					WHERE c.IDCliente = %s
					GROUP BY cc.IDTipoContato
					ORDER BY cc.IDContatoCliente DESC"""
    sql = utils.stringFormat(sql)
    data = (idCliente,)
    cur.execute(sql, data)
    response = cur.fetchall()
    log.query_log(cur._executed, response)
    return response

def findClientesNaoIntegrados(cnx, tipoIntegracao, idCliente, inicioID, fimID):

    try:
        data = ()
        sql = 'SELECT c.* FROM TB_Cliente c '
        cur = cnx.cursor(dictionary=True)
        if(tipoIntegracao == "1"):
            sql += "WHERE c.IsIntegrado IS NULL OR c.IsIntegrado IN ('N', 'E')"
            data = None
        elif(tipoIntegracao == "2"):
            sql += "WHERE c.IDCliente IN (%s)"
            data = (idCliente,)
        elif(tipoIntegracao == "2"):
            sql += "WHERE c.IDCliente IN (%s)"
            data = (idCliente,)
        elif(tipoIntegracao == "3"):
            sql += " WHERE c.IDCliente >=  %s AND c.IDCliente <=  %s AND c.IsIntegrado = 'N' "
            data = (inicioID, fimID)
        elif(tipoIntegracao == "4"):
            sql += "WHERE c.IsIntegrado = 'N'"
            data = None
        elif(tipoIntegracao == "5"):
            sql += "WHERE c.IsIntegrado = 'E'"
            data = None
        else:
            sql += "WHERE c.IsIntegrado IS NULL OR c.IsIntegrado IN ('N', 'E')"
            data = None

        cur.execute(sql, data)
        response = cur.fetchall()
        log.query_log(cur._executed, response)
        
        return response
    except myc.ProgrammingError as syntaxError:
        log.log.error(
            'Erro na sintaxe da query e/ou tabela inexistente: %s' % syntaxError)
        return None
    except Exception as e:
        msg = Exceptions.queryExceptions(e.__class__.__name__)
        log.log.error(
            "{0}: {1}".format(msg, e))
        return None

def findEnderecosCliente(cnx, idCliente):
    try:
        cur = cnx.cursor(dictionary=True)
        sql = """SELECT ec.ComplementoEndereco, ec.NumEndereco,
        ec.TipoEndereco, e.LogradouroEndereco, tl.Abreviatura, tl.DescricaoTipoLogradouro, e.CepEndereco,
        b.NomeBairro, cid.NomeCidade, cid.UFCidade, cid.CodigoCidadeIBGE
        FROM TB_Cliente c INNER JOIN TB_EnderecoCliente ec ON c.IDCliente = ec.IDCliente
        INNER JOIN #terceiros.TB_Endereco e ON e.IDEndereco = ec.IDEndereco
        INNER JOIN #terceiros.TB_TipoLogradouro tl ON e.IDTipoLogradouro = tl.IDTipoLogradouro
        INNER JOIN #terceiros.TB_Bairro b ON e.IDBairro = b.IDBairro
        INNER JOIN #terceiros.TB_Cidade cid ON b.IDCidade = cid.IDCidade
        WHERE c.IDCliente = %s GROUP BY ec.TipoEndereco
        ORDER BY e.IDEndereco DESC;"""
        data = (int(idCliente),)
        bdTerceiros = CONFIG.get("BANCO", 'database_terceiros')
        if(bdTerceiros == ''):
            raise configparser.NoOptionError("database_terceiros", "BANCO")
        sql = utils.stringFormat(sql.replace('#terceiros', bdTerceiros))
        cur.execute(sql, data)
        response = cur.fetchall()
        log.query_log(cur._executed, response)
        return response
    except myc.ProgrammingError as syntaxError:
        log.log.error(
            'Erro na sintaxe da query e/ou tabela inexistente: %s' % syntaxError)
        return None
    except Exception as e:
        msg = Exceptions.queryExceptions(e.__class__.__name__)
        log.log.error(
            "{0}: {1}".format(msg, e))
        return None

def findDadosDebitoCliente(cnx, idCLiente, banco):
    try:
        cur = cnx.cursor(dictionary=True)
        sql = """SELECT d.*, b.CodigoBanco FROM TB_DadosDebitoCliente d
        INNER JOIN {}.TB_Banco b ON d.IDBanco = b.IDBanco
        WHERE d.IDCliente = %s;""".format(banco)
        data = (idCLiente,)
        bdFinanceiro = CONFIG.get("BANCO", 'database_financeiro')
        if(bdFinanceiro == ''):
            raise configparser.NoOptionError("database_financeiro", "BANCO")
        sql = sql.replace('#financeiro', bdFinanceiro)
        cur.execute(sql, data)
        response = cur.fetchall()
        log.query_log(cur._executed, response)
        
        return response
    except myc.ProgrammingError as syntaxError:
        log.log.error(
            'Erro na sintaxe da query e/ou tabela inexistente: %s' % syntaxError)
        return None
    except Exception as e:
        msg = Exceptions.queryExceptions(e.__class__.__name__)
        log.log.error(
            "{0}: {1}".format(msg, e))
        return None

def updateStatusIntegracaoCliente(cnx, idCliente, status):
    try:
        cur = cnx.cursor()
        sql = "UPDATE TB_Cliente SET IsIntegrado = %s WHERE IDCliente = %s"
        data = (status, idCliente)
        cur.execute(sql, data)
        cnx.commit()
        log.query_log(
            cur._executed, "Quantidade de linhas alteradas:%s" % cur.rowcount)
        
    except myc.ProgrammingError as syntaxError:
        log.log.error(
            'Erro na sintaxe da query e/ou tabela inexistente: %s' % syntaxError)
        return None
    except Exception as e:
        msg = Exceptions.queryExceptions(e.__class__.__name__)
        log.log.error(
            "{0}: {1}".format(msg, e))
        return None

def insereLogIntegracaoClientes(cnx, acao, tipoAcao, idCliente, idUsuario):
    try:
        cur = cnx.cursor()
        sql = "INSERT INTO TB_LogIntegracaoClientes (Acao, TipoAcao, DataLog, IDCliente, IDUsuario) VALUES (%s, %s, NOW(), %s, %s);"
        data = (acao, tipoAcao, idCliente, idUsuario)
        cur.execute(sql, data)
        cnx.commit()
        log.query_log(
            cur._executed, "Quantidade de linhas alteradas:%s" % cur.rowcount)
        
    except myc.ProgrammingError as syntaxError:
        log.log.error(
            'Erro na sintaxe da query e/ou tabela inexistente: %s' % syntaxError)
        return None
    except Exception as e:
        msg = Exceptions.queryExceptions(e.__class__.__name__)
        log.log.error(
            "{0}: {1}".format(msg, e))
        return None

def getFormasCobrancaSAP(cnx, banco):
    try:
        cur = cnx.cursor(dictionary=True)
        # <> == (not equal)!=. O símbolo <> é o mesmo de diferente.
        sql = "SELECT f.CodigoSap FROM {}.TB_FormaCobranca f WHERE f.CodigoSap IS NOT NULL AND f.CodigoSap <> '' GROUP BY f.CodigoSap".format(banco)
        cur.execute(sql)
        response = cur.fetchall()
        log.query_log(cur._executed, response)
        
        return response

    except myc.ProgrammingError as syntaxError:
        log.log.error(
            'Erro na sintaxe da query e/ou tabela inexistente: %s' % syntaxError)
        return None
    except Exception as e:
        msg = Exceptions.queryExceptions(e.__class__.__name__)
        log.log.error(
            "{0}: {1}".format(msg, e))
        return None

def getConfiguracaoByChave(cnx, banco, chave):
    log.log.info(
            "{0}: {1}".format(banco, chave))
    try:
        cur = cnx.cursor(dictionary=True)
        sql = "SELECT ValorConfiguracao FROM {}.TB_Configuracoes WHERE ChaveConfiguracao = %s".format(banco)
        data = (chave,)
        cur.execute(sql, data)
        response = cur.fetchone()
        log.query_log(cur._executed, response)
        return response['ValorConfiguracao']
    except myc.ProgrammingError as syntaxError:
        log.log.error(
            'Erro na sintaxe da query e/ou tabela inexistente: %s' % syntaxError)
        return None
    except Exception as e:
        msg = Exceptions.queryExceptions(e.__class__.__name__)
        log.log.error(
            "{0}: {1}".format(msg, e))
        return None

def getServidorIntegracaoSap(cnx, banco):
    try:
        cur = cnx.cursor(dictionary=True)
        sql = "SELECT ValorConfiguracao FROM {}.TB_Configuracoes WHERE ChaveConfiguracao = 'ID_SERVIDOR_INTEGRACAO'".format(banco)
        print(sql)
        cur.execute(sql)
        response = cur.fetchone()
        idServidorIntegracao = response['ValorConfiguracao']
        print(idServidorIntegracao)
        if(idServidorIntegracao is not None and not(idServidorIntegracao == '')
           and idServidorIntegracao):
            sql = "SELECT URL, Login, AES_DECRYPT(Senha,'F583BE47632CEE39') as Senha, Porta FROM {}.TB_ServidorIntegracao WHERE IDServidorIntegracao = %s".format(banco)
            data = (idServidorIntegracao,)
            cur.execute(sql, data)
            response = cur.fetchone()
        log.query_log(cur._executed, response)
        
        return response
    except myc.ProgrammingError as syntaxError:
        log.log.error(
            'Erro na sintaxe da query e/ou tabela inexistente: %s' % syntaxError)
        return None
    except Exception as e:
        msg = Exceptions.queryExceptions(e.__class__.__name__)
        log.log.error(
            "{0}: {1}".format(msg, e))
        return None

def atualiza_status_cliente(cnx, status, idCliente):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
        """
            UPDATE TB_Cliente SET IsIntegrado = '{}' WHERE IDCliente = {};
        """.format(status,idCliente)
        )
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Falha ao realizar o insert no log %s' % e)
        return False

def insert_controle_execucao(cnx,banco,idusuario,idrotina,modulo):
    try:
        cur = cnx.cursor(dictionary=True)
        cur.execute(
        """
            INSERT %s.TB_ControleExecucaoRotina (IDUsuario,DataCadastro,`Status`,IDRotina) VALUES (%s,NOW(),'NOVO',%s)
        """ % (banco,idusuario,idrotina)
        )
        idcontrole = cur.lastrowid
        cur.execute('''
        INSERT %s.TB_ParametroExecucaoRotina 
								(IDControleExecucaoRotina,NomeParametro,TipoParametro,ValorParametro) 
				VALUES 
									(%s,'MODULO','STRING','%s');
        ''' % (banco,idcontrole,modulo))
        cnx.commit()
        cur.close()
        return True
    except Exception as e:
        log.log.error('Falha ao realizar o insert no controle execucao rotina: %s' % e)
        return False
