# -*- coding: utf-8 -*-
import datetime
import cgi
from re import UNICODE
import utils
import smtplib
from socket import gaierror
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from Configuracoes import Configuracoes
from exception import AdapterErrorException
import db
CONFIG = Configuracoes().getConfig()


def send_email(clientes=None, dataError=None, mensagemError=None, mensagem="Rotina", isError=False, cnxAdapter=None, banco=None):
    # tratar esse monte de chaves com exceção
    if cnxAdapter == None:
        msg = {"msg": "Connection to data base not provided",
               "error": "A conexão com o banco não foi informada"}
        AdapterErrorException
    port = CONFIG['EMAIL']['portaSMTP']
    smtp_server = CONFIG['EMAIL']['hostSMTP']
    login = CONFIG['EMAIL']['loginEmailAdapter']
    password = CONFIG['EMAIL']['senhaEmailAdapter']
    mensagem = formatMessage(
        mensagem, clientes, isError, dataError, mensagemError)
    sender_email = CONFIG['EMAIL']['remetenteAdapter']
    receiver_email = db.getConfiguracaoByChave(cnxAdapter, banco,'EMAILS_INTEGRACAO').split(';') if isError is False else CONFIG["CONFIG"]["destinatarioEmailsErros"]
    receiver_email = ','.join(receiver_email)
    receiver_email = str(receiver_email)
    message = MIMEMultipart("alternative")
    message["Subject"] = CONFIG['CONFIG']['assunto']
    message["From"] = sender_email 
    message["To"] = receiver_email
    # write the plain text part

    # convert both parts to MIMEText objects and add them to the MIMEMultipart message
    message.attach(MIMEText(mensagem, "html"))

    try:
        # send your message with credentials specified above
        server = smtplib.SMTP(str(smtp_server), int(port))
        server.ehlo()
        server.starttls()
        server.login(login, password)
        server.sendmail(sender_email, receiver_email,
                        message.as_string())
        server.close()
        # tell the script to report if your message was sent or which errors need to be fixed
        print('Sent')
    except (gaierror):
        print('Failed to connect to the server. Bad connection settings?')
    except smtplib.SMTPServerDisconnected:
        print('Failed to connect to the server. Wrong user/password?')
    except smtplib.SMTPException as e:
        print('SMTP error occurred: ' + str(e))


# def cria_mensagem(sucessos=[1, 2, 3, 4, 5], erros=[6, 7, 8, 9, 10]):


def formatMessage(message, clientes, isError=False, dataError=None, mensagemError=None):
    if dataError is None and isError:
        msg = {"msg": "Data não informada.",
               "error": "Date not provided"}
        raise AdapterErrorException(msg)
    if mensagemError is None and isError:
        msg = {"msg": "Mensagem de erro não informada.",
               "error": "Error message not provided"}
        raise AdapterErrorException(msg)
    headMessage = "<html><head>"
    styleMessage = """<style type='text/css'>.line:hover {background-color: #E0FFFF;} tr td {font-family: arial; vertical-align: center;
                text-align: center; border:1px solid #598080; text-decoration: none; overflow: hidden;}
                table {width:100%; border-collapse: collapse; border-spacing: 0; border:1px #598080; border-bottom-style:solid;}
                .title {font-family: arial; font-size: 31px; font-weight: bold; border:1px solid #598080; background-color: #598080}
                .header {font-weight: bold; font-size: 10px; border:1px solid #598080; background-color: #95CECE}</style></head>"""
    bodyMessage = """<body><br/><br/><br/><table cellpadding='8'><tr class='title'>
                    <td><img src='http://rotinas.viareal.int/images/viareal_logo.png' width='160px'/></td>
                    <td colspan='14'><p>{0}</p></td></tr>""".format(cgi.escape(message))
    bodyMessage += "<tr class='header'><td>Cliente</td><td colspan='14'>Resposta</td></tr>" if isError is False else\
        "<tr class='header'><td>Data</td><td colspan='8'>Erro</td></tr>"
    if isError:
        bodyMessage += "<tr class='line'>"
        bodyMessage += "<td colspan='8' style='font-size: 12px;'>" + \
            dataError.strftime('%d %b %Y %H:%M:%S') + "</td>"
        bodyMessage += "<td style='font-size: 12px;'>" + \
            cgi.escape(mensagemError) + "</td>"
        bodyMessage += "</tr>"
    else:
        for cliente in clientes:
            for key in cliente.keys():
                bodyMessage += """<tr class='line'><td style='font-size: 10px;'>
                            {0} "</td>""".format(str(key))
                bodyMessage += "<td colspan='14' style='font-size: 10px;'>{0}</td>".format(cliente)

            bodyMessage += "</tr>"
    bodyMessage += "</table></body>"

    return headMessage + styleMessage + bodyMessage + "</html>"
