# coding: utf-8 -*-
from mysql.connector import connect, connection
import db, log, requests, time
import utils, copy
from Configuracoes import Configuracoes

CONFIG = Configuracoes().getConfig()
DATABASEFINANCEIRO = CONFIG.get("BANCO", "database_financeiro")

class SapService():
    def __init__(self, pool, erros, lock, log, cliente, url, cardCodeDocumento, debitorAccount, downPaymentClearAct, substituirTipoEnderecoPadrao, 
        addressTypeExtenso, tipoLogradouroAbreviado, formasCobrancaSap, atualizacaoInformaTipoTributario, emailPadraoCliente, idUsuarioTarefasAutomaticas,
        usuarioWSSap, senhaWSSap):
        self.pool = pool
        self.lock = lock
        self.log = log
        self.erros = erros
        self.cliente = cliente
        self.url = url
        self.usuarioWSSap = usuarioWSSap
        self.senhaWSSap = senhaWSSap
        self.cardCodeDocumento = cardCodeDocumento
        self.debitorAccount = debitorAccount
        self.downPaymentClearAct = downPaymentClearAct
        self.substituirTipoEnderecoPadrao = substituirTipoEnderecoPadrao
        self.addressTypeExtenso = addressTypeExtenso
        self.tipoLogradouroAbreviado = tipoLogradouroAbreviado
        self.formasCobrancaSap = formasCobrancaSap
        self.atualizacaoInformaTipoTributario = atualizacaoInformaTipoTributario
        self.emailPadraoCliente = emailPadraoCliente
        self.idUsuarioTarefasAutomaticas = idUsuarioTarefasAutomaticas

    def replaceCaracteres(self, texto):
        texto = texto
        if (texto is None):
            return texto
        caracteres = [u"'", u"°", u"/", u"º", u"ª", u":"]
        substituto = [u"", u"", u"", u"", u"", u""]
        for i in range(len(caracteres)):
            texto = texto.replace(caracteres[i], substituto[i])
        return texto

    def cria_log(self, cnx, url, sucesso, retornoSAP, dadosEnviados, tempoResposta, idUsuarioTarefasAutomaticas, mensagemErro, idCliente, erroSAP):
        acao = ""
        respostaSAP = None
        dataSAP = None
        retorno = None
        tipoAcao = "CADASTRO"
        if sucesso:
            if self.isUpdate:
                acao = "EDICAO DE CLIENTE NO SAP\n"
            else:
                acao = "NOVO CLIENTE ENVIADO AO SAP\n"
        else:
            if self.isUpdate:
                acao = "ERRO NA EDICAO DE CLIENTE NO SAP\n"
            else:
                acao = "ERRO NA CRIACAO DE NOVO CLIENTE NO SAP\n"
        
        if self.isUpdate:
            tipoAcao = "ATUALIZAR"

        if retornoSAP is not None:
            retorno = retornoSAP
        else:
            respostaSAP = mensagemErro
            dataSAP = "Nao houve retorno do SAP"
            retorno = "Nao houve retorno do SAP"
        
        acao = "{}\t#URL: {}\n".format(acao,url)
        acao = "{}\t#{}: {}\n".format('Resposta de erro do SAP' if erroSAP else 'Resposta',acao,self.resposta_SAP)
        acao = "{}\t#DATA SAP: {}\n".format(acao,self.data_SAP)
        acao = "{}\t#Tempo resposta: {} s\n".format(acao,tempoResposta)
        acao = "{}\t#Dados enviados: \n\n{}\n".format(acao,dadosEnviados)
        acao = "{}\t#Dados recebidos: \n\n{}\n".format(acao,retorno)
        if self.response is not None:
            acao = "{}\t#Dados recebidos em JSON: \n\n{}\n".format(acao,self.response)
        db.insereLogIntegracaoClientes(cnx,acao,tipoAcao,idCliente,idUsuarioTarefasAutomaticas)

    def cria_json_integracao(self):
        idCliente = "{0}".format(self.cliente["IDCliente"])
        nomeCliente = "{0}".format(self.cliente["Nome"])
        lstEnderecos = db.findEnderecosCliente(self.cnx, idCliente)
        self.cliente["Enderecos"] = lstEnderecos
        lstContatos = db.findContatosCliente(self.cnx, idCliente)
        self.cliente["Contatos"] = lstContatos
        lstDadosDebito = db.findDadosDebitoCliente(self.cnx, idCliente,DATABASEFINANCEIRO)
        self.cliente["DadosDebito"] = lstDadosDebito
        isRespostaErroSap = False
        dadosFormatadosCliente = {}
        
        self.isUpdate = self.cliente["IsIntegrado"] is not None and not self.cliente["IsIntegrado"] == "N"
        if self.isUpdate:
            self.url += "/api/BusinessPartner/AtualizarParceiroNegocio"
        else:
            self.url += "/api/BusinessPartner/NovoParceiroNegocio"
        if (len(self.cliente["Nome"]) < 3 or len(self.cliente["Nome"]) > 60):
            raise ValueError(
                "Cliente: {0}, Com nome incorreto.".format(idCliente))

        #dadosFormatadosCliente["Industry"] = "3"  # MOB
        if (self.cardCodeDocumento != None and self.cardCodeDocumento == "1"):
            if (self.cliente["TipoPessoa"] == "PessoaJuridica"):
                dadosFormatadosCliente["CardCode"] = "C{0}".format(
                    self.cliente["CNPJ"])
                # Código do PN -> PADRÃO - Utilizar a letra "C"

            else:
                dadosFormatadosCliente["CardCode"] = "C000{0}".format(
                    self.cliente["CPF"])
                # Código do PN -> PADRÃO - Utilizar a letra "C"

        else:
            dadosFormatadosCliente["CardCode"] = "C{0}".format(idCliente)
            # Código do PN -> PADRÃO - Utilizar a letra "C"
        dadosFormatadosCliente["CardName"] = self.cliente["Nome"]
        # Nome do Parceiro
        if (self.cliente["TipoPessoa"] == "PessoaJuridica"):
            dadosFormatadosCliente["CardFName"] = self.cliente["NomeFantasia"]
            # Nome Fantasia do PN
            dadosFormatadosCliente["CardForeignName"] = self.cliente["NomeFantasia"]
        else:
            dadosFormatadosCliente["CardForeignName"] = self.cliente["Nome"]

        # Tipo de PN [C-Cliente | F-Fornecedor | L-Lead (Cliente em potencial)
        dadosFormatadosCliente["CardType"] = "C"
        dadosFormatadosCliente["SalesPersonCode"] = -1
        if(self.cliente["TelefoneFixo"] != None and len(self.cliente["TelefoneFixo"]) >= 10):
            ddd = self.cliente["TelefoneFixo"][:2].strip()
            telefone = self.cliente["TelefoneFixo"][2:len(
                self.cliente["TelefoneFixo"])].strip()
            if (len(ddd) != 2):
                raise ValueError(
                    "Cliente: {0}, Cliente está com DDD incorreto.".format(idCliente))

            if (len(telefone) < 8):
                raise ValueError(
                    "Cliente:{0}, Cliente está com Telefone incorreto.".format(idCliente))

            dadosFormatadosCliente["Phone2"] = ddd
            # DDD
            dadosFormatadosCliente["Phone1"] = telefone
            # Telefone do PN
        else:
            raise ValueError(
                "Cliente: {0}, Cliente está sem Telefone.".format(idCliente))

        if (self.cliente["EndEmail"] is not None and self.cliente["EndEmail"]):
            # E-Mail do PN
            dadosFormatadosCliente["EmailAddress"] = self.cliente["EndEmail"]
        else:
            if (self.emailPadraoCliente is not None and self.emailPadraoCliente):
                # E-Mail do PN
                dadosFormatadosCliente["EmailAddress"] = self.emailPadraoCliente

        #dadosFormatadosCliente["U_TU_CODATRIX"] = idCliente
        # MOB
        #dadosFormatadosCliente["U_TU_COBIMPRESSA"] = "N"
        # MOB
        #dadosFormatadosCliente["U_TU_Revisado"] = "N"
        # MOB

        # if (not self.isUpdate):
        #     # MOB
        #     dadosFormatadosCliente["U_TU_TipoTributario"] = '' if "PessoaJuridica" == self.cliente["TipoPessoa"] else "9"
        # else:
        #     if (self.atualizacaoInformaTipoTributario):
        #         # MOB
        #         dadosFormatadosCliente["U_TU_TipoTributario"] = '' if "PessoaJuridica" == self.cliente["TipoPessoa"] else "9"


        # # MOB
        # dadosFormatadosCliente["DebitorAccount"] = \
        #     self.debitorAccount != None and self.debitorAccount if self.debitorAccount else str(
        #         "")


        # # MOB																									// MOB
        # dadosFormatadosCliente["DownPaymentClearAct"] = \
        #     self.downPaymentClearAct is not None and self.downPaymentClearAct if self.downPaymentClearAct else str(
        #         "")
        
        # dadosFormatadosCliente["Valid"] = "tYES"  # TODO MOB
        bpFiscalTaxIDCollection = []
        dadosPessoa = {}
        if (self.cliente["TipoPessoa"] == "PessoaFisica"):
            dadosPessoa["TaxId1"] = "ISENTO"
            # Inscrição Estadual **
            dadosPessoa["TaxId3"] = "ISENTO"
            # Inscrição Municipal
            dadosPessoa["TaxId4"] = self.cliente["CPF"]
            # Campo de CPF
            dadosFormatadosCliente["U_SBZ_DACliEmp"] = self.cliente["CPF"]
            dadosFormatadosCliente["U_TpAssinante"] = "3"
            dadosFormatadosCliente["U_TpCli_ComEnerg"] = "03"
        else:
            dadosPessoa["TaxId0"] = self.cliente["CNPJ"]
            # Campo de CNPJ
            dadosPessoa["TaxId1"] = self.cliente["InscricaoEstadual"]
            # Inscrição Estadual **
            dadosPessoa["TaxId3"] = self.cliente["InscricaoMunicipal"]
            # Inscrição Municipal
            dadosFormatadosCliente["U_TpAssinante"] = "1"
            dadosFormatadosCliente["U_TpCli_ComEnerg"] = "01"

        bpFiscalTaxIDCollection.append(dadosPessoa)
        dadosFormatadosCliente["BPFiscalTaxIDCollection"] = bpFiscalTaxIDCollection
        rowNum = 0
        bpAddresses = []
        possuiEnderecoCobranca = False
        mapEndereco = {}

        # Parei na 192
        for end in self.cliente["Enderecos"]:
            mapEndereco = {}
            if (end["TipoEndereco"] == "COBRANCA"):
                possuiEnderecoCobranca = True

            mapEndereco["RowNum"] = copy.copy(rowNum)
            
            rowNum = rowNum + 1
            
            # CRIAR A EXCEÇÂO DE WARNING
            if (end["TipoEndereco"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem AddressName.")

            if (end["TipoEndereco"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem TypeOfAddress.")

            if (end["Abreviatura"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem Street.")

            if (end["CepEndereco"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem ZipCode.")

            if (end["NumEndereco"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem StreetNo.")

            if (end["NomeBairro"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem Block.")

            if (end["NomeCidade"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem City.")

            if (end["UFCidade"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem State.")

            if (end["CodigoCidadeIBGE"] is None):
                raise ValueError(
                    "Cliente: " + idCliente + ", Sem IBGE.")

            if (self.substituirTipoEnderecoPadrao is not None and end["TipoEndereco"] == "PADRAO"):
                mapEndereco["AddressName"] = self.substituirTipoEnderecoPadrao
            else:
                mapEndereco["AddressName"] = end["TipoEndereco"]
            
            if (self.addressTypeExtenso is not None and self.addressTypeExtenso == "1"):
                mapEndereco["AddressType"] = "bo_BillTo" if end["TipoEndereco"] == "COBRANCA" else "bo_ShipTo"
            else:
                mapEndereco["AddressType"] = "B" if end["TipoEndereco"] == "COBRANCA" else "S"
               
            if (self.tipoLogradouroAbreviado is not None and self.tipoLogradouroAbreviado == "1"):
                mapEndereco["TypeOfAddress"] = self.replaceCaracteres(end["Abreviatura"])
            else:
                mapEndereco["TypeOfAddress"] = self.replaceCaracteres(end["DescricaoTipoLogradouro"])

            mapEndereco["Street"] = self.replaceCaracteres(end["LogradouroEndereco"])
            # Nome da Rua
            # **
            mapEndereco["StreetNo"] = end["NumEndereco"]  # Número da Casa **
            if (end["ComplementoEndereco"] is not None and end["ComplementoEndereco"]):
                mapEndereco["BuildingFloorRoom"] = self.replaceCaracteres(end["ComplementoEndereco"])
                # Complemento
                # **
            mapEndereco["ZipCode"] = end["CepEndereco"]
            # CEP **
            mapEndereco["Block"] = self.replaceCaracteres(end["NomeBairro"])
            # Bairro **
            mapEndereco["City"] = self.replaceCaracteres(end["NomeCidade"])
            # Cidade **
            mapEndereco["State"] = self.replaceCaracteres(end["UFCidade"])
            # Estado **
            mapEndereco["IBGE"] = end["CodigoCidadeIBGE"]
            # Municipio **
            mapEndereco["Country"] = "BR"
            mapEndereco["U_SKILL_indIEDest"] = self.cliente["IndicadorIE"]
            bpAddresses.append(mapEndereco)
        
        if (not possuiEnderecoCobranca and len(self.cliente["Enderecos"]) > 0):
            for map in bpAddresses:
                if (map["AddressName"] == "PADRAO"
                        or map["AddressName"] == "INSTALACAO"
                        or self.substituirTipoEnderecoPadrao is not None
                        and map["AddressName"] == self.substituirTipoEnderecoPadrao):
                    mapEndereco = {}
                    mapEndereco = copy.deepcopy(map)  

            mapEndereco["RowNum"] = rowNum
            mapEndereco["AddressName"] = "COBRANCA"
            mapEndereco["AddressType"] = "bo_BillTo" if (self.addressTypeExtenso is not None and self.addressTypeExtenso == "1") else "B"  # Tipo do endereço[B-Cobrança S-Entrega] **

            bpAddresses.append(mapEndereco)
        
        if (self.substituirTipoEnderecoPadrao is not None):
            cont = 0
            for map in bpAddresses:
                if (map["AddressName"] == "ENTREGA"):
                    map["RowNum"] = 1
                else:
                    if (cont == 1):
                        cont = +1
                    map["RowNum"] = cont
                    cont = +1

        dadosFormatadosCliente["BPAddresses"] = bpAddresses
        contactEmployees = []
        for contato in self.cliente["Contatos"]:
            mapContato = {}
            mapContato["Name"] = contato["Tipo"]
            if (contato["Nome"] is not None and contato["Nome"]):
                mapContato["FirstName"] = contato["Nome"]  # Pais **
            if (contato["Telefone"] is not None and contato.get("Telefone")
                    and len(contato.get("Telefone")) >= 10):
                mapContato["Phone2"] = contato["Telefone"][:2]  # DDD **
                # Telefone **
                mapContato["Phone1"] = contato["Telefone"][2:len(
                    contato["Telefone"])]
            if (contato.get("Celular") is not None and contato["Celular"]
                    and len(contato["Celular"]) >= 10):
                mapContato["MobilePhone"] = contato["Celular"][2: len(
                    contato["Celular"])]  # Celular **

            if (contato["Email"] is not None and contato["Email"]):
                mapContato["E_Mail"] = contato["Email"]  # E-Mail **
            elif (self.emailPadraoCliente is not None and self.emailPadraoCliente):
                mapContato["E_Mail"] = self.emailPadraoCliente  # E-Mail do PN

            contactEmployees.append(mapContato)
            
        dadosFormatadosCliente["ContactEmployees"] = contactEmployees
        bpBankAccounts = []
        dadosBanco = self.cliente["DadosDebito"]
        if (dadosBanco is not None and len(dadosBanco) > 0):
            # dúvida, só o num 0?
            dadosFormatadosCliente["U_SBZ_DACliBco"] =\
                dadosBanco[0]["NumeroConta"] +\
                dadosBanco[0]["DVConta"] if dadosBanco[0]["DVConta"] is not\
                None else ""
            for dadosDebito in dadosBanco:
                mapDebito = {}
                mapDebito["Country"] = "BR"
                mapDebito["BankCode"] = dadosDebito["CodigoBanco"]
                mapDebito["Branch"] = dadosDebito["Agencia"]
                mapDebito["AccountNo"] = dadosDebito["NumeroConta"]
                mapDebito["ControlKey"] =\
                    dadosDebito["DVConta"] if dadosDebito["DVConta"] is not\
                    None else ""
                mapDebito["MandateID"] =\
                    dadosDebito["DVAgencia"] if dadosDebito["DVAgencia"]\
                    is not None else None
                bpBankAccounts.append(mapDebito)
        dadosFormatadosCliente["BPBankAccounts"] = bpBankAccounts
        # abrir financeiro só aqui
        
        bpPaymentMethods = []
        rowNumber = 0
        for formaCobranca in self.formasCobrancaSap:
            paymentMethodCode = {}
            paymentMethodCode["RowNumber"] = "{0}".format(rowNumber)
            rowNumber += 1
            paymentMethodCode["PaymentMethodCode"] = formaCobranca["CodigoSap"]
            bpPaymentMethods.append(paymentMethodCode)

        dadosFormatadosCliente["BPPaymentMethods"] = bpPaymentMethods

        return dadosFormatadosCliente

    def integrar(self):
        self.cnx = db.connect_db(self.pool)
        try:
            tempoResposta = 0
            sucesso = False
            self.isUpdate = False
            self.data_SAP = None
            respostaSAP = None
            msg = None
            json_integrar = None
            erroSAP = False
            inicio = None
            self.response = None
            try:
                
                print("Cliente {} Connection ID: {} ".format(self.cliente["IDCliente"], self.cnx.connection_id))

                self.resposta_SAP = None
                json_integrar = self.cria_json_integracao()
                inicio = time.time()
                print(self.url)
                print(self.usuarioWSSap)
                print(str(self.senhaWSSap,'UTF-8'))
                r = requests.post(self.url, json=json_integrar,auth=requests.auth.HTTPBasicAuth(self.usuarioWSSap, str(self.senhaWSSap,'UTF-8')))
                fim = time.time()
                tempoResposta = abs(fim - inicio)  # Em ms
                self.response = r.json()
                print("Retorno do SAP\n{}".format(r.text))
                if r.status_code != 200:
                    msg = {"error": "Server responded with a status code other than 200(OK!)",
                        "msg": "O servidor não conseguiu processar a requisição",
                        "sap": r.text}
                    raise ValueError(msg)
            
                r.close()
                
                if 'message' in self.response:
                    self.resposta_SAP = self.response['message']
                elif 'Message' in self.response:
                    self.resposta_SAP = self.response['Message']
                else:
                    self.resposta_SAP = 'Nao identificada'
                
                self.data_SAP = None
                if 'data' in self.response:
                    self.data_SAP = self.response['data']
                elif 'Data' in self.response:
                    self.data_SAP = self.response['Data']
                else:
                    self.data_SAP = 'Nao identificada'

                if 'status' not in self.response or self.response['status'] != '0':
                    valida = 'o PN C{} ja existe'.format(self.cliente["IDCliente"])
                    if valida in self.data_SAP:
                        sucesso = True
                        erroSAP = False
                    else:
                        sucesso = False
                        erroSAP = True
                else:
                    sucesso = True
                    erroSAP = False

            except ValueError as eDict:
                if time is not None and tempoResposta == None and inicio != None:
                    fim = time.time()
                    tempoResposta = abs(fim - inicio)  # Em ms

                sucesso = False

                if type(eDict) is dict:
                    msg = "{0}: {1}".format(eDict.message["msg"], eDict.message["error"])
                    self.log.log.error(msg)
                else:
                    msg = eDict
                    self.log.log.error(eDict)

                self.resposta_SAP = msg
                if self.data_SAP is None:
                    self.data_SAP = 'Nao identificada'
            except requests.exceptions.RequestException as connectionError:
                if time is not None and tempoResposta == None and inicio != None:
                    fim = time.time()
                    tempoResposta = abs(fim - inicio)  # Em ms

                sucesso = False

                msg = "Erro ao conectar no servidor: {0}".format(connectionError)
                self.log.log.error(msg)
                self.resposta_SAP = msg
                if self.data_SAP is None:
                    self.data_SAP = 'Nao identificada'
            except Exception as e:
                if time is not None and tempoResposta == None and inicio != None:
                    fim = time.time()
                    tempoResposta = abs(fim - inicio)  # Em ms
                sucesso = False

                msg = "Erro nao identificado {}".format(e)
                self.log.log.error(msg)
                self.resposta_SAP = msg
                if self.data_SAP is None:
                    self.data_SAP = 'Nao identificada'
            finally:
                if sucesso:
                    db.atualiza_status_cliente(self.cnx,'S',self.cliente["IDCliente"])
                else:
                    db.atualiza_status_cliente(self.cnx,'E' if self.isUpdate else 'N',self.cliente["IDCliente"])
                    self.erros.append({"{} - {}".format(self.cliente["IDCliente"],self.cliente["Nome"]):self.resposta_SAP})
                self.cria_log(self.cnx,self.url,sucesso,self.resposta_SAP,json_integrar,(round(tempoResposta,2) / 1000),self.idUsuarioTarefasAutomaticas,msg,self.cliente["IDCliente"],erroSAP)
        except Exception as e:
            print(e)
            print("Cliente {} RTRRRRRRRR ".format(self.cliente["IDCliente"]))

        db.close_connect_db(self.cnx)

            
