# -*- coding: utf-8 -*-
from datetime import datetime
import sys, utils, log
from Configuracoes import Configuracoes
import time, SapServiceRunnable, db
import concurrent.futures
import threading
import adapterEmail

CONFIG = Configuracoes().getConfig()
MENSAGEMCLIENTEERRO = "Rela&ccedil;&atilde;o dos clientes com erro na integra&ccedil;&atilde;o com o SAP"
MENSAGEMCLIENTESINTEGRADOS = "Rela&ccedil;&atilde;o dos clientes integrados ao SAP"
MENSAGEMERROR = "Erro de Execu&ccedil;&atilde;o Integra&ccedil;&atilde;o com o SAP - Clientes"
HOST = CONFIG.get("BANCO", "host")
DATABASECOMERCIAL = CONFIG.get("BANCO", "database_comercial")
DATABASEFINANCEIRO = CONFIG.get("BANCO", "database_financeiro")
DATABASEADAPTER = CONFIG.get("BANCO", "database_adapter")
PORTA = CONFIG.get("BANCO", 'porta')
LOGIN = CONFIG.get("BANCO", 'loginBancoAdapter')
PASSWORD = CONFIG.get("BANCO", "passwordBancoAdapter")
NUMERO_DE_THREAD = CONFIG.get("CONFIG", "numeroThreads")
print(NUMERO_DE_THREAD)
def main(argv):

    inicio = time.time()  # trocar para monotonic
    cnxComercial = None
    cnxFinanceiro = None
    cnxAdapter = None
    try:
        
        tipoIntegracao = argv[1]
        idCliente = ""
        inicioID = None
        fimID = None

        if(tipoIntegracao == "2"):
            if(len(argv) < 3):
                msg = {"msg": "O IDCliente nao foi informado.",
                       "error": "sufficient arguments not provided"}
                raise ValueError(msg)
            else:
                for i in range(2, len(sys.argv)):
                    idCliente = sys.argv[i] + ','
            idCliente = idCliente[0:-1]

        else:
            if(tipoIntegracao == "3"):
                inicioID = argv[2]
                fimID = argv[3]
                print("inícioId:{0}  fimId:{1}".format(inicioID, fimID))

        log.log.info("Início do envio dos clientes para o SAP")
        pool = db.create_pool(HOST, DATABASECOMERCIAL,
                                     PORTA,
                                     LOGIN,
                                     PASSWORD)
        cnxComercial = db.connect_db(pool)
        print("Connection db1:", cnxComercial.connection_id)
                            
        lstClientes = db.findClientesNaoIntegrados(cnxComercial,
                                                   tipoIntegracao, idCliente,
                                                   inicioID, fimID)
        print("Quantidade de clientes:{0}".format(len(lstClientes)))
        log.log.info("Quantidade de clientes:{0}".format(len(lstClientes)))
        servidorIntegracao = db.getServidorIntegracaoSap(cnxComercial,DATABASEADAPTER)
        if(not ("URL" in servidorIntegracao) or
           not("Porta" in servidorIntegracao)):
            msg = "Dados do servidor de integração não encontrados"
            error = "integration server port or URL not found"
            raise ValueError({"msg": msg, "error": error})
        url = "{0}:{1}".format(
            servidorIntegracao["URL"], servidorIntegracao["Porta"])
        usuarioWSSap = servidorIntegracao["Login"]
        senhaWSSap = servidorIntegracao["Senha"]
        tempoLimite = db.getConfiguracaoByChave(cnxComercial,DATABASEADAPTER,
                                                "TEMPO_LIMITE_REQUISICAO_INTEGRACAO")
        timeOut = 30
        if(tempoLimite is not None and int(tempoLimite) > 0):
            timeOut = tempoLimite

        clientesIntegrados = {}
        clientesErro = []
        # pesquisar melhor sobre thread lock e sincronismo
        cardCodeDocumento = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                      "CARDCODE_DOCUMENTO_INTEGRACAO_CLIENTES_SAP")

        debitorAccount = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                   "VALOR_DEBITORACCOUNT_CLIENTES_SAP")

        downPaymentClearAct = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                        "VALOR_DOWNPAYMENTCLEARACT_CLIENTES_SAP")
        substituirTipoEnderecoPadrao = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                                 "TEXTO_SUBSTITUICAO_ENDERECO_TIPO_PADRAO_SAP")
        addressTypeExtenso = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                       "ADDRESS_TYPE_CLIENTE_POR_EXTENSO_SAP")
        tipoLogradouroAbreviado = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                            "TIPO_LOGRADOURO_ABREVIADO_INTEGRACAO_SAP")
        atualizacaoInformaTipoTributario = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                                     "ATUALIZACAO_CLIENTE_SAP_INFORMA_TIPO_TRIBUTARIO") == "1"
        emailPadraoCliente = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                       "EMAIL_PADRAO_INTEGRACAO_CLIENTE")
        idUsuarioTarefasAutomaticas = db.getConfiguracaoByChave(cnxComercial,DATABASECOMERCIAL,
                                                                "ID_USUARIO_TAREFAS_AUTOMATICAS")
        idUsuarioTarefasAutomaticas = int(idUsuarioTarefasAutomaticas)                

        formasCobrancaSap = db.getFormasCobrancaSAP(cnxComercial,DATABASEFINANCEIRO)

        log.log.info(
            "Quantidade de clientes a serem integrados:{0}".format(
                len(lstClientes)))

        centro_custo_contratos = {}
        lock = threading.Lock()
        # Fazer a chamada da TASK nas threads#
        
        with concurrent.futures.ThreadPoolExecutor(max_workers = int(NUMERO_DE_THREAD)) as executor:
            for cliente in lstClientes:               
                future = executor.submit(SapServiceRunnable.SapService(pool,clientesErro,lock,log,cliente, url, cardCodeDocumento, debitorAccount, downPaymentClearAct, substituirTipoEnderecoPadrao, 
        addressTypeExtenso, tipoLogradouroAbreviado, formasCobrancaSap, atualizacaoInformaTipoTributario, emailPadraoCliente, idUsuarioTarefasAutomaticas, usuarioWSSap, senhaWSSap).integrar)
            executor.shutdown(wait=True)
        
        print("===================== FIM ======================")
        cnxAdapter = db.connect_db(pool)
        adapterEmail.send_email(clientesErro, mensagem=MENSAGEMCLIENTEERRO, cnxAdapter=cnxAdapter, banco=DATABASEADAPTER)

        log.log.info("Fim do envio dos clientes para o SAP")
        fim = time.time()
        tempoResposta = abs(fim - inicio)  # Em ms
        log.log.info(
            "===============> TEMPO TOTAL = {0} + ".format(tempoResposta))

    except Exception as e:
        print(e)
        log.log.info("ERRO: {0}".format(e))
    finally:
        db.close_connect_db(cnxComercial)


if __name__ == '__main__':
    
    if len(sys.argv) == 1 or (len(sys.argv) > 1 and sys.argv[1] == '?'):
        print ('''
        
        ########## Rotina de Integracao Clientes SAP ##########
        
            Para o funcionamento da rotina permitido os seguintes parametros:
            
            0 - Para reenviar toda a base de clientes;
            1 - Integra clientes pendedentes (nao integrados ou com erro)
            2 - Integra clientes informados. Ex: 1 2 3 4 5 6;
            3 - Integra clientes informados por Range do Menor ID para o Maior ID. Ex: 3 200;
            4 - Integra somente clientes novos (N)
            5 - Integra somente clientes erros (E)

        Para exibir essa lista novamente, necessario passar o parametro '?'

        ########## Rotina de Integracao Clientes SAP ##########

        ''')
        exit()

    main(sys.argv)
