/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.financeiro;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import rotinas.adapter.financeiro.Banco;
import rotinas.adapter.financeiro.InstrucaoBancaria;

@Entity
@Table(name="TB_ContaFinanceira")
public class ContaFinanceira
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="IDContaFinanceira")
    private Long id;
    @JoinColumn(name="IDBanco")
    @ManyToOne
    private Banco banco;
    @Column(name="NomeContaFinanceira")
    private String nome;
    @Column(name="Agencia", length=5)
    private String agencia;
    @Column(name="ContaCorrente")
    private String contaCorrente;
    @Column(name="Ativo")
    private boolean ativo;
    @Column(name="IDEmpresa")
    private Long empresa;
    @Column(name="CodigoCedente")
    private String codigoCedente;
    @Column(name="DVAgencia", length=1)
    private String dvAgencia;
    @Column(name="DVContaCorrente", length=1)
    private String dvContaCorrente;
    @OneToMany(mappedBy="contaFinanceira", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<InstrucaoBancaria> instrucoes;
    @Column(name="SaldoInicial")
    private Double saldoInicial;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DataSaldoInicial")
    private Date dataSaldoInicial;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Banco getBanco() {
        return this.banco;
    }

    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    public String getContaCorrente() {
        return this.contaCorrente;
    }

    public void setContaCorrente(String contaCorrente) {
        this.contaCorrente = contaCorrente;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public Long getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Long empresa) {
        this.empresa = empresa;
    }

    public String getCodigoCedente() {
        if (this.codigoCedente != null && this.codigoCedente.contains("-")) {
            return this.codigoCedente.split("-")[0];
        }
        return this.codigoCedente;
    }

    public void setCodigoCedente(String codigoCedente) {
        this.codigoCedente = codigoCedente;
    }

    public List<InstrucaoBancaria> getInstrucoes() {
        return this.instrucoes;
    }

    public void setInstrucoes(List<InstrucaoBancaria> instrucoes) {
        this.instrucoes = instrucoes;
    }

    public Double getSaldoInicial() {
        return this.saldoInicial;
    }

    public void setSaldoInicial(Double saldoInicial) {
        this.saldoInicial = saldoInicial;
    }

    public String getDvAgencia() {
        return this.dvAgencia;
    }

    public void setDvAgencia(String dvAgencia) {
        this.dvAgencia = dvAgencia;
    }

    public String getDvContaCorrente() {
        return this.dvContaCorrente;
    }

    public void setDvContaCorrente(String dvContaCorrente) {
        this.dvContaCorrente = dvContaCorrente;
    }

    public Date getDataSaldoInicial() {
        return this.dataSaldoInicial;
    }

    public void setDataSaldoInicial(Date dataSaldoInicial) {
        this.dataSaldoInicial = dataSaldoInicial;
    }

    public String obterCodigoCedenteComDV() {
        return this.codigoCedente;
    }
}

