/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import rotinas.adapter.config.AdapterTerceirosDatabase;

public class TerceirosDao {
    public Map<String, Object> findDadosDetalhadosEmpresaByID(Long idEmpresa) {
        String sql = "SELECT emp.IDEmpresa as 'id', p.NomePessoa as 'razao', p.NomeFantasiaPessoaJuridica as 'nomeFantasia', p.CNPJPessoaJuridica as 'cnpj', p.InscrEstadualPessoaJuridica as 'inscricaoEstadual', tel.NumTelefone as 'telefone', ePes.NumEndereco as 'numero', e.LogradouroEndereco as 'logradouro', b.NomeBairro as 'bairro', c.NomeCidade as 'cidade', c.UFCidade as 'estado', e.CepEndereco as 'cep', p.IDTributacaoFederal FROM TB_Empresa emp INNER JOIN TB_Pessoa p ON p.IDPessoa = emp.IDPessoa LEFT JOIN TB_Telefone tel ON tel.IDPessoa = p.IDPessoa AND tel.IDTipoDeContato = 2 INNER JOIN TB_EnderecoPessoa ePes ON ePes.IDPessoa = p.IDPessoa INNER JOIN TB_Endereco e ON e.IDEndereco = ePes.IDEndereco INNER JOIN TB_Bairro b ON b.IDBairro = e.IDBairro INNER JOIN TB_Cidade c ON c.IDCidade = b.IDCidade WHERE emp.IDEmpresa = ?";
        try {
            Session session = AdapterTerceirosDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)idEmpresa);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Map map = (Map)q.uniqueResult();
            session.close();
            return map;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Map<String, Object> findEnderecoByID(Long idEndereco) {
        String sql = "SELECT CONCAT(TRIM(tipo.DescricaoTipoLogradouro),' ',TRIM(e.LogradouroEndereco)) as 'endereco', TRIM(b.NomeBairro) as 'bairro', TRIM(c.NomeCidade) as 'cidade', TRIM(c.UFCidade) as 'estado', TRIM(e.CepEndereco) as 'cep' FROM TB_Endereco e INNER JOIN TB_Bairro b ON b.IDBairro = e.IDBairro INNER JOIN TB_Cidade c ON c.IDCidade = b.IDCidade INNER JOIN TB_TipoLogradouro tipo ON tipo.IDTipoLogradouro = e.IDTipoLogradouro WHERE e.IDEndereco = ?";
        try {
            Session session = AdapterTerceirosDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)idEndereco);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Map map = (Map)q.uniqueResult();
            session.close();
            return map;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

