/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import rotinas.adapter.config.AdapterComercialDatabase;
import rotinas.adapter.config.AdapterFinanceiroDatabase;
import rotinas.adapter.config.AdapterTerceirosDatabase;
import rotinas.adapter.config.LoggerConfiguration;
import rotinas.adapter.envio.EnviarFaturasENotasFiscais;
import rotinas.adapter.envio.EnvioService;

public class Main {
    public static StringWriter sw = new StringWriter();
    public static PrintWriter pw = new PrintWriter(sw);

    public static void main(String[] args) throws SecurityException, IOException {
        long startTime = System.nanoTime();
        LoggerConfiguration log = LoggerConfiguration.getInstance();
        try {
            log.logger.info("=========== * Iniciando envio de faturas de notas fiscais * ===========");
            int semLog = 0;
            if (args.length > 5) {
                semLog = new Integer(args[5]);
            }
            new EnviarFaturasENotasFiscais().enviar(Integer.parseInt(args[0]), new Long(args[1]), new Long(args[2]), new Integer(args[3]), new Integer(args[4]), semLog);
        }
        catch (Exception e) {
            log.logger.log(Level.SEVERE, String.format("Falha na execu\u00e7\u00e3o do script: %s", e.toString()), e);
            new EnvioService().sendRelatorioDeErro(sw.toString());
        }
        AdapterFinanceiroDatabase.shutdown();
        AdapterComercialDatabase.shutdown();
        AdapterTerceirosDatabase.shutdown();
        log.logger.info(String.format("=========== * Envio de faturas e notas fiscais finalizado em %s ms. * ===========", TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS)));
        System.exit(0);
    }
}

