/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import rotinas.adapter.envio.ComercialDao;
import rotinas.adapter.envio.EmailNotaFiscalService;
import rotinas.adapter.envio.FinanceiroDao;
import rotinas.adapter.envio.TerceirosDao;
import rotinas.adapter.financeiro.ClienteDto;
import rotinas.adapter.financeiro.Fatura;
import rotinas.adapter.financeiro.FaturamentoMes;
import rotinas.adapter.financeiro.ItemNota;
import rotinas.adapter.financeiro.Nota;
import rotinas.adapter.financeiro.NotaFiscalDto;

@Stateless
public class ImprimirNotaService {
    private ClienteDto cliente;

    public void enviarNF(List<Nota> notas, FinanceiroDao financeiroDao, ComercialDao comercialDao, TerceirosDao terceirosDao, Long idModeloMsg) throws JRException {
        EmailNotaFiscalService emailNota = new EmailNotaFiscalService();
        ArrayList<String> anexos = new ArrayList<String>();
        ArrayList<Nota> notasCliente = new ArrayList<Nota>();
        Long idUsuario = this.getIDUsuarioLog(financeiroDao);
        Map<String, Object> modeloEmail = comercialDao.findMensagemEmail(idModeloMsg);
        String remetente = this.getEmailRemetente(financeiroDao);
        String pathLayoutNota = this.getPathModeloNota(financeiroDao);
        int envios = 0;
        int i = 0;
        while (i < notas.size()) {
            try {
                int cont = 1;
                anexos = new ArrayList();
                notasCliente = new ArrayList();
                File anexo = this.imprimirNF(notas.get(i), pathLayoutNota, financeiroDao, comercialDao, terceirosDao);
                if (anexo != null) {
                    anexos.add(anexo.getPath());
                    notasCliente.add(notas.get(i));
                    while (i + cont < notas.size() && notas.get(i + cont).getIdCliente().equals(notas.get(i).getIdCliente())) {
                        if (!notas.get(i + cont).getIdCliente().equals(notas.get(i).getIdCliente())) continue;
                        String anexo2 = this.imprimirNF(notas.get(i + cont), pathLayoutNota, financeiroDao, comercialDao, terceirosDao).getPath();
                        if (anexo2 != null) {
                            anexos.add(anexo2);
                            notasCliente.add(notas.get(i + cont));
                        }
                        ++cont;
                    }
                    i = i + cont - 1;
                    emailNota.enviar(notasCliente, this.cliente, anexos, idUsuario, idModeloMsg, modeloEmail, remetente, financeiroDao);
                    ++envios;
                }
                if (envios == 20) {
                    envios = 0;
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private File imprimirNF(Nota nota, String pathJasper, FinanceiroDao financeiroDao, ComercialDao comercialDao, TerceirosDao terceirosDao) throws JRException {
        try {
            NotaFiscalDto dto = this.geraDadosNotaCompletaDto(nota, null, false, false, comercialDao, terceirosDao, financeiroDao);
            if (dto != null) {
                String nomeArquivo = "NF_" + nota.getNumeroNF() + "_" + nota.getModeloNotaFiscal().getDescricao() + "_" + this.trataTamanhoString(dto.getNomeCliente(), 30);
                HashMap<String, String> parametros = new HashMap<String, String>();
                parametros.put("SUBREPORT_DIR", pathJasper);
                pathJasper = String.valueOf(pathJasper) + nota.getModeloNotaFiscal().getNomeArquivoJasper();
                String pathArquivoPdf = this.getPDFTempName(nomeArquivo);
                ArrayList<NotaFiscalDto> lista = new ArrayList<NotaFiscalDto>();
                lista.add(dto);
                JRBeanCollectionDataSource source = new JRBeanCollectionDataSource(lista);
                JasperPrint jp = JasperFillManager.fillReport((String)pathJasper, parametros, (JRDataSource)source);
                JasperExportManager.exportReportToPdfFile((JasperPrint)jp, (String)pathArquivoPdf);
                return new File(pathArquivoPdf);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<NotaFiscalDto> buscaNotasParaImpressaoUnificada(Fatura fatura, Boolean isSVAIncluso, Map<String, Object> empresa, String cfop, ComercialDao comercialDao, FinanceiroDao financeiroDao, TerceirosDao terceirosDao) throws Exception {
        HashSet<Nota> notas = new HashSet<Nota>();
        ArrayList<NotaFiscalDto> dtos = new ArrayList<NotaFiscalDto>();
        for (FaturamentoMes faturamento : fatura.getFaturamentos()) {
            if (faturamento.getItemNota() == null) continue;
            notas.add(faturamento.getItemNota().getNota());
        }
        for (Nota nota : notas) {
            NotaFiscalDto dto = this.geraDadosNotaCompletaDto(nota, empresa, isSVAIncluso, true, comercialDao, terceirosDao, financeiroDao);
            dto.setCfop(cfop);
            dtos.add(dto);
        }
        return dtos;
    }

    private NotaFiscalDto montaDadosDtoNota(Nota nota, Boolean isSVAIncluso, Boolean isModeloUnificado, FinanceiroDao financeiroDao, ComercialDao comercialDao) throws Exception {
        Object dadosContratos = null;
        String config = financeiroDao.findValorConfiguracoesByChave("EXIBE_INFORMACAO_CONTRATO_NO_ITEM_NOTA");
        if (!isModeloUnificado.booleanValue() && config != null && config.equals("1")) {
            HashSet<Long> idsContratos = new HashSet<Long>();
            for (ItemNota item : nota.getItensNota()) {
                idsContratos.add(item.getFaturamento().getIdContrato());
            }
        }
        NotaFiscalDto dto = new NotaFiscalDto();
        dto.setVencimento(nota.getVencimento());
        dto.setEmissao(nota.getDataEmissao());
        dto.setNumeroNota(nota.getNumeroNF());
        dto.setTextoAliquota("");
        dto.setDescricaoModeloNotaFiscal(nota.getModeloNotaFiscal().getDescriacaoComercial());
        dto.setCodigoModeloNota(nota.getModeloNotaFiscal().getCodigoModelo());
        if (!isSVAIncluso.booleanValue()) {
            dto.setContratoCliente(this.getPlanosContratoNota(nota, comercialDao));
        }
        Double baseICMS = 0.0;
        Double valorIsentoICMS = 0.0;
        Double valorICMS = 0.0;
        Double valorOutrosICMS = 0.0;
        Double aliquotaICMSTotal = 0.0;
        for (ItemNota item : nota.getItensNota()) {
            if (isSVAIncluso.booleanValue()) {
                item.setCodigoModeloNota(nota.getModeloNotaFiscal().getCodigoModelo());
                item.setAliquotaISS(new Double(item.getFaturamento().getComposicao().getIss()));
            }
            baseICMS = baseICMS + (item.getBaseICMS() != null ? item.getBaseICMS() : 0.0);
            valorIsentoICMS = valorIsentoICMS + (item.getValorIsentoICMS() != null ? item.getValorIsentoICMS() : 0.0);
            valorICMS = valorICMS + (item.getValorICMS() != null ? item.getValorICMS() : 0.0);
            valorOutrosICMS = valorOutrosICMS + (item.getValorOutrosICMS() != null ? item.getValorOutrosICMS() : 0.0);
            if (item.getAliquotaICMS() != null && item.getAliquotaICMS() > 0.0) {
                aliquotaICMSTotal = item.getAliquotaICMS();
            }
            if (isModeloUnificado.booleanValue() || dadosContratos == null) continue;
            item.setDescricao(comercialDao.findDadosContratoByID(item.getFaturamento().getIdContrato()));
        }
        if (isModeloUnificado.booleanValue() && isSVAIncluso.booleanValue()) {
            dto.setItensAgrupados(this.montaItensAgrupadosPorAliquota(nota));
        }
        dto.setItens(nota.getItensNota());
        dto.setValorICMSTotal(valorICMS);
        dto.setBaseICMSTotal(baseICMS);
        dto.setValorIsentoICMSTotal(valorIsentoICMS);
        dto.setValorOutrosICMSTotal(valorOutrosICMS);
        dto.setAliquotaICMSTotal(aliquotaICMSTotal);
        dto.setValorTotalItensNota(nota.getValor());
        if (nota.getModeloNotaFiscal().getCodigoModelo() != null && (nota.getModeloNotaFiscal().getCodigoModelo().equals(21) || nota.getModeloNotaFiscal().getCodigoModelo().equals(22))) {
            dto.setChaveCodificacaoDigital(this.formataChave(nota.getChaveCodificacaoDigital().toUpperCase()));
        }
        return dto;
    }

    private List<ItemNota> montaItensAgrupadosPorAliquota(Nota nota) throws CloneNotSupportedException {
        ArrayList<ItemNota> itensAgrupados = new ArrayList<ItemNota>();
        for (ItemNota item : nota.getItensNota()) {
            Boolean agrupou = false;
            if (itensAgrupados.size() == 0) {
                itensAgrupados.add(item);
                continue;
            }
            for (ItemNota itemAg : itensAgrupados) {
                if (!itemAg.getAliquotaCOFINS().equals(item.getAliquotaCOFINS()) || !itemAg.getAliquotaISS().equals(item.getAliquotaISS()) || !itemAg.getAliquotaICMS().equals(item.getAliquotaICMS()) || !itemAg.getAliquotaPIS().equals(item.getAliquotaPIS())) continue;
                if (item.getValorCOFINS() > 0.0) {
                    itemAg.setValorCOFINS(itemAg.getValorCOFINS() + item.getValorCOFINS());
                }
                if (item.getBaseCOFINS() > 0.0) {
                    itemAg.setBaseCOFINS(itemAg.getBaseCOFINS() + item.getBaseCOFINS());
                }
                if (item.getValorICMS() > 0.0) {
                    itemAg.setValorICMS(itemAg.getValorICMS() + item.getValorICMS());
                }
                if (item.getBaseICMS() > 0.0) {
                    itemAg.setBaseICMS(itemAg.getBaseICMS() + item.getBaseICMS());
                }
                if (item.getValorISS() > 0.0) {
                    itemAg.setValorISS(itemAg.getValorISS() + item.getValorISS());
                }
                if (item.getBaseISS() > 0.0) {
                    itemAg.setBaseISS(itemAg.getBaseISS() + item.getBaseISS());
                }
                if (item.getValorPIS() > 0.0) {
                    itemAg.setValorPIS(itemAg.getValorPIS() + item.getValorPIS());
                }
                if (item.getBasePIS() > 0.0) {
                    itemAg.setBasePIS(itemAg.getBasePIS() + item.getBasePIS());
                }
                agrupou = true;
                break;
            }
            if (agrupou.booleanValue()) continue;
            itensAgrupados.add(item);
        }
        return itensAgrupados;
    }

    private NotaFiscalDto geraDadosNotaCompletaDto(Nota nota, Map<String, Object> empresa, Boolean isSVAIncluso, Boolean isModeloUnificado, ComercialDao comercialDao, TerceirosDao terceirosDao, FinanceiroDao financeiroDao) throws Exception {
        this.cliente = this.getDadosCliente(nota.getItensNota().get(0).getFaturamento().getIdContrato(), isModeloUnificado, comercialDao, terceirosDao);
        if (this.cliente != null) {
            if (empresa == null) {
                empresa = terceirosDao.findDadosDetalhadosEmpresaByID(nota.getIdEmpresa());
            }
            NotaFiscalDto dto = this.montaDadosDtoNota(nota, isSVAIncluso, isModeloUnificado, financeiroDao, comercialDao);
            dto.setNomeCliente(this.cliente.getNome().trim());
            dto.setBairroCliente(this.cliente.getBairro().trim());
            dto.setCepCliente(this.cliente.getCep());
            dto.setCidadeCliente(this.cliente.getCidade().trim());
            dto.setObservacaoFiscal(this.cliente.getObservacaoFiscal());
            if (this.cliente.getCpf() != null) {
                dto.setCnpjcpfCliente(this.cliente.getCpf());
                dto.setIeRgCliente(this.cliente.getRg());
                dto.setTipoCliente("(PESSOA F\u00cdSICA)");
            } else {
                dto.setCnpjcpfCliente(this.cliente.getCnpj());
                dto.setTipoCliente("(PESSOA JUR\u00cdDICA)");
                if (this.cliente.getInscricaoEstadual() != null) {
                    dto.setIeRgCliente(this.cliente.getInscricaoEstadual());
                } else {
                    dto.setIeRgCliente("ISENTO");
                }
            }
            if (this.cliente.getEmailsCobranca() != null && !this.cliente.getEmailsCobranca().trim().equals("")) {
                dto.setEmailCliente(this.cliente.getEmailsCobranca().split(";")[0]);
            }
            dto.setEnderecoCliente(String.valueOf(this.cliente.getEndereco().trim()) + ", " + String.valueOf(this.cliente.getNumero()));
            if (this.cliente.getTelefone() != null && this.cliente.getTelefone().trim().startsWith("55")) {
                dto.setTelefoneCliente(this.cliente.getTelefone().trim().substring(2, this.cliente.getTelefone().length()));
            } else {
                dto.setTelefoneCliente(this.cliente.getTelefone());
            }
            dto.setUfCliente(this.cliente.getEstado());
            dto.setCfop(this.cliente.getCfop());
            dto.setBairroEmpresa(empresa.get("bairro").toString());
            dto.setCepEmpresa(empresa.get("cep").toString());
            dto.setCidadeEmpresa(empresa.get("cidade").toString());
            dto.setCnpjEmpresa(empresa.get("cnpj").toString());
            dto.setEnderecoEmpresa(empresa.get("logradouro") + ", " + empresa.get("numero"));
            dto.setIeEmpresa(empresa.get("inscricaoEstadual").toString());
            dto.setNomeEmpresa(empresa.get("razao").toString());
            dto.setUfEmpresa(empresa.get("estado").toString());
            if (empresa.get("telefone") != null && empresa.get("telefone").toString().trim().startsWith("55")) {
                dto.setTelefoneEmpresa(empresa.get("telefone").toString().substring(2, empresa.get("telefone").toString().length()));
            } else {
                dto.setTelefoneEmpresa(empresa.get("telefone").toString());
            }
            return dto;
        }
        return null;
    }

    private String trataTamanhoString(String texto, int tamanhoMax) {
        if (texto.trim().length() > tamanhoMax) {
            return texto.trim().substring(0, tamanhoMax);
        }
        return texto.trim().toUpperCase();
    }

    private String getPDFTempName(String nome) {
        return String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + nome + ".pdf";
    }

    private String getTextoAliquota(Nota nota, FinanceiroDao financeiroDao) {
        Double total = financeiroDao.findSomaNotasByAnoEmissao(nota.getDataEmissao(), nota.getModeloNotaFiscal(), nota.getIdEmpresa());
        if (total <= 180000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 1,25%.";
        }
        if (total <= 360000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 1,86%";
        }
        if (total <= 540000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 2,33%";
        }
        if (total <= 720000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 2,56%";
        }
        if (total <= 900000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 2,58%";
        }
        if (total <= 1080000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 2,82%";
        }
        if (total <= 1260000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 2,84%";
        }
        if (total <= 1440000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 2,87%";
        }
        if (total <= 1620000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,07%";
        }
        if (total <= 1800000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,10%";
        }
        if (total <= 1980000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,38%";
        }
        if (total <= 2160000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,41%";
        }
        if (total <= 2340000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,45%";
        }
        if (total <= 2520000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,48%";
        }
        if (total <= 2700000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,51%";
        }
        if (total <= 2880000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,82%";
        }
        if (total <= 3060000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,85%";
        }
        if (total <= 3240000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,88%";
        }
        if (total <= 3420000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,91%";
        }
        if (total <= 3600000.0) {
            return "Empresa optante pelo Simples Nacional, permite o aproveitamento de cr\u00e9dito de ICMS sob al\u00edquota 3,95%";
        }
        return "";
    }

    private String getPlanosContratoNota(Nota nota, ComercialDao comercialDao) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ItemNota item : nota.getItensNota()) {
            ids.add(item.getFaturamento().getIdContrato());
        }
        String planos = comercialDao.findNomePlanoByContratos(ids);
        return planos.trim();
    }

    private String formataChave(String chave) {
        String texto = "";
        int i = 1;
        while (i <= 7) {
            texto = String.valueOf(texto) + chave.substring((i - 1) * 4, 4 * i) + ".";
            ++i;
        }
        texto = String.valueOf(texto) + chave.substring(28, 32);
        return texto;
    }

    private ClienteDto getDadosCliente(Long idContrato, Boolean isModeloUnificado, ComercialDao comercialDao, TerceirosDao terceirosDao) {
        ClienteDto cliente = new ClienteDto();
        Map<String, Object> dadosCliente = comercialDao.findDadosCliente(idContrato, "FISCAL", true, isModeloUnificado);
        if (dadosCliente == null || dadosCliente.get("idEndereco") == null) {
            dadosCliente = comercialDao.findDadosCliente(idContrato, "COBRANCA", true, isModeloUnificado);
        }
        if (dadosCliente == null || dadosCliente.get("nome") == null || dadosCliente.get("idEndereco") == null) {
            return null;
        }
        String emailsCobranca = "";
        if (dadosCliente.get("emailsCobranca") != null && !dadosCliente.get("emailsCobranca").toString().isEmpty() && ((String)dadosCliente.get("emailsCobranca")).length() > 1) {
            emailsCobranca = dadosCliente.get("emailsCobranca").toString().startsWith(";") ? ((String)dadosCliente.get("emailsCobranca")).substring(1) : (String)dadosCliente.get("emailsCobranca");
        }
        if (dadosCliente.get("emailCliente") != null && !emailsCobranca.contains((String)dadosCliente.get("emailCliente"))) {
            emailsCobranca = String.valueOf(emailsCobranca) + (!emailsCobranca.equals("") ? ";" : "") + dadosCliente.get("emailCliente");
        }
        dadosCliente.put("emailsCobranca", emailsCobranca);
        cliente.setNome((String)dadosCliente.get("nome"));
        if ((String)dadosCliente.get("cpf") != null) {
            cliente.setCpf((String)dadosCliente.get("cpf"));
            cliente.setRg((String)dadosCliente.get("rg"));
        } else {
            cliente.setCnpj((String)dadosCliente.get("cnpj"));
            cliente.setInscricaoEstadual((String)dadosCliente.get("ie"));
        }
        cliente.setEmailsCobranca((String)dadosCliente.get("emailsCobranca"));
        cliente.setTelefone((String)dadosCliente.get("telefone"));
        cliente.setCfop(dadosCliente.get("cfop").toString());
        cliente.setNumero((BigInteger)dadosCliente.get("numero"));
        BigInteger idEnd = (BigInteger)dadosCliente.get("idEndereco");
        cliente.setIdEndereco(idEnd.longValue());
        Map<String, Object> dadosEndereco = terceirosDao.findEnderecoByID(cliente.getIdEndereco());
        cliente.setEndereco((String)dadosEndereco.get("endereco"));
        cliente.setBairro((String)dadosEndereco.get("bairro"));
        cliente.setCidade((String)dadosEndereco.get("cidade"));
        cliente.setEstado((String)dadosEndereco.get("estado"));
        cliente.setCep((String)dadosEndereco.get("cep"));
        if (dadosCliente.get("observacaoFiscal") != null) {
            cliente.setObservacaoFiscal(dadosCliente.get("observacaoFiscal").toString());
        } else {
            cliente.setObservacaoFiscal("");
        }
        return cliente;
    }

    private Long getIDUsuarioLog(FinanceiroDao financeiroDao) {
        return new Long(financeiroDao.findValorConfiguracoesByChave("ID_USUARIO_ENVIO_AUTOMATICO_ROTINAS"));
    }

    private String getEmailRemetente(FinanceiroDao financeiroDao) {
        return financeiroDao.findValorConfiguracoesByChave("REMETENTE_EMAILS_FINANCEIRO");
    }

    private String getPathModeloNota(FinanceiroDao financeiroDao) {
        return String.valueOf(financeiroDao.findValorConfiguracoesByChave("PATH_LAYOUT_ARQUIVOS_NF")) + File.separator;
    }
}

