/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import rotinas.adapter.config.AdapterFinanceiroDatabase;
import rotinas.adapter.envio.EnvioService;
import rotinas.adapter.financeiro.Fatura;
import rotinas.adapter.financeiro.FaturaParcelamento;
import rotinas.adapter.financeiro.FaturamentoMes;
import rotinas.adapter.financeiro.GrupoComposicaoNota;
import rotinas.adapter.financeiro.LogEnvioFatura;
import rotinas.adapter.financeiro.LogEnvioNotaFiscal;
import rotinas.adapter.financeiro.ModeloNotaFiscal;
import rotinas.adapter.financeiro.Nota;

public class FinanceiroDao {
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw);

    public Double findSomaNotasByAnoEmissao(Date emissao, ModeloNotaFiscal modelo, Long idEmpresa) {
        try {
            String jpql = "SELECT SUM(n.valor) FROM Nota n WHERE FUNCTION('YEAR', n.dataEmissao) = FUNCTION('YEAR', :emissao) AND n.modeloNotaFiscal.id = :modelo AND n.idEmpresa = :idEmpresa AND n.situacao = :situacao";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            Query query = session.createQuery(jpql);
            query.setParameter("modelo", (Object)modelo.getId());
            query.setParameter("emissao", (Object)emissao);
            query.setParameter("idEmpresa", (Object)idEmpresa);
            query.setParameter("situacao", (Object)"N");
            Double total = (Double)query.uniqueResult();
            session.close();
            return total;
        }
        catch (NoResultException e) {
            return 0.0;
        }
    }

    public List<Nota> findNotasAEnviar(List<Long> idEmpresaNota, int dias) throws ParseException {
        String sql = "SELECT n FROM Nota n WHERE FUNCTION('DATEDIFF', n.vencimento, :dataAtual) = :dias AND n.situacao != :situacao AND n.valor > :valor AND n.idEmpresa IN :idEmpresaNota ORDER BY n.idCliente ";
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        Query q = session.createQuery(sql);
        q.setParameter("dataAtual", (Object)new Date());
        q.setParameter("dias", (Object)dias);
        q.setParameter("situacao", (Object)"S");
        q.setParameter("valor", (Object)0.0);
        q.setParameterList("idEmpresaNota", idEmpresaNota);
        List list = q.list();
        session.close();
        return list;
    }

    public List<BigInteger> findFaturasAVencerSemLog(int dias, List<Long> idsFormasCobranca, boolean permiteDemostrativoDebito) {
        String sql = "SELECT DISTINCT f.IDFatura FROM TB_Fatura f LEFT JOIN  TB_LogEnvioFatura envio ON envio.IDFatura = f.IDFatura INNER JOIN TB_FormaCobranca fc ON fc.IDFormaCobranca = f.IDFormaCobranca WHERE DATEDIFF(f.DataVencimento, CURDATE()) = :dias AND f.IsCancelado = 0 AND f.DataPagamento IS NULL AND f.IDArquivoRemessa IS NOT NULL AND envio.IDLogEnvioFatura IS NULL AND fc.IDFormaCobranca IN :idsFormasCobranca ";
        if (!permiteDemostrativoDebito) {
            sql = String.valueOf(sql) + "AND fc.DebitoAutomatico = 0 ";
        }
        sql = String.valueOf(sql) + "ORDER BY f.IDCliente";
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameter("dias", (Object)dias);
        q.setParameterList("idsFormasCobranca", idsFormasCobranca);
        List result = q.list();
        session.close();
        return result;
    }

    public List<BigInteger> findFaturasAVencer(int dias, List<Long> idsFormasCobranca, boolean permiteDemostrativoDebito) {
        String sql = "SELECT DISTINCT f.IDFatura FROM TB_Fatura f INNER JOIN TB_FormaCobranca fc ON fc.IDFormaCobranca = f.IDFormaCobranca WHERE DATEDIFF(f.DataVencimento, CURDATE()) = :dias AND f.IsCancelado = 0 AND f.DataPagamento IS NULL AND f.IDArquivoRemessa IS NOT NULL AND fc.IDFormaCobranca IN :idsFormasCobranca ";
        if (!permiteDemostrativoDebito) {
            sql = String.valueOf(sql) + "AND fc.DebitoAutomatico = 0 ";
        }
        sql = String.valueOf(sql) + "ORDER BY f.IDCliente";
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameter("dias", (Object)dias);
        q.setParameterList("idsFormasCobranca", idsFormasCobranca);
        List result = q.list();
        session.close();
        return result;
    }

    public List<FaturamentoMes> findFaturamentosByIDFatura(Long id) {
        try {
            String sql = "SELECT f FROM FaturamentoMes f WHERE f.fatura.id = :id";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            Query q = session.createQuery(sql);
            q.setParameter("id", (Object)id);
            List list = q.list();
            session.close();
            return list;
        }
        catch (NoResultException e) {
            e.printStackTrace(this.pw);
            new EnvioService().sendRelatorioDeErro(this.sw.toString());
            return null;
        }
    }

    public List<FaturaParcelamento> findParcelamentosByIDFatura(Long id) {
        try {
            String sql = "SELECT f FROM FaturaParcelamento f WHERE f.fatura.id = :id";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            Query q = session.createQuery(sql);
            q.setParameter("id", (Object)id);
            List list = q.list();
            session.close();
            return list;
        }
        catch (NoResultException e) {
            e.printStackTrace(this.pw);
            new EnvioService().sendRelatorioDeErro(this.sw.toString());
            return null;
        }
    }

    public Fatura findFaturaByID(Long id) {
        try {
            String sql = "SELECT f FROM Fatura f WHERE f.id = :id";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            Query q = session.createQuery(sql);
            q.setParameter("id", (Object)id);
            Fatura list = (Fatura)q.uniqueResult();
            session.close();
            return list;
        }
        catch (NoResultException e) {
            e.printStackTrace(this.pw);
            new EnvioService().sendRelatorioDeErro(this.sw.toString());
            return null;
        }
    }

    public List<Map<String, Object>> findDescontosByImprimirFatura(List<Long> idsContratos, Date vencimento) {
        String sql = "SELECT * FROM TB_FaturamentoDesconto WHERE IDContrato IN (" + this.convertListInParameters(idsContratos.size()) + ") " + "AND ParcelasFaturadas > 0 AND (ISProcessado = ? OR UltimoVencimentoFaturado = ?)";
        int cont = 0;
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        SQLQuery q = session.createSQLQuery(sql);
        q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        for (Long id : idsContratos) {
            q.setParameter(cont, (Object)id);
            ++cont;
        }
        q.setParameter(cont++, (Object)false);
        q.setParameter(cont, (Object)vencimento);
        List result = q.list();
        session.close();
        return result;
    }

    public String findValorConfiguracoesByChave(String chave) {
        String sql = "SELECT ValorConfiguracao FROM TB_Configuracoes WHERE ChaveConfiguracao = ?";
        try {
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)chave);
            String path = (String)q.uniqueResult();
            session.close();
            return path;
        }
        catch (NoResultException e) {
            e.printStackTrace(this.pw);
            return null;
        }
    }

    public synchronized void gravarLogFatura(LogEnvioFatura log) {
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        session.beginTransaction();
        session.save((Object)log);
        session.getTransaction().commit();
        session.close();
    }

    public synchronized void gravarLogNotaFiscal(LogEnvioNotaFiscal log) {
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        session.beginTransaction();
        session.save((Object)log);
        session.getTransaction().commit();
        session.close();
    }

    private String convertListInParameters(int quant) {
        String interrog = "";
        int index = 0;
        while (index < quant) {
            interrog = String.valueOf(interrog) + "?,";
            ++index;
        }
        return interrog.substring(0, interrog.length() - 1);
    }

    public Long findUltimoIDLogEnvioFatura() {
        try {
            String sql = "SELECT MAX(log.id) FROM LogEnvioFatura log";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            Query query = session.createQuery(sql);
            Long id = (Long)query.uniqueResult();
            session.close();
            return id;
        }
        catch (NoResultException e) {
            e.printStackTrace(this.pw);
            new EnvioService().sendRelatorioDeErro(this.sw.toString());
            return null;
        }
    }

    public Long findUltimoIDLogEnvioNotaFiscal() {
        try {
            String sql = "SELECT MAX(log.id) FROM LogEnvioNotaFiscal log";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            Query query = session.createQuery(sql);
            Long id = (Long)query.uniqueResult();
            session.close();
            return id;
        }
        catch (NoResultException e) {
            e.printStackTrace(this.pw);
            new EnvioService().sendRelatorioDeErro(this.sw.toString());
            return null;
        }
    }

    public List<Map<String, Object>> findLog(Long ultimoId, Boolean envioFatura) {
        try {
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            session.beginTransaction();
            String sql = "SELECT IDCliente, Acao, DataLog";
            sql = envioFatura != false ? String.valueOf(sql) + " FROM TB_LogEnvioFatura WHERE IDLogEnvioFatura > :ultimoId" : String.valueOf(sql) + " FROM TB_LogEnvioNotaFiscal WHERE IDLogEnvioNotaFiscal > :ultimoId";
            SQLQuery query = session.createSQLQuery(sql);
            query.setParameter("ultimoId", (Object)ultimoId);
            query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List list = query.list();
            session.close();
            return list;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Fatura> findFaturasVencidasSemPagamento(Long idCliente, Long idFatura) {
        String sql = "SELECT f FROM Fatura f WHERE f.idCliente = :idCliente AND f.dataVencimento < CURDATE() AND (f.valorPago IS NULL OR (f.descontoValorPago IS NULL AND f.valorPago < f.valor) OR ((f.descontoValorPago IS NOT NULL AND (f.valorPago + f.descontoValorPago) < f.valor) AND (f.descontoValorPago IS NOT NULL AND f.valor - (f.valorPago + f.descontoValorPago) > 0.01))) AND f.cancelado = :cancelado AND f.id != :idFatura ";
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        Query q = session.createQuery(sql);
        q.setParameter("idCliente", (Object)idCliente);
        q.setParameter("idFatura", (Object)idFatura);
        q.setParameter("cancelado", (Object)false);
        List list = q.list();
        session.close();
        return list;
    }

    public Long countFaturasAnterioresByCliente(Long idCliente, Date dataLancamento) {
        String sql = "SELECT count(f) FROM Fatura f WHERE f.idCliente = :idCliente AND f.dataLancamento < :dataLancamento AND f.cancelado = :cancelado";
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        Query q = session.createQuery(sql);
        q.setParameter("idCliente", (Object)idCliente);
        q.setParameter("dataLancamento", (Object)dataLancamento);
        q.setParameter("cancelado", (Object)false);
        Long count = (Long)q.uniqueResult();
        session.close();
        return count;
    }

    public List<GrupoComposicaoNota> findGruposComposicaoNota() {
        try {
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            session.beginTransaction();
            String sql = "SELECT g FROM GrupoComposicaoNota g ORDER BY g.ordem";
            Query query = session.createQuery(sql);
            List list = query.list();
            session.close();
            return list;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Map<String, Object>> findAlteracoesFatura(Long idFatura) {
        try {
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            session.beginTransaction();
            String sql = "SELECT DISTINCT o.Descricao as ocorrencia FROM TB_FaturaAlterada f INNER JOIN TB_OcorrenciaArquivoRemessa o ON o.IDOcorrenciaArquivoRemessa = f.IDOcorrenciaArquivoRemessa WHERE f.IDFatura = :idFatura";
            SQLQuery query = session.createSQLQuery(sql);
            query.setParameter("idFatura", (Object)idFatura);
            query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List list = query.list();
            session.close();
            return list;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

