/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.regex.Pattern;
import rotinas.adapter.config.LoggerConfiguration;
import rotinas.adapter.envio.ComercialDao;
import rotinas.adapter.envio.DadosClienteFatura;
import rotinas.adapter.envio.EmailFaturaService;
import rotinas.adapter.envio.FinanceiroDao;

public class EnviarFaturaRunnable
implements Runnable {
    public static final LoggerConfiguration log = LoggerConfiguration.getInstance();
    private List<DadosClienteFatura> dadosClienteFaturaList;
    private Long idUsuario;
    private Long idModeloMsg;
    private Map<String, Object> modeloEmail;
    private String remetente;
    private AtomicBoolean finalizouImpressaoFaturas;
    private EmailFaturaService emailFaturaService;
    private ComercialDao comercialDao;
    private FinanceiroDao financeiroDao;
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", 2);

    public EnviarFaturaRunnable(List<DadosClienteFatura> dadosClienteFaturaList, Long idUsuario, Long idModeloMsg, Map<String, Object> modeloEmail, String remetente, AtomicBoolean finalizouImpressaoFaturas, EmailFaturaService emailFaturaService, ComercialDao comercialDao, FinanceiroDao financeiroDao) {
        this.dadosClienteFaturaList = dadosClienteFaturaList;
        this.idUsuario = idUsuario;
        this.idModeloMsg = idModeloMsg;
        this.modeloEmail = modeloEmail;
        this.remetente = remetente;
        this.finalizouImpressaoFaturas = finalizouImpressaoFaturas;
        this.emailFaturaService = emailFaturaService;
        this.comercialDao = comercialDao;
        this.financeiroDao = financeiroDao;
    }

    @Override
    public void run() {
        try {
            int cont = 0;
            long startTime = 0L;
            ArrayList<DadosClienteFatura> dadosClienteFaturaListTemp = null;
            Iterator it = null;
            while (!this.finalizouImpressaoFaturas.get() || this.dadosClienteFaturaList.size() > 0) {
                dadosClienteFaturaListTemp = new ArrayList<DadosClienteFatura>(this.dadosClienteFaturaList);
                it = dadosClienteFaturaListTemp.iterator();
                while (it.hasNext()) {
                    startTime = System.nanoTime();
                    if (cont >= 10) {
                        cont = 0;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    DadosClienteFatura dadosClienteFatura = (DadosClienteFatura)it.next();
                    try {
                        this.emailFaturaService.enviar(dadosClienteFatura.getFatura(), dadosClienteFatura.getClienteDto(), dadosClienteFatura.getFilePath(), this.idUsuario, this.idModeloMsg, this.modeloEmail, this.remetente, dadosClienteFatura.getCodigoBarras(), this.financeiroDao, this.comercialDao, pattern);
                        EnviarFaturaRunnable.log.logger.info(String.format("+-+-+-+>>> E-MAIL enviado para o cliente '%s' em %s ms.\n", dadosClienteFatura.getClienteDto().getNome(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS)));
                    }
                    catch (Exception e) {
                        EnviarFaturaRunnable.log.logger.log(Level.SEVERE, String.format("Falha no envio do e-mail: %s", e.toString()), e);
                    }
                    this.dadosClienteFaturaList.remove(dadosClienteFatura);
                    ++cont;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            EnviarFaturaRunnable.log.logger.log(Level.SEVERE, String.format("Falha no envio do e-mail: %s", e.toString()), e);
        }
    }
}

