/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import adapter.email.EmailMessage;
import adapter.email.ePalavraChaveEmail;
import java.io.File;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import rotinas.adapter.config.LoggerConfiguration;
import rotinas.adapter.email.EmailService;
import rotinas.adapter.envio.ComercialDao;
import rotinas.adapter.envio.FinanceiroDao;
import rotinas.adapter.financeiro.ClienteDto;
import rotinas.adapter.financeiro.Fatura;
import rotinas.adapter.financeiro.FaturaParcelamento;
import rotinas.adapter.financeiro.FaturamentoMes;
import rotinas.adapter.financeiro.LogEnvioFatura;

public class EmailFaturaService {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enviar(Fatura fatura, ClienteDto cliente, String anexo, Long idUsuario, Long idModeloMsg, Map<String, Object> modeloEmail, String remetente, String codigoBarras, FinanceiroDao financeiroDao, ComercialDao comercialDao, Pattern pattern) {
        LoggerConfiguration log = LoggerConfiguration.getInstance();
        EmailService email = new EmailService();
        String emailEmailsErrados = "";
        if (cliente.getEmailsCobranca() != null && !cliente.getEmailsCobranca().trim().equals("")) {
            HashSet<String> destinatarios = new HashSet<String>();
            String[] stringArray = cliente.getEmailsCobranca().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String emailCliente = stringArray[n2];
                if (this.validarEmail(pattern, emailCliente)) {
                    destinatarios.add(emailCliente);
                } else {
                    emailEmailsErrados = String.valueOf(emailEmailsErrados) + emailCliente + ";";
                }
                ++n2;
            }
            if (emailEmailsErrados.length() > 0) {
                this.salvaLogClienteEmailErrado(fatura, cliente, idUsuario, financeiroDao, emailEmailsErrados);
            }
            if (destinatarios.size() <= 0) return;
            log.logger.info(String.format("[%s]", cliente.getEmailsCobranca()));
            try {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
                    String msg = (String)modeloEmail.get("Mensagem");
                    HashSet<Long> idsContratos = new HashSet<Long>();
                    for (FaturamentoMes f : fatura.getFaturamentos()) {
                        idsContratos.add(f.getIdContrato());
                    }
                    if (idsContratos.size() == 0) {
                        for (FaturaParcelamento faturaParcelamento : fatura.getParcelamentos()) {
                            idsContratos.add(faturaParcelamento.getIdContrato());
                        }
                    }
                    String nomePlano = comercialDao.findDescricaoPlanosByIDsContratos(idsContratos);
                    NumberFormat fCurrency = NumberFormat.getCurrencyInstance();
                    msg = ePalavraChaveEmail.formatarValuesMensagemEmail((String)msg, (String)cliente.getNome(), (String)codigoBarras, null, null, null, (String)nomePlano, (String)df.format(fatura.getDataVencimento()), (String)fCurrency.format(fatura.getValor()), (String)fatura.getNumeroBoleto());
                    if (codigoBarras != null && anexo == null) {
                        EmailMessage message = new EmailMessage.Builder(remetente).to(destinatarios.toArray(new String[0])).subject((String)modeloEmail.get("Assunto")).content(msg).build();
                        email.send(message);
                    } else {
                        EmailMessage message = new EmailMessage.Builder(remetente).to(destinatarios.toArray(new String[0])).subject((String)modeloEmail.get("Assunto")).content(msg).attachments(new String[]{anexo}).build();
                        email.send(message);
                    }
                    this.salvaLogEnvioFatura(fatura, cliente, idModeloMsg, idUsuario, financeiroDao);
                    return;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    this.salvaLogErroEnvioFatura(fatura, cliente, idModeloMsg, idUsuario, financeiroDao, e.getMessage());
                    if (anexo == null) return;
                    FileUtils.deleteQuietly((File)new File(anexo));
                }
                return;
            }
            finally {
                if (anexo != null) {
                    FileUtils.deleteQuietly((File)new File(anexo));
                }
            }
        } else {
            this.salvaLogClienteSemEmail(fatura, cliente, idUsuario, financeiroDao);
            if (anexo == null) return;
            FileUtils.deleteQuietly((File)new File(anexo));
        }
    }

    public boolean validarEmail(Pattern pattern, String email) {
        return pattern.matcher(email).matches();
    }

    private void salvaLogClienteSemEmail(Fatura fatura, ClienteDto cliente, Long idUsuario, FinanceiroDao financeiroDao) {
        LogEnvioFatura log = new LogEnvioFatura();
        log.setAcao("ERRO:\nO cliente " + fatura.getIdCliente() + " - " + cliente.getNome() + " n\u00e3o possui e-mail cadastrado para envio de faturas.");
        log.setDataLog(new Date());
        log.setIdCliente(fatura.getIdCliente());
        log.setIdUsuario(idUsuario);
        log.setIdFatura(fatura.getId());
        financeiroDao.gravarLogFatura(log);
    }

    private void salvaLogEnvioFatura(Fatura fatura, ClienteDto cliente, Long idModelo, Long idUsuario, FinanceiroDao financeiroDao) {
        LogEnvioFatura log = new LogEnvioFatura();
        log.setAcao(this.montaTextoLog(fatura, cliente.getEmailsCobranca()));
        log.setDataLog(new Date());
        log.setIdModeloEmail(idModelo);
        log.setIdCliente(fatura.getIdCliente());
        log.setIdUsuario(idUsuario);
        log.setIdFatura(fatura.getId());
        financeiroDao.gravarLogFatura(log);
    }

    private void salvaLogClienteEmailErrado(Fatura fatura, ClienteDto cliente, Long idUsuario, FinanceiroDao financeiroDao, String emails) {
        LogEnvioFatura log = new LogEnvioFatura();
        log.setAcao("ERRO:\nO cliente " + fatura.getIdCliente() + " - " + cliente.getNome() + " esta com os seguintes emails errados: " + emails);
        log.setDataLog(new Date());
        log.setIdCliente(fatura.getIdCliente());
        log.setIdUsuario(idUsuario);
        log.setIdFatura(fatura.getId());
        financeiroDao.gravarLogFatura(log);
    }

    private void salvaLogErroEnvioFatura(Fatura fatura, ClienteDto cliente, Long idModelo, Long idUsuario, FinanceiroDao financeiroDao, String erro) {
        LogEnvioFatura log = new LogEnvioFatura();
        log.setAcao(this.montaTextoLogErro(fatura.getIdCliente(), cliente.getNome(), cliente.getEmailsCobranca(), erro));
        log.setDataLog(new Date());
        log.setIdModeloEmail(idModelo);
        log.setIdCliente(fatura.getIdCliente());
        log.setIdUsuario(idUsuario);
        log.setIdFatura(fatura.getId());
        financeiroDao.gravarLogFatura(log);
    }

    private String montaTextoLogErro(Long idCliente, String nomeCliente, String destinatarios, String erro) {
        return "ERRO:\n O cliente " + idCliente + " - " + nomeCliente + " nao recebeu a fatura no emails: " + destinatarios + "\no motivo do erro: " + erro;
    }

    private String montaTextoLog(Fatura fatura, String destinatarios) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        return "ENVIO DE EMAIL\n\n#Foi enviada segunda via de fatura.\n#Destinat\ufffdrios: " + destinatarios + "\n#ID da fatura:" + fatura.getId() + "\n#Vencimento: " + df.format(fatura.getDataVencimento()) + "\n#Valor: " + fatura.getValor();
    }
}

