/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NoResultException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import rotinas.adapter.config.AdapterComercialDatabase;

public class ComercialDao {
    public Map<String, Object> findDadosCliente(Long idContrato, String tipo, Boolean isNotaFiscal, Boolean isNotaUnificada) {
        String sql = "SELECT cli.Nome as 'nome', cli.EndEmail AS 'emailCliente', GROUP_CONCAT(\tDISTINCT TRIM(cc.Email) SEPARATOR ';') AS 'emailsCobranca', cli.CPF as 'cpf', cli.CNPJ as 'cnpj', ecli.NumEndereco as 'numero', ecli.ComplementoEndereco as 'complemento', ecli.IDEndereco as 'idEndereco', cli.rg as 'rg', cli.InscricaoEstadual as 'ie', cli.TelefoneFixo as 'telefone', CONCAT(cfop.NumeroCFOP, ' - ', cfop.Descricao) as 'cfop', cont.ObservacaoFiscal as 'observacaoFiscal' FROM TB_Contrato cont INNER JOIN TB_Cliente cli ON cli.IDCliente = cont.IDCliente INNER JOIN TB_EnderecoContrato econt ON econt.IDContrato = cont.IDContrato INNER JOIN TB_EnderecoCliente ecli ON ecli.IDEnderecoCliente = econt.IDEnderecoCliente LEFT JOIN TB_ContatoCliente cc ON cc.IDCliente = cli.IDCliente LEFT JOIN TB_TipoContato tipo ON tipo.IDTipoContato = cc.IDTipoContato INNER JOIN TB_CFOP cfop ON cfop.IDCFOP = cli.IDCFOP WHERE cont.IDContrato = ? AND (ecli.TipoEndereco = ? OR ecli.TipoEndereco = 'PADRAO')";
        if (isNotaFiscal.booleanValue() && !isNotaUnificada.booleanValue()) {
            sql = String.valueOf(sql) + " AND cli.EnviaNotaFiscalPorEmail = ?";
        }
        sql = String.valueOf(sql) + " ORDER BY ecli.TipoEndereco";
        try {
            Session session = AdapterComercialDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            q.setMaxResults(1);
            q.setParameter(0, (Object)idContrato);
            q.setParameter(1, (Object)tipo);
            if (isNotaFiscal.booleanValue() && !isNotaUnificada.booleanValue()) {
                q.setParameter(2, (Object)true);
            }
            Map map = (Map)q.uniqueResult();
            session.close();
            return map;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Map<String, Object> findMensagemEmail(Long idMsg) {
        String sql = "SELECT Mensagem, Assunto, EnviaBoleto FROM TB_ModeloEmail WHERE IDModeloEmail = ? ";
        try {
            Session session = AdapterComercialDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            q.setParameter(0, (Object)idMsg);
            Map result = (Map)q.uniqueResult();
            session.close();
            return result;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String findNomePlanoByContratos(List<Long> idsContratos) {
        String sql = "SELECT GROUP_CONCAT(' ',p.DescricaoPlano) as planos FROM TB_Contrato cont INNER JOIN TB_Plano p ON p.IDPlano = cont.IDPlano WHERE cont.IDContrato IN (" + this.convertListInParameters(idsContratos.size()) + ")";
        try {
            Session session = AdapterComercialDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            int i = 0;
            while (i < idsContratos.size()) {
                q.setParameter(i, (Object)idsContratos.get(i));
                ++i;
            }
            String nomes = (String)q.uniqueResult();
            session.close();
            return nomes;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private String convertListInParameters(int quant) {
        String interrog = "";
        int index = 0;
        while (index < quant) {
            interrog = String.valueOf(interrog) + "?,";
            ++index;
        }
        return interrog.substring(0, interrog.length() - 1);
    }

    public String findTributacaoFederalByID(Long idTributacaoFederal) {
        String sql = "SELECT Descricao FROM TB_TributacaoFederal WHERE IDTributacaoFederal = ? ";
        try {
            Session session = AdapterComercialDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)idTributacaoFederal);
            String desc = (String)q.uniqueResult();
            session.close();
            return desc;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getConfiguracaoComercialByChave(String chave) throws Exception {
        Session session = AdapterComercialDatabase.getSessionFactory().openSession();
        String sql = "SELECT ValorConfiguracao FROM TB_Configuracoes WHERE ChaveConfiguracao = :chave";
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameter("chave", (Object)chave);
        String resultado = (String)q.uniqueResult();
        session.close();
        return resultado;
    }

    public Double findValorDescontoPagamentoAdiantado(Set<Long> idsContratos) {
        try {
            Session session = AdapterComercialDatabase.getSessionFactory().openSession();
            String sql = "SELECT SUM(IF(DescontoPagamento IS NULL, 0.0, DescontoPagamento)) FROM TB_DadosFinanceiroContrato WHERE IDContrato IN :idsContratos";
            SQLQuery query = session.createSQLQuery(sql);
            query.setParameterList("idsContratos", new ArrayList<Long>(idsContratos));
            Double valor = (Double)query.uniqueResult();
            session.close();
            return valor;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String findDescricaoPlanosByIDsContratos(Set<Long> idsContratos) {
        try {
            Session session = AdapterComercialDatabase.getSessionFactory().openSession();
            String sql = "SELECT GROUP_CONCAT(CONCAT(c.IDContrato,' - ', p.DescricaoPlano)) FROM TB_Contrato c INNER JOIN TB_Plano p ON p.IDPlano = c.IDPlano WHERE c.IDContrato IN :idsContratos";
            SQLQuery query = session.createSQLQuery(sql);
            query.setParameterList("idsContratos", new ArrayList<Long>(idsContratos));
            String result = query.uniqueResult().toString();
            session.close();
            return result;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Map<String, Object> findDadosPlanoPacoteForFaturaByContrato(Long idContrato) {
        try {
            Session session = AdapterComercialDatabase.getSessionFactory().openSession();
            String sql = "SELECT CONCAT(p.IDPlano, ' - ', p.DescricaoPlano) as nomePlano, IFNULL(CONCAT(cp.IDContratoPacote, ' - ', pp.Descricao), NULL) as nomePacote FROM TB_Contrato c INNER JOIN TB_Plano p ON p.IDPlano = c.IDPlano LEFT JOIN TB_ContratoPacote cp ON cp.IDContratoPacote = c.IDContratoPacote LEFT JOIN TB_PacotePlano pp ON pp.IDPacotePlano = cp.IDPacote WHERE c.IDContrato = ? ";
            SQLQuery query = session.createSQLQuery(sql);
            query.setParameter(0, (Object)idContrato);
            query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Map result = (Map)query.uniqueResult();
            session.close();
            return result;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String findDadosContratoByID(Long idContrato) throws Exception {
        Session session = AdapterComercialDatabase.getSessionFactory().openSession();
        String sql = "SELECT IFNULL(CONCAT(p.DescricaoPlano,' - ', v.Descricao, ' - ', t.DescricaoTecnologia),CONCAT(p.DescricaoPlano, ' - ', t.DescricaoTecnologia)) as dadosFROM TB_Contrato c INNER JOIN TB_Plano p ON p.IDPlano = c.IDPlanoINNER JOIN TB_Tecnologia t on t.IDTecnologia = p.IDTecnologiaLEFT JOIN TB_DadosRedeContrato dr ON dr.IDDadosRedeContrato = c.IDDadosRedeContratoLEFT JOIN TB_VelocidadeConexaoRadius vcr ON vcr.IDVelocidadeConexaoRadius = dr.IDVelocidadeConexaoRadiusLEFT JOIN TB_Velocidade v ON v.IDVelocidade = vcr.IDVelocidadeWHERE c.IDContrato = ? ";
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameter(0, (Object)idContrato);
        String resultado = (String)q.uniqueResult();
        session.close();
        return resultado;
    }

    public String findObsFaturaByIDContrato(List<Long> idsContratos) throws Exception {
        Session session = AdapterComercialDatabase.getSessionFactory().openSession();
        String sql = "SELECT GROUP_CONCAT(DISTINCT CONCAT(c.ObservacaoFatura,'\n'))FROM TB_Contrato c WHERE c.IDContrato IN :idsContratos ";
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameterList("idsContratos", idsContratos);
        String resultado = (String)q.uniqueResult();
        session.close();
        return resultado;
    }
}

