/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.config;

import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import rotinas.adapter.config.Configuracoes;
import rotinas.adapter.exception.ErrorException;
import rotinas.adapter.financeiro.ArquivoRemessa;
import rotinas.adapter.financeiro.Banco;
import rotinas.adapter.financeiro.ComposicaoServico;
import rotinas.adapter.financeiro.ContaFinanceira;
import rotinas.adapter.financeiro.Fatura;
import rotinas.adapter.financeiro.FaturaParcelamento;
import rotinas.adapter.financeiro.FaturamentoMes;
import rotinas.adapter.financeiro.FormaCobranca;
import rotinas.adapter.financeiro.GrupoComposicaoNota;
import rotinas.adapter.financeiro.InstrucaoBancaria;
import rotinas.adapter.financeiro.ItemNota;
import rotinas.adapter.financeiro.LogEnvioFatura;
import rotinas.adapter.financeiro.LogEnvioNotaFiscal;
import rotinas.adapter.financeiro.ModeloNotaFiscal;
import rotinas.adapter.financeiro.Nota;
import rotinas.adapter.financeiro.Servico;

public class AdapterFinanceiroDatabase {
    private static ServiceRegistry serviceRegistry;
    private static SessionFactory sessionFactory;

    private static SessionFactory buildSessionFactory() {
        try {
            Configuracoes config = new Configuracoes();
            Configuration configuration = new Configuration().setProperty("hibernate.connection.url", config.getUrlAdapterFinanceiro()).setProperty("hibernate.connection.username", config.getLoginBancoAdapter()).setProperty("hibernate.connection.password", config.getPasswordBancoAdapter()).setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver").setProperty("hibernate.dialect", "org.hibernate.dialect.MySQLDialect").addAnnotatedClass(Fatura.class).addAnnotatedClass(FormaCobranca.class).addAnnotatedClass(ContaFinanceira.class).addAnnotatedClass(Banco.class).addAnnotatedClass(InstrucaoBancaria.class).addAnnotatedClass(FaturamentoMes.class).addAnnotatedClass(LogEnvioFatura.class).addAnnotatedClass(LogEnvioNotaFiscal.class).addAnnotatedClass(Nota.class).addAnnotatedClass(ItemNota.class).addAnnotatedClass(ModeloNotaFiscal.class).addAnnotatedClass(FaturaParcelamento.class).addAnnotatedClass(ArquivoRemessa.class).addAnnotatedClass(ComposicaoServico.class).addAnnotatedClass(Servico.class).addAnnotatedClass(GrupoComposicaoNota.class);
            serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
            return configuration.buildSessionFactory(serviceRegistry);
        }
        catch (ErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ErrorException("Erro ao criar uma SessionFactory.", ex);
        }
    }

    public static synchronized SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            sessionFactory = AdapterFinanceiroDatabase.buildSessionFactory();
        }
        return sessionFactory;
    }

    public static void shutdown() {
        if (sessionFactory == null) {
            return;
        }
        AdapterFinanceiroDatabase.getSessionFactory().close();
    }
}

