/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.financeiro;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.codehaus.jackson.annotate.JsonBackReference;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import rotinas.adapter.financeiro.ArquivoRemessa;
import rotinas.adapter.financeiro.FaturaParcelamento;
import rotinas.adapter.financeiro.FaturamentoMes;
import rotinas.adapter.financeiro.FormaCobranca;

@Entity
@Table(name="TB_Fatura")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Fatura
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="IDFatura")
    private Long id;
    @Column(name="DataLancamento")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataLancamento;
    @Column(name="DataVencimento")
    @Temporal(value=TemporalType.DATE)
    private Date dataVencimento;
    @Column(name="NumeroDocumento", length=10)
    private String numeroDocumento;
    @Column(name="NumeroBoleto", length=8)
    private String numeroBoleto;
    @ManyToOne
    @JoinColumn(name="IDArquivoRemessa")
    private ArquivoRemessa arquivoRemessa;
    @Column(name="DataPagamento")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataPagamento;
    @Column(name="ValorPago")
    private Double valorPago;
    @Column(name="Valor")
    private Double valor;
    @Column(name="IDCliente")
    private Long idCliente;
    @JsonBackReference(value="faturamentos")
    @OneToMany(mappedBy="fatura", cascade={CascadeType.MERGE}, fetch=FetchType.EAGER)
    private List<FaturamentoMes> faturamentos;
    @Column(name="JurosValorPago")
    private Double jurosValorPago;
    @Column(name="MultaValorPago")
    private Double multaValorPago;
    @Column(name="DescontoValorPago")
    private Double descontoValorPago;
    @Column(name="IDEmpresa")
    private Long idEmpresa;
    @Column(name="IsCancelado")
    private Boolean cancelado;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DataCancelamento")
    private Date dataCancelamento;
    @Column(name="IDUsuarioCancelamento")
    private Long idUsuarioCancelamento;
    @Column(name="IsNegociacao")
    private Boolean negociacao;
    @ManyToOne
    @JoinColumn(name="IDFormaCobranca")
    private FormaCobranca formaCobranca;
    @JsonBackReference(value="parcelamentos")
    @OneToMany(mappedBy="fatura", cascade={CascadeType.MERGE}, fetch=FetchType.EAGER)
    private List<FaturaParcelamento> parcelamentos;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getDataLancamento() {
        return this.dataLancamento;
    }

    public void setDataLancamento(Date dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public String getNumeroBoleto() {
        return this.numeroBoleto;
    }

    public void setNumeroBoleto(String numeroBoleto) {
        this.numeroBoleto = numeroBoleto;
    }

    public ArquivoRemessa getArquivoRemessa() {
        return this.arquivoRemessa;
    }

    public void setArquivoRemessa(ArquivoRemessa arquivoRemessa) {
        this.arquivoRemessa = arquivoRemessa;
    }

    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    public Double getValorPago() {
        return this.valorPago;
    }

    public void setValorPago(Double valorPago) {
        this.valorPago = valorPago;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public Long getIdCliente() {
        return this.idCliente;
    }

    public void setIdCliente(Long idCliente) {
        this.idCliente = idCliente;
    }

    public List<FaturamentoMes> getFaturamentos() {
        return this.faturamentos;
    }

    public void setFaturamentos(List<FaturamentoMes> faturamentos) {
        this.faturamentos = faturamentos;
    }

    public Double getJurosValorPago() {
        return this.jurosValorPago;
    }

    public void setJurosValorPago(Double jurosValorPago) {
        this.jurosValorPago = jurosValorPago;
    }

    public Double getMultaValorPago() {
        return this.multaValorPago;
    }

    public void setMultaValorPago(Double multaValorPago) {
        this.multaValorPago = multaValorPago;
    }

    public Double getDescontoValorPago() {
        return this.descontoValorPago;
    }

    public void setDescontoValorPago(Double descontoValorPago) {
        this.descontoValorPago = descontoValorPago;
    }

    public Long getIdEmpresa() {
        return this.idEmpresa;
    }

    public void setIdEmpresa(Long idEmpresa) {
        this.idEmpresa = idEmpresa;
    }

    public Boolean getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    public Long getIdUsuarioCancelamento() {
        return this.idUsuarioCancelamento;
    }

    public void setIdUsuarioCancelamento(Long idUsuarioCancelamento) {
        this.idUsuarioCancelamento = idUsuarioCancelamento;
    }

    public Boolean getNegociacao() {
        return this.negociacao;
    }

    public void setNegociacao(Boolean negociacao) {
        this.negociacao = negociacao;
    }

    public FormaCobranca getFormaCobranca() {
        return this.formaCobranca;
    }

    public void setFormaCobranca(FormaCobranca formaCobranca) {
        this.formaCobranca = formaCobranca;
    }

    public List<FaturaParcelamento> getParcelamentos() {
        return this.parcelamentos;
    }

    public void setParcelamentos(List<FaturaParcelamento> parcelamentos) {
        this.parcelamentos = parcelamentos;
    }

    public Fatura clone() throws CloneNotSupportedException {
        return (Fatura)super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cancelado == null ? 0 : this.cancelado.hashCode());
        result = 31 * result + (this.dataLancamento == null ? 0 : this.dataLancamento.hashCode());
        result = 31 * result + (this.dataVencimento == null ? 0 : this.dataVencimento.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.idCliente == null ? 0 : this.idCliente.hashCode());
        result = 31 * result + (this.idEmpresa == null ? 0 : this.idEmpresa.hashCode());
        result = 31 * result + (this.negociacao == null ? 0 : this.negociacao.hashCode());
        result = 31 * result + (this.numeroBoleto == null ? 0 : this.numeroBoleto.hashCode());
        result = 31 * result + (this.numeroDocumento == null ? 0 : this.numeroDocumento.hashCode());
        result = 31 * result + (this.valor == null ? 0 : this.valor.hashCode());
        result = 31 * result + (this.valorPago == null ? 0 : this.valorPago.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fatura other = (Fatura)obj;
        if (this.cancelado == null ? other.cancelado != null : !this.cancelado.equals(other.cancelado)) {
            return false;
        }
        if (this.dataLancamento == null ? other.dataLancamento != null : !this.dataLancamento.equals(other.dataLancamento)) {
            return false;
        }
        if (this.dataVencimento == null ? other.dataVencimento != null : !this.dataVencimento.equals(other.dataVencimento)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.idCliente == null ? other.idCliente != null : !this.idCliente.equals(other.idCliente)) {
            return false;
        }
        if (this.idEmpresa == null ? other.idEmpresa != null : !this.idEmpresa.equals(other.idEmpresa)) {
            return false;
        }
        if (this.negociacao == null ? other.negociacao != null : !this.negociacao.equals(other.negociacao)) {
            return false;
        }
        if (this.numeroBoleto == null ? other.numeroBoleto != null : !this.numeroBoleto.equals(other.numeroBoleto)) {
            return false;
        }
        if (this.numeroDocumento == null ? other.numeroDocumento != null : !this.numeroDocumento.equals(other.numeroDocumento)) {
            return false;
        }
        if (this.valor == null ? other.valor != null : !this.valor.equals(other.valor)) {
            return false;
        }
        return !(this.valorPago == null ? other.valorPago != null : !this.valorPago.equals(other.valorPago));
    }
}

