/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import adapter.exceptions.AdapterErrorException;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.lang.StringUtils;
import org.jrimum.bopepo.BancosSuportados;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.campolivre.CampoLivre;
import org.jrimum.bopepo.view.BoletoViewer;
import org.jrimum.domkee.comum.pessoa.id.cprf.CNPJ;
import org.jrimum.domkee.financeiro.banco.Banco;
import org.jrimum.domkee.financeiro.banco.febraban.Agencia;
import org.jrimum.domkee.financeiro.banco.febraban.Carteira;
import org.jrimum.domkee.financeiro.banco.febraban.Cedente;
import org.jrimum.domkee.financeiro.banco.febraban.CodigoDeCompensacaoBACEN;
import org.jrimum.domkee.financeiro.banco.febraban.ContaBancaria;
import org.jrimum.domkee.financeiro.banco.febraban.NumeroDaConta;
import org.jrimum.domkee.financeiro.banco.febraban.Sacado;
import org.jrimum.domkee.financeiro.banco.febraban.TipoDeCobranca;
import org.jrimum.domkee.financeiro.banco.febraban.TipoDeTitulo;
import org.jrimum.domkee.financeiro.banco.febraban.Titulo;
import rotinas.adapter.config.LoggerConfiguration;
import rotinas.adapter.envio.ComercialDao;
import rotinas.adapter.envio.FinanceiroDao;
import rotinas.adapter.envio.ImprimirNotaService;
import rotinas.adapter.envio.TerceirosDao;
import rotinas.adapter.financeiro.CLBancoABC;
import rotinas.adapter.financeiro.CLCaixaCarteira14E11;
import rotinas.adapter.financeiro.CLSantanderCarteira104E101;
import rotinas.adapter.financeiro.ClienteDto;
import rotinas.adapter.financeiro.Fatura;
import rotinas.adapter.financeiro.FaturaNotaUnificadaDto;
import rotinas.adapter.financeiro.FaturaParcelamento;
import rotinas.adapter.financeiro.FaturamentoMes;
import rotinas.adapter.financeiro.FormaCobranca;
import rotinas.adapter.financeiro.GrupoComposicaoNota;
import rotinas.adapter.financeiro.InstrucaoBancaria;
import rotinas.adapter.financeiro.eTipoInstrucao;

public class ImprimirFaturaService {
    public static final LoggerConfiguration log = LoggerConfiguration.getInstance();
    private ClienteDto clienteDto = null;

    private FaturaNotaUnificadaDto montaDtoImpressao(Map<String, Object> empresa, ClienteDto cliente, Boleto boleto, Boolean isSVAIncluso, Fatura fatura, ComercialDao comercialDao, FinanceiroDao financeiroDao, TerceirosDao terceirosDao) throws Exception {
        ImprimirNotaService imprimirNotaService = new ImprimirNotaService();
        FaturaNotaUnificadaDto dto = new FaturaNotaUnificadaDto();
        dto.setDadosEmpresaDto(empresa);
        dto.setDadosClienteDto(cliente);
        dto.setCodigoBeneficiario(String.valueOf(StringUtils.leftPad((String)boleto.getTitulo().getContaBancaria().getAgencia().getCodigo().toString(), (int)4, (String)"0")) + " / " + boleto.getTitulo().getContaBancaria().getNumeroDaConta().getCodigoDaConta() + " - " + boleto.getTitulo().getContaBancaria().getNumeroDaConta().getDigitoDaConta());
        Map<Object, Object> mapDadosServicosFatura = new HashMap();
        Map<Object, Object> mapInformacoesComplementares = new HashMap();
        if (isSVAIncluso.booleanValue()) {
            Map<String, String> mapComposicoes = this.geraDadosValoresComposicoesMarcadas(fatura);
            mapDadosServicosFatura = this.geraDadosServicosSVAIncluso(boleto, fatura, comercialDao);
            mapInformacoesComplementares = this.geraTextoInformacoesComplementaresNota(fatura, financeiroDao);
            dto.setTextoDataInicioPeriodo((String)mapDadosServicosFatura.get("textoDataInicio"));
            dto.setTextoDataFimPeriodo((String)mapDadosServicosFatura.get("textoDataFim"));
            dto.setTextoDescricaoInformacoesComplementares((String)mapInformacoesComplementares.get("textoDescricao"));
            dto.setTextoValorInformacoesComplementares((String)mapInformacoesComplementares.get("textoValor"));
            dto.setTextoValoresComposicoes(mapComposicoes != null ? mapComposicoes.get("valor") : null);
            dto.setTextoDescricaoComposicoes(mapComposicoes != null ? mapComposicoes.get("descricao") : null);
        } else {
            mapDadosServicosFatura = this.geraDadosServicosComum(boleto, fatura, comercialDao);
        }
        dto.setObservacaoFatura(mapDadosServicosFatura.containsKey("obsFatura") && mapDadosServicosFatura.get("obsFatura") != null ? (String)mapDadosServicosFatura.get("obsFatura") : "");
        dto.setTextoFaturasAnterioresEmAberto(this.geraTextoDebitosAnteriores(fatura.getIdCliente(), fatura.getId(), financeiroDao));
        dto.setTextoServicosFatura((String)mapDadosServicosFatura.get("textoDescricao"));
        dto.setValorServicosFatura((String)mapDadosServicosFatura.get("textoValor"));
        dto.setVencimentoFatura(fatura.getDataVencimento());
        dto.setValorTotalFatura(fatura.getValor());
        dto.setCodigoTransmissao(fatura.getFormaCobranca().getDebitoAutomatico() != null && fatura.getFormaCobranca().getDebitoAutomatico() != false ? fatura.getFormaCobranca().getCodigoConvenio() : fatura.getFormaCobranca().getCodigoTransmissao());
        dto.setAgenciaConta(String.valueOf(fatura.getFormaCobranca().getContaFinanceira().getAgencia()) + " / " + fatura.getFormaCobranca().getContaFinanceira().getContaCorrente() + (fatura.getFormaCobranca().getContaFinanceira().getDvContaCorrente() != null ? "-" + fatura.getFormaCobranca().getContaFinanceira().getDvContaCorrente() : ""));
        dto.setNumeroBoleto(fatura.getNumeroBoleto());
        dto.setNomeBanco(fatura.getFormaCobranca().getContaFinanceira().getBanco().getNome());
        if (!fatura.getFormaCobranca().getDebitoAutomatico().booleanValue()) {
            dto.setNomeBanco(fatura.getFormaCobranca().getContaFinanceira().getBanco().getNome());
            dto.setCodigoBarras(boleto.getCodigoDeBarras().write());
            dto.setLinhaDigitavel(boleto.getLinhaDigitavel().write());
        } else {
            dto.setNomeBanco("");
            dto.setLinhaDigitavel("Demonstrativo de conta em debito automatico");
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(fatura.getDataVencimento());
        gc.add(2, -1);
        dto.setMesReferencia(new SimpleDateFormat("MM/yyyy").format(gc.getTime()));
        for (InstrucaoBancaria instrucao : fatura.getFormaCobranca().getContaFinanceira().getInstrucoes()) {
            if (!instrucao.getTipo().equals((Object)eTipoInstrucao.PRIMEIRA_FATURA) || financeiroDao.countFaturasAnterioresByCliente(fatura.getIdCliente(), fatura.getDataLancamento()) > 0L) continue;
            dto.setTextoPrimeiraFatura(instrucao.getTexto());
            break;
        }
        dto.setNotas(imprimirNotaService.buscaNotasParaImpressaoUnificada(fatura, isSVAIncluso, empresa, dto.getCfop(), comercialDao, financeiroDao, terceirosDao));
        return dto;
    }

    private Map<String, String> geraDadosValoresComposicoesMarcadas(Fatura fatura) {
        String texto = "";
        String textoValor = "";
        DecimalFormat df = new DecimalFormat("0.00");
        HashMap<String, String> dados = new HashMap<String, String>();
        for (FaturamentoMes fm : fatura.getFaturamentos()) {
            if (fm.getComposicao().getExibeValorFatura() == null || !fm.getComposicao().getExibeValorFatura().booleanValue()) continue;
            texto = String.valueOf(texto) + fm.getDescricao().split("\\(")[0] + " \n ";
            textoValor = String.valueOf(textoValor) + "R$ " + df.format(fm.getValor()) + " \n";
        }
        if (!texto.isEmpty()) {
            dados.put("descricao", texto);
            dados.put("valor", textoValor);
            return dados;
        }
        return null;
    }

    private FaturaNotaUnificadaDto montaDadosFaturaNotaUnificada(Fatura fatura, Boolean isSVAIncluso, FinanceiroDao financeiroDao, TerceirosDao terceirosDao, ComercialDao comercialDao) throws ParseException {
        try {
            Long idContrato = null;
            Map<String, Object> mapEmpresa = terceirosDao.findDadosDetalhadosEmpresaByID(fatura.getIdEmpresa());
            if (fatura.getFaturamentos() != null && fatura.getFaturamentos().size() > 0) {
                List<FaturamentoMes> faturamentos = fatura.getFaturamentos();
                idContrato = faturamentos.get(0).getIdContrato();
            } else {
                idContrato = fatura.getParcelamentos().get(0).getIdContrato();
            }
            this.clienteDto = this.getDadosCliente(idContrato, comercialDao, terceirosDao);
            Cedente cedente = new Cedente(mapEmpresa.get("razao").toString(), mapEmpresa.get("cnpj").toString());
            Sacado sacado = new Sacado(this.clienteDto.getNome(), this.clienteDto.getCpf() != null ? this.clienteDto.getCpf() : this.clienteDto.getCnpj());
            ContaBancaria conta = this.geraDadosContaBancaria(fatura.getFormaCobranca());
            Titulo titulo = this.geraDadosTitulo(conta, sacado, cedente, fatura);
            Boleto boleto = null;
            if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("033")) {
                CLSantanderCarteira104E101 campoLivreSantander104 = new CLSantanderCarteira104E101(titulo, fatura.getFormaCobranca().getCodigoCarteiraFatura());
                boleto = new Boleto(titulo, (CampoLivre)campoLivreSantander104);
            } else if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("246")) {
                CLBancoABC campoLivre = new CLBancoABC(fatura.getFormaCobranca().getContaFinanceira().getAgencia(), String.valueOf(fatura.getFormaCobranca().getCodigoCarteiraFatura()), fatura.getNumeroBoleto(), fatura.getFormaCobranca().getOperacao());
                boleto = new Boleto(titulo, (CampoLivre)campoLivre);
            } else if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("104") && (fatura.getFormaCobranca().getCodigoCarteiraFatura() == 11 || fatura.getFormaCobranca().getCodigoCarteiraFatura() == 14)) {
                CLCaixaCarteira14E11 campoLivreCaixa = new CLCaixaCarteira14E11(titulo, fatura.getFormaCobranca().getCodigoCarteiraFatura(), fatura.getNumeroBoleto());
                boleto = new Boleto(titulo, (CampoLivre)campoLivreCaixa);
            } else {
                boleto = new Boleto(titulo);
            }
            return this.montaDtoImpressao(mapEmpresa, this.clienteDto, boleto, isSVAIncluso, fatura, comercialDao, financeiroDao, terceirosDao);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdapterErrorException("Erro ao gerar fatura/Nota unificada", e);
        }
    }

    private Boleto geraCabecalho(Boleto boleto, Map<String, Object> empresa, FormaCobranca formaCobranca, String pathLayoutFatura) {
        String telFormat = "";
        if (empresa.get("telefone") != null) {
            telFormat = "(" + empresa.get("telefone").toString();
            telFormat = String.valueOf(telFormat.substring(0, 3)) + ")" + telFormat.substring(3, 7) + "-" + telFormat.substring(7, telFormat.length());
        }
        boleto.addTextosExtras("txtRsNomeEmpresa", empresa.get("razao") != null ? empresa.get("razao").toString() : "");
        String endereco = String.valueOf(empresa.get("logradouro") != null ? empresa.get("logradouro").toString() : "") + ", " + (empresa.get("numero") != null ? empresa.get("numero").toString() : "") + " - " + (empresa.get("bairro") != null ? empresa.get("bairro").toString() : "");
        endereco = String.valueOf(endereco) + "\n" + (empresa.get("cidade") != null ? empresa.get("cidade").toString() : "") + " (" + (empresa.get("estado") != null ? empresa.get("estado").toString() : "") + ")" + " - CEP: " + (empresa.get("cep") != null ? empresa.get("cep").toString() : "");
        endereco = String.valueOf(endereco) + "\nTELEFONE: " + telFormat;
        boleto.addTextosExtras("txtRsEnderecoEmpresa", endereco);
        boleto.addImagensExtras("txtLogoEmpresa", new ImageIcon(String.valueOf(pathLayoutFatura) + "logo_empresa.png").getImage());
        if (formaCobranca != null && formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("104")) {
            boleto.addTextosExtras("txtRsEnderecoBeneficiario", String.valueOf(empresa.get("logradouro") != null ? empresa.get("logradouro").toString() : "") + ", " + (empresa.get("numero") != null ? empresa.get("numero").toString() : "") + " - " + (empresa.get("bairro") != null ? empresa.get("bairro").toString() : "") + " - " + (empresa.get("cidade") != null ? empresa.get("cidade").toString() : ""));
            boleto.addTextosExtras("txtRsUFBeneficiario", empresa.get("estado").toString());
            boleto.addTextosExtras("txtRsCepBeneficiario", empresa.get("cep").toString());
            boleto.addTextosExtras("txtFcCedente", empresa.get("razao") + ", CNPJ: " + empresa.get("cnpj"));
            boleto.addTextosExtras("txtFcEnderecoCedente", String.valueOf(empresa.get("logradouro") != null ? empresa.get("logradouro").toString() : "") + ", " + (empresa.get("numero") != null ? empresa.get("numero").toString() : "") + " - " + (empresa.get("bairro") != null ? empresa.get("bairro").toString() : "") + " - " + (empresa.get("cidade") != null ? empresa.get("cidade").toString() : "") + "(" + empresa.get("estado").toString() + ")");
        }
        return boleto;
    }

    private Boleto geraDadosServicos(Boleto boleto, Fatura fatura, Boolean isModeloSVAIncluso, ComercialDao comercialDao) throws Exception {
        Map<Object, Object> textos = new HashMap();
        textos = isModeloSVAIncluso != false ? this.geraDadosServicosSVAIncluso(boleto, fatura, comercialDao) : this.geraDadosServicosComum(boleto, fatura, comercialDao);
        boleto.addTextosExtras("txtRsHistoricoDespesaDescricao", (String)textos.get("textoDescricao"));
        boleto.addTextosExtras("txtRsHistoricoDespesaValor", (String)textos.get("textoValor"));
        return boleto;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> geraDadosServicosSVAIncluso(Boleto boleto, Fatura fatura, ComercialDao comercialDao) throws Exception {
        String textoDescricao = "";
        String textoValor = "";
        String textoDataInicio = "";
        String textoDataFim = "";
        DecimalFormat df = new DecimalFormat("0.00");
        HashMap nomePlanoPacoteContrato = new HashMap();
        HashMap<String, Double> valorPlanoPacoteContrato = new HashMap<String, Double>();
        HashMap<String, Double> servicosAdicionais = new HashMap<String, Double>();
        Map<Object, Object> respostaCom = new HashMap();
        Set<Long> idsContratos = new HashSet<Long>();
        Double valor = 0.0;
        if (fatura.getFaturamentos() != null && fatura.getFaturamentos().size() > 0) {
            for (FaturamentoMes faturamentoMes : fatura.getFaturamentos()) {
                respostaCom = comercialDao.findDadosPlanoPacoteForFaturaByContrato(faturamentoMes.getIdContrato());
                if (faturamentoMes.getComposicao().getServico() == null) {
                    String nomeChave;
                    idsContratos = new HashSet();
                    if (respostaCom.get("nomePacote") != null && !nomePlanoPacoteContrato.containsKey(respostaCom.get("nomePacote").toString())) {
                        idsContratos.add(faturamentoMes.getIdContrato());
                        nomePlanoPacoteContrato.put(respostaCom.get("nomePacote").toString(), idsContratos);
                        valorPlanoPacoteContrato.put(respostaCom.get("nomePacote").toString(), 0.0);
                        nomeChave = "nomePacote";
                    } else if (respostaCom.get("nomePacote") != null && nomePlanoPacoteContrato.containsKey(respostaCom.get("nomePacote").toString())) {
                        idsContratos = (Set)nomePlanoPacoteContrato.get(respostaCom.get("nomePacote").toString());
                        idsContratos.add(faturamentoMes.getIdContrato());
                        nomePlanoPacoteContrato.put(respostaCom.get("nomePacote").toString(), idsContratos);
                        nomeChave = "nomePacote";
                    } else if (respostaCom.get("nomePlano") != null && !nomePlanoPacoteContrato.containsKey(respostaCom.get("nomePlano").toString())) {
                        idsContratos.add(faturamentoMes.getIdContrato());
                        nomePlanoPacoteContrato.put(respostaCom.get("nomePlano").toString(), idsContratos);
                        valorPlanoPacoteContrato.put(respostaCom.get("nomePlano").toString(), 0.0);
                        nomeChave = "nomePlano";
                    } else {
                        idsContratos = (Set)nomePlanoPacoteContrato.get(respostaCom.get("nomePlano").toString());
                        idsContratos.add(faturamentoMes.getIdContrato());
                        nomePlanoPacoteContrato.put(respostaCom.get("nomePlano").toString(), idsContratos);
                        nomeChave = "nomePlano";
                    }
                    valor = faturamentoMes.getValor() - (faturamentoMes.getDesconto() != null ? faturamentoMes.getDesconto() : 0.0);
                    valorPlanoPacoteContrato.put(respostaCom.get(nomeChave).toString(), (Double)valorPlanoPacoteContrato.get(respostaCom.get(nomeChave).toString()) + valor);
                    continue;
                }
                if (servicosAdicionais.containsKey(faturamentoMes.getComposicao().getServico().getDescricao())) {
                    servicosAdicionais.put(faturamentoMes.getComposicao().getServico().getDescricao(), (Double)servicosAdicionais.get(faturamentoMes.getComposicao().getServico().getDescricao()) + (faturamentoMes.getValor() - (faturamentoMes.getDesconto() != null ? faturamentoMes.getDesconto() : 0.0)));
                    continue;
                }
                servicosAdicionais.put(faturamentoMes.getComposicao().getServico().getDescricao(), faturamentoMes.getValor() - (faturamentoMes.getDesconto() != null ? faturamentoMes.getDesconto() : 0.0));
            }
            Object var16_18 = null;
            for (Map.Entry planoPacoteMap : nomePlanoPacoteContrato.entrySet()) {
                textoDescricao = String.valueOf(textoDescricao) + ((String)planoPacoteMap.getKey()).split(" - ")[1] + "\n";
                textoValor = String.valueOf(textoValor) + "R$ " + df.format(valorPlanoPacoteContrato.get(planoPacoteMap.getKey())) + "\n";
                Object var16_20 = null;
                for (FaturamentoMes fat : fatura.getFaturamentos()) {
                    void var16_21;
                    if (!((Set)planoPacoteMap.getValue()).contains(fat.getIdContrato()) || fat.getComposicao().getServico() != null) continue;
                    if (var16_21 == null) {
                        String string = " (" + fat.getDescricao().split("\\(")[1];
                        textoDescricao = String.valueOf(textoDescricao) + string + "\n";
                        textoDataInicio = String.valueOf(textoDataInicio) + fat.getDescricao().split("\\(")[1].split(" a ")[0];
                        textoDataFim = String.valueOf(textoDataFim) + fat.getDescricao().split("\\(")[1].split(" a ")[1].replace(")", "");
                    }
                    textoDescricao = String.valueOf(textoDescricao) + "   - " + fat.getDescricao().split("\\(")[0] + "\n";
                    textoValor = String.valueOf(textoValor) + "incluso\n";
                    textoDataInicio = String.valueOf(textoDataInicio) + "\n";
                    textoDataFim = String.valueOf(textoDataFim) + "\n";
                }
            }
        }
        if (fatura.getParcelamentos() != null) {
            for (FaturaParcelamento faturaParcelamento : fatura.getParcelamentos()) {
                valor = faturaParcelamento.getValor();
                if (faturaParcelamento.getValorDesconto() != null) {
                    valor = valor - faturaParcelamento.getValorDesconto();
                }
                textoDescricao = String.valueOf(textoDescricao) + faturaParcelamento.getDescricao() + "\n";
                textoValor = String.valueOf(textoValor) + "R$ " + df.format(valor) + "\n";
            }
        }
        if (servicosAdicionais.size() > 0) {
            for (Map.Entry entry : servicosAdicionais.entrySet()) {
                textoDescricao = String.valueOf(textoDescricao) + (String)entry.getKey() + "\n";
                textoValor = String.valueOf(textoValor) + "R$ " + df.format(entry.getValue()) + "\n";
                textoDataInicio = String.valueOf(textoDataInicio) + "\n";
                textoDataFim = String.valueOf(textoDataFim) + "\n";
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("textoDescricao", textoDescricao);
        hashMap.put("textoValor", textoValor);
        hashMap.put("textoDataInicio", textoDataInicio);
        hashMap.put("textoDataFim", textoDataFim);
        if (idsContratos != null && idsContratos.size() > 0) {
            hashMap.put("obsFatura", comercialDao.findObsFaturaByIDContrato(new ArrayList<Long>(idsContratos)));
        }
        return hashMap;
    }

    private Map<String, String> geraDadosServicosComum(Boleto boleto, Fatura fatura, ComercialDao comercialDao) throws Exception {
        Double valor;
        boleto.addTextosExtras("txtRsHistoricoDespesaCabecalho", "SERVI\u00c7OS");
        String textoDescricao = "";
        String textoValor = "";
        DecimalFormat df = new DecimalFormat("0.00");
        HashSet<Long> idsContratos = new HashSet<Long>();
        if (fatura.getFaturamentos() != null && fatura.getFaturamentos().size() > 0) {
            for (FaturamentoMes faturamentoMes : fatura.getFaturamentos()) {
                idsContratos.add(faturamentoMes.getIdContrato());
                valor = faturamentoMes.getValor();
                if (faturamentoMes.getDesconto() != null) {
                    valor = valor - faturamentoMes.getDesconto();
                }
                textoDescricao = String.valueOf(textoDescricao) + faturamentoMes.getDescricao() + "\n";
                textoValor = String.valueOf(textoValor) + "R$ " + df.format(valor) + "\n";
            }
        }
        if (fatura.getParcelamentos() != null) {
            for (FaturaParcelamento faturaParcelamento : fatura.getParcelamentos()) {
                idsContratos.add(faturaParcelamento.getIdContrato());
                valor = faturaParcelamento.getValor();
                if (faturaParcelamento.getValorDesconto() != null) {
                    valor = valor - faturaParcelamento.getValorDesconto();
                }
                textoDescricao = String.valueOf(textoDescricao) + faturaParcelamento.getDescricao() + "\n";
                textoValor = String.valueOf(textoValor) + "R$ " + df.format(valor) + "\n";
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("textoDescricao", textoDescricao);
        hashMap.put("textoValor", textoValor);
        if (idsContratos != null && idsContratos.size() > 0) {
            hashMap.put("obsFatura", comercialDao.findObsFaturaByIDContrato(new ArrayList<Long>(idsContratos)));
        }
        return hashMap;
    }

    private Boleto geraDadosBoleto(Titulo titulo, Fatura fatura, FormaCobranca formaCobranca, CampoLivre campoLivre, String carteira, String pathLayoutFatura) {
        Boleto boleto = campoLivre != null ? new Boleto(titulo, campoLivre) : new Boleto(titulo);
        String enderecoSacadoL2 = this.getEnderecoSacado(this.clienteDto, 2);
        String enderecoSacadoL3 = this.getEnderecoSacado(this.clienteDto, 3);
        boleto.addTextosExtras("txtFcSacadoL2", enderecoSacadoL2);
        boleto.addTextosExtras("txtFcSacadoL3", enderecoSacadoL3);
        boleto.addTextosExtras("txtFcSacadoL4", this.clienteDto.getNome());
        boleto.addTextosExtras("txtFcSacadoL5", enderecoSacadoL2);
        boleto.addTextosExtras("txtFcSacadoL6", enderecoSacadoL3);
        boleto.addTextosExtras("txtRsSacadoL2", String.valueOf(enderecoSacadoL2) + "\n" + enderecoSacadoL3);
        boleto.addTextosExtras("txtCodigoNomeCliente1", fatura.getIdCliente() + " - " + this.clienteDto.getNome());
        boleto.addTextosExtras("txtCodigoNomeCliente2", fatura.getIdCliente() + " - " + this.clienteDto.getNome());
        boleto.addTextosExtras("txtCodigoNomeCliente3", fatura.getIdCliente() + " - " + this.clienteDto.getNome());
        boleto.addTextosExtras("txtCodigoTransmissao", fatura.getFormaCobranca().getDebitoAutomatico() != null && fatura.getFormaCobranca().getDebitoAutomatico() != false ? fatura.getFormaCobranca().getCodigoConvenio() : fatura.getFormaCobranca().getCodigoTransmissao());
        boleto.addTextosExtras("txtAgenciaConta", String.valueOf(fatura.getFormaCobranca().getContaFinanceira().getAgencia()) + " / " + fatura.getFormaCobranca().getContaFinanceira().getContaCorrente() + (fatura.getFormaCobranca().getContaFinanceira().getDvContaCorrente() != null ? "-" + fatura.getFormaCobranca().getContaFinanceira().getDvContaCorrente() : ""));
        String nn = "";
        String agcedente = "";
        switch (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo()) {
            case "341": {
                nn = String.valueOf(fatura.getFormaCobranca().getCodigoCarteiraFatura()) + "/" + this.getNossoNumero(fatura, false) + "-" + this.getNossoNumero(fatura, true);
                boleto.addTextosExtras("txtRsNossoNumero", nn);
                boleto.addTextosExtras("txtFcNossoNumero", nn);
                break;
            }
            case "756": {
                String pathLogo = String.valueOf(pathLayoutFatura) + File.separator + "logo_sicoob.png";
                boleto.addImagensExtras("txtRsLogoBanco", new ImageIcon(pathLogo).getImage());
                boleto.addImagensExtras("txtFcLogoBanco", new ImageIcon(pathLogo).getImage());
                nn = String.valueOf(fatura.getNumeroBoleto().substring(0, fatura.getNumeroBoleto().length() - 1)) + "-" + fatura.getNumeroBoleto().substring(fatura.getNumeroBoleto().length() - 1);
                boleto.addTextosExtras("txtRsNossoNumero", nn);
                boleto.addTextosExtras("txtFcNossoNumero", nn);
                break;
            }
            case "001": {
                String agenciaCedente = String.valueOf(fatura.getFormaCobranca().getContaFinanceira().getAgencia()) + "-" + fatura.getFormaCobranca().getContaFinanceira().getDvAgencia() + " / " + fatura.getFormaCobranca().getContaFinanceira().getContaCorrente() + "-" + fatura.getFormaCobranca().getContaFinanceira().getDvContaCorrente();
                boleto.addTextosExtras("txtFcAgenciaCodigoCedente", agenciaCedente);
                boleto.addTextosExtras("txtRsAgenciaCodigoCedente", agenciaCedente);
                break;
            }
            case "237": {
                String cart = StringUtils.leftPad((String)String.valueOf(fatura.getFormaCobranca().getCodigoCarteiraFatura()), (int)2, (String)"0");
                boleto.addTextosExtras("txtFcValor", fatura.getValor().toString());
                agcedente = String.valueOf(StringUtils.leftPad((String)fatura.getFormaCobranca().getContaFinanceira().getAgencia(), (int)4, (String)"0")) + "-" + fatura.getFormaCobranca().getContaFinanceira().getDvAgencia() + " / " + StringUtils.leftPad((String)fatura.getFormaCobranca().getContaFinanceira().getContaCorrente(), (int)7, (String)"0") + "-" + fatura.getFormaCobranca().getContaFinanceira().getDvContaCorrente();
                boleto.addTextosExtras("txtFcAgenciaCodigoCedente", agcedente);
                boleto.addTextosExtras("txtRsAgenciaCodigoCedente", agcedente);
                boleto.addTextosExtras("txtFcEspecie", "R$");
                boleto.addTextosExtras("txtFcCarteira", cart);
                nn = String.valueOf(StringUtils.leftPad((String)fatura.getNumeroBoleto().substring(0, fatura.getNumeroBoleto().length() - 1), (int)11, (String)"0")) + "-" + fatura.getNumeroBoleto().substring(fatura.getNumeroBoleto().length() - 1);
                boleto.addTextosExtras("txtRsNossoNumero", String.valueOf(cart) + "/" + nn);
                boleto.addTextosExtras("txtFcNossoNumero", String.valueOf(cart) + "/" + nn);
                break;
            }
            case "104": {
                String texto = String.valueOf(StringUtils.leftPad((String)fatura.getFormaCobranca().getContaFinanceira().getAgencia(), (int)4, (String)"0")) + " / " + fatura.getFormaCobranca().getContaFinanceira().obterCodigoCedenteComDV();
                nn = String.valueOf(this.getNossoNumero(fatura, false)) + "-" + fatura.getNumeroBoleto().substring(fatura.getNumeroBoleto().length() - 1);
                boleto.addTextosExtras("txtFcAgenciaCodigoCedente", texto);
                boleto.addTextosExtras("txtRsAgenciaCodigoCedente", texto);
                boleto.addTextosExtras("txtRsNossoNumero", nn);
                boleto.addTextosExtras("txtFcNossoNumero", nn);
                boleto.addTextosExtras("txtRsDataDocumento", new SimpleDateFormat("dd/MM/yyyy").format(boleto.getTitulo().getDataDoDocumento()));
                boleto.addTextosExtras("txtRsDataProcessamento", new SimpleDateFormat("dd/MM/yyyy").format(new Date()));
                break;
            }
            case "004": {
                String texto = String.valueOf(StringUtils.leftPad((String)fatura.getFormaCobranca().getContaFinanceira().getAgencia(), (int)4, (String)"0")) + " / " + fatura.getFormaCobranca().getContaFinanceira().obterCodigoCedenteComDV();
                nn = String.valueOf(boleto.getTitulo().getNossoNumero()) + "-" + boleto.getTitulo().getDigitoDoNossoNumero() + "        " + formaCobranca.getCodigoCarteiraFatura();
                boleto.addTextosExtras("txtFcAgenciaCodigoCedente", texto);
                boleto.addTextosExtras("txtRsAgenciaCodigoCedente", texto);
                boleto.addTextosExtras("txtRsNossoNumero", nn);
                boleto.addTextosExtras("txtFcNossoNumero", nn);
                break;
            }
            case "246": {
                String pathLogo = String.valueOf(pathLayoutFatura) + File.separator + "logo_abc.png";
                boleto.addImagensExtras("txtRsLogoBanco", new ImageIcon(pathLogo).getImage());
                boleto.addImagensExtras("txtFcLogoBanco", new ImageIcon(pathLogo).getImage());
                boleto.addTextosExtras("txtRsLogoBanco", "");
                boleto.addTextosExtras("txtFcLogoBanco", "");
                nn = String.valueOf(fatura.getFormaCobranca().getContaFinanceira().getAgencia()) + (fatura.getFormaCobranca().getContaFinanceira().getDvAgencia() != null ? fatura.getFormaCobranca().getContaFinanceira().getDvAgencia() : "0") + "/" + fatura.getFormaCobranca().getCodigoCarteiraFatura() + StringUtils.leftPad((String)fatura.getNumeroBoleto().substring(0, fatura.getNumeroBoleto().length() - 1), (int)10, (String)"0") + "-" + fatura.getNumeroBoleto().substring(fatura.getNumeroBoleto().length() - 1);
                boleto.addTextosExtras("txtRsNossoNumero", nn);
                boleto.addTextosExtras("txtFcNossoNumero", nn);
                String texto = String.valueOf(StringUtils.leftPad((String)fatura.getFormaCobranca().getContaFinanceira().getAgencia(), (int)4, (String)"0")) + fatura.getFormaCobranca().getContaFinanceira().getDvAgencia() + "/" + fatura.getFormaCobranca().getContaFinanceira().obterCodigoCedenteComDV();
                boleto.addTextosExtras("txtFcAgenciaCodigoCedente", texto);
                boleto.addTextosExtras("txtRsAgenciaCodigoCedente", texto);
                break;
            }
            case "748": {
                agcedente = String.valueOf(StringUtils.leftPad((String)fatura.getFormaCobranca().getContaFinanceira().getAgencia(), (int)4, (String)"0")) + "." + StringUtils.leftPad((String)fatura.getFormaCobranca().getOperacao(), (int)2, (String)"0") + "." + StringUtils.leftPad((String)fatura.getFormaCobranca().getContaFinanceira().getCodigoCedente(), (int)5, (String)"0");
                boleto.addTextosExtras("txtFcAgenciaCodigoCedente", agcedente);
                boleto.addTextosExtras("txtRsAgenciaCodigoCedente", agcedente);
                nn = String.valueOf(fatura.getNumeroBoleto().substring(0, 2)) + "/" + fatura.getNumeroBoleto().substring(2, fatura.getNumeroBoleto().length() - 1) + "-" + fatura.getNumeroBoleto().substring(fatura.getNumeroBoleto().length() - 1);
                boleto.addTextosExtras("txtRsNossoNumero", nn);
                boleto.addTextosExtras("txtFcNossoNumero", nn);
            }
        }
        if (carteira != null) {
            boleto.addTextosExtras("txtFcCarteira", carteira);
        }
        boleto.addTextosExtras("txtDataEmissao", new SimpleDateFormat("dd/MM/yyyy").format(fatura.getDataLancamento()));
        boleto.addTextosExtras("txtNomeDocumentoCliente", this.geraNomeDocumentoCliente());
        return boleto;
    }

    private String geraNomeDocumentoCliente() {
        String identificacaoCliente = "";
        if (this.clienteDto.getCpf() != null) {
            identificacaoCliente = "CPF: " + this.clienteDto.getCpf().substring(0, 3) + StringUtils.repeat((String)".***", (int)2) + "-**";
        } else if (this.clienteDto.getCnpj() != null) {
            identificacaoCliente = "CNPJ: " + this.clienteDto.getCnpj().substring(0, 3) + StringUtils.repeat((String)".***", (int)2) + "/****-**";
        }
        return String.format("%s, %s", this.clienteDto.getNome(), identificacaoCliente);
    }

    private String getEnderecoSacado(ClienteDto cliente, int linha) {
        if (linha == 2) {
            return String.valueOf(cliente.getEndereco().trim()) + ", N\u00ba: " + cliente.getNumero() + (cliente.getComplemento() != null && !cliente.getComplemento().isEmpty() ? ", " + cliente.getComplemento() : "") + " - CEP: " + this.formataCep(cliente.getCep());
        }
        return "B. " + cliente.getBairro().trim() + " - " + cliente.getCidade().trim() + " / " + cliente.getEstado();
    }

    private Boleto geraInstrucoes(Fatura fatura, Boleto boleto, FormaCobranca formaCobranca, FinanceiroDao financeiroDao, ComercialDao comercialDao) throws Exception {
        DecimalFormat df = new DecimalFormat("0.00");
        Double valorMulta = fatura.getValor() * (new Double(formaCobranca.getPercentualMulta()) / 100.0);
        Double valorJurosAoDia = fatura.getValor() / 30.0 * (new Double(formaCobranca.getPercentualJuros()) / 100.0);
        String textoMulta = "";
        String textoDesconto = null;
        int cont = 1;
        for (InstrucaoBancaria instrucao : formaCobranca.getContaFinanceira().getInstrucoes()) {
            List<Map<String, Object>> alteracoes;
            String texto;
            if (instrucao.getTipo().equals((Object)eTipoInstrucao.INSTRUCAO_SACADO)) {
                boleto.setInstrucaoAoSacado(instrucao.getTexto());
                continue;
            }
            if (instrucao.getTipo().equals((Object)eTipoInstrucao.LOCAL_PAGAMENTO)) {
                boleto.setLocalPagamento(instrucao.getTexto());
                continue;
            }
            if (instrucao.getTipo().equals((Object)eTipoInstrucao.PADRAO)) {
                ++cont;
                boleto = this.setTextoIntrucao(instrucao, instrucao.getTexto(), boleto);
                continue;
            }
            if (instrucao.getTipo().equals((Object)eTipoInstrucao.PAGAMENTO_ADIANTADO) && fatura.getFaturamentos() != null && fatura.getFaturamentos().size() > 0) {
                Double valorDescontoAdiantado = this.getDescontoPagamentoAdiantado(fatura.getFaturamentos(), comercialDao);
                if (valorDescontoAdiantado == null || !(valorDescontoAdiantado > 0.0)) continue;
                ++cont;
                texto = instrucao.getTexto().replaceAll("\\[VALOR_TOTAL\\]", df.format(valorDescontoAdiantado));
                boleto = this.setTextoIntrucao(instrucao, texto, boleto);
                continue;
            }
            if (instrucao.getTipo().equals((Object)eTipoInstrucao.INSTRUCAO_MULTA)) {
                textoMulta = instrucao.getTexto();
                continue;
            }
            if (instrucao.getTipo().equals((Object)eTipoInstrucao.DESCONTO)) {
                textoDesconto = instrucao.getTexto();
                continue;
            }
            if (instrucao.getTipo().equals((Object)eTipoInstrucao.ATRASO_MENSALIDADE)) {
                if (financeiroDao.findFaturasVencidasSemPagamento(fatura.getIdCliente(), fatura.getId()).size() <= 0) continue;
                if (boleto.getInstrucaoAoSacado().isEmpty()) {
                    boleto.setInstrucaoAoSacado(instrucao.getTexto());
                    continue;
                }
                boleto.setInstrucaoAoSacado(String.valueOf(boleto.getInstrucaoAoSacado()) + "\n" + instrucao.getTexto());
                continue;
            }
            if (instrucao.getTipo().equals((Object)eTipoInstrucao.PRIMEIRA_FATURA)) {
                if (financeiroDao.countFaturasAnterioresByCliente(fatura.getIdCliente(), fatura.getDataLancamento()) > 0L) continue;
                boleto.addTextosExtras("txtRsTextoPrimeiraFatura", instrucao.getTexto());
                continue;
            }
            if (!instrucao.getTipo().equals((Object)eTipoInstrucao.ALTERACAO) || (alteracoes = financeiroDao.findAlteracoesFatura(fatura.getId())) == null || alteracoes.size() <= 0) continue;
            texto = "";
            for (Map<String, Object> map : alteracoes) {
                texto = String.valueOf(texto) + instrucao.getTexto().replaceAll("\\[OCORRENCIA\\]", map.get("ocorrencia").toString()) + "; ";
            }
            boleto = this.setTextoIntrucao(instrucao, texto, boleto);
        }
        textoMulta = textoMulta.replaceAll("\\[MULTA%\\]", df.format(formaCobranca.getPercentualMulta()));
        textoMulta = textoMulta.replaceAll("\\[MULTARS\\]", df.format(valorMulta));
        textoMulta = textoMulta.replaceAll("\\[JUROS%\\]", df.format(formaCobranca.getPercentualJuros()));
        textoMulta = textoMulta.replaceAll("\\[JUROSRS\\]", df.format(valorJurosAoDia));
        boleto = this.setaInstrucaoMulta(boleto, cont, textoMulta);
        if (textoDesconto != null && fatura.getFaturamentos() != null && fatura.getFaturamentos().size() > 0) {
            return this.getTextoDescontos(fatura, textoDesconto, boleto, cont, financeiroDao);
        }
        return boleto;
    }

    private Double getDescontoPagamentoAdiantado(List<FaturamentoMes> faturamentos, ComercialDao comercialDao) {
        HashSet<Long> idsContratos = new HashSet<Long>();
        for (FaturamentoMes faturamento : faturamentos) {
            idsContratos.add(faturamento.getIdContrato());
        }
        return comercialDao.findValorDescontoPagamentoAdiantado(idsContratos);
    }

    private Boleto setaInstrucaoMulta(Boleto boleto, int cont, String textoMulta) {
        switch (cont) {
            case 1: {
                boleto.setInstrucao1(textoMulta);
                return boleto;
            }
            case 2: {
                boleto.setInstrucao2(textoMulta);
                return boleto;
            }
            case 3: {
                boleto.setInstrucao3(textoMulta);
                return boleto;
            }
            case 4: {
                boleto.setInstrucao4(textoMulta);
                return boleto;
            }
            case 5: {
                boleto.setInstrucao5(textoMulta);
                return boleto;
            }
            case 6: {
                boleto.setInstrucao6(textoMulta);
                return boleto;
            }
        }
        boleto.setInstrucao7(textoMulta);
        return boleto;
    }

    private Boleto setTextoIntrucao(InstrucaoBancaria instrucao, String texto, Boleto boleto) {
        switch (instrucao.getOrdem()) {
            case 1: {
                boleto.setInstrucao1(texto);
                return boleto;
            }
            case 2: {
                boleto.setInstrucao2(texto);
                return boleto;
            }
            case 3: {
                boleto.setInstrucao3(texto);
                return boleto;
            }
            case 4: {
                boleto.setInstrucao4(texto);
                return boleto;
            }
            case 5: {
                boleto.setInstrucao5(texto);
                return boleto;
            }
            case 6: {
                boleto.setInstrucao6(texto);
                return boleto;
            }
        }
        boleto.setInstrucao7(texto);
        return boleto;
    }

    private Boleto getTextoDescontos(Fatura fatura, String textoInstrucao, Boleto boleto, int cont, FinanceiroDao financeiroDao) {
        HashSet<Long> idsContratos = new HashSet<Long>();
        for (FaturamentoMes faturamento : fatura.getFaturamentos()) {
            idsContratos.add(faturamento.getIdContrato());
        }
        if (idsContratos.size() > 0) {
            List<Object> descontos = new ArrayList();
            descontos = financeiroDao.findDescontosByImprimirFatura(new ArrayList<Long>(idsContratos), fatura.getDataVencimento());
            if (descontos.size() > 0) {
                int contItem = 0;
                try {
                    switch (cont) {
                        case 1: {
                            contItem = 0;
                            boleto.setInstrucao2(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao3(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao4(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao5(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao6(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao7(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao8(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            return boleto;
                        }
                        case 2: {
                            contItem = 0;
                            boleto.setInstrucao3(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao4(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao5(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao6(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao7(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao8(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            return boleto;
                        }
                        case 3: {
                            contItem = 0;
                            boleto.setInstrucao4(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao5(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao6(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao7(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao8(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            return boleto;
                        }
                        case 4: {
                            contItem = 0;
                            boleto.setInstrucao5(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao6(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao7(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao8(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            return boleto;
                        }
                        case 5: {
                            contItem = 0;
                            boleto.setInstrucao6(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao7(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao8(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            return boleto;
                        }
                        case 6: {
                            contItem = 0;
                            boleto.setInstrucao7(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            boleto.setInstrucao8(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                            return boleto;
                        }
                    }
                    contItem = 0;
                    boleto.setInstrucao8(this.formataTextoDesconto(textoInstrucao, (Map)descontos.get(contItem++)));
                    return boleto;
                }
                catch (Exception e) {
                    return boleto;
                }
            }
        }
        return boleto;
    }

    private String formataTextoDesconto(String textoInstrucao, Map<String, Object> desc) {
        try {
            DecimalFormat df = new DecimalFormat("0.00");
            int totalParc = (Integer)desc.get("ParcelasDesconto");
            textoInstrucao = textoInstrucao.replaceAll("\\[PARCELA_CORRENTE\\]", String.valueOf(desc.get("ParcelasFaturadas")));
            textoInstrucao = textoInstrucao.replaceAll("\\[PARCELA_TOTAL\\]", String.valueOf(desc.get("ParcelasDesconto")));
            textoInstrucao = textoInstrucao.replaceAll("\\[VALOR_PARCELA\\]", df.format((Double)desc.get("Valor") / new Double(totalParc)));
            textoInstrucao = textoInstrucao.replaceAll("\\[VALOR_TOTAL\\]", df.format(desc.get("Valor")));
            textoInstrucao = textoInstrucao.replaceAll("\\[DESCRICAO\\]", desc.get("Observacao").toString());
            return this.trataTamanhoString(textoInstrucao, 85);
        }
        catch (Exception e) {
            ImprimirFaturaService.log.logger.info("Erro ao gerar texto da instru\u00e7\u00e3o de desconto. ID do faturamento desconto: " + desc.get("IDDesconto"));
            e.printStackTrace();
            return "";
        }
    }

    private String trataTamanhoString(String texto, int tamanhoMax) {
        if (texto.trim().length() > tamanhoMax) {
            return texto.trim().substring(0, tamanhoMax);
        }
        return texto.trim().toUpperCase();
    }

    private Titulo geraDadosTitulo(ContaBancaria conta, Sacado sacado, Cedente cedente, Fatura fatura) throws ParseException {
        Titulo titulo = new Titulo(conta, sacado, cedente);
        titulo.setNumeroDoDocumento(fatura.getNumeroDocumento());
        titulo.setNossoNumero(this.getNossoNumero(fatura, false));
        if (!fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("001") || fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("001") && new Long(fatura.getFormaCobranca().getContaFinanceira().getCodigoCedente()) > 1000000L) {
            titulo.setDigitoDoNossoNumero(this.getNossoNumero(fatura, true));
        }
        titulo.setValor(BigDecimal.valueOf(fatura.getValor()));
        titulo.setDataDoDocumento(fatura.getDataLancamento());
        titulo.setDataDoVencimento(fatura.getDataVencimento());
        titulo.setTipoDeDocumento(TipoDeTitulo.DM_DUPLICATA_MERCANTIL);
        titulo.setAceite(Titulo.Aceite.N);
        if (!fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("004") && !fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("104")) {
            titulo.setDesconto(BigDecimal.ZERO);
            titulo.setDeducao(BigDecimal.ZERO);
            titulo.setMora(BigDecimal.ZERO);
            titulo.setAcrecimo(BigDecimal.ZERO);
            titulo.setValorCobrado(BigDecimal.ZERO);
        }
        return titulo;
    }

    private Sacado geraDadosSacado(ClienteDto cliente) throws Exception {
        return new Sacado(cliente.getNome(), cliente.getCpf() != null ? cliente.getCpf() : cliente.getCnpj());
    }

    private ContaBancaria geraDadosContaBancaria(FormaCobranca formaCobranca) {
        BancosSuportados banco = this.getBancoSuportado(formaCobranca.getContaFinanceira().getBanco());
        ContaBancaria contaBancaria = null;
        if (banco != null) {
            contaBancaria = new ContaBancaria((Banco)banco.create());
        } else if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("246")) {
            CodigoDeCompensacaoBACEN codigo = new CodigoDeCompensacaoBACEN(Integer.valueOf(246));
            org.jrimum.domkee.financeiro.banco.febraban.Banco bc = new org.jrimum.domkee.financeiro.banco.febraban.Banco(codigo, "ABC BRASIL S.A.");
            bc.setSegmento("Banco M\u00faltiplo");
            CNPJ c = new CNPJ(Long.valueOf(28195667000106L));
            bc.setCNPJ(c);
            contaBancaria = new ContaBancaria((Banco)bc);
        }
        String dvAgencia = formaCobranca.getContaFinanceira().getDvAgencia() != null ? formaCobranca.getContaFinanceira().getDvAgencia() : null;
        Carteira carteira = new Carteira(Integer.valueOf(formaCobranca.getCodigoCarteiraFatura()), TipoDeCobranca.COM_REGISTRO);
        Agencia agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())), dvAgencia);
        NumeroDaConta numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getCodigoCedente())), formaCobranca.getContaFinanceira().getDvContaCorrente());
        if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("033")) {
            carteira = new Carteira(Integer.valueOf(101));
            if (dvAgencia == null) {
                dvAgencia = "0";
            }
            agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())), dvAgencia);
            numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(this.getNumeroConta(formaCobranca.getContaFinanceira().getCodigoCedente(), false, formaCobranca.getContaFinanceira().getBanco().getCodigo()))), this.getNumeroConta(formaCobranca.getContaFinanceira().getCodigoCedente(), true, formaCobranca.getContaFinanceira().getBanco().getCodigo()));
        } else if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("001")) {
            carteira = new Carteira(Integer.valueOf(17));
            if (dvAgencia == null) {
                dvAgencia = "0";
            }
            agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())), dvAgencia);
            numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getCodigoCedente())));
        } else if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("341")) {
            carteira = new Carteira(Integer.valueOf(formaCobranca.getCodigoCarteiraFatura()));
            agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())));
            numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getCodigoCedente())), formaCobranca.getContaFinanceira().getDvContaCorrente());
        } else if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("756")) {
            carteira = new Carteira(Integer.valueOf(1));
            agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())));
            numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getCodigoCedente())));
        } else if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("104") || formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("004")) {
            carteira = new Carteira(Integer.valueOf(formaCobranca.getCodigoCarteiraFatura()));
            agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())));
            String dvConta = formaCobranca.getContaFinanceira().getDvContaCorrente();
            if (formaCobranca.getContaFinanceira().obterCodigoCedenteComDV().contains("-")) {
                dvConta = formaCobranca.getContaFinanceira().obterCodigoCedenteComDV().split("-")[1];
            }
            numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getCodigoCedente())), dvConta);
        } else if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("237")) {
            carteira = new Carteira(Integer.valueOf(formaCobranca.getCodigoCarteiraFatura()));
            if (dvAgencia == null) {
                dvAgencia = "0";
            }
            agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())), dvAgencia);
            numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(this.getNumeroConta(formaCobranca.getContaFinanceira().getCodigoCedente(), false, formaCobranca.getContaFinanceira().getBanco().getCodigo()))), this.getNumeroConta(formaCobranca.getContaFinanceira().getCodigoCedente(), true, formaCobranca.getContaFinanceira().getBanco().getCodigo()));
        } else if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("422")) {
            carteira = new Carteira(Integer.valueOf(formaCobranca.getCodigoCarteiraFatura()), TipoDeCobranca.COM_REGISTRO);
            if (dvAgencia == null) {
                dvAgencia = "0";
            }
            agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())), dvAgencia);
            numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getContaCorrente())), formaCobranca.getContaFinanceira().getDvContaCorrente());
        } else if (formaCobranca.getContaFinanceira().getBanco().getCodigo().equals("246")) {
            carteira = new Carteira(Integer.valueOf(formaCobranca.getCodigoCarteiraFatura()));
            agencia = new Agencia(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getAgencia())), dvAgencia);
            numeroConta = new NumeroDaConta(Integer.valueOf(Integer.parseInt(formaCobranca.getContaFinanceira().getCodigoCedente())), formaCobranca.getContaFinanceira().getDvContaCorrente());
        }
        contaBancaria.setAgencia(agencia);
        contaBancaria.setCarteira(carteira);
        contaBancaria.setNumeroDaConta(numeroConta);
        return contaBancaria;
    }

    private String getNumeroConta(String codCedente, Boolean dv, String codBanco) {
        String ced = StringUtils.leftPad((String)codCedente.toString(), (int)7, (String)"0");
        if (codBanco.equals("756")) {
            return ced;
        }
        if (dv.booleanValue()) {
            return ced.substring(ced.length() - 1, ced.length());
        }
        return ced.substring(0, ced.length() - 1);
    }

    private ClienteDto getDadosCliente(Long idContrato, ComercialDao comercialDao, TerceirosDao terceirosDao) {
        ClienteDto cliente = new ClienteDto();
        Map<String, Object> dadosCliente = comercialDao.findDadosCliente(idContrato, "COBRANCA", false, false);
        if (dadosCliente == null) {
            ImprimirFaturaService.log.logger.info("N\u00e3o foi poss\u00edvel encontrar os dados do cliente a partir do contrato " + idContrato + ". Verificar se o mesmo possui um endere\u00e7o de COBRANCA ou PADR\u00c3O.");
            return null;
        }
        String emailsCobranca = "";
        if (dadosCliente.get("emailsCobranca") != null && !dadosCliente.get("emailsCobranca").toString().isEmpty() && ((String)dadosCliente.get("emailsCobranca")).length() > 1) {
            emailsCobranca = dadosCliente.get("emailsCobranca").toString().startsWith(";") ? ((String)dadosCliente.get("emailsCobranca")).substring(1) : (String)dadosCliente.get("emailsCobranca");
        }
        if (dadosCliente.get("emailCliente") != null && !emailsCobranca.contains((String)dadosCliente.get("emailCliente"))) {
            emailsCobranca = String.valueOf(emailsCobranca) + (!emailsCobranca.equals("") ? ";" : "") + dadosCliente.get("emailCliente");
        }
        dadosCliente.put("emailsCobranca", emailsCobranca);
        cliente.setNome((String)dadosCliente.get("nome"));
        if ((String)dadosCliente.get("cpf") != null) {
            cliente.setCpf((String)dadosCliente.get("cpf"));
        } else {
            cliente.setCnpj((String)dadosCliente.get("cnpj"));
        }
        if (dadosCliente.get("observacaoFiscal") != null) {
            cliente.setObservacaoFiscal(dadosCliente.get("observacaoFiscal").toString());
        }
        cliente.setCfop(dadosCliente.get("cfop").toString());
        cliente.setEmailsCobranca((String)dadosCliente.get("emailsCobranca"));
        cliente.setNumero((BigInteger)dadosCliente.get("numero"));
        cliente.setComplemento((String)dadosCliente.get("complemento"));
        BigInteger idEndereco = (BigInteger)dadosCliente.get("idEndereco");
        cliente.setIdEndereco(idEndereco.longValue());
        Map<String, Object> dadosEndereco = terceirosDao.findEnderecoByID(cliente.getIdEndereco());
        cliente.setEndereco((String)dadosEndereco.get("endereco"));
        cliente.setBairro((String)dadosEndereco.get("bairro"));
        cliente.setCidade((String)dadosEndereco.get("cidade"));
        cliente.setEstado((String)dadosEndereco.get("estado"));
        cliente.setCep((String)dadosEndereco.get("cep"));
        return cliente;
    }

    private String formataCep(String cep) {
        if (!cep.contains("-")) {
            return String.valueOf(cep.substring(0, 5)) + "-" + cep.substring(5, cep.length());
        }
        return cep;
    }

    private BancosSuportados getBancoSuportado(rotinas.adapter.financeiro.Banco banco) {
        switch (banco.getCodigo()) {
            case "033": {
                return BancosSuportados.BANCO_SANTANDER;
            }
            case "104": {
                return BancosSuportados.CAIXA_ECONOMICA_FEDERAL;
            }
            case "001": {
                return BancosSuportados.BANCO_DO_BRASIL;
            }
            case "341": {
                return BancosSuportados.BANCO_ITAU;
            }
            case "756": {
                return BancosSuportados.BANCOOB;
            }
            case "237": {
                return BancosSuportados.BANCO_BRADESCO;
            }
            case "004": {
                return BancosSuportados.BANCO_DO_NORDESTE_DO_BRASIL;
            }
            case "422": {
                return BancosSuportados.BANCO_SAFRA;
            }
            case "748": {
                return BancosSuportados.BANCO_SICREDI;
            }
        }
        return null;
    }

    private String getNossoNumero(Fatura fatura, Boolean dv) {
        String nn;
        switch (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo()) {
            case "001": {
                if (new Long(fatura.getFormaCobranca().getContaFinanceira().getCodigoCedente()) > 1000000L) {
                    String codCedente = StringUtils.leftPad((String)fatura.getFormaCobranca().getContaFinanceira().getCodigoCedente(), (int)7, (String)"0");
                    String nn2 = String.valueOf(codCedente) + StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)10, (String)"0");
                    if (!dv.booleanValue()) {
                        return nn2;
                    }
                    return this.calculaDVBB(fatura);
                }
                if (new Long(fatura.getFormaCobranca().getContaFinanceira().getCodigoCedente()) <= 9999L) {
                    String codCedente = StringUtils.leftPad((String)StringUtils.stripStart((String)fatura.getFormaCobranca().getContaFinanceira().getCodigoCedente(), (String)"0"), (int)4, (String)"0");
                    nn = String.valueOf(codCedente) + StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)8, (String)"0");
                    break;
                }
                nn = StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)17, (String)"0");
                break;
            }
            case "004": 
            case "341": {
                nn = StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)8, (String)"0");
                break;
            }
            case "756": {
                if (!dv.booleanValue()) {
                    return StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)8, (String)"0");
                }
                return fatura.getNumeroBoleto().substring(fatura.getNumeroBoleto().length() - 1);
            }
            case "237": {
                nn = StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)12, (String)"0");
                break;
            }
            case "104": {
                String nn3 = fatura.getNumeroBoleto().substring(0, fatura.getNumeroBoleto().length() - 1);
                return String.valueOf(fatura.getFormaCobranca().getCodigoCarteiraFatura()) + StringUtils.leftPad((String)nn3, (int)15, (String)"0");
            }
            case "422": {
                return StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)9, (String)"0");
            }
            case "246": {
                nn = StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)11, (String)"0");
                break;
            }
            case "748": {
                nn = fatura.getNumeroBoleto();
                break;
            }
            default: {
                nn = StringUtils.leftPad((String)fatura.getNumeroBoleto(), (int)13, (String)"0");
            }
        }
        if (dv.booleanValue()) {
            return nn.substring(nn.length() - 1);
        }
        return nn.substring(0, nn.length() - 1);
    }

    private String calculaDVBB(Fatura fatura) {
        String nnFinal = fatura.getNumeroBoleto();
        String[] nossoNumero = nnFinal.split("");
        int total = 0;
        int multiplicador = 9;
        int i = nossoNumero.length - 1;
        while (i >= 0) {
            int valor = Integer.parseInt(nossoNumero[i]) * multiplicador--;
            total += valor;
            if (multiplicador < 2) {
                multiplicador = 9;
            }
            --i;
        }
        int resto = total % 11;
        if (resto < 10) {
            return "" + resto;
        }
        return "X";
    }

    private String getPDFTempName(Date vencimento, String nomeCliente, Long idFatura) {
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yy");
        String[] nome = nomeCliente.trim().split(" ");
        return String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + idFatura + "_" + nome[0] + " " + nome[1] + "_" + df.format(vencimento) + ".pdf";
    }

    private String geraTextoDebitosAnteriores(Long idCliente, Long idFatura, FinanceiroDao financeiroDao) {
        SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy");
        DecimalFormat df = new DecimalFormat("0.00");
        List<Fatura> faturasAtrasadas = financeiroDao.findFaturasVencidasSemPagamento(idCliente, idFatura);
        String texto = "";
        for (Fatura fatura : faturasAtrasadas) {
            texto = String.valueOf(texto) + "FATURA VENCIMENTO " + f.format(fatura.getDataVencimento()) + " - R$" + df.format(fatura.getValor()) + "\n";
        }
        return texto.isEmpty() ? null : texto;
    }

    private Map<String, String> geraTextoInformacoesComplementaresNota(Fatura fatura, FinanceiroDao financeiroDao) {
        String textoDescricao = "";
        String textoValor = "";
        Double valor = 0.0;
        DecimalFormat df = new DecimalFormat("0.00");
        TreeMap<String, Double> gruposNota = new TreeMap<String, Double>();
        List<GrupoComposicaoNota> grupos = financeiroDao.findGruposComposicaoNota();
        if (grupos != null && grupos.size() > 0) {
            for (GrupoComposicaoNota grupoComposicaoNota : grupos) {
                gruposNota.put(grupoComposicaoNota.getDescricao(), 0.0);
            }
            for (FaturamentoMes faturamentoMes : fatura.getFaturamentos()) {
                if (faturamentoMes.getItemNota() == null || faturamentoMes.getComposicao().getGrupoComposicaoNota() == null) continue;
                valor = (Double)gruposNota.get(faturamentoMes.getComposicao().getGrupoComposicaoNota().getDescricao());
                gruposNota.put(faturamentoMes.getComposicao().getGrupoComposicaoNota().getDescricao(), valor + faturamentoMes.getItemNota().getValorItem());
            }
            for (Map.Entry entry : gruposNota.entrySet()) {
                textoDescricao = String.valueOf(textoDescricao) + (String)entry.getKey() + "\n";
                textoValor = String.valueOf(textoValor) + "R$ " + df.format(entry.getValue()) + "\n";
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("textoDescricao", textoDescricao);
        hashMap.put("textoValor", textoValor);
        return hashMap;
    }

    public String geraLinhaDigitavel(Fatura fatura, ComercialDao comercialDao, TerceirosDao terceirosDao, FinanceiroDao financeiroDao) {
        Map<String, Object> mapEmpresa = terceirosDao.findDadosDetalhadosEmpresaByID(fatura.getIdEmpresa());
        List<FaturamentoMes> faturamentos = financeiroDao.findFaturamentosByIDFatura(fatura.getId());
        Long idContrato = null;
        this.clienteDto = null;
        try {
            if (faturamentos != null && faturamentos.size() > 0) {
                fatura.setFaturamentos(faturamentos);
                idContrato = fatura.getFaturamentos().get(0).getIdContrato();
            } else {
                List<FaturaParcelamento> parcelamentos = financeiroDao.findParcelamentosByIDFatura(fatura.getId());
                if (parcelamentos != null && parcelamentos.size() > 0) {
                    fatura.setParcelamentos(parcelamentos);
                    idContrato = fatura.getParcelamentos().get(0).getIdContrato();
                }
            }
            if (idContrato != null) {
                this.clienteDto = this.getDadosCliente(idContrato, comercialDao, terceirosDao);
            }
            if (this.clienteDto != null) {
                Boleto boleto;
                Cedente cedente = new Cedente(mapEmpresa.get("razao").toString(), mapEmpresa.get("cnpj").toString());
                Sacado sacado = this.geraDadosSacado(this.clienteDto);
                ContaBancaria conta = this.geraDadosContaBancaria(fatura.getFormaCobranca());
                Titulo titulo = this.geraDadosTitulo(conta, sacado, cedente, fatura);
                if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("033")) {
                    CLSantanderCarteira104E101 campoLivreSantander104 = new CLSantanderCarteira104E101(titulo, fatura.getFormaCobranca().getCodigoCarteiraFatura());
                    boleto = new Boleto(titulo, (CampoLivre)campoLivreSantander104);
                } else if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("246")) {
                    CLBancoABC campoLivre = new CLBancoABC(fatura.getFormaCobranca().getContaFinanceira().getAgencia(), String.valueOf(fatura.getFormaCobranca().getCodigoCarteiraFatura()), fatura.getNumeroBoleto(), fatura.getFormaCobranca().getOperacao());
                    boleto = new Boleto(titulo, (CampoLivre)campoLivre);
                } else if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("104") && (fatura.getFormaCobranca().getCodigoCarteiraFatura() == 11 || fatura.getFormaCobranca().getCodigoCarteiraFatura() == 14)) {
                    CLCaixaCarteira14E11 campoLivreCaixa = new CLCaixaCarteira14E11(titulo, fatura.getFormaCobranca().getCodigoCarteiraFatura(), fatura.getNumeroBoleto());
                    boleto = new Boleto(titulo, (CampoLivre)campoLivreCaixa);
                } else {
                    boleto = new Boleto(titulo);
                }
                return boleto.getLinhaDigitavel().write();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> imprimirFaturaNotaUnificada(Fatura fatura, Long idNota, Boolean isSVAIncluso, String pathLayoutNota, String modeloUnificado, FinanceiroDao financeiroDao, TerceirosDao terceirosDao, ComercialDao comercialDao) throws JRException, ParseException {
        try {
            FaturaNotaUnificadaDto dto = this.montaDadosFaturaNotaUnificada(fatura, isSVAIncluso, financeiroDao, terceirosDao, comercialDao);
            String pathJasper = pathLayoutNota;
            HashMap<String, String> parametros = new HashMap<String, String>();
            parametros.put("SUBREPORT_DIR", pathJasper);
            String pathArquivoPdf = this.getPDFTempName(fatura.getDataVencimento(), dto.getNomeCliente(), fatura.getId());
            ArrayList<FaturaNotaUnificadaDto> lista = new ArrayList<FaturaNotaUnificadaDto>();
            lista.add(dto);
            JRBeanCollectionDataSource source = new JRBeanCollectionDataSource(lista);
            JasperPrint jp = JasperFillManager.fillReport((String)(String.valueOf(pathJasper) + modeloUnificado), parametros, (JRDataSource)source);
            JasperExportManager.exportReportToPdfFile((JasperPrint)jp, (String)pathArquivoPdf);
            HashMap<String, Object> resposta = new HashMap<String, Object>();
            resposta.put("File", new File(pathArquivoPdf));
            if (!fatura.getFormaCobranca().getDebitoAutomatico().booleanValue()) {
                resposta.put("CodigoBarras", dto.getLinhaDigitavel());
            } else {
                resposta.put("CodigoBarras", "Demonstrativo de conta em debito automatico");
            }
            return resposta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> imprimirFatura(Fatura fatura, Boolean isSVAIncluso, FinanceiroDao financeiroDao, TerceirosDao terceirosDao, ComercialDao comercialDao, String pathLayoutFatura) {
        Map<String, Object> mapEmpresa = terceirosDao.findDadosDetalhadosEmpresaByID(fatura.getIdEmpresa());
        List<FaturamentoMes> faturamentos = financeiroDao.findFaturamentosByIDFatura(fatura.getId());
        Long idContrato = null;
        this.clienteDto = null;
        try {
            if (faturamentos != null && faturamentos.size() > 0) {
                fatura.setFaturamentos(faturamentos);
                idContrato = fatura.getFaturamentos().get(0).getIdContrato();
            } else {
                List<FaturaParcelamento> parcelamentos = financeiroDao.findParcelamentosByIDFatura(fatura.getId());
                if (parcelamentos != null && parcelamentos.size() > 0) {
                    fatura.setParcelamentos(parcelamentos);
                    idContrato = fatura.getParcelamentos().get(0).getIdContrato();
                }
            }
            if (idContrato != null) {
                this.clienteDto = this.getDadosCliente(idContrato, comercialDao, terceirosDao);
            }
            if (this.clienteDto != null) {
                Boleto boleto;
                Cedente cedente = new Cedente(mapEmpresa.get("razao").toString(), mapEmpresa.get("cnpj").toString());
                Sacado sacado = this.geraDadosSacado(this.clienteDto);
                ContaBancaria conta = this.geraDadosContaBancaria(fatura.getFormaCobranca());
                Titulo titulo = this.geraDadosTitulo(conta, sacado, cedente, fatura);
                if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("033")) {
                    CLSantanderCarteira104E101 campoLivreSantander104 = new CLSantanderCarteira104E101(titulo, fatura.getFormaCobranca().getCodigoCarteiraFatura());
                    boleto = this.geraDadosBoleto(titulo, fatura, fatura.getFormaCobranca(), campoLivreSantander104, String.valueOf(fatura.getFormaCobranca().getCodigoCarteiraFatura()), pathLayoutFatura);
                } else if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("246")) {
                    CLBancoABC campoLivre = new CLBancoABC(fatura.getFormaCobranca().getContaFinanceira().getAgencia(), String.valueOf(fatura.getFormaCobranca().getCodigoCarteiraFatura()), fatura.getNumeroBoleto(), fatura.getFormaCobranca().getOperacao());
                    boleto = new Boleto(titulo, (CampoLivre)campoLivre);
                    boleto = this.geraDadosBoleto(titulo, fatura, fatura.getFormaCobranca(), campoLivre, String.valueOf(fatura.getFormaCobranca().getCodigoCarteiraFatura()), pathLayoutFatura);
                } else if (fatura.getFormaCobranca().getContaFinanceira().getBanco().getCodigo().equals("104") && (fatura.getFormaCobranca().getCodigoCarteiraFatura() == 11 || fatura.getFormaCobranca().getCodigoCarteiraFatura() == 14)) {
                    String textoCarteira = "RG";
                    CLCaixaCarteira14E11 campoLivreCaixa = new CLCaixaCarteira14E11(titulo, fatura.getFormaCobranca().getCodigoCarteiraFatura(), fatura.getNumeroBoleto());
                    if (fatura.getFormaCobranca().getCodigoCarteiraFatura() != 11 && fatura.getFormaCobranca().getCodigoCarteiraFatura() != 14) {
                        textoCarteira = "SR";
                    }
                    boleto = this.geraDadosBoleto(titulo, fatura, fatura.getFormaCobranca(), campoLivreCaixa, textoCarteira, pathLayoutFatura);
                } else {
                    boleto = this.geraDadosBoleto(titulo, fatura, fatura.getFormaCobranca(), null, null, pathLayoutFatura);
                }
                boleto = this.geraCabecalho(boleto, mapEmpresa, fatura.getFormaCobranca(), pathLayoutFatura);
                boleto = this.geraDadosServicos(boleto, fatura, isSVAIncluso, comercialDao);
                boleto = this.geraInstrucoes(fatura, boleto, fatura.getFormaCobranca(), financeiroDao, comercialDao);
                if (fatura.getFormaCobranca().getDebitoAutomatico() != null && fatura.getFormaCobranca().getDebitoAutomatico().booleanValue()) {
                    boleto.addTextosExtras("txtFcLinhaDigitavel", "Demonstrativo de conta em debito automatico");
                    boleto.addImagensExtras("txtFcCodigoBarra", new ImageIcon(String.valueOf(pathLayoutFatura) + File.separator + "transparente.png").getImage());
                }
                BoletoViewer boletoViewer = new BoletoViewer(boleto);
                boletoViewer.setTemplate(String.valueOf(pathLayoutFatura) + fatura.getFormaCobranca().getLayoutFatura());
                File arquivoPdf = boletoViewer.getPdfAsFile(this.getPDFTempName(fatura.getDataVencimento(), this.clienteDto.getNome(), fatura.getId()));
                HashMap<String, Object> resposta = new HashMap<String, Object>();
                resposta.put("File", arquivoPdf);
                if (!fatura.getFormaCobranca().getDebitoAutomatico().booleanValue()) {
                    resposta.put("CodigoBarras", boleto.getLinhaDigitavel().write());
                } else {
                    resposta.put("CodigoBarras", "Demonstrativo de conta em debito automatico");
                }
                return resposta;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPathLayoutFatura(FinanceiroDao financeiroDao) {
        return String.valueOf(financeiroDao.findValorConfiguracoesByChave("PATH_LAYOUT_ARQUIVOS_REMESSA_RETORNO_FATURA")) + File.separator;
    }

    public Long getIDUsuarioLog(FinanceiroDao financeiroDao) {
        return new Long(financeiroDao.findValorConfiguracoesByChave("ID_USUARIO_ENVIO_AUTOMATICO_ROTINAS"));
    }

    public String getEmailRemetente(FinanceiroDao financeiroDao) {
        return financeiroDao.findValorConfiguracoesByChave("REMETENTE_EMAILS_FINANCEIRO");
    }

    public String getPathModeloNota(FinanceiroDao financeiroDao) {
        return String.valueOf(financeiroDao.findValorConfiguracoesByChave("PATH_LAYOUT_ARQUIVOS_NF")) + File.separator;
    }

    public String getIsSVAIncluso(FinanceiroDao financeiroDao) {
        return financeiroDao.findValorConfiguracoesByChave("IMPRIME_SVA_INCLUSO_FATURA");
    }

    public ClienteDto getClienteDto() {
        return this.clienteDto;
    }
}

