/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import rotinas.adapter.config.LoggerConfiguration;
import rotinas.adapter.envio.ComercialDao;
import rotinas.adapter.envio.DadosClienteFatura;
import rotinas.adapter.envio.FinanceiroDao;
import rotinas.adapter.envio.ImprimirFaturaService;
import rotinas.adapter.envio.TerceirosDao;
import rotinas.adapter.financeiro.Fatura;

public class ImprimirFaturaRunnable
implements Runnable {
    public static final LoggerConfiguration log = LoggerConfiguration.getInstance();
    private Fatura fatura;
    private String nomeArquivoModeloUnificado;
    private Boolean isSVAIncluso;
    private String pathLayoutFatura;
    private String pathLayoutNota;
    private FinanceiroDao financeiroDao;
    private ComercialDao comercialDao;
    private TerceirosDao terceirosDao;
    private ImprimirFaturaService imprimirFaturaService;
    private List<DadosClienteFatura> dadosClienteFaturaList;

    public ImprimirFaturaRunnable(Fatura fatura, String nomeArquivoModeloUnificado, Boolean isSVAIncluso, String pathLayoutFatura, String pathLayoutNota, List<DadosClienteFatura> dadosClienteFaturaList, FinanceiroDao financeiroDao, ComercialDao comercialDao, TerceirosDao terceirosDao, ImprimirFaturaService imprimirFaturaService) {
        this.fatura = fatura;
        this.nomeArquivoModeloUnificado = nomeArquivoModeloUnificado;
        this.isSVAIncluso = isSVAIncluso;
        this.pathLayoutFatura = pathLayoutFatura;
        this.pathLayoutNota = pathLayoutNota;
        this.dadosClienteFaturaList = dadosClienteFaturaList;
        this.financeiroDao = financeiroDao;
        this.comercialDao = comercialDao;
        this.terceirosDao = terceirosDao;
        this.imprimirFaturaService = imprimirFaturaService;
    }

    @Override
    public void run() {
        try {
            long startTime = System.nanoTime();
            Map<Object, Object> dadosFatura = new HashMap();
            File file = null;
            String codigoBarras = null;
            if (this.nomeArquivoModeloUnificado != null && !this.nomeArquivoModeloUnificado.isEmpty()) {
                dadosFatura = this.imprimirFaturaService.imprimirFaturaNotaUnificada(this.fatura, null, this.isSVAIncluso, this.pathLayoutNota, this.nomeArquivoModeloUnificado, this.financeiroDao, this.terceirosDao, this.comercialDao);
                file = (File)dadosFatura.get("File");
                codigoBarras = dadosFatura.get("CodigoBarras").toString();
            } else {
                dadosFatura = this.imprimirFaturaService.imprimirFatura(this.fatura, this.isSVAIncluso, this.financeiroDao, this.terceirosDao, this.comercialDao, this.pathLayoutFatura);
                file = (File)dadosFatura.get("File");
                codigoBarras = dadosFatura.get("CodigoBarras").toString();
            }
            if (file != null) {
                ImprimirFaturaRunnable.log.logger.info(String.format("*=*=*=*>>> FATURA gerada no caminho '%s' em %s ms.\n", file.getPath(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS)));
                this.dadosClienteFaturaList.add(new DadosClienteFatura(this.fatura, this.imprimirFaturaService.getClienteDto(), file.getPath(), codigoBarras));
                file = null;
            }
        }
        catch (Exception e) {
            ImprimirFaturaRunnable.log.logger.log(Level.SEVERE, String.format("Falha na impress\u00e3o da fatura: %s", e.toString()), e);
        }
    }
}

