/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import adapter.email.EmailMessage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import rotinas.adapter.config.Configuracoes;
import rotinas.adapter.email.EmailService;
import rotinas.adapter.envio.ComercialDao;

public class EnvioService {
    private EmailService emailService = new EmailService();
    private static ComercialDao comercialDao = new ComercialDao();
    Configuracoes config = Configuracoes.getInstance();

    private String getMessage() {
        String headMessage = "<html><head>";
        String styleMessage = "<style type='text/css'>.line:hover {background-color: #E0FFFF;} tr td {font-family: arial; vertical-align: center; text-align: center; border:1px solid #598080; text-decoration: none; overflow: hidden;}table {width:100%; border-collapse: collapse; border-spacing: 0; border:1px #598080; border-bottom-style:solid;}.title {font-family: arial; font-size: 31px; font-weight: bold; border:1px solid #598080; background-color: #598080}.header {font-weight: bold; font-size: 12px; border:1px solid #598080; background-color: #95CECE}</style></head>";
        return String.valueOf(headMessage) + styleMessage;
    }

    private String getMessageByListLog(List<Map<String, Object>> listLog, Boolean envioFatura) {
        try {
            String headStyleMessage = this.getMessage();
            String bodyMessage = "<body><br/><br/><br/><table cellpadding='8'><tr class='title'><td><img src='http://rotinas.viareal.int/images/viareal_logo.png' width='160px'/></td><td colspan='14'><p>##Titulo##</p></td></tr><tr class='header'><td>C&oacute;digo cliente</td><td colspan='8'>Resumo</td><td colspan='6'>Data</td></tr>";
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            bodyMessage = envioFatura != false ? bodyMessage.replace("##Titulo##", "Log Envio Faturas") : bodyMessage.replace("##Titulo##", "Log Envio Notas Fiscais");
            for (Map<String, Object> log : listLog) {
                bodyMessage = String.valueOf(bodyMessage) + "<tr class='line'><td style='font-size: 12px;'>" + log.get("IDCliente") + "</td>";
                bodyMessage = String.valueOf(bodyMessage) + "<td colspan='8' style='font-size: 12px;'>" + StringEscapeUtils.escapeHtml((String)String.valueOf(log.get("Acao"))) + "</td>";
                bodyMessage = String.valueOf(bodyMessage) + "<td colspan='6' style='font-size: 12px;'>" + formatter.format(log.get("DataLog")) + "</td>";
                bodyMessage = String.valueOf(bodyMessage) + "</tr>";
            }
            bodyMessage = String.valueOf(bodyMessage) + "</table></body>";
            return String.valueOf(headStyleMessage) + bodyMessage + "</html>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getErrorMessage(String mensagemErro, Date dataErro) {
        try {
            String headStyleMessage = this.getMessage();
            String bodyMessage = "<body><br/><br/><br/><table cellpadding='8'><tr class='title'><td colspan='8'><img src='http://rotinas.viareal.int/images/viareal_logo.png' width='160px'/></td><td><p>Erro de Execu&ccedil;&atilde;o Envio de Notas Fiscais/Faturas</p></td></tr><tr class='header'><td>Data</td><td colspan='8'>Erro</td></tr>";
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            bodyMessage = String.valueOf(bodyMessage) + "<tr class='line'>";
            bodyMessage = String.valueOf(bodyMessage) + "<td colspan='8' style='font-size: 12px;'>" + formatter.format(dataErro) + "</td>";
            bodyMessage = String.valueOf(bodyMessage) + "<td style='font-size: 12px;'>" + StringEscapeUtils.escapeHtml((String)mensagemErro) + "</td>";
            bodyMessage = String.valueOf(bodyMessage) + "</tr>";
            bodyMessage = String.valueOf(bodyMessage) + "</table></body>";
            return String.valueOf(headStyleMessage) + bodyMessage + "</html>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendRelatorioLog(List<Map<String, Object>> listLog, Boolean envioFatura) throws Exception {
        String msg = this.getMessageByListLog(listLog, envioFatura);
        String emailGestorFinanceiro = comercialDao.getConfiguracaoComercialByChave("EMAIL_GESTOR_FINANCEIRO");
        String d = "desenvolvimento@adaptersolucoes.com;" + emailGestorFinanceiro;
        String[] destinos = d.split(";");
        if (msg != null) {
            this.sendRelatorio(msg, destinos);
        }
    }

    public void sendRelatorioDeErro(String mensagemErro) {
        String msg = this.getErrorMessage(mensagemErro, new Date());
        if (msg != null) {
            this.sendRelatorio(msg, this.config.getDestinatarioEmailsErros().split(";"));
        }
    }

    public void sendRelatorio(String mensagem, String[] destinatarios) {
        EmailMessage message = new EmailMessage.Builder(this.config.getRemetenteAdapter()).to(new String[]{"priscilla.serpa@adaptersolucoes.com"}).subject("[Adapter] Relat\u00f3rio Execu\u00e7\u00e3o Envio Notas Fiscais/Faturas").content(mensagem).attachments(new String[0]).build();
        this.emailService.send(message);
    }
}

