/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.envio;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import rotinas.adapter.config.Configuracoes;
import rotinas.adapter.config.LoggerConfiguration;
import rotinas.adapter.envio.ComercialDao;
import rotinas.adapter.envio.DadosClienteFatura;
import rotinas.adapter.envio.EmailFaturaService;
import rotinas.adapter.envio.EnviarFaturaRunnable;
import rotinas.adapter.envio.EnvioService;
import rotinas.adapter.envio.FinanceiroDao;
import rotinas.adapter.envio.ImprimirFaturaRunnable;
import rotinas.adapter.envio.ImprimirFaturaService;
import rotinas.adapter.envio.ImprimirNotaService;
import rotinas.adapter.envio.TerceirosDao;
import rotinas.adapter.exception.ErrorException;
import rotinas.adapter.financeiro.Fatura;
import rotinas.adapter.financeiro.Nota;

public class EnviarFaturasENotasFiscais {
    public static final LoggerConfiguration log = LoggerConfiguration.getInstance();
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", 2);

    public boolean getPermiteDemostrativoDebito(FinanceiroDao financeiroDao) {
        String valor = financeiroDao.findValorConfiguracoesByChave("IMPRIME_DEMONSTRATIVO_DEBITO_AUTOMATICO");
        return valor != null && valor.equalsIgnoreCase("1");
    }

    public void enviar(int dias, Long idModeloEnvioFatura, Long idModeloEnvioNF, int enviaFatura, int enviaNota, int semLog) {
        try {
            FinanceiroDao financeiroDao = new FinanceiroDao();
            ComercialDao comercialDao = new ComercialDao();
            TerceirosDao terceirosDao = new TerceirosDao();
            EnvioService envioService = new EnvioService();
            boolean permiteDemostrativoDebito = this.getPermiteDemostrativoDebito(financeiroDao);
            Configuracoes configuracoes = Configuracoes.getInstance();
            String idsFormasCobrancaFaturasString = configuracoes.getIdsFormasCobrancaFaturas();
            Integer numeroThreads = configuracoes.getNumeroThreads() == null || configuracoes.getNumeroThreads().isEmpty() ? 16 : new Integer(configuracoes.getNumeroThreads());
            List<Long> idsFormasCobrancaFaturasStringList = Pattern.compile(";").splitAsStream(idsFormasCobrancaFaturasString).map(Long::valueOf).collect(Collectors.toList());
            String modeloUnificado = this.getNomeArquivoModeloNotaUnificado(financeiroDao);
            if (enviaFatura == 1) {
                EnviarFaturasENotasFiscais.log.logger.info("Iniciando busca de faturas a vencer");
                List<BigInteger> idsFaturas = semLog == 1 ? financeiroDao.findFaturasAVencerSemLog(dias, idsFormasCobrancaFaturasStringList, permiteDemostrativoDebito) : financeiroDao.findFaturasAVencer(dias, idsFormasCobrancaFaturasStringList, permiteDemostrativoDebito);
                EnviarFaturasENotasFiscais.log.logger.info("Fim da busca de faturas a vencer - Qtde: " + (idsFaturas != null ? idsFaturas.size() : 0));
                if (idsFaturas != null && idsFaturas.size() > 0) {
                    Long idMaxLogEnvioFatura = financeiroDao.findUltimoIDLogEnvioFatura();
                    EnviarFaturasENotasFiscais.log.logger.info("Iniciando envio de faturas");
                    this.enviarFatura(idsFaturas, modeloUnificado, financeiroDao, comercialDao, terceirosDao, idModeloEnvioFatura, numeroThreads);
                    EnviarFaturasENotasFiscais.log.logger.info("Fim do envio de faturas");
                    List<Object> listaLogEnvioFatura = new ArrayList();
                    listaLogEnvioFatura = idMaxLogEnvioFatura != null ? financeiroDao.findLog(idMaxLogEnvioFatura, true) : financeiroDao.findLog(new Long(0L), true);
                    if (!listaLogEnvioFatura.isEmpty()) {
                        envioService.sendRelatorioLog(listaLogEnvioFatura, true);
                    }
                }
            }
            if (modeloUnificado == null && enviaNota == 1) {
                EnviarFaturasENotasFiscais.log.logger.info("Iniciando busca de notas fiscais a enviar");
                ArrayList<Long> idsEmpresas = new ArrayList<Long>();
                String[] stringArray = configuracoes.getIdEmpresaNota().split(";");
                int n = stringArray.length;
                int listaLogEnvioFatura = 0;
                while (listaLogEnvioFatura < n) {
                    String id = stringArray[listaLogEnvioFatura];
                    idsEmpresas.add(new Long(id));
                    ++listaLogEnvioFatura;
                }
                List<Nota> notas = financeiroDao.findNotasAEnviar(idsEmpresas, dias);
                EnviarFaturasENotasFiscais.log.logger.info("Fim da busca de notas fiscais a enviar - Qtde: " + (notas != null ? notas.size() : 0));
                if (notas != null && notas.size() > 0) {
                    Long idMaxLogEnvioNotaFiscal = financeiroDao.findUltimoIDLogEnvioNotaFiscal();
                    EnviarFaturasENotasFiscais.log.logger.info("Iniciando envio de notas fiscais");
                    ImprimirNotaService imprimirNotaService = new ImprimirNotaService();
                    imprimirNotaService.enviarNF(notas, financeiroDao, comercialDao, terceirosDao, idModeloEnvioNF);
                    EnviarFaturasENotasFiscais.log.logger.info("Fim do envio de notas fiscais");
                    List<Object> listaLogEnvioNotaFiscal = new ArrayList();
                    listaLogEnvioNotaFiscal = idMaxLogEnvioNotaFiscal != null ? financeiroDao.findLog(idMaxLogEnvioNotaFiscal, false) : financeiroDao.findLog(new Long(0L), false);
                    if (!listaLogEnvioNotaFiscal.isEmpty()) {
                        envioService.sendRelatorioLog(listaLogEnvioNotaFiscal, false);
                    }
                }
            }
        }
        catch (ErrorException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ErrorException("Ocorreu erro ao tentar enviar faturas e notas fiscais", e);
        }
    }

    public void enviarFatura(List<BigInteger> idsFaturas, String nomeArquivoModeloUnificado, FinanceiroDao financeiroDao, ComercialDao comercialDao, TerceirosDao terceirosDao, Long idModeloMsg, Integer numeroThreads) throws InterruptedException {
        EmailFaturaService emailFaturaService = new EmailFaturaService();
        ImprimirFaturaService imprimirFaturaService = new ImprimirFaturaService();
        Long idUsuario = imprimirFaturaService.getIDUsuarioLog(financeiroDao);
        Map<String, Object> modeloEmail = comercialDao.findMensagemEmail(idModeloMsg);
        String remetente = imprimirFaturaService.getEmailRemetente(financeiroDao);
        String pathLayoutFatura = imprimirFaturaService.getPathLayoutFatura(financeiroDao);
        String pathLayoutNota = imprimirFaturaService.getPathModeloNota(financeiroDao);
        String svaIncluso = imprimirFaturaService.getIsSVAIncluso(financeiroDao);
        Boolean isSVAIncluso = svaIncluso != null && svaIncluso.equals("1");
        ExecutorService executorServiceImprimirFatura = Executors.newFixedThreadPool(numeroThreads);
        if (modeloEmail.get("EnviaBoleto") != null && modeloEmail.get("EnviaBoleto").toString().equals("1")) {
            List<DadosClienteFatura> dadosClienteFaturaList = Collections.synchronizedList(new ArrayList());
            AtomicBoolean finalizouImpressaoFaturas = new AtomicBoolean();
            finalizouImpressaoFaturas.set(false);
            EnviarFaturasENotasFiscais.log.logger.info("@ Thread do envio de faturas iniciada");
            ExecutorService executorServiceEnviarFatura = Executors.newSingleThreadExecutor();
            executorServiceEnviarFatura.execute(new EnviarFaturaRunnable(dadosClienteFaturaList, idUsuario, idModeloMsg, modeloEmail, remetente, finalizouImpressaoFaturas, emailFaturaService, comercialDao, financeiroDao));
            EnviarFaturasENotasFiscais.log.logger.info("* Thread da impress\u00e3o de faturas iniciada");
            for (BigInteger id : idsFaturas) {
                try {
                    Fatura fat = financeiroDao.findFaturaByID(id.longValue());
                    ImprimirFaturaService imprimirFaturaServiceRunnable = new ImprimirFaturaService();
                    executorServiceImprimirFatura.execute(new ImprimirFaturaRunnable(fat, nomeArquivoModeloUnificado, isSVAIncluso, pathLayoutFatura, pathLayoutNota, dadosClienteFaturaList, financeiroDao, comercialDao, terceirosDao, imprimirFaturaServiceRunnable));
                }
                catch (Exception e) {
                    EnviarFaturasENotasFiscais.log.logger.log(Level.SEVERE, String.format("Falha na impress\u00e3o da fatura: %s", e.toString()), e);
                }
            }
            executorServiceImprimirFatura.shutdown();
            executorServiceImprimirFatura.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            EnviarFaturasENotasFiscais.log.logger.info("* Thread da impress\u00e3o de faturas finalizada");
            finalizouImpressaoFaturas.set(true);
            executorServiceEnviarFatura.shutdown();
            executorServiceEnviarFatura.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            EnviarFaturasENotasFiscais.log.logger.info("@ Thread do envio de faturas finalizada");
        } else {
            for (BigInteger id : idsFaturas) {
                try {
                    Fatura fat = financeiroDao.findFaturaByID(id.longValue());
                    if (fat.getFormaCobranca().getDebitoAutomatico() != null && fat.getFormaCobranca().getDebitoAutomatico().booleanValue()) continue;
                    int cont = 0;
                    String linhaDigitavel = imprimirFaturaService.geraLinhaDigitavel(fat, comercialDao, terceirosDao, financeiroDao);
                    if (linhaDigitavel == null) continue;
                    emailFaturaService.enviar(fat, imprimirFaturaService.getClienteDto(), null, idUsuario, idModeloMsg, modeloEmail, remetente, linhaDigitavel, financeiroDao, comercialDao, pattern);
                    if (++cont != 20) continue;
                    cont = 0;
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getNomeArquivoModeloNotaUnificado(FinanceiroDao financeiroDao) {
        return financeiroDao.findValorConfiguracoesByChave("MODELO_UNIFICADO_FATURA_NOTA");
    }
}

