/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.dao;

import adapter.exceptions.AdapterErrorException;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import rotinas.adapter.config.AdapterFinanceiroDatabase;

public class FinanceiroDao {
    public List<Map<String, Object>> findNotasCanceladasIntegracao(String tipoIntegracao, String idsNotas) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT DISTINCT nt.IDNota, fm.IDDocumentoSap ");
            sql.append(" FROM TB_Nota nt ");
            sql.append(" INNER JOIN TB_ItemNota itn ON nt.IDNota = itn.IDNota ");
            sql.append(" INNER JOIN TB_FaturamentoMes fm ON itn.IDItemNota = fm.IDItemNota ");
            sql.append(" WHERE nt.IsCancelamentoIntegradoSAP IN ('E', 'N') ");
            sql.append(" AND nt.DataCancelamento IS NOT NULL AND nt.IDUsuarioCancelamento IS NOT NULL ");
            sql.append(" AND nt.IsIntegrado = 'S' AND fm.IsIntegrado = 'S' AND fm.IsCancelado = 1 ");
            if (tipoIntegracao.equals("0")) {
                sql.append(" AND nt.IsCancelamentoIntegradoSAP IN ('E', 'N') ");
            } else if (tipoIntegracao.equals("1")) {
                sql.append(" AND nt.IsCancelamentoIntegradoSAP = 'N' ");
            } else if (tipoIntegracao.equals("2")) {
                sql.append(" AND nt.IsCancelamentoIntegradoSAP = 'E' ");
            } else if (tipoIntegracao.equals("3")) {
                sql.append(" AND nt.IDNota IN (" + idsNotas + ") ");
            } else {
                sql.append(" AND nt.IsCancelamentoIntegradoSAP = 'N' ");
            }
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateNotasStatusIntegracao(Long IDNota, String IsCancelamentoIntegradoSAP) {
        try {
            String sql = "UPDATE TB_Nota nt SET nt.IsCancelamentoIntegradoSAP = :IsCancelamentoIntegradoSAP WHERE nt.IDNota = :IDNota";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("IDNota", (Object)IDNota);
            q.setParameter("IsCancelamentoIntegradoSAP", (Object)IsCancelamentoIntegradoSAP);
            session.beginTransaction();
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdapterErrorException("Erro ao atualizar o Status do da Integracao de Nota cancelada com o SAP.", e);
        }
    }

    public void insereLogIntegracaoNota(String acao, String tipoAcao, Long IDNota, Long idUsuario) {
        try {
            String sql = "INSERT INTO TB_LogIntegracaoNota (Acao, TipoAcao, DataLog, IDNota, IDUsuario) VALUES (?, ?, NOW(), ?, ?)";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            session.beginTransaction();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)acao);
            q.setParameter(1, (Object)tipoAcao);
            q.setParameter(2, (Object)IDNota);
            q.setParameter(3, (Object)idUsuario);
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            throw new AdapterErrorException("Erro ao registrar o Log de integracao de Nota com o SAP", e);
        }
    }

    public String getConfiguracaoByChave(String chave) throws Exception {
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        String sql = "SELECT ValorConfiguracao FROM TB_Configuracoes WHERE ChaveConfiguracao = :chave";
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameter("chave", (Object)chave);
        String resultado = (String)q.uniqueResult();
        session.close();
        return resultado;
    }
}

