/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.dao;

import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import rotinas.adapter.config.AdapterComercialDatabase;
import rotinas.adapter.config.Configuracoes;

public class ComercialDao {
    public String getConfiguracaoComercialByChave(String chave) throws Exception {
        Session session = AdapterComercialDatabase.getSessionFactory().openSession();
        String sql = "SELECT ValorConfiguracao FROM TB_Configuracoes WHERE ChaveConfiguracao = :chave";
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameter("chave", (Object)chave);
        String resultado = (String)q.uniqueResult();
        session.close();
        return resultado;
    }

    public List<Map<String, Object>> findCentroCustosByContrato(Long idContrato) {
        Configuracoes conf = Configuracoes.getInstance();
        String bdTerceiros = conf.getBdTerceiros();
        try {
            String sql = " SELECT ecli.TipoEndereco, cid.CostingCodeSap  FROM TB_Contrato c  JOIN TB_EnderecoContrato ec ON ec.IDContrato = c.IDContrato  JOIN TB_EnderecoCliente ecli ON ec.IDEnderecoCliente = ecli.IDEnderecoCliente  JOIN " + bdTerceiros + ".TB_Endereco e ON ecli.IDEndereco = e.IDEndereco " + " JOIN " + bdTerceiros + ".TB_Bairro b ON e.IDBairro = b.IDBairro " + " JOIN " + bdTerceiros + ".TB_Cidade cid ON b.IDCidade = cid.IDCidade " + " WHERE c.idContrato = :idContrato " + " GROUP BY ecli.TipoEndereco";
            Session session = AdapterComercialDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("idContrato", (Object)idContrato);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

