/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter;

import adapter.exceptions.AdapterErrorException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import rotinas.adapter.SapServiceRunnable;
import rotinas.adapter.config.AdapterFinanceiroDatabase;
import rotinas.adapter.config.Configuracoes;
import rotinas.adapter.dao.AdapterDao;
import rotinas.adapter.dao.ComercialDao;
import rotinas.adapter.dao.FinanceiroDao;
import rotinas.adapter.email.EnvioEmailService;

public class IntegracaoSapCancelamentosNFsMain {
    public static final Logger LOGGER = Logger.getLogger(IntegracaoSapCancelamentosNFsMain.class.getName());
    public static StringWriter sw = new StringWriter();
    public static PrintWriter pw = new PrintWriter(sw);
    private static EnvioEmailService envioEmailService = new EnvioEmailService();

    public static void main(String[] args) throws Exception {
        LocalDateTime inicio = LocalDateTime.now();
        LOGGER.info("In\u00edcio do envio do faturamento para o SAP");
        try {
            try {
                if (args.length <= 0) {
                    throw new AdapterErrorException("O par\u00e2metro que define quais notas canceladas devem ser integradas n\u00e3o foi informado\n0 = Integra todas as Notas Canceladas\n1 = Integra apenas as Notas Canceladas nao Integradas\n2 = Integra apenas Notas Canceladas com Erro\n3 = Integra IDs Notas Canceladas informados.");
                }
                String tipoIntegracao = args[0];
                String idsNotas = "";
                if (tipoIntegracao.equals("3")) {
                    if (args.length < 2) {
                        throw new AdapterErrorException("O IDNotas n\u00e3o foi informado.");
                    }
                    int i = 1;
                    while (i < args.length) {
                        idsNotas = String.valueOf(idsNotas) + args[i] + ",";
                        ++i;
                    }
                    idsNotas = idsNotas.substring(0, idsNotas.length() - 1);
                }
                System.out.println("===================== INICIO ======================");
                AdapterDao adapterDao = new AdapterDao();
                FinanceiroDao financeiroDao = new FinanceiroDao();
                String integraSap = financeiroDao.getConfiguracaoByChave("INTEGRA_CANCELAMENTO_NOTA_SAP");
                if (integraSap == null || integraSap.equals("0")) {
                    throw new AdapterErrorException("A Integra\u00e7\u00e3o com o SAP est\u00e1 desativada.");
                }
                ComercialDao comercialDao = new ComercialDao();
                Configuracoes conf = Configuracoes.getInstance();
                ExecutorService executor = Executors.newFixedThreadPool(Integer.valueOf(conf.getNumeroThreads()));
                Map<String, Object> servidorIntegracao = adapterDao.getServidorIntegracaoSap();
                if (!servidorIntegracao.containsKey("URL") || !servidorIntegracao.containsKey("Porta")) {
                    throw new AdapterErrorException("Dados do servidor de integra\u00e7\u00e3o n\u00e3o encontrados.");
                }
                Long idUsuarioTarefasAutomaticas = Long.parseLong(comercialDao.getConfiguracaoComercialByChave("ID_USUARIO_TAREFAS_AUTOMATICAS"));
                String url = String.valueOf(servidorIntegracao.get("URL").toString()) + ":" + servidorIntegracao.get("Porta");
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpParams httpParams = httpClient.getParams();
                int tempoLimite = Integer.parseInt(adapterDao.getConfiguracaoByChave("TEMPO_LIMITE_REQUISICAO_INTEGRACAO"));
                if (tempoLimite > 0) {
                    HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)(tempoLimite * 1000));
                    HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)(tempoLimite * 1000));
                }
                String metodoLogin = String.valueOf(url) + "/api/Login/Login";
                HttpPost httpPost = new HttpPost(metodoLogin);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = httpResponse.getEntity();
                List<Map<String, Object>> listaNotas = financeiroDao.findNotasCanceladasIntegracao(tipoIntegracao, idsNotas);
                System.out.println("Quantidade de Notas Canceladas a serem integradas: " + listaNotas.size());
                Map<String, String> notasIntegrados = Collections.synchronizedMap(new HashMap());
                Map<String, String> notasErro = Collections.synchronizedMap(new HashMap());
                for (Map<String, Object> nota : listaNotas) {
                    executor.execute(new SapServiceRunnable(nota, url, notasIntegrados, notasErro, financeiroDao, servidorIntegracao, idUsuarioTarefasAutomaticas));
                }
                executor.shutdown();
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                System.out.println("===================== FIM ======================");
                if (notasIntegrados.size() > 0) {
                    envioEmailService.sendRelatorioLogSucesso(notasIntegrados);
                }
                if (notasErro.size() > 0) {
                    envioEmailService.sendRelatorioLogErro(notasErro);
                }
                LocalDateTime fim = LocalDateTime.now();
                Duration duration = Duration.between(inicio, fim);
                long tempoResposta = Math.abs(duration.getSeconds());
                LOGGER.info("============================================> TEMPO TOTAL = " + (double)tempoResposta / 60.0 + " min");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.info("ERRO = " + e.getMessage());
                envioEmailService.sendRelatorioDeErro(e.getMessage() != null ? e.getMessage() : e.getCause().toString());
                AdapterFinanceiroDatabase.shutdown();
                System.exit(0);
            }
        }
        finally {
            AdapterFinanceiroDatabase.shutdown();
            System.exit(0);
        }
    }
}

