/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.dao;

import adapter.exceptions.AdapterErrorException;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import rotinas.adapter.config.AdapterFinanceiroDatabase;

public class FinanceiroDao {
    public List<Map<String, Object>> pegaNotasGambs(String limit) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT DISTINCT IDDocumentoSAP as IDDocumentoSap ");
            sql.append(" FROM TB_AjusteDocumentoSAP ");
            if (limit != null) {
                sql.append(" LIMIT " + limit);
            }
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void insereLogIntegracaoNota(String acao, String tipoAcao, Long IDNota, Long idUsuario) {
        try {
            String sql = "INSERT INTO TB_LogIntegracaoNota (Acao, TipoAcao, DataLog, IDNota, IDUsuario) VALUES (?, ?, NOW(), ?, ?)";
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            session.beginTransaction();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)acao);
            q.setParameter(1, (Object)tipoAcao);
            q.setParameter(2, (Object)IDNota);
            q.setParameter(3, (Object)idUsuario);
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            throw new AdapterErrorException("Erro ao registrar o Log de integracao de Nota com o SAP", e);
        }
    }

    public String getConfiguracaoByChave(String chave) throws Exception {
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        String sql = "SELECT ValorConfiguracao FROM TB_Configuracoes WHERE ChaveConfiguracao = :chave";
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameter("chave", (Object)chave);
        String resultado = (String)q.uniqueResult();
        session.close();
        return resultado;
    }
}

