/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter;

import adapter.criptografia.CriptografiaAES;
import adapter.exceptions.AdapterWarnException;
import com.google.gson.Gson;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import rotinas.adapter.IntegracaoSapCancelamentosNFsMain;
import rotinas.adapter.dao.FinanceiroDao;

public class SapServiceRunnable
implements Runnable {
    private String url;
    private String prettyJson = "";
    private boolean isRespostaErroSap;
    private String acao = "";
    private String tipoAcao = "CANCELAMENTO";
    private FinanceiroDao financeiroDao;
    private Long idUsuarioTarefasAutomaticas;
    private long tempoResposta;
    private Map<String, Object> nota;
    private Map<String, String> notasIntegrados;
    private Map<String, String> notasErro;
    private Map<String, Object> servidorIntegracao;
    private String respostaSAP = "";
    private String dataSAP = "";

    public SapServiceRunnable(Map<String, Object> nota, String url, Map<String, String> notasIntegrados, Map<String, String> notasErro, FinanceiroDao financeiroDao, Map<String, Object> servidorIntegracao, Long idUsuarioTarefasAutomaticas) {
        this.nota = nota;
        this.url = url;
        this.notasIntegrados = notasIntegrados;
        this.notasErro = notasErro;
        this.financeiroDao = financeiroDao;
        this.servidorIntegracao = servidorIntegracao;
        this.idUsuarioTarefasAutomaticas = idUsuarioTarefasAutomaticas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            String url = String.format("%s:%s/api/Invoice/CancelarNotaSaida?docEntry=%s", this.servidorIntegracao.get("URL"), this.servidorIntegracao.get("Porta"), this.nota.get("IDDocumentoSap"));
            HttpGet httpGet = new HttpGet(url);
            this.defineAuthorization(this.servidorIntegracao, httpGet);
            LocalDateTime antesReq = LocalDateTime.now();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            LocalDateTime depoisReq = LocalDateTime.now();
            Duration duration = Duration.between(antesReq, depoisReq);
            this.tempoResposta = Math.abs(duration.getSeconds());
            if (entity == null) {
                throw new AdapterWarnException("Erro ao cancelar Nota no SAP.\nResposta da requisicao ao SAP e nula");
            }
            String response = EntityUtils.toString((HttpEntity)entity);
            JSONObject resposta = new JSONObject(response);
            httpClient.getConnectionManager().shutdown();
            this.respostaSAP = "";
            this.respostaSAP = resposta.has("message") ? resposta.get("message").toString() : (resposta.has("Message") ? resposta.get("Message").toString() : "N\u00e3o identificada");
            this.dataSAP = "";
            this.dataSAP = resposta.has("data") ? resposta.get("data").toString() : (resposta.has("Data") ? resposta.get("Data").toString() : "Nao identificada");
            IntegracaoSapCancelamentosNFsMain.LOGGER.info("URL = " + url);
            IntegracaoSapCancelamentosNFsMain.LOGGER.info("RESPOSTA = " + this.respostaSAP + "\n Data = " + this.dataSAP + "\n\tTEMPO = " + this.tempoResposta);
            Gson gson = new Gson();
            if (resposta.has("status") && resposta.get("status").equals("0")) {
                this.acao = String.valueOf(this.acao) + "DADOS DE NOTA CANCELADAS ENVIADAS AO SAP\n";
                this.acao = String.valueOf(this.acao) + "\t# DOCENTRY: " + this.nota.get("IDDocumentoSap") + "\n";
                this.acao = String.valueOf(this.acao) + "\t# URL: " + url + "\n";
                this.acao = String.valueOf(this.acao) + "\t# Resposta: " + this.respostaSAP + "\n";
                this.acao = String.valueOf(this.acao) + "\t# Data: " + this.dataSAP + "\n";
                this.acao = String.valueOf(this.acao) + "\t# Tempo de resposta: " + this.tempoResposta + " segundos" + "\n";
                this.acao = String.valueOf(this.acao) + "\t# Dados enviados:\n" + this.prettyJson + "\n\n";
                this.acao = String.valueOf(this.acao) + "\t# Dados recebidos:\n " + gson.toJson((Object)resposta);
                this.financeiroDao.insereLogIntegracaoNota(this.acao, this.tipoAcao, 1L, this.idUsuarioTarefasAutomaticas);
                return;
            }
            if (this.respostaSAP.toLowerCase().contains("document is already cancelled")) {
                this.acao = String.valueOf(this.acao) + "DADOS DE NOTA CANCELADAS ENVIADAS AO SAP\n";
                this.acao = String.valueOf(this.acao) + "\t# DOCENTRY: " + this.nota.get("IDDocumentoSap") + "\n";
                this.acao = String.valueOf(this.acao) + "\t# URL: " + url + "\n";
                this.acao = String.valueOf(this.acao) + "\t# Resposta: " + this.respostaSAP + "\n";
                this.acao = String.valueOf(this.acao) + "\t# Data: " + this.dataSAP + "\n";
                this.acao = String.valueOf(this.acao) + "\t# Tempo de resposta: " + this.tempoResposta + " segundos" + "\n";
                this.acao = String.valueOf(this.acao) + "\t# Dados enviados:\n" + this.prettyJson + "\n\n";
                this.acao = String.valueOf(this.acao) + "\t# Dados recebidos:\n " + gson.toJson((Object)resposta);
                this.financeiroDao.insereLogIntegracaoNota(this.acao, this.tipoAcao, 1L, this.idUsuarioTarefasAutomaticas);
                return;
            }
            this.isRespostaErroSap = true;
            throw new AdapterWarnException(this.respostaSAP);
        }
        catch (Exception e) {
            e.printStackTrace();
            IntegracaoSapCancelamentosNFsMain.LOGGER.info("ERRO = " + e.getMessage());
            String origemErro = this.isRespostaErroSap ? "Resposta obtida do SAP" : "Erro";
            String descricaoErro = "";
            if (e.getMessage() == null && e.getMessage().equals("Read timed out")) {
                descricaoErro = "Timeout - Excedeu o limite de tempo determinado para uma requisi\u00e7\u00e3o";
            } else if (e.getCause() != null) {
                descricaoErro = e.getCause().toString();
            } else if (e.getMessage() != null) {
                descricaoErro = e.getMessage();
            }
            String erro = "Erro ao integrar os dados das Notas Canceladas ao SAP\n";
            erro = String.valueOf(erro) + "\t# DOCENTRY: " + this.nota.get("IDDocumentoSap") + "\n";
            erro = String.valueOf(erro) + "# Disparado por: Rotina-IntegracaoSapCancelamentosNFs\n";
            erro = String.valueOf(erro) + "# URL:" + this.url + "\n";
            erro = String.valueOf(erro) + "# " + origemErro + ": " + descricaoErro + "\n";
            erro = String.valueOf(erro) + "# Tempo de resposta: " + this.tempoResposta + " segundos\n";
            if (!this.prettyJson.isEmpty()) {
                erro = String.valueOf(erro) + "# Dados enviados:\n" + this.prettyJson;
            }
            erro = String.valueOf(erro) + "\t# Resposta: " + this.respostaSAP + "\n";
            erro = String.valueOf(erro) + "\t# Data: " + this.dataSAP + "\n";
            this.financeiroDao.insereLogIntegracaoNota(erro, this.tipoAcao, 1L, this.idUsuarioTarefasAutomaticas);
        }
    }

    private void defineAuthorization(Map<String, Object> servidorIntegracaoDto, Object http) {
        if (servidorIntegracaoDto.get("Login") != null && servidorIntegracaoDto.get("Senha") != null) {
            String AUTHORIZATION = "Authorization";
            String auth = "Basic " + Base64.getEncoder().encodeToString((String.valueOf(servidorIntegracaoDto.get("Login").toString()) + ":" + CriptografiaAES.descriptografar((byte[])((byte[])servidorIntegracaoDto.get("Senha")))).getBytes());
            if (http instanceof HttpGet) {
                ((HttpGet)http).setHeader("Authorization", auth);
            }
            if (http instanceof HttpPost) {
                ((HttpPost)http).setHeader("Authorization", auth);
            }
            if (http instanceof HttpPut) {
                ((HttpPut)http).setHeader("Authorization", auth);
            }
            if (http instanceof HttpDelete) {
                ((HttpDelete)http).setHeader("Authorization", auth);
            }
        }
    }
}

