/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.email;

import adapter.email.EmailMessage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import rotinas.adapter.config.Configuracoes;
import rotinas.adapter.dao.AdapterDao;
import rotinas.adapter.email.EmailService;

public class EnvioEmailService {
    private EmailService emailService = new EmailService();
    Configuracoes config = Configuracoes.getInstance();
    private AdapterDao adapterDao = new AdapterDao();

    private String getMessage() {
        String headMessage = "<html><head>";
        String styleMessage = "<style type='text/css'>.line:hover {background-color: #E0FFFF;} tr td {font-family: arial; vertical-align: center; text-align: center; border:1px solid #598080; text-decoration: none; overflow: hidden;}table {width:100%; border-collapse: collapse; border-spacing: 0; border:1px #598080; border-bottom-style:solid;}.title {font-family: arial; font-size: 31px; font-weight: bold; border:1px solid #598080; background-color: #598080}.header {font-weight: bold; font-size: 10px; border:1px solid #598080; background-color: #95CECE}</style></head>";
        return String.valueOf(headMessage) + styleMessage;
    }

    private String getMensagemFaturasIntegrados(Map<String, String> faturasIntegradas) {
        try {
            String headStyleMessage = this.getMessage();
            String bodyMessage = "<body><br/>";
            bodyMessage = String.valueOf(bodyMessage) + "Total de blocos de Pagamentos = " + faturasIntegradas.size();
            bodyMessage = String.valueOf(bodyMessage) + "<br/><br/><table cellpadding='8'><tr class='title'><td><img src='http://rotinas.viareal.int/images/viareal_logo.png' width='160px'/></td><td colspan='14'><p>Rela&ccedil;&atilde;o da Intre\u00e7\u00e3o de Pagamentos integrados ao SAP</p></td></tr><tr class='header'><td>Faturas</td><td colspan='14'>Nota gerada</td></tr>";
            for (String idFatura : faturasIntegradas.keySet()) {
                bodyMessage = String.valueOf(bodyMessage) + "<tr class='line'><td style='font-size: 10px;'>" + idFatura + "</td>";
                bodyMessage = String.valueOf(bodyMessage) + "<td colspan='14' style='font-size: 10px;'>" + faturasIntegradas.get(idFatura) + "</td>";
                bodyMessage = String.valueOf(bodyMessage) + "</tr>";
            }
            bodyMessage = String.valueOf(bodyMessage) + "</table></body>";
            return String.valueOf(headStyleMessage) + bodyMessage + "</html>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getMensagemFaturasErro(Map<String, String> faturasErro) {
        try {
            String headStyleMessage = this.getMessage();
            String bodyMessage = "<body><br/>";
            bodyMessage = String.valueOf(bodyMessage) + "Total de blocos de Faturas com erro = " + faturasErro.size();
            bodyMessage = String.valueOf(bodyMessage) + "<br/><br/><table cellpadding='8'><tr class='title'><td><img src='http://rotinas.viareal.int/images/viareal_logo.png' width='160px'/></td><td colspan='14'><p>Rela&ccedil;&atilde;o dos Pagamentos com erro na integra&ccedil;&atilde;o com o SAP</p></td></tr><tr class='header'><td>Faturas</td><td colspan='14'>Resposta</td></tr>";
            for (String idFatura : faturasErro.keySet()) {
                bodyMessage = String.valueOf(bodyMessage) + "<tr class='line'><td style='font-size: 10px;'>" + idFatura.toString() + "</td>";
                bodyMessage = String.valueOf(bodyMessage) + "<td colspan='14' style='font-size: 10px;'>" + faturasErro.get(idFatura) + "</td>";
                bodyMessage = String.valueOf(bodyMessage) + "</tr>";
            }
            bodyMessage = String.valueOf(bodyMessage) + "</table></body>";
            return String.valueOf(headStyleMessage) + bodyMessage + "</html>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getErrorMessage(String mensagemErro, Date dataErro) {
        try {
            String headStyleMessage = this.getMessage();
            String bodyMessage = "<body><br/><br/><br/><table cellpadding='8'><tr class='title'><td colspan='8'><img src='http://rotinas.viareal.int/images/viareal_logo.png' width='160px'/></td><td><p>Erro de Execu&ccedil;&atilde;o Integra&ccedil;&atilde;o com o SAP - Pagamentos</p></td></tr><tr class='header'><td>Data</td><td colspan='8'>Erro</td></tr>";
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            bodyMessage = String.valueOf(bodyMessage) + "<tr class='line'>";
            bodyMessage = String.valueOf(bodyMessage) + "<td colspan='8' style='font-size: 12px;'>" + formatter.format(dataErro) + "</td>";
            bodyMessage = String.valueOf(bodyMessage) + "<td style='font-size: 12px;'>" + StringEscapeUtils.escapeHtml((String)mensagemErro) + "</td>";
            bodyMessage = String.valueOf(bodyMessage) + "</tr>";
            bodyMessage = String.valueOf(bodyMessage) + "</table></body>";
            return String.valueOf(headStyleMessage) + bodyMessage + "</html>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendRelatorioLogSucesso(Map<String, String> faturasIntegradas) throws Exception {
        String msg = this.getMensagemFaturasIntegrados(faturasIntegradas);
        String emails = this.adapterDao.getConfiguracaoByChave("EMAILS_INTEGRACAO");
        String[] destinos = emails.split(";");
        if (msg != null) {
            String assunto = "[Adapter-SAP] Relatorio de envio de Pagamentos ao SAP";
            this.sendRelatorio(assunto, msg, destinos);
        }
    }

    public void sendRelatorioLogErro(Map<String, String> faturaErro) throws Exception {
        String msg = this.getMensagemFaturasErro(faturaErro);
        String emails = this.adapterDao.getConfiguracaoByChave("EMAILS_INTEGRACAO");
        String[] destinos = emails.split(";");
        if (msg != null) {
            String assunto = "[Adapter-SAP] ERRO no envio de Pagamentos ao SAP";
            this.sendRelatorio(assunto, msg, destinos);
        }
    }

    public void sendRelatorioDeErro(String mensagemErro) throws Exception {
        String msg = this.getErrorMessage(mensagemErro, new Date());
        if (msg != null) {
            String assunto = "[Adapter-SAP] ERRO no envio de Pagamento ao SAP";
            this.sendRelatorio(assunto, msg, this.adapterDao.getConfiguracaoByChave("EMAILS_INTEGRACAO").split(";"));
        }
    }

    public void sendRelatorio(String assunto, String mensagem, String[] destinatarios) {
        EmailMessage message = new EmailMessage.Builder(this.config.getRemetenteAdapter()).to(destinatarios).subject(assunto).content(mensagem).attachments(new String[0]).build();
        this.emailService.send(message);
    }
}

