/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.email;

import adapter.email.EmailMessage;
import adapter.exceptions.AdapterErrorException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import rotinas.adapter.config.Configuracoes;

public class EmailService {
    private Session mailSession;
    private final String PROTOCOL = "smtp";

    public EmailService() {
        Properties props = new Properties();
        final Configuracoes configuracoes = new Configuracoes();
        props.setProperty("mail.smtp.host", configuracoes.getHostSMTP());
        props.setProperty("mail.smtp.port", configuracoes.getPortaSMTP());
        props.put("mail.smtp.auth", (Object)true);
        props.put("mail.debug", configuracoes.getDebugSMTP());
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.starttls.enable", configuracoes.getTlsSMTP());
        this.mailSession = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(configuracoes.getLoginEmailAdapter(), configuracoes.getSenhaEmailAdapter());
            }
        });
    }

    public void send(EmailMessage message) {
        try {
            String[] stringArray = message.getTo();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String para = stringArray[n2];
                Message msg = this.createMessage(message, para);
                Multipart mp = this.createContent(message);
                String[] stringArray2 = message.getAttachments();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String attach = stringArray2[n4];
                    mp.addBodyPart((BodyPart)this.createAttachment(attach));
                    ++n4;
                }
                msg.setContent(mp);
                Transport.send((Message)msg);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new AdapterErrorException("Erro ao tentar enviar o email", e);
        }
    }

    private MimeBodyPart createAttachment(String attach) throws MessagingException {
        MimeBodyPart attachment = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(attach);
        attachment.setFileName(fds.getName());
        attachment.setDataHandler(new DataHandler((DataSource)fds));
        return attachment;
    }

    private Multipart createContent(EmailMessage message) throws MessagingException {
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setContent((Object)message.getContent(), message.getMimeType());
        mp.addBodyPart((BodyPart)htmlPart);
        return mp;
    }

    private Message createMessage(EmailMessage message, String para) throws MessagingException, AddressException {
        MimeMessage msg = new MimeMessage(this.mailSession);
        msg.setFrom((Address)new InternetAddress(message.getFrom()));
        msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(para));
        msg.setSubject(message.getSubject());
        return msg;
    }
}

