/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.dao;

import adapter.configuracoes.eStatusControle;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import rotinas.adapter.config.AdapterRotinasDatabase;

public class RotinasDao {
    public Map<String, Object> findControleExecucaoRotina(Long idControleExecucaoRotina) {
        String sql = "SELECT * FROM TB_ControleExecucaoRotina WHERE IDControleExecucaoRotina =  ?";
        try {
            Session session = AdapterRotinasDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)idControleExecucaoRotina);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Map map = (Map)q.uniqueResult();
            session.close();
            return map;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public void updateStatusControle(Long idControleExecucaoRotina, eStatusControle statusControle) {
        String sql = "UPDATE TB_ControleExecucaoRotina SET `Status` = ? WHERE IDControleExecucaoRotina = ?";
        try {
            Session session = AdapterRotinasDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)statusControle.name());
            q.setParameter(1, (Object)idControleExecucaoRotina);
            q.executeUpdate();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateStatusAndDataFimControle(Long idControleExecucaoRotina, eStatusControle statusControle) {
        String sql = "UPDATE TB_ControleExecucaoRotina SET `Status` = :status, DataFim = NOW() WHERE IDControleExecucaoRotina = :idControleExecucaoRotina";
        try {
            Session session = AdapterRotinasDatabase.getSessionFactory().openSession();
            session.beginTransaction();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("status", (Object)statusControle.name());
            q.setParameter("idControleExecucaoRotina", (Object)idControleExecucaoRotina);
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateStatusPidControle(Long idControleExecucaoRotina, Long pid, eStatusControle statusControle) {
        String sql = "UPDATE TB_ControleExecucaoRotina SET `Status` = :status, PID = :pid, DataInicio = NOW() WHERE IDControleExecucaoRotina = :idControleExecucaoRotina";
        try {
            Session session = AdapterRotinasDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            session.beginTransaction();
            q.setParameter("status", (Object)statusControle.name());
            q.setParameter("pid", (Object)pid);
            q.setParameter("idControleExecucaoRotina", (Object)idControleExecucaoRotina);
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Map<String, String>> findParametrosControleExecucaoRotina(Long idControleRotina) {
        String sql = "SELECT * FROM TB_ParametroExecucaoRotina WHERE IDControleExecucaoRotina = ?";
        try {
            Session session = AdapterRotinasDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)idControleRotina);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            System.out.println(q.list());
            List map = q.list();
            session.close();
            return map;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Map<String, Object> findUsuarioSolicitacao(String banco_gateway, Long idControleExecucaoRotina) {
        String sql = "SELECT usuario.IDUsuario, usuario.NomeUsuario, usuario.EmailUsuario, controle.NomeArquivo FROM TB_ControleExecucaoRotina controle  INNER JOIN " + banco_gateway + ".TB_Usuario usuario ON controle.IDUsuario = usuario.IDUsuario " + " WHERE controle.IDControleExecucaoRotina = ? ";
        try {
            Session session = AdapterRotinasDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)idControleExecucaoRotina);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Map map = (Map)q.uniqueResult();
            session.close();
            return map;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

