/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter.dao;

import adapter.configuracoes.eNomeParametro;
import adapter.exceptions.AdapterErrorException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import rotinas.adapter.config.AdapterFinanceiroDatabase;
import rotinas.adapter.config.Configuracoes;

public class FinanceiroDao {
    public List<Map<String, Object>> findPagamentosIntegracao(Map<String, String> parametros, String idFatura) throws ParseException {
        Session session = null;
        SimpleDateFormat formato = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatoBr = new SimpleDateFormat("dd-MM-yyyy");
        try {
            Configuracoes conf = Configuracoes.getInstance();
            String bdTerceiros = conf.getBdTerceiros();
            String bdComercial = conf.getBdComercial();
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT DISTINCT fat.IDFatura, fat.IDCliente, fat.DataLancamento, fat.DataVencimento, fat.NumeroBoleto, emp.IDFilialSap, fat.IsNegociacao, ");
            sql.append(" fat.DataPagamento, fat.ValorPago, fat.Valor, fat.MultaValorPago, fat.JurosValorPago, fat.DescontoValorPago, fat.IDFormaPagamento, fat.NumeroDocumento, ");
            sql.append(" fat.CodigoAutorizacaoCartao, fat.TIDCartao, fp.IsDebito, fat.IDBandeiraCartao, fat.IDBandeiraCartaoEmpresa,");
            sql.append(" CASE WHEN fat.TipoPagamento = 'LOJA' THEN 'PL' ");
            sql.append(" WHEN fat.TipoPagamento = 'RETORNO' THEN 'PR' ");
            sql.append(" WHEN fat.TipoPagamento = 'PARCIAL' THEN  'PP' ");
            sql.append(" WHEN fat.TipoPagamento = 'RENEGOCIACAO' THEN  'R' ");
            sql.append(" ELSE 'PR' ");
            sql.append(" END TipoPagamento, ");
            sql.append(" fc.CodigoSap, cli.CPF, cli.CNPJ, fat.IDFormaCobranca ");
            sql.append(" FROM TB_Fatura fat ");
            sql.append(" INNER JOIN TB_FormaCobranca fc ON fat.IDFormaCobranca = fc.IDFormaCobranca ");
            sql.append(" INNER JOIN TB_ContaFinanceira contF ON fc.IDContaFinanceira = contF.IDContaFinanceira ");
            sql.append(" INNER JOIN " + bdTerceiros + ".TB_Empresa emp ON contF.IDEmpresa = emp.IDEmpresa ");
            sql.append(" INNER JOIN " + bdComercial + ".TB_Cliente cli ON cli.IDCliente = fat.IDCliente ");
            sql.append(" LEFT JOIN TB_FormaPagamento fp ON fp.IDFormaPagamento = fat.IDFormaPagamento ");
            sql.append(" LEFT JOIN TB_FaturamentoMes fm ON fm.IDFatura = fat.IDFatura ");
            sql.append(" LEFT JOIN TB_FaturaParcelamento faturaParcelamento ON faturaParcelamento.IDFatura = fat.IDFatura ");
            sql.append(" WHERE fat.IsCancelado = 0 AND fat.DataPagamento IS NOT NULL ");
            sql.append(" AND fc.CodigoSap IS NOT NULL AND fc.CodigoSap != '' ");
            sql.append(" AND (fm.IDItemNota IS NOT NULL OR faturaParcelamento.IDItemNotaAntiga IS NOT NULL) ");
            if (idFatura != null) {
                sql.append(" AND fat.IDFatura = " + idFatura + " ");
            } else {
                sql.append(" AND fat.IsPagamentoIntegrado IN (" + parametros.get(eNomeParametro.STATUS_INTEGRACAO_SAP.name()) + ") ");
                if (parametros.containsKey(eNomeParametro.DATA_PAGAMENTO_INICIO.name()) && parametros.get(eNomeParametro.DATA_PAGAMENTO_INICIO.name()) != null) {
                    sql.append(" AND fat.DataPagamento >= '" + formato.format(formatoBr.parse(parametros.get(eNomeParametro.DATA_PAGAMENTO_INICIO.name()))) + "' ");
                }
                if (parametros.containsKey(eNomeParametro.DATA_PAGAMENTO_FIM.name()) && parametros.get(eNomeParametro.DATA_PAGAMENTO_FIM.name()) != null) {
                    sql.append(" AND fat.DataPagamento <= '" + formato.format(formatoBr.parse(parametros.get(eNomeParametro.DATA_PAGAMENTO_FIM.name()))) + "' ");
                }
                if (parametros.containsKey(eNomeParametro.NUMERO_DOCUMENTO.name()) && parametros.get(eNomeParametro.NUMERO_DOCUMENTO.name()) != null) {
                    sql.append(" AND fat.NumeroDocumento = '" + parametros.get(eNomeParametro.NUMERO_DOCUMENTO.name()) + "' ");
                }
                if (parametros.containsKey(eNomeParametro.NUMERO_BOLETO.name()) && parametros.get(eNomeParametro.NUMERO_BOLETO.name()) != null) {
                    sql.append(" AND fat.NumeroBoleto = '" + parametros.get(eNomeParametro.NUMERO_BOLETO.name()) + "' ");
                }
                if (parametros.containsKey(eNomeParametro.ID_FORMA_COBRANCA.name()) && parametros.get(eNomeParametro.ID_FORMA_COBRANCA.name()) != null) {
                    sql.append(" AND fc.IDFormaCobranca = " + parametros.get(eNomeParametro.ID_FORMA_COBRANCA.name()) + " ");
                }
                if (parametros.containsKey(eNomeParametro.ID_CLIENTE.name()) && parametros.get(eNomeParametro.ID_CLIENTE.name()) != null) {
                    sql.append(" AND fat.IDCliente = " + parametros.get(eNomeParametro.ID_CLIENTE.name()) + " ");
                }
                if (parametros.containsKey(eNomeParametro.ID_FATURA.name()) && parametros.get(eNomeParametro.ID_FATURA.name()) != null) {
                    sql.append(" AND fat.IDFatura = " + parametros.get(eNomeParametro.ID_FATURA.name()) + " ");
                }
            }
            sql.append(" ORDER BY fat.IDCliente ASC ");
            System.out.println("sql --> " + sql.toString());
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public List<Map<String, Object>> findNotasFaturamentosIntegracao(String IDFatura) {
        Session session = null;
        try {
            Configuracoes conf = Configuracoes.getInstance();
            String bdTerceiros = conf.getBdTerceiros();
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT fm.IDFaturamentoMes, fm.IDDocumentoSap, nt.Valor AS 'ValorNota', nt.DataEmissao, emp.DataLimiteLCMPagamentoSap  ");
            sql.append(" FROM TB_FaturamentoMes fm ");
            sql.append(" INNER JOIN TB_ItemNota itn ON fm.IDItemNota = itn.IDItemNota ");
            sql.append(" INNER JOIN TB_Nota nt ON itn.IDNota = nt.IDNota ");
            sql.append(" INNER JOIN " + bdTerceiros + ".TB_Empresa emp ON emp.IDEmpresa = nt.IDEmpresa ");
            sql.append(" WHERE fm.IDFatura = :IDFatura ");
            sql.append(" GROUP BY fm.IDDocumentoSap ");
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setParameter("IDFatura", (Object)IDFatura);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public List<Map<String, Object>> findNotasFaturamentosFaturaNegociaoIntegracao(String IDFatura) {
        Session session = null;
        try {
            Configuracoes conf = Configuracoes.getInstance();
            String bdTerceiros = conf.getBdTerceiros();
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT fm.IDFaturamentoMes, fm.IDDocumentoSap, fp.NumeroParcela, fp.QtdeParcela, nt.Valor AS 'ValorNota', nt.DataEmissao, emp.DataLimiteLCMPagamentoSap");
            sql.append(" FROM TB_FaturaParcelamento fp ");
            sql.append(" INNER JOIN TB_FaturamentoMes fm ON fp.IDFaturaAntiga = fm.IDFatura ");
            sql.append(" INNER JOIN TB_ItemNota itn ON fm.IDItemNota = itn.IDItemNota ");
            sql.append(" INNER JOIN TB_Nota nt ON itn.IDNota = nt.IDNota ");
            sql.append(" INNER JOIN " + bdTerceiros + ".TB_Empresa emp ON emp.IDEmpresa = nt.IDEmpresa ");
            sql.append(" WHERE fp.IDFatura = :IDFatura ");
            sql.append(" GROUP BY fm.IDDocumentoSap ");
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setParameter("IDFatura", (Object)IDFatura);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            e.printStackTrace();
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public Map<String, Object> findJurosMultaDescontoByFaturaNegociacao(String IDFatura) {
        Session session = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT SUM(fp.Juros) as Juros, SUM(fp.Multa) as Multa, SUM(fp.ValorDesconto) as ValorDesconto");
            sql.append(" FROM TB_FaturaParcelamento fp ");
            sql.append(" WHERE fp.IDFatura = :IDFatura");
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setParameter("IDFatura", (Object)IDFatura);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Map mapList = (Map)q.uniqueResult();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            e.printStackTrace();
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public Map<String, Object> findCodigoSapContaFinanceiraPagamento(String numeroBoleto, String numeroDocumento, String idCliente) {
        Session session = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT cf.CodigoSap, r.IDReceita FROM TB_ContaFinanceira cf ");
            sql.append(" INNER JOIN TB_Receita r ON r.IDContaFinanceira = cf.IDContaFinanceira ");
            sql.append(" WHERE r.NumeroBoleto = :numeroBoleto AND r.DocumentoGerador = :numeroDocumento AND r.IDCliente = :idCliente ");
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setParameter("numeroBoleto", (Object)numeroBoleto);
            q.setParameter("numeroDocumento", (Object)numeroDocumento);
            q.setParameter("idCliente", (Object)idCliente);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return (Map)mapList.get(0);
        }
        catch (NoResultException e) {
            e.printStackTrace();
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public List<Map<String, Object>> findDadosParaNotaInexistenteIntegracao(String IDFatura) {
        Session session = null;
        try {
            Configuracoes conf = Configuracoes.getInstance();
            String bdTerceiros = conf.getBdTerceiros();
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT fm.IDFaturamentoMes, fm.IDDocumentoSap, SUM(fm.Valor - IFNULL(fm.Desconto,0.0)) AS 'ValorNota', fm.DataGeracaoFaturamento as DataEmissao, emp.DataLimiteLCMPagamentoSap  ");
            sql.append(" FROM TB_FaturamentoMes fm ");
            sql.append(" INNER JOIN TB_FormaCobranca fc ON fc.IDFormaCobranca = fm.IDFormaCobranca ");
            sql.append(" INNER JOIN TB_ContaFinanceira cf ON cf.IDContaFinanceira = fc.IDContaFinanceira ");
            sql.append(" INNER JOIN " + bdTerceiros + ".TB_Empresa emp ON emp.IDEmpresa = cf.IDEmpresa ");
            sql.append(" WHERE fm.IDFatura = :IDFatura ");
            sql.append(" GROUP BY fm.IDDocumentoSap ");
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setParameter("IDFatura", (Object)IDFatura);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public List<Map<String, Object>> findPagamentosReceita(String idReceita) {
        Session session = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT * FROM TB_PagamentoReceita pr ");
            sql.append(" WHERE pr.IDReceita = :idReceita AND pr.IsPagamentoIntegrado = 'N'");
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setParameter("idReceita", (Object)idReceita);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List mapList = q.list();
            session.close();
            return mapList;
        }
        catch (NoResultException e) {
            e.printStackTrace();
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public Map<String, Object> findCodigoBandeiraById(Long idBandeira) {
        Session session = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT CodigoCreditoSap, CodigoDebitoSap FROM TB_BandeiraCartao WHERE IDBandeiraCartao = :idBandeira");
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setParameter("idBandeira", (Object)idBandeira);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Map map = (Map)q.uniqueResult();
            session.close();
            return map;
        }
        catch (NoResultException e) {
            e.printStackTrace();
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public Map<String, Object> findCodigoBandeiraEmpresaById(Long idBandeira) {
        Session session = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT CodigoCreditoSap, CodigoDebitoSap FROM TB_BandeiraCartaoEmpresa WHERE IDBandeiraCartaoEmpresa = :idBandeira");
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql.toString());
            q.setParameter("idBandeira", (Object)idBandeira);
            q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Map map = (Map)q.uniqueResult();
            session.close();
            return map;
        }
        catch (NoResultException e) {
            e.printStackTrace();
            if (session != null) {
                session.close();
            }
            return null;
        }
    }

    public void updateFaturaStatusIntegracao(Long IDFatura, String IsPagamentoIntegrado) {
        Session session = null;
        try {
            String sql = "UPDATE TB_Fatura f SET f.IsPagamentoIntegrado = :IsPagamentoIntegrado WHERE f.IDFatura = :IDFatura";
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("IDFatura", (Object)IDFatura);
            q.setParameter("IsPagamentoIntegrado", (Object)IsPagamentoIntegrado);
            session.beginTransaction();
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
            }
            throw new AdapterErrorException("Erro ao atualizar o Status do da Integra\u00e7\u00e3o da Fatura com o SAP.", e);
        }
    }

    public void updateFaturamentoCarneStatusIntegracao(Long idFaturamentoMes) {
        Session session = null;
        try {
            String sql = "UPDATE TB_FaturamentoMes f SET f.IsIntegrado = :IsIntegrado WHERE f.IDFaturamentoMes = :idFaturamentoMes";
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("idFaturamentoMes", (Object)idFaturamentoMes);
            q.setParameter("IsIntegrado", (Object)"N");
            session.beginTransaction();
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
            }
            throw new AdapterErrorException("Erro ao atualizar o Status do da Integra\u00e7\u00e3o do faturamento de carne com o SAP.", e);
        }
    }

    public void updatePagamentoReceitaStatusIntegracao(Long IDReceita, String IsPagamentoIntegrado) {
        Session session = null;
        try {
            String sql = "UPDATE TB_PagamentoReceita pr SET pr.IsPagamentoIntegrado = :IsPagamentoIntegrado WHERE pr.IDReceita = :IDReceita AND pr.IsPagamentoIntegrado = 'N'";
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("IDReceita", (Object)IDReceita);
            q.setParameter("IsPagamentoIntegrado", (Object)IsPagamentoIntegrado);
            session.beginTransaction();
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
            }
            throw new AdapterErrorException("Erro ao atualizar o Status da Integra\u00e7\u00e3o do Pagamento Receita com o SAP.", e);
        }
    }

    public void insereLogIntegracaoFatura(String acao, String tipoAcao, Long IDFatura, Long idUsuario) {
        Session session = null;
        try {
            String sql = "INSERT INTO TB_LogIntegracaoFatura (Acao, TipoAcao, DataLog, IDFatura, IDUsuario) VALUES (?, ?, NOW(), ?, ?)";
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            session.beginTransaction();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter(0, (Object)acao);
            q.setParameter(1, (Object)tipoAcao);
            q.setParameter(2, (Object)IDFatura);
            q.setParameter(3, (Object)idUsuario);
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
            }
            throw new AdapterErrorException("Erro ao registrar o Log de integra\u00e7\u00e3o de faturamento com o SAP", e);
        }
    }

    public String getConfiguracaoFinanceiroByChave(String chave) throws Exception {
        Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
        String sql = "SELECT ValorConfiguracao FROM TB_Configuracoes WHERE ChaveConfiguracao = :chave";
        SQLQuery q = session.createSQLQuery(sql);
        q.setParameter("chave", (Object)chave);
        String resultado = (String)q.uniqueResult();
        session.close();
        return resultado;
    }

    public String verificaSeTabelaNotaFechadaExiste() {
        Configuracoes conf = Configuracoes.getInstance();
        String bdFinanceiro = conf.getBdTerceiros().replace("terceiros", "financeiro");
        try {
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            String sql = "SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_schema='" + bdFinanceiro + "' AND table_name like'TB_NotaFechadaSAP'";
            SQLQuery q = session.createSQLQuery(sql);
            String resultado = (String)q.uniqueResult();
            session.close();
            return resultado;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long findNotaFechadaByDocEntry(String DocEntry) {
        try {
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            String sql = "SELECT COUNT(*) FROM TB_NotaFechadaSAP WHERE DocEntry = :DocEntry ";
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("DocEntry", (Object)DocEntry);
            Long resultado = new Long(q.uniqueResult().toString());
            session.close();
            return resultado;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String findDocEntryCarneByCodFat(String codfat) {
        try {
            Session session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            String sql = "SELECT DocEntry FROM TB_FaturaCarneSAP WHERE TRIM(Codfat) = :codfat ";
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("codfat", (Object)codfat);
            String resultado = (String)q.uniqueResult();
            session.close();
            return resultado;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Double findControlePagamentoByDocumentoSap(String idDocumentoSap) {
        Session session = null;
        try {
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            String sql = "SELECT ValorPagoNota FROM TB_ControlePagamentoSAP WHERE IDDocumentoSAP = :idDocumentoSap ";
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("idDocumentoSap", (Object)idDocumentoSap);
            Double resultado = (Double)q.uniqueResult();
            session.close();
            return resultado;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
            }
            e.printStackTrace();
            throw new AdapterErrorException("Erro ao buscar pagamento na tabela Controle de pagamento.", e);
        }
    }

    public void updateControlePagamentoSAP(String idDocumentoSap, Double valor) {
        Session session = null;
        try {
            String sql = "UPDATE TB_ControlePagamentoSAP c SET c.ValorPagoNota = :valor, DataUltimaAlteracao = :dataAlteracao WHERE c.IDDocumentoSAP = :idDocumentoSap";
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("valor", (Object)valor);
            q.setParameter("dataAlteracao", (Object)new Date());
            q.setParameter("idDocumentoSap", (Object)idDocumentoSap);
            session.beginTransaction();
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
            }
            e.printStackTrace();
            throw new AdapterErrorException("Erro ao atualizar o Controle de pagamento.", e);
        }
    }

    public void insertControlePagamentoSAP(String idDocumentoSap, Double valor) {
        Session session = null;
        try {
            String sql = "INSERT INTO TB_ControlePagamentoSAP(DataUltimaAlteracao, IDDocumentoSAP, ValorPagoNota) VALUES (:dataAlteracao, :idDocumentoSap, :valor)";
            session = AdapterFinanceiroDatabase.getSessionFactory().openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.setParameter("valor", (Object)valor);
            q.setParameter("dataAlteracao", (Object)new Date());
            q.setParameter("idDocumentoSap", (Object)idDocumentoSap);
            session.beginTransaction();
            q.executeUpdate();
            session.getTransaction().commit();
            session.close();
        }
        catch (Exception e) {
            if (session != null) {
                session.close();
            }
            e.printStackTrace();
            throw new AdapterErrorException("Erro ao inserir na controle de pagamento.", e);
        }
    }
}

