/*
 * Decompiled with CFR 0.152.
 */
package rotinas.adapter;

import adapter.criptografia.CriptografiaAES;
import adapter.exceptions.AdapterErrorException;
import adapter.exceptions.AdapterWarnException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import rotinas.adapter.IntegracaoSapPagamentoMain;
import rotinas.adapter.config.Configuracoes;
import rotinas.adapter.dao.FinanceiroDao;

public class SapServiceRunnable
implements Runnable {
    private String url;
    private String prettyJson = "";
    private boolean isRespostaErroSap;
    private String acao = "";
    private String tipoAcao = "PAGAMENTO";
    private FinanceiroDao financeiroDao;
    private Long idUsuarioTarefasAutomaticas;
    private long tempoResposta;
    private Map<String, Object> fatura;
    private Map<String, String> faturasIntegrados;
    private Map<String, String> faturasErro;
    private Map<String, Object> servidorIntegracao;
    private String respostaSAP = "";
    private String dataSAP = "";
    private String response;
    private Configuracoes configuracoes;
    private String cardCodeDocumento;
    private String idFilialFixo;
    private List<Long> idsFormasCobrancaSomamUmDia;
    private List<Map<String, Object>> pagamentosReceita;
    private Map<String, Object> inforPagamento;
    private String dataVencimentoIgualPagamento;
    private Boolean verificaNotaFechada;
    private String docEntryCarne;
    private Long idFaturamentoCarne;
    private Double valorPagoTotalNotas;
    private List<Map<String, Object>> dadosPagamentosNotas;
    private Date dataMaiorEmissaoNota;
    private SimpleDateFormat formato = new SimpleDateFormat("yyyy-MM-dd");

    public SapServiceRunnable(Map<String, Object> fatura, Map<String, String> faturasIntegrados, Map<String, String> faturasErro, FinanceiroDao financeiroDao, Map<String, Object> servidorIntegracao, Long idUsuarioTarefasAutomaticas, Configuracoes configuracoes, String cardCodeDocumento, String idFilialFixo, List<Long> idsFormasCobrancaSomamUmDia, String dataVencimentoIgualPagamento, Boolean verificaNotaFechada) {
        this.fatura = fatura;
        this.faturasIntegrados = faturasIntegrados;
        this.faturasErro = faturasErro;
        this.financeiroDao = financeiroDao;
        this.servidorIntegracao = servidorIntegracao;
        this.idUsuarioTarefasAutomaticas = idUsuarioTarefasAutomaticas;
        this.configuracoes = configuracoes;
        this.cardCodeDocumento = cardCodeDocumento;
        this.idFilialFixo = idFilialFixo;
        this.idsFormasCobrancaSomamUmDia = idsFormasCobrancaSomamUmDia;
        this.pagamentosReceita = new ArrayList<Map<String, Object>>();
        this.inforPagamento = new HashMap<String, Object>();
        this.dataVencimentoIgualPagamento = dataVencimentoIgualPagamento;
        this.verificaNotaFechada = verificaNotaFechada;
        this.docEntryCarne = null;
        this.idFaturamentoCarne = null;
        this.valorPagoTotalNotas = 0.0;
        this.dadosPagamentosNotas = new ArrayList<Map<String, Object>>();
        this.dataMaiorEmissaoNota = null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block32: {
            try {
                block33: {
                    listaNotaInicial = this.fatura.get("IsNegociacao") != null && this.fatura.get("IsNegociacao").toString().equals("1") != false ? this.financeiroDao.findNotasFaturamentosFaturaNegociaoIntegracao(this.fatura.get("IDFatura").toString()) : this.financeiroDao.findNotasFaturamentosIntegracao(this.fatura.get("IDFatura").toString());
                    if (listaNotaInicial == null || listaNotaInicial.size() <= 0 || listaNotaInicial.isEmpty()) {
                        listaNotaInicial = this.financeiroDao.findDadosParaNotaInexistenteIntegracao(this.fatura.get("IDFatura").toString());
                    }
                    valida = true;
                    notaErro = "";
                    retornoValidacao = new HashMap<K, V>();
                    listaNota = new ArrayList<E>();
                    listaNota = this.verificaNotaFechada.booleanValue() && this.isPagamentoParcial().booleanValue() ? ((notasVerificadas = this.verificaNotaFechada(listaNotaInicial)).size() > 0 && notasVerificadas.size() < listaNotaInicial.size() ? notasVerificadas : listaNotaInicial) : listaNotaInicial;
                    if (this.fatura.get("codfat") != null && !this.fatura.get("codfat").toString().isEmpty()) {
                        this.docEntryCarne = this.financeiroDao.findDocEntryCarneByCodFat(this.fatura.get("codfat").toString().trim());
                    }
                    for (Map nota : listaNota) {
                        retornoValidacao = this.docEntryCarne != null ? this.validaSituacaoPagamento("ADC", this.docEntryCarne) : this.validaSituacaoPagamento(this.tipoNotaPagamento(nota.get("DataEmissao").toString(), (Date)nota.get("DataLimiteLCMPagamentoSap")), nota.get("IDDocumentoSap").toString());
                        System.out.println(retornoValidacao);
                        System.out.println("---------------");
                        if (!((String)retornoValidacao.get("Status")).equals("0")) {
                            valida = false;
                            notaErro = nota.get("IDDocumentoSap").toString();
                            break;
                        }
                        if (((String)retornoValidacao.get("Documento")).contains("Nao identificada")) continue;
                        nota.put("saldoSAP", retornoValidacao.get("Documento"));
                    }
                    if (!valida.booleanValue()) break block33;
                    System.out.println("Passei do valida--------------");
                    this.inforPagamento = this.financeiroDao.findCodigoSapContaFinanceiraPagamento(this.fatura.get("NumeroBoleto").toString(), this.fatura.get("NumeroDocumento").toString(), this.fatura.get("IDCliente").toString());
                    this.pagamentosReceita = this.financeiroDao.findPagamentosReceita(this.inforPagamento.get("IDReceita").toString());
                    if (this.isPagamentoParcial().booleanValue()) {
                        this.configuraValoresPagamentoParcial();
                    }
                    mapIntegracao = new HashMap<String, Object>();
                    notasCompoemPagamento = new ArrayList<Map<Object, Object>>();
                    this.geraCorpoMapIntegracao(mapIntegracao, (Map)listaNota.get(0));
                    mapNota = new HashMap<K, V>();
                    if (listaNota.size() == 1) {
                        mapNota = this.geraMapNotaCompoePagamento((Map)listaNota.get(0));
                        notasCompoemPagamento.add(mapNota);
                        this.valorPagoTotalNotas = new Double(mapNota.get("ValorDocumento").toString());
                        this.dataMaiorEmissaoNota = (Date)((Map)listaNota.get(0)).get("DataEmissao");
                    } else {
                        for (Map nota : listaNota) {
                            mapNota = this.geraMapNotaCompoePagamento(nota);
                            notasCompoemPagamento.add(mapNota);
                            this.valorPagoTotalNotas = this.valorPagoTotalNotas + new Double(mapNota.get("ValorDocumento").toString());
                            if (this.dataMaiorEmissaoNota != null) {
                                dataEm = (Date)nota.get("DataEmissao");
                                if (!dataEm.after(this.dataMaiorEmissaoNota)) continue;
                                this.dataMaiorEmissaoNota = dataEm;
                                continue;
                            }
                            this.dataMaiorEmissaoNota = (Date)nota.get("DataEmissao");
                        }
                    }
                    System.out.println("Data maior emissao de nota ---> : " + this.dataMaiorEmissaoNota);
                    dataPagamento = (Date)this.fatura.get("DataPagamento");
                    System.out.println("Data de pagamento original ---> : " + dataPagamento);
                    if (this.dataMaiorEmissaoNota != null && dataPagamento.before(this.dataMaiorEmissaoNota)) {
                        ft = new SimpleDateFormat("yyyy-MM-dd");
                        mapIntegracao.put("DataPagamento", ft.format(this.dataMaiorEmissaoNota));
                        mapIntegracao.put("DataLancamento", ft.format(this.dataMaiorEmissaoNota));
                        if (this.dataVencimentoIgualPagamento != null && this.dataVencimentoIgualPagamento.equals("1")) {
                            mapIntegracao.put("DataVencimento", ft.format(this.dataMaiorEmissaoNota));
                        }
                        if (mapIntegracao.containsKey("PaymentCreditCards") && mapIntegracao.get("PaymentCreditCards") != null && (pagamentoCartao = (List)mapIntegracao.get("PaymentCreditCards")).size() > 0 && ((Map)pagamentoCartao.get(0)).containsKey("FirstPaymentDue") && ((Map)pagamentoCartao.get(0)).get("FirstPaymentDue") != null) {
                            ((Map)pagamentoCartao.get(0)).put("FirstPaymentDue", ft.format(this.dataMaiorEmissaoNota));
                        }
                        if (mapIntegracao.containsKey("PaymentChecks") && mapIntegracao.get("PaymentChecks") != null && (pagamentoCheque = (List)mapIntegracao.get("PaymentChecks")).size() > 0 && ((Map)pagamentoCheque.get(0)).containsKey("DueDate") && ((Map)pagamentoCheque.get(0)).get("DueDate") != null) {
                            ((Map)pagamentoCheque.get(0)).put("DueDate", ft.format(this.dataMaiorEmissaoNota));
                        }
                    }
                    if (new Double(mapIntegracao.get("DescontoPagamento").toString()) == 0.0) {
                        v0 = new Double(this.fatura.get("ValorPago").toString());
                        if (this.valorPagoTotalNotas > v0) {
                            mapIntegracao.put("DescontoPagamento", this.verificaDesconto());
                        }
                    }
                    desconto = new Double(mapIntegracao.get("DescontoNegociacao").toString()) + new Double(mapIntegracao.get("DescontoPagamento").toString());
                    jurosMulta = new Double(mapIntegracao.get("MultaJurosPagamento").toString()) + new Double(mapIntegracao.get("MultaJurosNegociacao").toString());
                    if (this.isPagamentoParcial().booleanValue() && this.valorPagoTotalNotas != new Double(this.fatura.get("ValorPago").toString()) + desconto - jurosMulta) {
                        diferenca = new Double(this.fatura.get("ValorPago").toString()) + desconto - jurosMulta - this.valorPagoTotalNotas;
                        valor = new Double(((Map)notasCompoemPagamento.get(0)).get("ValorDocumento").toString());
                        ((Map)notasCompoemPagamento.get(0)).put("ValorDocumento", this.arredondaValor(valor + diferenca));
                    }
                    mapIntegracao.put("NotasCompoemPagamento", notasCompoemPagamento);
                    gsonBuilder = new GsonBuilder().serializeNulls();
                    gson = gsonBuilder.setPrettyPrinting().create();
                    parser = new JsonParser();
                    jsonPretty = parser.parse(gson.toJson(mapIntegracao, LinkedHashMap.class)).getAsJsonObject();
                    gson = new GsonBuilder().setPrettyPrinting().create();
                    this.prettyJson = gson.toJson((JsonElement)jsonPretty);
                    System.out.println(this.prettyJson);
                    httpClient = new DefaultHttpClient();
                    this.url = this.servidorIntegracao.get("URL") + ":" + this.servidorIntegracao.get("Porta") + "/api/payments/AddPayments";
                    httpPost = new HttpPost(this.url);
                    System.out.println(gson.toJson(mapIntegracao, LinkedHashMap.class));
                    params = new StringEntity(gson.toJson(mapIntegracao, LinkedHashMap.class), "UTF-8");
                    httpPost.addHeader("content-type", "application/json");
                    this.defineAuthorization(this.servidorIntegracao, httpPost);
                    httpPost.setEntity((HttpEntity)params);
                    antesReq = LocalDateTime.now();
                    httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                    entity = httpResponse.getEntity();
                    depoisReq = LocalDateTime.now();
                    duration = Duration.between(antesReq, depoisReq);
                    this.tempoResposta = Math.abs(duration.getSeconds());
                    if (entity == null) {
                        throw new AdapterWarnException("Erro ao integrar os dados de Pagamento ao SAP.\nResposta da requisi\u00e7ao ao SAP \u00e9 nula");
                    }
                    this.response = EntityUtils.toString((HttpEntity)entity);
                    resposta = new JSONObject(this.response);
                    httpClient.getConnectionManager().shutdown();
                    this.respostaSAP = "";
                    this.respostaSAP = resposta.has("message") != false ? resposta.get("message").toString() : (resposta.has("Message") != false ? resposta.get("Message").toString() : "Nao identificada");
                    this.dataSAP = "";
                    this.dataSAP = resposta.has("data") != false ? resposta.get("data").toString() : (resposta.has("Data") != false ? resposta.get("Data").toString() : "Nao identificada");
                    IntegracaoSapPagamentoMain.LOGGER.info("URL = " + this.url);
                    IntegracaoSapPagamentoMain.LOGGER.info("RESPOSTA = " + this.respostaSAP + "\tTEMPO = " + this.tempoResposta);
                    if (resposta.has("status") && resposta.get("status").equals("0")) ** GOTO lbl136
                    if (resposta.get("data") != null && resposta.get("data").toString().equals("Registro j\u00e1 encontrado na Stage.")) {
                        this.financeiroDao.updateFaturaStatusIntegracao(Long.valueOf(this.fatura.get("IDFatura").toString()), "S");
                        this.financeiroDao.updatePagamentoReceitaStatusIntegracao(new Long(this.pagamentosReceita.get(0).get("IDReceita").toString()), "S");
                        if (this.idFaturamentoCarne != null) {
                            this.financeiroDao.updateFaturamentoCarneStatusIntegracao(this.idFaturamentoCarne);
                        }
                        this.faturasIntegrados.put(this.fatura.get("IDFatura").toString(), resposta.toString());
                        this.acao = String.valueOf(this.acao) + "DADOS DE PAGAMENTOS ENVIADOS AO SAP\n";
                        this.acao = String.valueOf(this.acao) + "\t# URL: " + this.url + "\n";
                        this.acao = String.valueOf(this.acao) + "\t# Resposta: " + this.respostaSAP + "\n";
                        this.acao = String.valueOf(this.acao) + "\t# Data: " + this.dataSAP + "\n";
                        this.acao = String.valueOf(this.acao) + "\t# Tempo de resposta: " + this.tempoResposta + " segundos" + "\n";
                        this.acao = String.valueOf(this.acao) + "\t# Dados enviados:\n" + this.prettyJson + "\n\n";
                        this.acao = String.valueOf(this.acao) + "\t# Dados recebidos:\n " + gson.toJson((Object)resposta);
                        this.financeiroDao.insereLogIntegracaoFatura(this.acao, this.tipoAcao, Long.valueOf(this.fatura.get("IDFatura").toString()), this.idUsuarioTarefasAutomaticas);
                    } else {
                        this.isRespostaErroSap = true;
                        throw new AdapterWarnException(String.valueOf(this.respostaSAP) + ": " + resposta.get("data") != null ? resposta.get("data").toString() : "");
lbl136:
                        // 1 sources

                        this.financeiroDao.updateFaturaStatusIntegracao(Long.valueOf(this.fatura.get("IDFatura").toString()), "S");
                        this.financeiroDao.updatePagamentoReceitaStatusIntegracao(new Long(this.pagamentosReceita.get(0).get("IDReceita").toString()), "S");
                        if (this.idFaturamentoCarne != null) {
                            this.financeiroDao.updateFaturamentoCarneStatusIntegracao(this.idFaturamentoCarne);
                        }
                        this.faturasIntegrados.put(this.fatura.get("IDFatura").toString(), resposta.toString());
                        this.acao = String.valueOf(this.acao) + "DADOS DE PAGAMENTOS ENVIADOS AO SAP\n";
                        this.acao = String.valueOf(this.acao) + "\t# URL: " + this.url + "\n";
                        this.acao = String.valueOf(this.acao) + "\t# Resposta: " + this.respostaSAP + "\n";
                        this.acao = String.valueOf(this.acao) + "\t# Data: " + this.dataSAP + "\n";
                        this.acao = String.valueOf(this.acao) + "\t# Tempo de resposta: " + this.tempoResposta + " segundos" + "\n";
                        this.acao = String.valueOf(this.acao) + "\t# Dados enviados:\n" + this.prettyJson + "\n\n";
                        this.acao = String.valueOf(this.acao) + "\t# Dados recebidos:\n " + gson.toJson((Object)resposta);
                        this.financeiroDao.insereLogIntegracaoFatura(this.acao, this.tipoAcao, Long.valueOf(this.fatura.get("IDFatura").toString()), this.idUsuarioTarefasAutomaticas);
                    }
                    break block32;
                }
                System.out.println("cai no else do valida --------------");
                if (((String)retornoValidacao.get("Status")).equals("2")) {
                    this.financeiroDao.updateFaturaStatusIntegracao(Long.valueOf(this.fatura.get("IDFatura").toString()), "S");
                    this.financeiroDao.updatePagamentoReceitaStatusIntegracao(new Long(this.pagamentosReceita.get(0).get("IDReceita").toString()), "S");
                } else {
                    this.financeiroDao.updateFaturaStatusIntegracao(Long.valueOf(this.fatura.get("IDFatura").toString()), "E");
                }
                acaoValidacao = "DADOS DE VALIDACAO DO PAGAMENTO NO SAP\n";
                acaoValidacao = String.valueOf(acaoValidacao) + "\t# URL: " + this.url + "\n";
                acaoValidacao = String.valueOf(acaoValidacao) + "\t# Resposta: " + (String)retornoValidacao.get("Documento") + "\n";
                acaoValidacao = String.valueOf(acaoValidacao) + "\t# Tempo de resposta: " + this.tempoResposta + " segundos" + "\n";
                acaoValidacao = String.valueOf(acaoValidacao) + "\t# Nota com erro: " + notaErro + "\n";
                acaoValidacao = String.valueOf(acaoValidacao) + "\t# Dados recebidos: \n" + new Gson().toJson((Object)this.respostaSAP);
                erro = "Erro ao validar os dados de pagamento ao SAP\n";
                erro = String.valueOf(erro) + "# Disparado por: Rotina-IntegracaoSapPagamentos\n";
                erro = String.valueOf(erro) + acaoValidacao;
                this.financeiroDao.insereLogIntegracaoFatura(acaoValidacao, this.tipoAcao, Long.valueOf(this.fatura.get("IDFatura").toString()), this.idUsuarioTarefasAutomaticas);
                this.faturasErro.put(this.fatura.get("IDFatura").toString(), erro);
            }
            catch (Exception e) {
                e.printStackTrace();
                IntegracaoSapPagamentoMain.LOGGER.info("ERRO = " + e.getMessage());
                this.financeiroDao.updateFaturaStatusIntegracao(Long.valueOf(this.fatura.get("IDFatura").toString()), "E");
                origemErro = this.isRespostaErroSap != false ? "Resposta obtida do SAP" : "Erro";
                descricaoErro = "";
                if (e.getMessage() != null && e.getMessage().equals("Read timed out")) {
                    descricaoErro = "Timeout - Excedeu o limite de tempo determinado para uma requisi\ufffd\ufffdo";
                } else if (e.getCause() != null) {
                    descricaoErro = e.getCause().toString();
                } else if (e.getMessage() != null) {
                    descricaoErro = e.getMessage();
                }
                erro = "Erro ao integrar os dados de pagamento ao SAP\n";
                erro = String.valueOf(erro) + "# Disparado por: Rotina-IntegracaoSapPagamentos\n";
                erro = String.valueOf(erro) + "# URL:" + this.url + "\n";
                erro = String.valueOf(erro) + "# " + origemErro + ": " + descricaoErro + "\n";
                erro = String.valueOf(erro) + "# Tempo de resposta: " + this.tempoResposta + " segundos\n";
                if (!this.prettyJson.isEmpty()) {
                    erro = String.valueOf(erro) + "# Dados enviados:\n" + this.prettyJson;
                }
                if (this.response != null && !this.response.isEmpty()) {
                    erro = String.valueOf(erro) + "# Dados recebidos:\n" + this.response;
                }
                erro = String.valueOf(erro) + "\t# Resposta: " + this.respostaSAP + "\n";
                erro = String.valueOf(erro) + "\t# Data: " + this.dataSAP + "\n";
                this.faturasErro.put(this.fatura.get("IDFatura").toString(), erro);
                this.financeiroDao.insereLogIntegracaoFatura(erro, this.tipoAcao, Long.valueOf(this.fatura.get("IDFatura").toString()), this.idUsuarioTarefasAutomaticas);
            }
        }
    }

    private void geraCorpoMapIntegracao(Map<String, Object> mapIntegracao, Map<String, Object> nota) throws Exception {
        if (this.cardCodeDocumento != null && !this.cardCodeDocumento.isEmpty() && this.cardCodeDocumento.equals("1")) {
            if ((this.fatura.get("CNPJ") == null || this.fatura.get("CNPJ").toString().isEmpty()) && (this.fatura.get("CPF") == null || this.fatura.get("CPF").toString().isEmpty())) {
                throw new AdapterErrorException(String.format("O cliente da Fatura: %s: nao possui CPF nem CNPJ para integracao.", this.fatura.get("IDFatura").toString()));
            }
            if (this.fatura.get("CNPJ") != null && !this.fatura.get("CNPJ").toString().isEmpty()) {
                mapIntegracao.put("CardCode", String.format("C%s", this.fatura.get("CNPJ")));
            } else {
                mapIntegracao.put("CardCode", String.format("C000%s", this.fatura.get("CPF")));
            }
        } else {
            if (this.fatura.get("IDCliente") == null || this.fatura.get("IDCliente").toString().isEmpty()) {
                throw new AdapterErrorException(String.format("A Fatura: %s: Nao possui IDCliente para integracao.", this.fatura.get("IDFatura").toString()));
            }
            mapIntegracao.put("CardCode", String.format("C%s", this.fatura.get("IDCliente")));
        }
        if (this.idFilialFixo != null && !this.idFilialFixo.isEmpty()) {
            mapIntegracao.put("Filial", this.idFilialFixo);
        } else {
            if (this.fatura.get("IDFilialSap") == null || this.fatura.get("IDFilialSap").toString().isEmpty()) {
                throw new AdapterErrorException(String.format("A Fatura: %s: Nao possui Filial para integracao.", this.fatura.get("IDFatura").toString()));
            }
            mapIntegracao.put("Filial", this.fatura.get("IDFilialSap"));
        }
        if (this.fatura.get("DataPagamento") == null || this.fatura.get("DataPagamento").toString().isEmpty()) {
            throw new AdapterErrorException(String.format("A Fatura: %s: Nao possui DataPagamento para integra\u00e7ao.", this.fatura.get("IDFatura").toString()));
        }
        if (this.idsFormasCobrancaSomamUmDia != null && this.idsFormasCobrancaSomamUmDia.size() > 0 && this.idsFormasCobrancaSomamUmDia.contains(new Long(this.fatura.get("IDFormaCobranca").toString()))) {
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
            Date diaMaisUm = this.somaUmDia((Date)this.fatura.get("DataPagamento"));
            mapIntegracao.put("DataPagamento", ft.format(diaMaisUm));
            mapIntegracao.put("DataLancamento", ft.format(diaMaisUm));
        } else {
            mapIntegracao.put("DataPagamento", this.fatura.get("DataPagamento").toString());
            mapIntegracao.put("DataLancamento", this.fatura.get("DataPagamento").toString());
        }
        if (this.dataVencimentoIgualPagamento != null && this.dataVencimentoIgualPagamento.equals("1")) {
            mapIntegracao.put("DataVencimento", mapIntegracao.get("DataPagamento"));
        } else {
            if (this.fatura.get("DataVencimento") == null || this.fatura.get("DataVencimento").toString().isEmpty()) {
                throw new AdapterErrorException(String.format("A Fatura: %s: Nao possui DataVencimento para integra\u00e7ao.", this.fatura.get("IDFatura").toString()));
            }
            mapIntegracao.put("DataVencimento", this.fatura.get("DataVencimento").toString());
        }
        if (this.fatura.get("CodigoSap") == null || this.fatura.get("CodigoSap").toString().isEmpty()) {
            throw new AdapterErrorException(String.format("A Fatura: %s: Nao possui CodigoSap para integra\u00e7ao.", this.fatura.get("IDFatura").toString()));
        }
        mapIntegracao.put("FormaPagamento", this.fatura.get("CodigoSap"));
        if (this.fatura.get("NumeroBoleto") == null) {
            throw new AdapterErrorException(String.format("A Fatura: %s: Nao possui NumeroBoleto para integra\u00e7ao.", this.fatura.get("IDFatura").toString()));
        }
        mapIntegracao.put("NumeroBoleto", this.fatura.get("NumeroBoleto"));
        if (this.fatura.get("TipoPagamento") == null || this.fatura.get("TipoPagamento").toString().isEmpty()) {
            throw new AdapterErrorException(String.format("A Fatura: %s: Nao possui TipoPagamento para integra\u00e7ao.", this.fatura.get("IDFatura").toString()));
        }
        mapIntegracao.put("Acao", this.fatura.get("TipoPagamento"));
        mapIntegracao.put("TotalParcelas", nota.containsKey("QtdeParcela") && nota.get("QtdeParcela") != null ? nota.get("QtdeParcela") : Integer.valueOf(1));
        mapIntegracao.put("NumeroParcela", nota.containsKey("NumeroParcela") && nota.get("NumeroParcela") != null ? nota.get("NumeroParcela") : Integer.valueOf(1));
        mapIntegracao.put("JournalRemarks", String.format("Parcela %s de %s", nota.get("NumeroParcela") != null ? nota.get("NumeroParcela") : Integer.valueOf(1), nota.get("QtdeParcela") != null ? nota.get("QtdeParcela") : Integer.valueOf(1)));
        Double multaNeg = 0.0;
        Double jurosNeg = 0.0;
        Double descontoNeg = 0.0;
        Map<String, Object> multaJurosDesconto = null;
        if (this.fatura.get("IsNegociacao") != null && this.fatura.get("IsNegociacao").toString().equals("1")) {
            multaJurosDesconto = this.financeiroDao.findJurosMultaDescontoByFaturaNegociacao(this.fatura.get("IDFatura").toString());
            multaNeg = multaJurosDesconto.get("Multa") != null ? Double.parseDouble(multaJurosDesconto.get("Multa").toString()) : 0.0;
            jurosNeg = multaJurosDesconto.get("Juros") != null ? Double.parseDouble(multaJurosDesconto.get("Juros").toString()) : 0.0;
            descontoNeg = multaJurosDesconto.get("ValorDesconto") != null ? Double.parseDouble(multaJurosDesconto.get("ValorDesconto").toString()) : 0.0;
        }
        mapIntegracao.put("MultaJurosNegociacao", this.arredondaValor(multaNeg + jurosNeg));
        mapIntegracao.put("DescontoNegociacao", this.arredondaValor(descontoNeg));
        mapIntegracao.put("MultaJurosPagamento", this.arredondaValor((this.fatura.get("JurosValorPago") != null ? Double.parseDouble(this.fatura.get("JurosValorPago").toString()) : 0.0) + (this.fatura.get("MultaValorPago") != null ? Double.parseDouble(this.fatura.get("MultaValorPago").toString()) : 0.0)));
        mapIntegracao.put("DescontoPagamento", this.fatura.get("DescontoValorPago") != null ? this.arredondaValor(Double.parseDouble(this.fatura.get("DescontoValorPago").toString())) : 0.0);
        this.geraMetodoPagamento(mapIntegracao);
    }

    private Map<String, Object> geraMapNotaCompoePagamento(Map<String, Object> nota) throws Exception {
        HashMap<String, Object> notaCompoePagamento = new HashMap<String, Object>();
        if (this.isPagamentoParcial().booleanValue()) {
            if (this.isUltimoPagamentoParcial().booleanValue()) {
                System.out.println("isUltimo");
                notaCompoePagamento.put("ValorDocumento", new Double(nota.get("saldoSAP").toString()));
            } else {
                notaCompoePagamento.put("ValorDocumento", this.calculaValorDocumentoPagamentoParcial(nota.containsKey("valorTotalNotaPP") && nota.get("valorTotalNotaPP") != null ? new Double(nota.get("valorTotalNotaPP").toString()) : new Double(this.fatura.get("Valor").toString()), new Double(this.fatura.get("ValorPago").toString()), new Double(nota.get("ValorNota").toString()), this.fatura.get("DescontoValorPago") != null ? Double.parseDouble(this.fatura.get("DescontoValorPago").toString()) : 0.0));
            }
        } else {
            notaCompoePagamento.put("ValorDocumento", nota.get("ValorNota"));
        }
        notaCompoePagamento.put("ValorJuros", "0");
        notaCompoePagamento.put("ValorMulta", "0");
        notaCompoePagamento.put("ValorDesconto", "0");
        if (this.docEntryCarne != null) {
            notaCompoePagamento.put("DocEntry", this.docEntryCarne);
            notaCompoePagamento.put("Tipo", "ADC");
            this.idFaturamentoCarne = new Long(nota.get("IDFaturamentoMes").toString());
        } else {
            if (nota.get("IDDocumentoSap") == null || nota.get("IDDocumentoSap").toString().isEmpty()) {
                throw new AdapterErrorException(String.format("O Faturamento: %s: Nao possui IDDocumentoSap para integra\u00e7ao.", nota.get("IDFaturamentoMes").toString()));
            }
            notaCompoePagamento.put("DocEntry", nota.get("IDDocumentoSap"));
            notaCompoePagamento.put("Tipo", this.tipoNotaPagamento(nota.get("DataEmissao").toString(), (Date)nota.get("DataLimiteLCMPagamentoSap")));
        }
        return notaCompoePagamento;
    }

    private void geraMetodoPagamento(Map<String, Object> mapIntegracao) {
        String codigoSap = this.inforPagamento.get("CodigoSap").toString();
        String idPagamentoReceita = this.pagamentosReceita != null ? this.pagamentosReceita.get(0).get("IDPagamentoReceita").toString() : "";
        mapIntegracao.put("U_G2_PAGADAPER", idPagamentoReceita);
        if (this.fatura.get("IDFormaPagamento") == null || this.fatura.get("TipoPagamento").equals("PR")) {
            if (this.fatura.get("TipoPagamento").equals("PR") || this.fatura.get("TipoPagamento").equals("R")) {
                mapIntegracao.put("TransferAccount", codigoSap);
                mapIntegracao.put("TransferSum", this.fatura.get("ValorPago").toString());
                mapIntegracao.put("PaymentChecks", new ArrayList());
                mapIntegracao.put("PaymentCreditCards", new ArrayList());
                mapIntegracao.put("CashAccount", null);
                mapIntegracao.put("CashSum", 0);
            }
        } else if (this.contemID(this.configuracoes.getDinheiro(), this.fatura.get("IDFormaPagamento").toString())) {
            mapIntegracao.put("CashAccount", codigoSap);
            mapIntegracao.put("CashSum", this.fatura.get("ValorPago").toString());
            mapIntegracao.put("PaymentChecks", new ArrayList());
            mapIntegracao.put("PaymentCreditCards", new ArrayList());
            mapIntegracao.put("TransferAccount", null);
            mapIntegracao.put("TransferSum", 0);
        } else if (this.contemID(this.configuracoes.getTransferencia(), this.fatura.get("IDFormaPagamento").toString())) {
            mapIntegracao.put("TransferAccount", codigoSap);
            mapIntegracao.put("TransferSum", this.fatura.get("ValorPago").toString());
            mapIntegracao.put("PaymentChecks", new ArrayList());
            mapIntegracao.put("PaymentCreditCards", new ArrayList());
            mapIntegracao.put("CashAccount", null);
            mapIntegracao.put("CashSum", 0);
        } else if (this.contemID(this.configuracoes.getCartao(), this.fatura.get("IDFormaPagamento").toString())) {
            mapIntegracao.put("PaymentChecks", new ArrayList());
            mapIntegracao.put("PaymentCreditCards", Arrays.asList(this.getMapPagamentoCartao(codigoSap, mapIntegracao.get("CardCode").toString())));
            mapIntegracao.put("CashAccount", null);
            mapIntegracao.put("CashSum", 0);
            mapIntegracao.put("TransferAccount", null);
            mapIntegracao.put("TransferSum", 0);
        } else if (this.contemID(this.configuracoes.getCheque(), this.fatura.get("IDFormaPagamento").toString())) {
            mapIntegracao.put("PaymentChecks", Arrays.asList(this.getPagamentoCheque(codigoSap)));
            mapIntegracao.put("PaymentCreditCards", new ArrayList());
            mapIntegracao.put("CashAccount", null);
            mapIntegracao.put("CashSum", 0);
            mapIntegracao.put("TransferAccount", null);
            mapIntegracao.put("TransferSum", 0);
        }
    }

    private Map<String, Object> getMapPagamentoCartao(String codigoSap, String codigoClienteSAP) {
        HashMap<String, Object> pagamentoCartao = new HashMap<String, Object>();
        pagamentoCartao.put("CreditCard", this.getCodigoBandeira());
        pagamentoCartao.put("CreditAcct", codigoSap);
        pagamentoCartao.put("CreditCardNumber", this.fatura.get("CodigoAutorizacaoCartao").toString());
        pagamentoCartao.put("CardValidUntil", "2027-12-01");
        pagamentoCartao.put("VoucherNum", this.fatura.get("TIDCartao") != null ? this.fatura.get("TIDCartao").toString() : "");
        pagamentoCartao.put("OwnerIdNum", codigoClienteSAP);
        pagamentoCartao.put("OwnerPhone", null);
        pagamentoCartao.put("PaymentMethodCode", 1);
        pagamentoCartao.put("NumOfPayments", 1);
        pagamentoCartao.put("FirstPaymentDue", this.fatura.get("DataPagamento").toString());
        pagamentoCartao.put("FirstPaymentSum", this.fatura.get("ValorPago").toString());
        pagamentoCartao.put("AdditionalPaymentSum", "0.0");
        pagamentoCartao.put("CreditSum", this.fatura.get("ValorPago").toString());
        pagamentoCartao.put("CreditCur", "R$");
        pagamentoCartao.put("CreditRate", "0.0");
        pagamentoCartao.put("ConfirmationNum", null);
        pagamentoCartao.put("NumOfCreditPayments", 1);
        pagamentoCartao.put("CreditType", "cr_Regular");
        pagamentoCartao.put("SplitPayments", "tNO");
        return pagamentoCartao;
    }

    private Map<String, Object> getPagamentoCheque(String codigoSap) {
        HashMap<String, Object> pagamentoCheque = new HashMap<String, Object>();
        pagamentoCheque.put("LineNum", 0);
        pagamentoCheque.put("CheckNumber", 1);
        pagamentoCheque.put("DueDate", this.fatura.get("DataPagamento").toString());
        pagamentoCheque.put("BankCode", "");
        pagamentoCheque.put("Branch", null);
        pagamentoCheque.put("Details", null);
        pagamentoCheque.put("Trnsfrable", "tNO");
        pagamentoCheque.put("CheckSum", this.fatura.get("ValorPago").toString());
        pagamentoCheque.put("CheckAccount", codigoSap);
        pagamentoCheque.put("AccounttNum", null);
        pagamentoCheque.put("ManualCheck", "tNO");
        pagamentoCheque.put("FiscalID", null);
        pagamentoCheque.put("OriginallyIssuedBy", null);
        pagamentoCheque.put("Endorse", "tNO");
        pagamentoCheque.put("Currency", "R$");
        pagamentoCheque.put("CountryCode", "BR");
        pagamentoCheque.put("CheckAbsEntry", 3);
        pagamentoCheque.put("EndorsableCheckNo", null);
        return pagamentoCheque;
    }

    private String getCodigoBandeira() {
        Map<Object, Object> mapBandeira = new HashMap();
        mapBandeira = this.fatura.get("IDBandeiraCartaoEmpresa") != null ? this.financeiroDao.findCodigoBandeiraEmpresaById(new Long(this.fatura.get("IDBandeiraCartaoEmpresa").toString())) : this.financeiroDao.findCodigoBandeiraById(new Long(this.fatura.get("IDBandeiraCartao").toString()));
        if (this.fatura.get("IsDebito") != null && this.fatura.get("IsDebito").toString().equals("1")) {
            return mapBandeira.get("CodigoDebitoSap").toString();
        }
        return mapBandeira.get("CodigoCreditoSap").toString();
    }

    private String tipoNotaPagamento(String dataEmissao, Date dataLimite) {
        try {
            Date geracaoNota = this.formato.parse(dataEmissao);
            if (geracaoNota.after(dataLimite)) {
                return "NFS";
            }
            return "LCM";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "NFS";
        }
    }

    private boolean contemID(String idsArray, String id) {
        String[] ids;
        String[] stringArray = ids = idsArray.split(",");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String temp = stringArray[n2];
            if (temp.equals(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Map<String, String> validaSituacaoPagamento(String tipo, String docEntry) throws ClientProtocolException, IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        this.url = this.servidorIntegracao.get("URL") + ":" + this.servidorIntegracao.get("Porta") + "/api/payments/ValidaDocumento?Tipo=" + tipo + "&DocEntry=" + docEntry;
        HttpGet httpGet = new HttpGet(this.url);
        this.defineAuthorization(this.servidorIntegracao, httpGet);
        LocalDateTime antesReq = LocalDateTime.now();
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        HttpEntity entity = httpResponse.getEntity();
        LocalDateTime depoisReq = LocalDateTime.now();
        Duration duration = Duration.between(antesReq, depoisReq);
        this.tempoResposta = Math.abs(duration.getSeconds());
        HashMap<String, String> resp = new HashMap<String, String>();
        if (entity == null) {
            throw new AdapterWarnException("Erro ao integrar os dados de Pagamento ao SAP.\nResposta da requisi\u00e7ao ao SAP \u00e9 nula");
        }
        this.response = EntityUtils.toString((HttpEntity)entity);
        JSONObject resposta = new JSONObject(this.response);
        httpClient.getConnectionManager().shutdown();
        this.respostaSAP = new Gson().toJson((Object)resposta);
        if (resposta.has("Documento")) {
            resp.put("Documento", resposta.get("Documento").toString());
        } else if (resposta.has("documento")) {
            resp.put("Documento", resposta.get("documento").toString());
        } else {
            resp.put("Documento", "Nao identificada");
        }
        if (resposta.has("Status")) {
            resp.put("Status", resposta.get("Status").toString());
        } else if (resposta.has("status")) {
            resp.put("Status", resposta.get("status").toString());
        } else {
            resp.put("Status", "Nao identificada");
        }
        return resp;
    }

    private Double calculaValorDocumentoPagamentoParcial(Double valorTotalFatura, Double valorPago, Double valorNota, Double desconto) throws Exception {
        Double percentualNota = this.arredondaValor3Casas(this.divideValor(valorNota, valorTotalFatura));
        return this.arredondaValor(this.multiplicaValor(valorPago + desconto, percentualNota));
    }

    private List<Map<String, Object>> verificaNotaFechada(List<Map<String, Object>> notas) {
        Long count = 0L;
        ArrayList<Map<String, Object>> novaLista = new ArrayList<Map<String, Object>>();
        Double valorTotalNotas = 0.0;
        for (Map<String, Object> map : notas) {
            count = this.financeiroDao.findNotaFechadaByDocEntry(map.get("IDDocumentoSap").toString());
            if (count != null && count != 0L) continue;
            novaLista.add(map);
            valorTotalNotas = valorTotalNotas + Double.parseDouble(map.get("ValorNota").toString());
        }
        for (Map<String, Object> map : novaLista) {
            map.put("valorTotalNotaPP", this.arredondaValor(valorTotalNotas));
        }
        return novaLista;
    }

    private Double arredondaValor(Double valor) {
        BigDecimal bd = new BigDecimal(valor);
        bd = bd.setScale(2, 6);
        return bd.doubleValue();
    }

    private Double arredondaValor3Casas(Double valor) {
        BigDecimal bd = new BigDecimal(valor);
        bd = bd.setScale(3, 6);
        return bd.doubleValue();
    }

    private Double multiplicaValor(Double valor1, Double valor2) throws Exception {
        return BigDecimal.valueOf(valor1).multiply(BigDecimal.valueOf(valor2), MathContext.DECIMAL64).doubleValue();
    }

    private Double divideValor(Double valor1, Double valor2) throws Exception {
        return BigDecimal.valueOf(valor1).divide(BigDecimal.valueOf(valor2), MathContext.DECIMAL64).doubleValue();
    }

    private Double somaValor(Double valor1, Double valor2) throws Exception {
        return BigDecimal.valueOf(valor1).add(BigDecimal.valueOf(valor2), MathContext.DECIMAL64).doubleValue();
    }

    private Boolean isPagamentoParcial() {
        return this.fatura.get("TipoPagamento").toString().equals("PP");
    }

    private void configuraValoresPagamentoParcial() {
        Double valorPago = 0.0;
        Double desconto = 0.0;
        Double juros = 0.0;
        Double multa = 0.0;
        for (Map<String, Object> pagamento : this.pagamentosReceita) {
            valorPago = valorPago + (Double)pagamento.get("ValorPago");
            desconto = desconto + (Double)pagamento.get("ValorDescontoPagamento");
            juros = juros + (Double)pagamento.get("ValorJurosPago");
            multa = multa + (Double)pagamento.get("ValorMultaPaga");
        }
        this.fatura.put("ValorPagoTotal", this.fatura.get("ValorPago"));
        this.fatura.put("DescontoValorPagoTotal", this.fatura.get("DescontoValorPago"));
        this.fatura.put("ValorPago", valorPago);
        this.fatura.put("JurosValorPago", juros);
        this.fatura.put("MultaValorPago", multa);
        this.fatura.put("DescontoValorPago", desconto);
    }

    private Date somaUmDia(Date data) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(data);
        gc.add(5, 1);
        return gc.getTime();
    }

    private Boolean isUltimoPagamentoParcial() throws Exception {
        Double valorPago = new Double(this.fatura.get("ValorPagoTotal").toString());
        Double desconto = this.fatura.get("DescontoValorPagoTotal") != null ? new Double(this.fatura.get("DescontoValorPagoTotal").toString()) : 0.0;
        Double d = new Double(this.fatura.get("Valor").toString());
        if (this.somaValor(valorPago, desconto) >= d) {
            return true;
        }
        return false;
    }

    private Double verificaDesconto() {
        if (!this.fatura.get("TipoPagamento").toString().equals("PP")) {
            Double valorPago = new Double(this.fatura.get("ValorPago").toString());
            Double valor = this.valorPagoTotalNotas;
            return this.arredondaValor(valor - valorPago);
        }
        return 0.0;
    }

    private void defineAuthorization(Map<String, Object> servidorIntegracaoDto, Object http) {
        if (servidorIntegracaoDto.get("Login") != null && servidorIntegracaoDto.get("Senha") != null) {
            String AUTHORIZATION = "Authorization";
            String auth = "Basic " + Base64.getEncoder().encodeToString((String.valueOf(servidorIntegracaoDto.get("Login").toString()) + ":" + CriptografiaAES.descriptografar((byte[])((byte[])servidorIntegracaoDto.get("Senha")))).getBytes());
            if (http instanceof HttpGet) {
                ((HttpGet)http).setHeader("Authorization", auth);
            }
            if (http instanceof HttpPost) {
                ((HttpPost)http).setHeader("Authorization", auth);
            }
            if (http instanceof HttpPut) {
                ((HttpPut)http).setHeader("Authorization", auth);
            }
            if (http instanceof HttpDelete) {
                ((HttpDelete)http).setHeader("Authorization", auth);
            }
        }
    }
}

